/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.ExchangeTypeEnum;
import kd.fi.fa.business.calc.DataModelWrapper;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.FaBillBaseFormPlugin;
import kd.fi.fa.utils.FaBillImportOrgCheckUtil;
import kd.fi.fa.utils.FaF7CostCenterUtils;
import kd.fi.fa.utils.FaF7DeptUtils;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaTransferUtils;
import kd.fi.fa.utils.FaUtils;

public class FaPurcharseBillEditPlugin
extends FaBillBaseFormPlugin {
    private static final String ASSETCAT = "assetcat";
    private static final String UNIT = "unit";
    private static final String ASSETSENTRY = "assetsentry";
    private static final String CURRENCY = "currency";
    private static final String ORGANDCURRENCYSTR = "orgAndCurrencyStr";
    private static final String ORGANDAMTSTR = "orgAndAmtStr";
    private static final String ISNOTAXAMOUNT = "isNotaxamount";
    private static final String ISUNITPRICEORQTY = "isUnitpriceOrQty";
    private static final String EXRATEMAP = "exrateMap";
    private static final String ISSTOREMAPSTR = "isStoreMapStr";
    private static final String NUMBERANDASSETBOOKMAPSTR = "numberAndAssetBookMapStr";
    private static final String NUMBERANDDATE = "numberAndDateStr";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        if (orgF7 != null) {
            orgF7.setIsOnlyDisplayOrgLeaves(true);
            orgF7.addBeforeF7SelectListener(listener -> FaF7DeptUtils.orgDelegateAssetUnit(listener, this.getModel()));
        }
        BasedataEdit assetunit = (BasedataEdit)this.getView().getControl("assetunit");
        assetunit.addBeforeF7SelectListener(evt -> FaFormPermissionUtil.beforeAssetUnitSelectV2(this.getView().getPageId(), evt, "fa_purchasebill"));
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject assetUnit = (DynamicObject)this.getModel().getValue("assetunit");
        BasedataEdit deptF7 = (BasedataEdit)this.getControl("handleorg");
        deptF7.addBeforeF7SelectListener(evt -> FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit));
        BasedataEdit costCenter = (BasedataEdit)this.getControl("costcentrer");
        costCenter.addBeforeF7SelectListener(evt -> FaF7CostCenterUtils.beforeCostCenterSelect(evt, org));
    }

    private String getNumber(Map<String, Object> sourceData, String name) {
        HashMap orgNumberObj;
        String number = null;
        if (sourceData instanceof JSONObject) {
            JSONObject orgNumberObj2 = (JSONObject)sourceData.get(name);
            if (orgNumberObj2 != null) {
                number = orgNumberObj2.getString("number");
            }
        } else if (sourceData instanceof LinkedHashMap) {
            LinkedHashMap orgNumberObj3 = (LinkedHashMap)sourceData.get(name);
            if (orgNumberObj3 != null && orgNumberObj3.get("number") != null) {
                number = orgNumberObj3.get("number").toString();
            }
        } else if (sourceData instanceof HashMap && (orgNumberObj = (HashMap)sourceData.get(name)) != null && orgNumberObj.get("number") != null) {
            number = orgNumberObj.get("number").toString();
        }
        return number;
    }

    public void initImportData(InitImportDataEventArgs e) {
        long orgId;
        DynamicObjectCollection sourceCurrencys;
        super.initImportData(e);
        List sourceDataList = e.getSourceDataList();
        HashMap<String, Boolean> isStoreMap = new HashMap<String, Boolean>(sourceDataList.size(), 1.0f);
        ArrayList<String> purchaseBillNumbers = new ArrayList<String>(16);
        HashSet<Long> assetUnitIds = new HashSet<Long>(2);
        HashSet<String> assetUnitNumbers = new HashSet<String>(2);
        FaBillImportOrgCheckUtil.checkOrgPermission(this.getView().getPageId(), e, "fa_purchasebill", "assetunit", "09");
        FaBillImportOrgCheckUtil.checkOrgPermission(this.getView().getPageId(), e, "fa_purchasebill", "org", "10");
        Map<Object, Object> exrateMap = new HashMap(2);
        HashSet<String> orgNumbers = new HashSet<String>(2);
        HashSet<Long> orgIds = new HashSet<Long>(2);
        ArrayList<String> sourceCurrencyNumbers = new ArrayList<String>(16);
        HashMap<String, Long> purchaseCurrencyNumberAndIdMap = new HashMap<String, Long>(2);
        for (Object sourceData : sourceDataList) {
            Object billNumberObj;
            String assetUnitNumber;
            String sourceCurrencyNumber;
            String orgNumber = this.getNumber((Map<String, Object>)sourceData, "org");
            if (orgNumber != null) {
                orgNumbers.add(orgNumber);
            }
            if ((sourceCurrencyNumber = this.getNumber((Map<String, Object>)sourceData, "purchasecurrency")) != null) {
                sourceCurrencyNumbers.add(sourceCurrencyNumber);
            }
            if ((assetUnitNumber = this.getNumber((Map<String, Object>)sourceData, "assetunit")) != null) {
                assetUnitNumbers.add(assetUnitNumber);
            }
            if ((billNumberObj = sourceData.get("billno")) == null) continue;
            purchaseBillNumbers.add(billNumberObj.toString());
        }
        if (sourceCurrencyNumbers.size() > 0 && (sourceCurrencys = QueryServiceHelper.query((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", sourceCurrencyNumbers)})) != null) {
            for (Iterator sourceCurrency : sourceCurrencys) {
                long curSourceCurrencyId = sourceCurrency.getLong("id");
                purchaseCurrencyNumberAndIdMap.put(sourceCurrency.getString("number"), curSourceCurrencyId);
            }
        }
        HashMap<String, Long> idAndNumber = new HashMap<String, Long>(2);
        if (orgNumbers.size() > 0) {
            DynamicObjectCollection orgIdsCollection = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", orgNumbers)});
            for (DynamicObject dynamicObject : orgIdsCollection) {
                long id = dynamicObject.getLong("id");
                orgIds.add(id);
                idAndNumber.put(dynamicObject.getString("number"), id);
            }
        }
        if (assetUnitNumbers.size() > 0) {
            DynamicObjectCollection assetUnitIdsCollection = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", assetUnitNumbers)});
            for (DynamicObject dynamicObject : assetUnitIdsCollection) {
                long id = dynamicObject.getLong("id");
                assetUnitIds.add(id);
            }
        }
        QFilter assetUnitIdFilter = new QFilter("assetunit", "in", assetUnitIds);
        QFilter orgIdFilter = new QFilter("org", "in", orgIds);
        QFilter billNumberFilter = new QFilter("billno", "in", purchaseBillNumbers);
        String purchaseSelectFields = Fa.comma((String[])new String[]{"billno", "org", "assetunit", "billstatus"});
        DynamicObjectCollection purchasebills = QueryServiceHelper.query((String)"fa_purchasebill", (String)purchaseSelectFields, (QFilter[])new QFilter[]{assetUnitIdFilter, orgIdFilter, billNumberFilter});
        for (DynamicObject purchasebill : purchasebills) {
            String key = purchasebill.getString("org") + "_" + purchasebill.getString("assetunit") + "_" + purchasebill.getString("billno");
            String status = purchasebill.getString("billstatus");
            boolean isStore = "A".equals(status);
            isStoreMap.put(key, isStore);
        }
        String isStoreMapStr = SerializationUtils.serializeToBase64(isStoreMap);
        this.getPageCache().put(ISSTOREMAPSTR, isStoreMapStr);
        QFilter isMainFilter = new QFilter("ismainbook", "=", (Object)"1");
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        String selectfields = Fa.comma((String[])new String[]{"id", "exchangetable", "basecurrency", "org", "curperiod.beginDate begindate,basecurrency.amtprecision amtprecision"});
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)selectfields, (QFilter[])new QFilter[]{orgFilter, isMainFilter});
        HashMap numberAndAssetBookMap = new HashMap(2);
        HashMap<Long, Date> numberAndDate = new HashMap<Long, Date>(2);
        for (DynamicObject assetBook : assetBooks) {
            HashMap<String, Long> info = new HashMap<String, Long>(2);
            long curExchangeTableId = assetBook.getLong("exchangetable");
            long curBaseCurrencyId = assetBook.getLong("basecurrency");
            long curAmtprecision = assetBook.getLong("amtprecision");
            info.put("exchangetable", curExchangeTableId);
            info.put("basecurrency", curBaseCurrencyId);
            info.put("amtprecision", curAmtprecision);
            Date beginDate = assetBook.getDate("begindate");
            orgId = assetBook.getLong("org");
            numberAndAssetBookMap.put(orgId, info);
            numberAndDate.put(orgId, beginDate);
        }
        String numberAndAssetBookMapStr = SerializationUtils.serializeToBase64(numberAndAssetBookMap);
        this.getPageCache().put(NUMBERANDASSETBOOKMAPSTR, numberAndAssetBookMapStr);
        String numberAndDateStr = SerializationUtils.serializeToBase64(numberAndDate);
        this.getPageCache().put(NUMBERANDDATE, numberAndDateStr);
        if (sourceDataList.size() > 1) {
            sourceDataList.sort(new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    Object date1Obj = o1.get("purchasedate");
                    Date date1 = FaPurcharseBillEditPlugin.this.getDate(date1Obj);
                    Object date2Obj = o2.get("purchasedate");
                    Date date2 = FaPurcharseBillEditPlugin.this.getDate(date2Obj);
                    return FaUtils.compareDate(date1, date2);
                }
            });
            ArrayList<Map<String, Object>> valueList = new ArrayList<Map<String, Object>>(16);
            for (Map sourceData : sourceDataList) {
                String orgNumber;
                long exchangerateTableId = 0L;
                long purchaseCurrencyId = 0L;
                long baseCurrencyId = 0L;
                String purchaseCurrencyNumberStr = this.getNumber(sourceData, "purchasecurrency");
                if (purchaseCurrencyNumberStr != null) {
                    purchaseCurrencyId = (Long)purchaseCurrencyNumberAndIdMap.get(purchaseCurrencyNumberStr);
                }
                if ((orgNumber = this.getNumber(sourceData, "org")) != null && idAndNumber.get(orgNumber) != null) {
                    long orgId2 = (Long)idAndNumber.get(orgNumber);
                    Map assetBook = (Map)numberAndAssetBookMap.get(orgId2);
                    baseCurrencyId = (Long)assetBook.get("basecurrency");
                    exchangerateTableId = (Long)assetBook.get("exchangetable");
                }
                HashMap<String, Long> value = new HashMap<String, Long>(4);
                value.put("exctable", exchangerateTableId);
                value.put("orgcur", purchaseCurrencyId);
                value.put("cur", baseCurrencyId);
                value.put("date", (Long)sourceData.get("purchasedate"));
                valueList.add(value);
            }
            exrateMap = FaUtils.getExrates(valueList);
            String exrateMapStr = SerializationUtils.serializeToBase64(exrateMap);
            this.getPageCache().put(EXRATEMAP, exrateMapStr);
        } else if (sourceDataList.size() == 1) {
            QFilter oneOrgFilter;
            DynamicObject assetBook;
            DynamicObject orgIdDyo;
            DynamicObject sourceCurrency;
            String orgNumber = "";
            String sourceCurrencyNumber = "";
            long sourceCurrencyId = 0L;
            long targetCurrencyId = 0L;
            long exchangeTableId = 0L;
            orgId = 0L;
            Map sourceData = (Map)sourceDataList.get(0);
            orgNumber = this.getNumber(sourceData, "org");
            sourceCurrencyNumber = this.getNumber(sourceData, "purchasecurrency");
            if (sourceCurrencyNumber != null && (sourceCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)sourceCurrencyNumber)})) != null) {
                sourceCurrencyId = sourceCurrency.getLong("id");
            }
            Object dateObj = sourceData.get("purchasedate");
            Date date = this.getDate(dateObj);
            if (orgNumber != null && (orgIdDyo = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)})) != null) {
                orgId = orgIdDyo.getLong("id");
            }
            if ((assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)selectfields, (QFilter[])new QFilter[]{isMainFilter, oneOrgFilter = new QFilter("org", "=", (Object)orgId)})) != null) {
                targetCurrencyId = assetBook.getLong("basecurrency");
                exchangeTableId = assetBook.getLong("exchangetable");
            }
            if (sourceCurrencyId != targetCurrencyId) {
                exrateMap = FaUtils.getExrate(exchangeTableId, sourceCurrencyId, targetCurrencyId, date);
            }
            String exrateMapStr = SerializationUtils.serializeToBase64(exrateMap);
            this.getPageCache().put(EXRATEMAP, exrateMapStr);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        long costCenterId;
        Boolean isSame;
        boolean checkResult;
        boolean isStore;
        String numberAndDateStr;
        Map numberAndDate;
        Date beginDate;
        BillModel model = (BillModel)this.getModel();
        String isStoreMapStr = this.getPageCache().get(ISSTOREMAPSTR);
        Map isStoreMap = (Map)SerializationUtils.deSerializeFromBase64((String)isStoreMapStr);
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject assetUnit = (DynamicObject)model.getValue("assetunit");
        Object billnoObj = model.getValue("billno");
        String billno = "";
        long assetUnitId = 0L;
        long basecurrencyId = 0L;
        long exchangeTableId = 0L;
        long orgId = 0L;
        int amtprecision = 2;
        if (org != null) {
            orgId = org.getLong("id");
        }
        if (assetUnit != null) {
            assetUnitId = assetUnit.getLong("id");
        }
        if (billnoObj != null) {
            billno = billnoObj.toString();
        }
        if ((beginDate = (Date)(numberAndDate = (Map)SerializationUtils.deSerializeFromBase64((String)(numberAndDateStr = this.getPageCache().get(NUMBERANDDATE)))).get(orgId)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u201d\u6ca1\u6709\u4e3b\u8d26\u7c3f\u6216\u201c\u4e3b\u8d26\u7c3f\u201d\u6ca1\u6709\u5f53\u524d\u671f\u95f4\u3002", (String)"FaPurcharseBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if (model.getValue("purchasedate") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u4e3a\u7a7a\u3002", (String)"FaPurcharseBillEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        String storeKey = orgId + "_" + assetUnitId + "_" + billno;
        if (isStoreMap.containsKey(storeKey) && !(isStore = ((Boolean)isStoreMap.get(storeKey)).booleanValue())) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e\uff08\u8f6c\u56fa\u5355\u53f7\uff1a%s\uff09\u53ea\u6709\u5904\u4e8e\u6682\u5b58\u72b6\u6001\u624d\u80fd\u5bfc\u5165\u3002", (String)"FaPurcharseBillEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), billno));
        }
        Long useDept = 0L;
        if (null != model.getValue("handleorg")) {
            useDept = ((DynamicObject)model.getValue("handleorg")).getLong("id");
        }
        if (!(checkResult = FaAssetUnitAndUseDeptUnits.checkUseDeptByAssetUnit((DynamicObject)org, (DynamicObject)assetUnit, (Long)useDept))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f7f\u7528\u90e8\u95e8\u5f53\u524d\u8d44\u4ea7\u7ec4\u7ec7\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u90e8\u95e8", (String)"FaPurcharseBillEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObjectCollection entries = model.getEntryEntity(ASSETSENTRY);
        String numberAndAssetBookMapStr = this.getPageCache().get(NUMBERANDASSETBOOKMAPSTR);
        Map numberAndAssetBookMap = (Map)SerializationUtils.deSerializeFromBase64((String)numberAndAssetBookMapStr);
        Map assetBookInfo = new HashMap(2);
        if (numberAndAssetBookMap.get(orgId) != null) {
            assetBookInfo = (Map)numberAndAssetBookMap.get(orgId);
        }
        if (assetBookInfo.size() > 0) {
            basecurrencyId = (Long)assetBookInfo.get("basecurrency");
            exchangeTableId = (Long)assetBookInfo.get("exchangetable");
            long amtprecisionLong = (Long)assetBookInfo.get("amtprecision");
            amtprecision = (int)amtprecisionLong;
        }
        if (basecurrencyId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u4e3b\u8d26\u7c3f\u6216\u4e3b\u8d26\u7c3f\u6ca1\u6709\u672c\u4f4d\u5e01\u3002", (String)"FaPurcharseBillEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        model.setValue("basecurrency_id", (Object)basecurrencyId);
        model.setValue("exchangetable_id", (Object)exchangeTableId);
        DynamicObjectCollection colls = model.getDataEntity().getDynamicObjectCollection(ASSETSENTRY);
        for (DynamicObject obj : colls) {
            obj.set("currency_id", (Object)basecurrencyId);
            obj.set("assetqtyleft", obj.get("assetqty"));
        }
        long purchasecurrencyId = 0L;
        int purAmtprecision = 2;
        DynamicObject purchasecurrency = (DynamicObject)model.getValue("purchasecurrency");
        String exchangeratetype = model.getValue("exchangeratetype").toString();
        if (purchasecurrency == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u91c7\u8d2d\u5e01\u522b\u3002", (String)"FaPurcharseBillEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        purchasecurrencyId = purchasecurrency.getLong("id");
        purAmtprecision = purchasecurrency.getInt("amtprecision");
        int purPricePrecision = purchasecurrency.getInt("priceprecision");
        BigDecimal curExchangeRate = BigDecimal.ONE;
        BigDecimal exchangeRate = BigDecimal.ONE;
        Object curExchangeRateObj = model.getValue("exchangerate");
        if (curExchangeRateObj != null) {
            exchangeRate = curExchangeRate = new BigDecimal(curExchangeRateObj.toString());
        }
        if (!(isSame = this.isSameCurrency(basecurrencyId, purchasecurrencyId)).booleanValue() && curExchangeRate.compareTo(BigDecimal.ONE) != 0) {
            String exrateMapStr = this.getPageCache().get(EXRATEMAP);
            Map exrateMap = (Map)SerializationUtils.deSerializeFromBase64((String)exrateMapStr);
            Date date = (Date)model.getValue("purchasedate");
            String key = exchangeTableId + "_" + purchasecurrencyId + "_" + basecurrencyId + "_" + date.toString();
            String valueName = ExchangeTypeEnum.A.getValue().equals(exchangeratetype) ? "excval" : "indirectexrate";
            Map valueMap = (Map)exrateMap.get(key);
            if (valueMap != null) {
                exchangeRate = (BigDecimal)valueMap.get(valueName);
            }
            model.setValue("exchangerate", (Object)exchangeRate);
        }
        for (DynamicObject entry : entries) {
            boolean importMaterialProductLine;
            BigDecimal assetqty = entry.getBigDecimal("assetqty");
            BigDecimal newUnitprice = entry.getBigDecimal("newunitprice");
            if (newUnitprice.compareTo(newUnitprice.setScale(purPricePrecision, RoundingMode.UP)) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u4ef7\u7cbe\u5ea6\u8d85\u8fc7\u91c7\u8d2d\u5e01\u522b\u5355\u4ef7\u7cbe\u5ea6\uff0c\u5f15\u5165\u5931\u8d25\u3002", (String)"FaPurcharseBillEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            DynamicObject taxratedyo = entry.getDynamicObject("taxrate");
            BigDecimal taxrate = BigDecimal.ZERO;
            if (taxratedyo != null && taxratedyo.getString("taxrate") != null) {
                taxrate = new BigDecimal(taxratedyo.getString("taxrate"));
            }
            taxrate = taxrate.divide(new BigDecimal(100), RoundingMode.HALF_UP);
            int index = entry.getInt("seq") - 1;
            BigDecimal origintaxamount = this.getBigDecimal(e.getSourceData(), ASSETSENTRY, index, "origintaxamount");
            BigDecimal taxamount = this.getBigDecimal(e.getSourceData(), ASSETSENTRY, index, "taxamount");
            this.setOriginValuesByEntry(newUnitprice, assetqty, taxrate, entry, purAmtprecision, amtprecision, exchangeRate, exchangeratetype, null, 0, origintaxamount, taxamount);
            DynamicObject productLine = entry.getDynamicObject("productline");
            boolean importProductLine = productLine != null && productLine.getLong("id") != 0L;
            DynamicObject material = entry.getDynamicObject("materielfield");
            boolean bl = importMaterialProductLine = material != null && material.get("productline") != null;
            if (importProductLine || !importMaterialProductLine) continue;
            entry.set("productline", material.get("productline"));
        }
        Object costCenter = model.getValue("costcentrer");
        if (costCenter != null && !FaF7CostCenterUtils.checkCostCenterHasValidator4Org(orgId, costCenterId = ((DynamicObject)costCenter).getLong("id"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u8f6c\u56fa\u5355\uff1a%s\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u5728\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u7684\u53ef\u7528\u8303\u56f4\u4e4b\u5185\u3002", (String)"FaPurcharseBillEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]), model.getValue("billno")));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryname = e.getEntryProp().getName();
        if (!entryname.equals(ASSETSENTRY)) {
            return;
        }
        IDataModel model = this.getModel();
        Object purchasedate = model.getValue("purchasedate");
        RowDataEntity[] rows = e.getRowDataEntities();
        Long currencyPK = FaTransferUtils.getBaseCurrencyPK(model);
        Stream.of(rows).forEach(v -> {
            int rowIndex = v.getRowIndex();
            model.setValue(CURRENCY, currencyPK, rowIndex);
            model.setValue("realaccountdate", purchasedate, rowIndex);
            this.setUnit(rowIndex);
        });
    }

    @Override
    public void afterCreateNewData(EventObject eventobject) {
        DynamicObjectCollection entry;
        super.afterCreateNewData(eventobject);
        IDataModel model = this.getModel();
        Object isChangingMainOrg = this.getModel().getContextVariable("isChangingMainOrg");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (isChangingMainOrg == null && parentView != null && parentView.toString().indexOf("FormView-fa_mainpage_grid") == 0) {
            List assetUnits = FaPermissionUtils.getAllPermissionAsseUnitsV2((String)this.getView().getPageId(), (String)"fa_purchasebill");
            Long org = FaPermissionUtils.getDefaultAcctOrg((List)assetUnits);
            this.getModel().setValue("assetunit", (Object)org);
            this.getModel().setValue("org", (Object)org);
            Long assetUnitId = FaPermissionUtils.getDefaultAcctOrg((List)assetUnits);
            if (null == assetUnitId) {
                return;
            }
            model.setValue("assetunit", (Object)assetUnitId);
            DynamicObject assetUnit = (DynamicObject)model.getValue("assetunit");
            String assetUnitName = assetUnit.getLocaleString("name").toString();
            List fromOrgList = OrgUnitServiceHelper.getFromOrgs((String)"09", (Long)assetUnitId, (String)"10", (boolean)true);
            if (fromOrgList != null && fromOrgList.size() == 1) {
                Long fromOrg = (Long)fromOrgList.get(0);
                model.setValue("org", (Object)fromOrg);
            } else {
                model.setValue("org", null);
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7ec4\u7ec7\u3010%s\u3011\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaPurcharseBillEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), assetUnitName));
            }
        }
        model.setValue("handler", (Object)ContextUtil.getUserId());
        DynamicObject bill = model.getDataEntity(true);
        String buildWay = bill.getString("buildway");
        if ("3".equals(buildWay) && (entry = bill.getDynamicObjectCollection(ASSETSENTRY)).size() > 0) {
            ((DynamicObject)entry.get(0)).set("ismainline", (Object)true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject model = this.getModel().getDataEntity();
        if (!model.getDataEntityState().getFromDatabase()) {
            int size = this.getModel().getEntryRowCount(ASSETSENTRY);
            Long currencyPK = FaTransferUtils.getBaseCurrencyPK(this.getModel());
            for (int index = 0; index < size; ++index) {
                this.getModel().setValue(CURRENCY, (Object)currencyPK, index);
            }
            this.getModel().setValue("basecurrency", (Object)currencyPK);
            this.getModel().setValue("purchasecurrency", (Object)currencyPK);
        }
        if (null == model.get("exchangetable")) {
            this.setCurrencyRate();
        }
        boolean needUpdateDate = this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW && model.get("purchasedate") == null;
        String sourceBillSign = model.getString("sourcebillsign");
        if ("im_purreceivebill".equals(sourceBillSign)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"addrow"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String buildWay;
        boolean newValue;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String propertyName = e.getProperty().getName();
        String srcBillKey = (String)model.getValue("sourcebillsign");
        if ("im_purreceivebill".equals(srcBillKey)) {
            this.imPurreceiveBillPropertyChange(e, model, propertyName);
        } else {
            if ("exchangeratetype".equals(propertyName)) {
                this.setCurrencyRate();
            }
            long basecurrencyId = 0L;
            long purchasecurrencyId = 0L;
            int amtprecision = 2;
            int purAmtprecision = 2;
            DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency");
            DynamicObject purchasecurrency = (DynamicObject)model.getValue("purchasecurrency");
            if (basecurrency != null) {
                basecurrencyId = basecurrency.getLong("id");
                amtprecision = basecurrency.getInt("amtprecision");
            }
            if (purchasecurrency != null) {
                purchasecurrencyId = purchasecurrency.getLong("id");
                purAmtprecision = purchasecurrency.getInt("amtprecision");
            }
            int entryCurrentRowIndex = e.getChangeSet()[0].getRowIndex();
            Object exchangeRateTypeObj = model.getValue("exchangeratetype");
            String exchangeRateType = "";
            if (exchangeRateTypeObj != null) {
                exchangeRateType = exchangeRateTypeObj.toString();
            }
            Boolean isSame = this.isSameCurrency(basecurrencyId, purchasecurrencyId);
            if ("exchangerate".equals(propertyName) || "exchangeratetype".equals(propertyName)) {
                this.exchangeRateOrExchangeRateTypeChange(model, amtprecision, purAmtprecision, exchangeRateType);
            }
            if (!isSame.booleanValue()) {
                BigDecimal originNotaxAmount;
                BigDecimal originTaxAmount;
                BigDecimal taxrate;
                DynamicObject taxratedyo;
                BigDecimal originTotalAmount;
                if ("assetqty".equals(propertyName) || "newunitprice".equals(propertyName)) {
                    BigDecimal newunitprice = new BigDecimal(model.getValue("newunitprice", entryCurrentRowIndex).toString());
                    BigDecimal assetqty = new BigDecimal(model.getValue("assetqty", entryCurrentRowIndex).toString());
                    BigDecimal originTotalAmount2 = this.multi(newunitprice, assetqty, purAmtprecision);
                    model.setValue("origintotalamount", (Object)originTotalAmount2, entryCurrentRowIndex);
                    this.getView().updateView(ASSETSENTRY);
                } else if ("origintotalamount".equals(propertyName)) {
                    originTotalAmount = new BigDecimal(model.getValue("origintotalamount", entryCurrentRowIndex).toString());
                    taxratedyo = (DynamicObject)model.getValue("taxrate", entryCurrentRowIndex);
                    taxrate = BigDecimal.ZERO;
                    if (taxratedyo != null && taxratedyo.getString("taxrate") != null) {
                        taxrate = new BigDecimal(taxratedyo.getString("taxrate"));
                    }
                    taxrate = taxrate.divide(new BigDecimal(100));
                    originTaxAmount = this.multi(originTotalAmount, taxrate, purAmtprecision).divide(taxrate.add(BigDecimal.ONE), purAmtprecision, 4);
                    model.setValue("origintaxamount", (Object)originTaxAmount, entryCurrentRowIndex);
                    originNotaxAmount = originTotalAmount.subtract(originTaxAmount);
                    model.setValue("originnotaxamount", (Object)originNotaxAmount, entryCurrentRowIndex);
                    BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
                    this.setOtherValuesByEntry(null, amtprecision, exchangeRate, exchangeRateType, originTaxAmount, originTotalAmount, model, entryCurrentRowIndex, null);
                    this.getView().updateView(ASSETSENTRY);
                } else if ("origintaxamount".equals(propertyName)) {
                    BigDecimal originTotalAmount3;
                    BigDecimal originTaxAmount2 = new BigDecimal(model.getValue("origintaxamount", entryCurrentRowIndex).toString());
                    if (originTaxAmount2.compareTo(originTotalAmount3 = new BigDecimal(model.getValue("origintotalamount", entryCurrentRowIndex).toString())) > 0) {
                        ChangeData changeData = e.getChangeSet()[0];
                        model.setValue("origintaxamount", changeData.getOldValue(), entryCurrentRowIndex);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u539f\u5e01\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e\u539f\u5e01\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"FaPurcharseBillEditPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    BigDecimal originNotaxAmount2 = originTotalAmount3.subtract(originTaxAmount2);
                    model.setValue("originnotaxamount", (Object)originNotaxAmount2, entryCurrentRowIndex);
                } else if ("taxrate".equals(propertyName)) {
                    originTotalAmount = new BigDecimal(model.getValue("origintotalamount", entryCurrentRowIndex).toString());
                    taxratedyo = (DynamicObject)model.getValue("taxrate", entryCurrentRowIndex);
                    taxrate = BigDecimal.ZERO;
                    if (taxratedyo != null && taxratedyo.getString("taxrate") != null) {
                        taxrate = new BigDecimal(taxratedyo.getString("taxrate"));
                    }
                    taxrate = taxrate.divide(new BigDecimal(100));
                    originTaxAmount = this.multi(originTotalAmount, taxrate, purAmtprecision).divide(taxrate.add(BigDecimal.ONE), purAmtprecision, 4);
                    model.setValue("origintaxamount", (Object)originTaxAmount, entryCurrentRowIndex);
                    originNotaxAmount = originTotalAmount.subtract(originTaxAmount);
                    model.setValue("originnotaxamount", (Object)originNotaxAmount, entryCurrentRowIndex);
                    BigDecimal totalAmount = (BigDecimal)model.getValue("totalamount", entryCurrentRowIndex);
                    BigDecimal exchangeRate = (BigDecimal)model.getValue("exchangerate");
                    String exchangerateType = model.getValue("exchangeratetype").toString();
                    BigDecimal taxAmount = ExchangeTypeEnum.A.getValue().equals(exchangeRateType) ? this.multi(originTaxAmount, exchangeRate, amtprecision) : this.divide(originTaxAmount, exchangeRate, amtprecision);
                    model.setValue("taxamount", (Object)taxAmount, entryCurrentRowIndex);
                    BigDecimal notaxamount = totalAmount.subtract(taxAmount);
                    model.setValue("notaxamount", (Object)notaxamount, entryCurrentRowIndex);
                    this.getView().updateView(ASSETSENTRY);
                }
            } else {
                if ("assetqty".equals(propertyName) || "newunitprice".equals(propertyName)) {
                    BigDecimal assetqty = (BigDecimal)model.getValue("assetqty", entryCurrentRowIndex);
                    BigDecimal newUnitprice = (BigDecimal)model.getValue("newunitprice", entryCurrentRowIndex);
                    BigDecimal totalamount = this.multi(assetqty, newUnitprice, amtprecision);
                    model.setValue("totalamount", (Object)totalamount, entryCurrentRowIndex);
                    this.updateTaxamountAndNotaxamount(model, totalamount, amtprecision, entryCurrentRowIndex);
                    this.getView().updateView(ASSETSENTRY);
                }
                if ("taxrate".equals(propertyName)) {
                    BigDecimal totalamount = (BigDecimal)model.getValue("totalamount", entryCurrentRowIndex);
                    this.updateTaxamountAndNotaxamount(model, totalamount, amtprecision, entryCurrentRowIndex);
                    this.getView().updateView(ASSETSENTRY);
                }
            }
            if ("taxamount".equals(propertyName)) {
                BigDecimal totalAmount;
                BigDecimal taxAmount = new BigDecimal(model.getValue("taxamount", entryCurrentRowIndex).toString());
                if (taxAmount.compareTo(totalAmount = new BigDecimal(model.getValue("totalamount", entryCurrentRowIndex).toString())) > 0) {
                    ChangeData changeData = e.getChangeSet()[0];
                    model.setValue("taxamount", changeData.getOldValue(), entryCurrentRowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u989d\u4e0d\u80fd\u5927\u4e8e\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"FaPurcharseBillEditPlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    return;
                }
                BigDecimal notaxAmount = totalAmount.subtract(taxAmount);
                model.setValue("notaxamount", (Object)notaxAmount, entryCurrentRowIndex);
            }
        }
        if (ASSETCAT.equals(propertyName)) {
            int currentRowIndex = e.getChangeSet()[0].getRowIndex();
            this.setUnit(currentRowIndex);
        } else if ("handler".equals(propertyName) && !ObjectUtils.isEmpty((Object)this.getModel().getValue("handler")) && ObjectUtils.isEmpty((Object)this.getModel().getValue("handleorg"))) {
            this.updateDeptByPerson();
        }
        if ("purchasecurrency".equalsIgnoreCase(propertyName)) {
            this.setCurrencyRate();
        }
        ChangeData changeData = e.getChangeSet()[0];
        if ("ismainline".equals(propertyName) && (newValue = ((Boolean)changeData.getNewValue()).booleanValue())) {
            this.getModel().beginInit();
            int rowIndex = changeData.getRowIndex();
            DynamicObjectCollection assetEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ASSETSENTRY);
            for (int i = 0; i < assetEntry.size(); ++i) {
                if (i == rowIndex) continue;
                ((DynamicObject)assetEntry.get(i)).set("ismainline", (Object)false);
            }
            this.getModel().endInit();
            this.getView().updateView(ASSETSENTRY);
        }
        if ("buildway".equals(propertyName) && "3".equals(buildWay = (String)changeData.getNewValue())) {
            DynamicObjectCollection assetEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(ASSETSENTRY);
            if (assetEntry.isEmpty()) {
                return;
            }
            int count = 0;
            for (DynamicObject entry : assetEntry) {
                boolean isMainLine = entry.getBoolean("ismainline");
                if (isMainLine) {
                    ++count;
                }
                if (count <= 1) continue;
                break;
            }
            if (count == 0) {
                ((DynamicObject)assetEntry.get(0)).set("ismainline", (Object)true);
                this.getView().updateView(ASSETSENTRY);
            } else if (count > 1) {
                this.getModel().beginInit();
                ((DynamicObject)assetEntry.get(0)).set("ismainline", (Object)true);
                for (int i = 1; i < assetEntry.size(); ++i) {
                    ((DynamicObject)assetEntry.get(i)).set("ismainline", (Object)false);
                }
                this.getModel().endInit();
                this.getView().updateView(ASSETSENTRY);
            }
        }
        if ("materielfield".equals(propertyName)) {
            Object newValue2 = changeData.getNewValue();
            DynamicObject productLine = (DynamicObject)this.getModel().getValue("productline");
            if (newValue2 != null && productLine == null) {
                DynamicObject material = (DynamicObject)changeData.getNewValue();
                this.getModel().setValue("productline", material.get("productline.id"), changeData.getRowIndex());
            }
        }
    }

    private void exchangeRateOrExchangeRateTypeChange(IDataModel model, int amtprecision, int purAmtprecision, String exchangeRateType) {
        DynamicObjectCollection assetsentries = model.getEntryEntity(ASSETSENTRY);
        BigDecimal curExchangeRate = (BigDecimal)model.getValue("exchangerate");
        BigDecimal exchangeRate = curExchangeRate != null ? curExchangeRate : BigDecimal.ZERO;
        for (DynamicObject assetsentry : assetsentries) {
            BigDecimal newUnitPrice = assetsentry.getBigDecimal("newunitprice");
            BigDecimal assetqty = assetsentry.getBigDecimal("assetqty");
            DynamicObject taxratedyo = assetsentry.getDynamicObject("taxrate");
            BigDecimal taxrate = BigDecimal.ZERO;
            if (taxratedyo != null && taxratedyo.getString("taxrate") != null) {
                taxrate = new BigDecimal(taxratedyo.getString("taxrate"));
            }
            taxrate = taxrate.divide(new BigDecimal(100));
            this.setOriginValuesByEntry(newUnitPrice, assetqty, taxrate, assetsentry, purAmtprecision, amtprecision, exchangeRate, exchangeRateType, null, 0, null, null);
        }
        this.getView().updateView(ASSETSENTRY);
    }

    private void imPurreceiveBillPropertyChange(PropertyChangedArgs e, IDataModel model, String propertyName) {
        int entryCurrentRowIndex = e.getChangeSet()[0].getRowIndex();
        List<String> changeFields = Arrays.asList("assetqty", "newunitprice", "unitprice");
        if (changeFields.contains(propertyName)) {
            int amtprecision = 2;
            DynamicObject basecurrency = (DynamicObject)model.getValue("basecurrency");
            if (basecurrency != null) {
                amtprecision = basecurrency.getInt("amtprecision");
            }
            BigDecimal assetqty = new BigDecimal(model.getValue("assetqty", entryCurrentRowIndex).toString());
            BigDecimal newUnitprice = new BigDecimal(model.getValue("newunitprice", entryCurrentRowIndex).toString());
            BigDecimal unitprice = new BigDecimal(model.getValue("unitprice", entryCurrentRowIndex).toString());
            BigDecimal totalAmount = assetqty.multiply(newUnitprice).setScale(amtprecision, RoundingMode.HALF_UP);
            BigDecimal notaxAmount = assetqty.multiply(unitprice).setScale(amtprecision, RoundingMode.HALF_UP);
            BigDecimal taxAmount = totalAmount.subtract(notaxAmount);
            model.setValue("notaxamount", (Object)notaxAmount, entryCurrentRowIndex);
            model.setValue("totalamount", (Object)totalAmount, entryCurrentRowIndex);
            model.setValue("taxamount", (Object)taxAmount, entryCurrentRowIndex);
        }
    }

    private void updateDeptByPerson() {
        DynamicObject usePerson = (DynamicObject)this.getModel().getValue("handler");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long assetUnitId = ((DynamicObject)this.getModel().getValue("assetunit")).getLong("id");
        FaF7DeptUtils.getUseDeptByUsePerson(this.getModel(), usePerson, org, "handleorg", assetUnitId);
    }

    private void setUnit(int currentRowIndex) {
        DynamicObject dobj = (DynamicObject)this.getModel().getValue(ASSETCAT, currentRowIndex);
        if (null == dobj || null == dobj.getDynamicObject(UNIT)) {
            return;
        }
        this.getModel().setValue(UNIT, dobj.getDynamicObject(UNIT).getPkValue(), currentRowIndex);
    }

    private Boolean isSameCurrency(long basecurrencyId, long purchasecurrencyId) {
        return basecurrencyId == purchasecurrencyId;
    }

    private void setCurrencyRate() {
        DataModelWrapper objWrapper = new DataModelWrapper(this.getModel());
        this.setCurrencyRate((IObjWrapper)objWrapper);
    }

    public void setCurrencyRate(IObjWrapper objWrapper) {
        DynamicObject dynObj = objWrapper.getDynamicObject();
        DynamicObject basecurrency = dynObj.getDynamicObject("basecurrency");
        DynamicObject purchasecurrency = dynObj.getDynamicObject("purchasecurrency");
        DynamicObject org = dynObj.getDynamicObject("org");
        Long exchangetableId = 0L;
        Long basecurrencyId = 0L;
        Long purchasecurrencyId = 0L;
        Long orgId = 0L;
        DynamicObject assetbook = null;
        if (org != null) {
            orgId = org.getLong("id");
        }
        if (orgId != 0L) {
            assetbook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id,exchangetable", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        }
        if (assetbook != null) {
            exchangetableId = assetbook.getLong("exchangetable");
            if (exchangetableId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d26\u7c3f\u672a\u8bbe\u7f6e\u6c47\u7387\u8868\u3002", (String)"FaPurcharseBillEditPlugin_11", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("exchangetable", (Object)exchangetableId);
        }
        if (basecurrency != null) {
            basecurrencyId = basecurrency.getLong("id");
        }
        if (purchasecurrency != null) {
            purchasecurrencyId = purchasecurrency.getLong("id");
        }
        if (null != basecurrency && null != purchasecurrency) {
            if (basecurrency.getString("number").equals(purchasecurrency.getString("number"))) {
                objWrapper.setValue("exchangerate", (Object)new BigDecimal(1).toString());
            } else {
                String exchangerateType = objWrapper.getValue("exchangeratetype").toString();
                BigDecimal exchangeRate = FaUtils.getExrate(exchangetableId, purchasecurrencyId, basecurrencyId, (Date)objWrapper.getValue("purchasedate"), exchangerateType);
                objWrapper.setValue("exchangerate", (Object)exchangeRate);
            }
        }
    }

    private void updateTaxamountAndNotaxamount(IDataModel model, BigDecimal totalamount, int amtprecision, int entryCurrentRowIndex) {
        DynamicObject taxratedyo = (DynamicObject)model.getValue("taxrate", entryCurrentRowIndex);
        BigDecimal taxrate = BigDecimal.ZERO;
        if (taxratedyo != null && taxratedyo.getString("taxrate") != null) {
            taxrate = new BigDecimal(taxratedyo.getString("taxrate"));
        }
        taxrate = taxrate.divide(new BigDecimal(100));
        BigDecimal taxamount = this.multi(totalamount, taxrate, amtprecision).divide(taxrate.add(BigDecimal.ONE), amtprecision, 4);
        model.setValue("taxamount", (Object)taxamount, entryCurrentRowIndex);
        model.setValue("origintaxamount", (Object)taxamount, entryCurrentRowIndex);
        BigDecimal notaxamount = totalamount.subtract(taxamount);
        model.setValue("notaxamount", (Object)notaxamount, entryCurrentRowIndex);
        model.setValue("originnotaxamount", (Object)notaxamount, entryCurrentRowIndex);
        model.setValue("origintotalamount", (Object)totalamount, entryCurrentRowIndex);
    }

    private BigDecimal multi(BigDecimal bigDecimal1, BigDecimal bigDecimal2, int scale) {
        return bigDecimal1.multiply(bigDecimal2).setScale(scale, RoundingMode.HALF_UP);
    }

    private BigDecimal divide(BigDecimal bigDecimal1, BigDecimal bigDecimal2, int scale) {
        return bigDecimal1.divide(bigDecimal2, scale, RoundingMode.HALF_UP);
    }

    private void setOriginValuesByEntry(BigDecimal newUnitPrice, BigDecimal assetqty, BigDecimal taxrate, DynamicObject entry, int purAmtprecision, int amtprecision, BigDecimal exchangeRate, String exchangeType, IDataModel model, int entryCurrentRowIndex, BigDecimal originTaxAmountImport, BigDecimal taxAmountImport) {
        BigDecimal originTotalAmount = this.multi(newUnitPrice, assetqty, purAmtprecision);
        BigDecimal originTaxAmount = this.multi(originTotalAmount, taxrate, purAmtprecision).divide(taxrate.add(BigDecimal.ONE), purAmtprecision, RoundingMode.HALF_UP);
        if (originTaxAmountImport != null && originTotalAmount.compareTo(originTaxAmountImport) >= 0) {
            originTaxAmount = originTaxAmountImport;
        }
        BigDecimal originNotaxAmount = originTotalAmount.subtract(originTaxAmount);
        if (entry != null && model == null) {
            entry.set("origintotalamount", (Object)originTotalAmount);
            entry.set("origintaxamount", (Object)originTaxAmount);
            entry.set("originnotaxamount", (Object)originNotaxAmount);
        } else if (entry == null && model != null) {
            model.setValue("origintotalamount", (Object)originTotalAmount, entryCurrentRowIndex);
            model.setValue("origintaxamount", (Object)originTaxAmount, entryCurrentRowIndex);
            model.setValue("originnotaxamount", (Object)originNotaxAmount, entryCurrentRowIndex);
        }
        this.setOtherValuesByEntry(entry, amtprecision, exchangeRate, exchangeType, originTaxAmount, originTotalAmount, model, entryCurrentRowIndex, taxAmountImport);
    }

    private void setOtherValuesByEntry(DynamicObject entry, int amtprecision, BigDecimal exchangeRate, String exchangeType, BigDecimal originTaxAmount, BigDecimal originTotalAmount, IDataModel model, int entryCurrentRowIndex, BigDecimal taxAmountImport) {
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal totalamount = BigDecimal.ZERO;
        BigDecimal notaxAmount = BigDecimal.ZERO;
        if (ExchangeTypeEnum.A.getValue().equals(exchangeType)) {
            taxAmount = this.multi(originTaxAmount, exchangeRate, amtprecision);
            totalamount = this.multi(originTotalAmount, exchangeRate, amtprecision);
            notaxAmount = totalamount.subtract(taxAmount);
        } else if (ExchangeTypeEnum.B.getValue().equals(exchangeType)) {
            if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                taxAmount = originTaxAmount;
                totalamount = originTotalAmount;
            } else {
                taxAmount = this.divide(originTaxAmount, exchangeRate, amtprecision);
                totalamount = this.divide(originTotalAmount, exchangeRate, amtprecision);
                notaxAmount = totalamount.subtract(taxAmount);
            }
        }
        if (taxAmountImport != null && totalamount.compareTo(taxAmountImport) >= 0) {
            taxAmount = taxAmountImport;
            notaxAmount = totalamount.subtract(taxAmount);
        }
        if (entry != null && model == null) {
            entry.set("taxamount", (Object)taxAmount);
            entry.set("totalamount", (Object)totalamount);
            entry.set("notaxamount", (Object)notaxAmount);
        } else if (entry == null && model != null) {
            model.setValue("taxamount", (Object)taxAmount, entryCurrentRowIndex);
            model.setValue("totalamount", (Object)totalamount, entryCurrentRowIndex);
            model.setValue("notaxamount", (Object)notaxAmount, entryCurrentRowIndex);
        }
    }

    private Date getDate(Object dateObj) {
        if (dateObj == null) {
            return null;
        }
        if (dateObj instanceof Date) {
            return (Date)dateObj;
        }
        try {
            Date date = DateUtil.getShortDate().parse(dateObj.toString());
            return date;
        }
        catch (Exception exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"FaPurcharseBillEditPlugin_12", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private BigDecimal getBigDecimal(Map<String, Object> sourceData, String entryName, int index, String propertyName) {
        JSONObject coll;
        JSONArray colls;
        if (sourceData instanceof JSONObject && (colls = (JSONArray)sourceData.get(entryName)) != null && index < colls.size() && (coll = (JSONObject)colls.get(index)) != null) {
            return coll.getBigDecimal(propertyName);
        }
        return null;
    }
}

