/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaChangeBillUtil;
import kd.fi.fa.business.utils.FaChangeTypeUtils;
import kd.fi.fa.business.utils.FaDepreAdjustUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaRealCardF7Plugin
extends AbstractListPlugin {
    private static final String ENTITYNAME = "fa_card_real_base";
    private static final Map<String, String> sprecialMap = new HashMap<String, String>();
    private static final Set<String> hideFilterField = new HashSet<String>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"querybtn", "btnok"});
    }

    private Set<String> getSprcialEntity() {
        return sprecialMap.keySet();
    }

    private Date getDate(IDataModel parentModel) {
        String entity = parentModel.getDataEntityType().getName();
        Date date = (Date)parentModel.getValue(sprecialMap.get(entity));
        return date;
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        boolean checkRes = this.checkRealCard();
        evt.setCancel(!checkRes);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        boolean checkRes = this.checkRealCard();
        evt.setCancel(!checkRes);
    }

    private boolean checkRealCard() {
        IDataModel parentModel = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).getModel();
        if (parentModel != null) {
            HashMap<Object, String> cardId2Number;
            ListSelectedRowCollection selectorIds;
            BillList billList;
            String parentEntity = parentModel.getDataEntityType().getName();
            if (this.getSprcialEntity().contains(parentEntity)) {
                String dataAssetCardNumber;
                billList = (BillList)this.getView().getControl("billlistap");
                selectorIds = billList.getSelectedRows();
                cardId2Number = new HashMap<Object, String>(selectorIds.size());
                for (ListSelectedRow row : selectorIds) {
                    cardId2Number.put(row.getPrimaryKeyValue(), row.getNumber());
                }
                HashSet cardIds = new HashSet(selectorIds.size());
                HashSet<String> cardNumbers = new HashSet<String>(selectorIds.size());
                for (ListSelectedRow row : selectorIds) {
                    cardIds.add((Long)row.getPrimaryKeyValue());
                    cardNumbers.add(row.getNumber());
                }
                String msg = FaUtils.checkRealCardBizStatus((Set)cardIds);
                if (!msg.isEmpty()) {
                    this.getView().showErrorNotification(msg);
                    return false;
                }
                Date date = this.getDate(parentModel);
                long orgId = (Long)parentModel.getValue("org_id");
                Iterator it = selectorIds.iterator();
                ListSelectedRow currRow = null;
                StringBuilder sb = new StringBuilder();
                int errCount = 0;
                Set existCards = new HashSet(3);
                Set existCardNumbers = new HashSet(8);
                if ("fa_asset_devalue".equalsIgnoreCase(parentEntity)) {
                    existCards = FaUtils.getDecValCard((DynamicObject)parentModel.getDataEntity(), (Long)orgId, (Boolean)false, (Set)cardIds);
                    while (it.hasNext()) {
                        currRow = (ListSelectedRow)it.next();
                        if (existCards.contains(currRow.getPrimaryKeyValue())) continue;
                        ++errCount;
                        if (sb.length() > 0) {
                            sb.append("\u3001");
                        }
                        sb.append(currRow.getNumber());
                    }
                    if (sb.length() > 0) {
                        FaUtils.showErrorNoDevRealCardMsg((int)errCount, (String)sb.toString(), null, (IFormView)this.getView());
                        return false;
                    }
                } else if ("fa_mergebill".equalsIgnoreCase(parentEntity)) {
                    if (!this.mergeCardCheck(cardIds)) {
                        return false;
                    }
                } else if ("fa_assetsplitbill".equals(parentEntity) && !(dataAssetCardNumber = FaUtils.checkDataAssetRealCard((Set)cardIds)).isEmpty()) {
                    String part2 = ResManager.loadKDString((String)"\u5efa\u5361\u65b9\u5f0f\u4e3a\u3010\u6570\u636e\u5361\u7247\u3011\uff0c\u4e0d\u652f\u6301\u505a\u62c6\u5206\u4e1a\u52a1\u3002", (String)"FaRealCardF7Plugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                    FaUtils.showErrorSourceFlagRealCardMsg((int)dataAssetCardNumber.split(",").length, (String)dataAssetCardNumber, (String)part2, (IFormView)this.getView());
                    return false;
                }
                BusyTypeDetailEnum busyTypeEnum = BusyTypeDetailEnum.REAL_FIN_CHG;
                if (parentEntity.equals("fa_change_dept")) {
                    DynamicObject changeType = (DynamicObject)parentModel.getValue("changetype");
                    if (StringUtils.isEmpty((Object)changeType)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d8\u66f4\u7c7b\u578b", (String)"FaRealCardF7Plugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    Map changeItemID2TopMap = FaChangeBillUtil.getChangeItemMap();
                    busyTypeEnum = FaChangeBillUtil.getChangeTypeDetail4F7((DynamicObject)changeType, (Map)changeItemID2TopMap);
                    String checkMsg = FaRealCardF7Plugin.checkFinCardDepreMethodChange(changeType, cardId2Number);
                    if (!StringUtils.isEmpty((Object)checkMsg)) {
                        this.getView().showErrorNotification(checkMsg);
                        return false;
                    }
                } else if (parentEntity.equals("fa_asset_devalue") || parentEntity.equals("fa_depreadjustbill") || parentEntity.equals("fa_workload") || parentEntity.equals("fa_workload_batch")) {
                    busyTypeEnum = BusyTypeDetailEnum.FIN_CHG;
                }
                existCardNumbers = FaUtils.getCurRealCard4Future((Date)date, (Long)orgId, (Boolean)false, (Set)cardIds, cardNumbers, (BusyTypeDetailEnum)busyTypeEnum);
                it = selectorIds.iterator();
                currRow = null;
                sb = new StringBuilder();
                errCount = 0;
                while (it.hasNext()) {
                    currRow = (ListSelectedRow)it.next();
                    if (existCardNumbers.contains(currRow.getNumber())) continue;
                    ++errCount;
                    if (sb.length() > 0) {
                        sb.append("\u3001");
                    }
                    sb.append(currRow.getNumber());
                }
                if (sb.length() > 0) {
                    FaUtils.showErrorRealCardMsg((int)errCount, (String)sb.toString(), null, (IFormView)this.getView());
                    return false;
                }
            }
            if ("fa_depreadjustbill".equals(parentEntity)) {
                Object periodPk;
                Object depreUsePk;
                billList = (BillList)this.getView().getControl("billlistap");
                selectorIds = billList.getSelectedRows();
                cardId2Number = new HashMap(selectorIds.size());
                for (ListSelectedRow row : selectorIds) {
                    cardId2Number.put(row.getPrimaryKeyValue(), row.getNumber());
                }
                Object orgPk = ((DynamicObject)parentModel.getValue("org")).getPkValue();
                String checkMsg = FaRealCardF7Plugin.checkFinCardByDepreAdjust(orgPk, depreUsePk = ((DynamicObject)parentModel.getValue("depreuse")).getPkValue(), periodPk = ((DynamicObject)parentModel.getValue("period")).getPkValue(), cardId2Number);
                if (checkMsg != null) {
                    this.getView().showErrorNotification(checkMsg);
                    return false;
                }
                String msg = FaDepreAdjustUtils.getAlreadyDepAdjustCardMsg((Object)orgPk, (Object)depreUsePk, (Object)periodPk, cardId2Number.keySet());
                if (msg != null) {
                    this.getView().showErrorNotification(msg);
                    return false;
                }
            }
        }
        return true;
    }

    protected static String checkFinCardByDepreAdjust(Object orgId, Object depreUseId, Object periodId, Map<Object, String> cardId2Number) {
        Set depreMethodIds = FaUtils.getDepreMethodByType((String)"5");
        QFilter[] filters = new QFilter[]{new QFilter("depreuse", "=", depreUseId), new QFilter("org", "=", orgId), new QFilter("bizperiod", "=", periodId), new QFilter("isneeddepre", "=", (Object)Boolean.FALSE), new QFilter("monthdepre", "!=", (Object)0), new QFilter("depremethod", "not in", (Object)depreMethodIds), new QFilter("realcardmasterid", "in", cardId2Number.keySet())};
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FaRealCardF7.checkFinCardByDepreAdjust", (String)"fa_card_fin", (String)"realcardmasterid", (QFilter[])filters, null);
        HashSet<Object> realCards = new HashSet<Object>(cardId2Number.size());
        while (dataSet.hasNext()) {
            realCards.add(dataSet.next().get("realcardmasterid"));
        }
        HashSet<String> numbers = new HashSet<String>(cardId2Number.size());
        for (Map.Entry<Object, String> entry : cardId2Number.entrySet()) {
            if (!realCards.add(entry.getKey())) continue;
            numbers.add(entry.getValue());
        }
        if (numbers.isEmpty()) {
            return null;
        }
        return String.format(ResManager.loadKDString((String)"\u5df2\u8ba1\u63d0\u6298\u65e7\u4e14\u6298\u65e7\u989d\u4e0d\u4e3a0\u3001\u975e\u5de5\u4f5c\u91cf\u6cd5\u7684\u5361\u7247\u624d\u80fd\u505a\u6298\u65e7\u8c03\u6574\u5355\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaRealCardF7Plugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), String.join((CharSequence)"\u3001 ", numbers));
    }

    private boolean mergeCardCheck(Set<Long> cardIds) {
        if (cardIds.isEmpty()) {
            return true;
        }
        IFormView view = this.getView();
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"number", "sourceflag"}), (QFilter[])new QFilter[]{new QFilter("id", "in", cardIds)});
        StringBuilder leaseContractCard = new StringBuilder();
        StringBuilder dataAssetCard = new StringBuilder();
        List<String> leaseFlag = Arrays.asList("LEASECONTRACT", "INITLEASECONTRACT");
        int i = 0;
        for (DynamicObject realCard : realCards) {
            String sourceFlag = realCard.getString("sourceflag");
            if (leaseFlag.contains(sourceFlag)) {
                if (leaseContractCard.length() > 0) {
                    leaseContractCard.append("\u3001");
                }
                leaseContractCard.append(realCard.getString("number"));
                ++i;
                continue;
            }
            if (!SourceFlagEnum.DATAASSET.name().equals(sourceFlag)) continue;
            if (dataAssetCard.length() > 0) {
                dataAssetCard.append("\u3001");
            }
            dataAssetCard.append(realCard.getString("number"));
        }
        if (i > 0) {
            if (leaseContractCard.length() > 0) {
                FaUtils.showErrorIsLeaseContractCardMsg((int)i, (String)leaseContractCard.toString(), null, (IFormView)view);
            } else if (dataAssetCard.length() > 0) {
                String part2 = ResManager.loadKDString((String)"\u5efa\u5361\u65b9\u5f0f\u4e3a\u3010\u6570\u636e\u5361\u7247\u3011\uff0c\u4e0d\u652f\u6301\u505a\u5408\u5e76\u4e1a\u52a1\u3002", (String)"FaRealCardF7Plugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                FaUtils.showErrorSourceFlagRealCardMsg((int)i, (String)dataAssetCard.toString(), (String)part2, (IFormView)this.getView());
            }
            return false;
        }
        String finField = Fa.comma((String[])new String[]{"number", "period", "org"});
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)finField, (QFilter[])new QFilter[]{new QFilter("realcardmasterid", "in", cardIds), new QFilter("endperiod", "=", (Object)99999999999L)});
        if (finCards.isEmpty()) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u5b9e\u7269\u5361\u7247\u627e\u4e0d\u5230\u8d22\u52a1\u5361\u7247", (String)"FaRealCardF7Plugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return false;
        }
        Long orgId = null;
        HashMap<String, Long> number2BizPeriodIdMap = new HashMap<String, Long>(finCards.size());
        for (DynamicObject finCard : finCards) {
            if (orgId == null) {
                orgId = finCard.getLong("org");
            }
            number2BizPeriodIdMap.putIfAbsent(finCard.getString("number"), finCard.getLong("period"));
        }
        String assetField = Fa.comma((String[])new String[]{"curperiod"});
        DynamicObject assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)assetField, (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("ismainbook", "=", (Object)true)});
        if (assetBook == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u4e3b\u8d26\u7c3f", (String)"FaRealCardF7Plugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean enableCurPeriodBiz = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)orgId);
        long curPeriodId = assetBook.getLong("curperiod");
        ArrayList numbers = new ArrayList(number2BizPeriodIdMap.size());
        for (Map.Entry num2Period : number2BizPeriodIdMap.entrySet()) {
            if ((curPeriodId > (Long)num2Period.getValue() || enableCurPeriodBiz) && (curPeriodId >= (Long)num2Period.getValue() || !enableCurPeriodBiz)) continue;
            numbers.add(num2Period.getKey());
        }
        if (!numbers.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String number : numbers) {
                if (sb.length() > 0) {
                    sb.append("\u3001");
                }
                sb.append(number);
            }
            FaUtils.showErrorIsCurPeriodCardMsg((int)numbers.size(), (String)sb.toString(), null, (IFormView)view);
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        QFilter qFilter = this.getFilterGridFilter();
        if (qFilter != null) {
            this.getView().updateView();
        }
    }

    private QFilter getFilterGridFilter() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)ENTITYNAME), filterCondition);
        filterBuilder.buildFilter(false);
        QFilter qFilter = filterBuilder.getQFilter();
        return qFilter;
    }

    public void setFilter(SetFilterEvent e) {
        QFilter qFilter = this.getFilterGridFilter();
        if (qFilter != null) {
            List qFilters = e.getQFilters();
            qFilters.add(qFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ENTITYNAME);
        EntityTypeUtil helper = new EntityTypeUtil();
        List cols = helper.getFilterColumns((IDataEntityType)entityType, true);
        for (int i = 0; i < cols.size(); ++i) {
            Map col = (Map)cols.get(i);
            String fieldName = (String)col.get("fieldName");
            if (!hideFilterField.contains(fieldName)) continue;
            cols.remove(i);
            --i;
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("ffiltergrid");
        filterGrid.setFilterColumns(cols);
        filterGrid.setEntityNumber(ENTITYNAME);
    }

    private static String checkFinCardDepreMethodChange(DynamicObject changeType, Map<Object, String> cardId2Number) {
        if (FaChangeTypeUtils.isSystemPreDepreMethodChg4Workload((DynamicObject)changeType)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"5").or(new QFilter("type", "=", (Object)"51"))};
            DynamicObjectCollection workloadAndDayDepreMethods = QueryServiceHelper.query((String)"fa_depremethod", (String)"id", (QFilter[])qFilters);
            HashSet workloadAndDayDepreMethodIds = new HashSet(workloadAndDayDepreMethods.size());
            workloadAndDayDepreMethods.stream().forEach(t -> workloadAndDayDepreMethodIds.add(t.getLong("id")));
            DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"realcard", "depremethod"}), (QFilter[])new QFilter[]{new QFilter("realcard", "in", cardId2Number.keySet())});
            HashSet<String> checkFailedNumbers = new HashSet<String>(finCards.size());
            for (DynamicObject finCard : finCards) {
                Long realCardId = finCard.getLong("realcard");
                Long depreMethodId = finCard.getLong("depremethod");
                if (!workloadAndDayDepreMethodIds.contains(depreMethodId)) continue;
                checkFailedNumbers.add(cardId2Number.get(realCardId));
            }
            if (CollectionUtils.isNotEmpty(checkFailedNumbers)) {
                return String.format(ResManager.loadKDString((String)"\u6298\u65e7\u65b9\u6cd5\u53d8\u66f4\uff08\u53d8\u66f4\u540e\u5de5\u4f5c\u91cf\u6cd5\uff09\u4e0d\u652f\u6301\u53d8\u66f4\u5de5\u4f5c\u91cf\u6cd5/\u6309\u65e5\u6298\u65e7\u6cd5\u7684\u5361\u7247\u3002\u4e0d\u6ee1\u8db3\u8981\u6c42\u5361\u7247\u8d44\u4ea7\u7f16\u7801\uff1a%s", (String)"FaRealCardF7Plugin_11", (String)"fi-fa-formplugin", (Object[])new Object[0]), checkFailedNumbers.stream().collect(Collectors.joining(",")));
            }
        }
        return null;
    }

    static {
        sprecialMap.put("fa_clearbill", "cleardate");
        sprecialMap.put("fa_clearapplybill", "cleardate");
        sprecialMap.put("fa_change_dept", "changedate");
        sprecialMap.put("fa_dispatch", "dispatchdate");
        sprecialMap.put("fa_dispatch_in", "dispatchdate");
        sprecialMap.put("fa_recalculate", "bizdate");
        sprecialMap.put("fa_asset_devalue", "businessdate");
        sprecialMap.put("fa_assetsplitbill", "splitdate");
        sprecialMap.put("fa_workload_batch", "date");
        sprecialMap.put("fa_workload", "date");
        sprecialMap.put("fa_mergebill", "mergedate");
        sprecialMap.put("fa_restartrealbill", "restartdate");
        hideFilterField.add("srcbillnumber");
        hideFilterField.add("org.number");
        hideFilterField.add("org.name");
        hideFilterField.add("billstatus");
        hideFilterField.add("sourceentryid");
        hideFilterField.add("picturefield");
    }
}

