/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.FilterColumn;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class FaStorePlaceRefreshGroupPlugin
extends AbstractTreeListPlugin {
    private static final String FA_STORE_PLACE_GROUP = "fa_storeplace_group";
    private static final String STORE_PLACE_GROUP_ROOT = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String USE_ORG_ID = "useorg.id";
    private static final String CACHE_KEY_FIRST_LOAD = "cache_key_first_load";
    private static final String BASE_DATA_FILTER_KEY = "fuseorgid=";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Long useOrgId4F7 = this.getUseOrgFromBaseDataFilter();
        if (useOrgId4F7 != null) {
            this.refreshGroupTree(useOrgId4F7);
        } else {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn column : commonFilterColumns) {
                String firstLoad;
                String fieldName = column.getFieldName();
                if (!USE_ORG_ID.equals(fieldName) || !StringUtils.isBlank((CharSequence)(firstLoad = this.getPageCache().get(CACHE_KEY_FIRST_LOAD)))) continue;
                List defaultValues = column.getDefaultValues();
                String useOrgIdStr = (String)defaultValues.get(0);
                Long useOrgId = Long.parseLong(useOrgIdStr);
                this.refreshGroupTree(useOrgId);
                this.getPageCache().put(CACHE_KEY_FIRST_LOAD, "true");
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        SearchClickEvent evt = args.getSearchClickEvent();
        Map currentCommonFilter = evt.getCurrentCommonFilter();
        if (currentCommonFilter == null) {
            return;
        }
        List fieldNameList = (List)currentCommonFilter.get("FieldName");
        for (Object fieldName : fieldNameList) {
            if (!USE_ORG_ID.equals(fieldName)) continue;
            List valueList = (List)currentCommonFilter.get("Value");
            Long orgId = Long.parseLong((String)valueList.get(0));
            this.refreshGroupTree(orgId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        if (this.getControlFilters() != null) {
            List filter = this.getControlFilters().getFilter(USE_ORG_ID);
            if (filter.isEmpty()) {
                return;
            }
            String useOrgIdStr = (String)filter.get(0);
            long useOrgId = Long.parseLong(useOrgIdStr);
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)FA_STORE_PLACE_GROUP, (Long)useOrgId);
            ListView listView = (ListView)this.getView();
            ITreeListView treeListView = listView.getTreeListView();
            TreeListModel treeListModel = (TreeListModel)treeListView.getTreeModel();
            long count = treeListModel.getTreeFilter().stream().filter(v -> v.getProperty().contains(BASE_DATA_FILTER_KEY)).count();
            if (count == 0L) {
                treeListModel.getTreeFilter().add(baseDataFilter);
            }
        }
    }

    private void refreshGroupTree(Long orgId) {
        ListView listView = (ListView)this.getView();
        ITreeListView treeListView = listView.getTreeListView();
        TreeListModel treeListModel = (TreeListModel)treeListView.getTreeModel();
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)FA_STORE_PLACE_GROUP, (Long)orgId);
        treeListModel.getTreeFilter().add(baseDataFilter);
        treeListModel.setCurrentNodeId((Object)STORE_PLACE_GROUP_ROOT);
        treeListView.refreshTreeView();
    }

    private Long getUseOrgFromBaseDataFilter() {
        ListShowParameter listShowParam = (ListShowParameter)this.getView().getFormShowParameter();
        ListFilterParameter listFilterParam = listShowParam.getListFilterParameter();
        List qFilters = listFilterParam.getQFilters();
        for (QFilter filter : qFilters) {
            String property = filter.getProperty();
            if (!property.contains(BASE_DATA_FILTER_KEY)) continue;
            int index = property.indexOf(BASE_DATA_FILTER_KEY);
            String useOrgIdStr = property.substring(index += BASE_DATA_FILTER_KEY.length());
            return Long.parseLong(useOrgIdStr);
        }
        return null;
    }
}

