/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.common.util.Fa;

public class FaUpWorkLoadUniteEditPlugin
extends AbstractFormPlugin {
    private static final String WORKLOADENTRY = "workloadentry";
    private static final String ASSETCAT = "assetcat";
    private static final String FIN_CARD = "fincard";
    public static final String NEW_UNIT = "new_unit";

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeBindData(EventObject e) {
        String orgListStr;
        super.beforeBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        IDataModel model = this.getModel();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(16);
        Object depreUseIdObj = param.getCustomParam("depreUseId");
        if (Objects.nonNull(depreUseIdObj)) {
            Long depreUseId = Long.parseLong(depreUseIdObj.toString());
            QFilter qDepreUse = new QFilter("depreuse", "=", (Object)depreUseId);
            qFilterList.add(qDepreUse);
        }
        if (StringUtils.isNotBlank((CharSequence)(orgListStr = (String)param.getCustomParam("orgId")))) {
            List orgList = SerializationUtils.fromJsonStringToList((String)orgListStr, Long.class);
            QFilter qOrg = new QFilter("org", "in", (Object)orgList);
            qFilterList.add(qOrg);
        }
        qFilterList.add(new QFilter(FaDaoOrmImpl.dot((String[])new String[]{"depremethod", "type"}), "=", (Object)"5"));
        qFilterList.add(new QFilter("endperiod", "=", (Object)99999999999L));
        qFilterList.add(new QFilter("workloadunit", "=", (Object)0L));
        String selectProperties = Fa.comma((String[])new String[]{"id"});
        DynamicObject[] faFinCardArray = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selectProperties, (QFilter[])qFilterList.toArray(new QFilter[0]));
        ArrayList<DynamicObject> faFinCardDynObjList = new ArrayList<DynamicObject>(faFinCardArray.length);
        faFinCardDynObjList.addAll(Arrays.asList(faFinCardArray));
        int index = 0;
        AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
        TableValueSetter setter = new TableValueSetter(new String[0]);
        dataModel.beginInit();
        for (DynamicObject faFinCardDyn : faFinCardDynObjList) {
            setter.set(FIN_CARD, (Object)faFinCardDyn, index);
            setter.set("fincard_id", (Object)faFinCardDyn.getLong("id"), index);
            ++index;
        }
        dataModel.batchCreateNewEntryRow(WORKLOADENTRY, setter);
        dataModel.endInit();
        this.getView().updateView(WORKLOADENTRY);
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String operationKey = e.getOperationKey();
        if ("setworkloadunit".equals(operationKey)) {
            this.updateUnit();
        }
        if ("setunitfromassetpolicy".equals(operationKey)) {
            this.setUnitFromAssetPolicy();
        }
    }

    private void setUnitFromAssetPolicy() {
        Long assetBookId;
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection workLoadEntry = model.getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection(WORKLOADENTRY);
        HashMap<Long, Set> assetBook2AssetCats = new HashMap<Long, Set>(workLoadEntry.size());
        HashSet<Long> assetBookIdSet = new HashSet<Long>(workLoadEntry.size());
        for (DynamicObject dynamicObject : workLoadEntry) {
            DynamicObject assetCat;
            DynamicObject faFinCard = dynamicObject.getDynamicObject(FIN_CARD);
            DynamicObject assetBook = faFinCard.getDynamicObject("assetbook");
            if (assetBook == null || (assetCat = faFinCard.getDynamicObject(ASSETCAT)) == null) continue;
            Long l = assetCat.getLong("id");
            assetBookId = assetBook.getLong("id");
            Set assetCats = assetBook2AssetCats.computeIfAbsent(assetBookId, v -> new HashSet(workLoadEntry.size()));
            assetCats.add(l);
            assetBookIdSet.add(assetBookId);
        }
        HashMap<Long, Long> assetBook2DepreSystemIdMap = new HashMap<Long, Long>(workLoadEntry.size());
        String selectFields = Fa.comma((String[])new String[]{"id", "depresystem"});
        DynamicObjectCollection assetBookDynObjColl = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])new QFilter("id", "in", assetBookIdSet).toArray());
        for (Object assetBookDynObj : assetBookDynObjColl) {
            long l = assetBookDynObj.getLong("id");
            long v2 = assetBookDynObj.getLong("depresystem");
            assetBook2DepreSystemIdMap.put(l, v2);
        }
        HashMap depreSystemAndCatBatchMap = new HashMap(assetBook2DepreSystemIdMap.size());
        for (Map.Entry entry : assetBook2AssetCats.entrySet()) {
            assetBookId = (Long)entry.getKey();
            Long depreSystemId = (Long)assetBook2DepreSystemIdMap.get(assetBookId);
            HashSet<Long> depreSystemIdSet = new HashSet<Long>();
            depreSystemIdSet.add(depreSystemId);
            Set assetCatIds = (Set)assetBook2AssetCats.get(assetBookId);
            depreSystemAndCatBatchMap.putAll(AssetPolicyUtil.getByDepreSystemAndCatBatch(depreSystemIdSet, (Set)assetCatIds));
        }
        for (int i = 0; i < workLoadEntry.size(); ++i) {
            Object object = model.getValue(NEW_UNIT, i);
            if (Objects.nonNull(object)) continue;
            DynamicObject faFinCard = ((DynamicObject)workLoadEntry.get(i)).getDynamicObject(FIN_CARD);
            DynamicObject assetCatDynObj = faFinCard.getDynamicObject(ASSETCAT);
            Long catPk = (Long)assetCatDynObj.getPkValue();
            Long assetBookId2 = (Long)faFinCard.getDynamicObject("assetbook").getPkValue();
            Long depreSystemId = (Long)assetBook2DepreSystemIdMap.get(assetBookId2);
            Map longDynamicObjectMap = (Map)depreSystemAndCatBatchMap.get(depreSystemId);
            DynamicObject assetPolicy = (DynamicObject)longDynamicObjectMap.get(catPk);
            if (assetPolicy == null) continue;
            model.setValue(NEW_UNIT, assetPolicy.get("workloadunit"), i);
        }
        this.getView().updateView(WORKLOADENTRY);
    }

    private void updateUnit() {
        DynamicObject upgradeModel = this.getModel().getDataEntity();
        DynamicObjectCollection workLoadEntry = upgradeModel.getDynamicObjectCollection(WORKLOADENTRY);
        ArrayList<Object[]> updateFaCardFinParams = new ArrayList<Object[]>(workLoadEntry.size());
        ArrayList<Object[]> updateFaWorkLoadParams = new ArrayList<Object[]>(workLoadEntry.size());
        ArrayList<String> precisionErrorCardNumber = new ArrayList<String>(16);
        for (DynamicObject dy : workLoadEntry) {
            DynamicObject finCard = dy.getDynamicObject(FIN_CARD);
            String number = finCard.getString("number");
            long orgId = finCard.getLong("org.id");
            DynamicObject unit = dy.getDynamicObject(NEW_UNIT);
            if (Objects.isNull(unit)) continue;
            if (unit.getInt("precision") < 2) {
                precisionErrorCardNumber.add(number);
                continue;
            }
            long depreUseId = finCard.getDynamicObject("depreuse").getLong("id");
            long workLoadUnitId = unit.getLong("id");
            updateFaCardFinParams.add(new Object[]{workLoadUnitId, number, depreUseId, orgId});
            long realCardId = finCard.getDynamicObject("realcard").getLong("id");
            updateFaWorkLoadParams.add(new Object[]{workLoadUnitId, realCardId, depreUseId, orgId});
        }
        if (!precisionErrorCardNumber.isEmpty()) {
            String errorCardNumber = String.join((CharSequence)"\uff0c", precisionErrorCardNumber);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801: %s \u7ef4\u62a4\u7684\u5355\u4f4d\u5c0f\u4e8e\u4e24\u4f4d, \u7cbe\u5ea6\u5fc5\u987b\u662f\u4e24\u4f4d\u53ca\u4ee5\u4e0a\u3002", (String)"FaUpWorkLoadUniteEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), errorCardNumber));
        }
        if (updateFaCardFinParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"update t_fa_card_fin set fworkloadunitid = ?  WHERE fnumber = ? AND fdepreuseid = ? AND forg = ?", updateFaCardFinParams);
        }
        if (updateFaWorkLoadParams.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)"UPDATE t_fa_workload SET fworkloadunitid = ?  WHERE frealcardid = ? AND fdepreuseid = ? AND forgid = ?", updateFaWorkLoadParams);
        }
    }
}

