/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.formplugin.AbstractWorkLoadPlugin;

public class FaWorkLoadBatchEditPlugin
extends AbstractWorkLoadPlugin {
    private static final String BATCH_SAVE = "batchsave";
    private static final String CACHE_FIRST_LOAD = "cache_first_load";

    @Override
    protected QFilter getRealCardFilter() {
        Set<Long> realCardIds = super.getUsedRealCardId();
        DynamicObjectCollection entry = this.getModel().getEntryEntity("workloadentry");
        HashSet<Long> selectedRealCardIds = new HashSet<Long>(16);
        for (DynamicObject row : entry) {
            DynamicObject realCard = row.getDynamicObject("realcard");
            if (realCard == null) continue;
            long realCardId = realCard.getLong("id");
            selectedRealCardIds.add(realCardId);
        }
        realCardIds.removeAll(selectedRealCardIds);
        return new QFilter("id", "in", realCardIds);
    }

    public void afterCreateNewData(EventObject e) {
        this.setOrg();
        this.setDepreUse();
        super.setCurPeriodAndDate();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (BATCH_SAVE.equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.getView().returnDataToParent((Object)true);
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void setOrg() {
        if (this.getPageCache().get(CACHE_FIRST_LOAD) != null) {
            return;
        }
        FormShowParameter param = this.getView().getFormShowParameter();
        String orgIdStr = (String)param.getCustomParam("orgId");
        if (StringUtils.isNotBlank((CharSequence)orgIdStr)) {
            long orgId = Long.parseLong(orgIdStr);
            this.getModel().setValue("org", (Object)orgId);
        }
        this.getPageCache().put(CACHE_FIRST_LOAD, "true");
    }

    private void setDepreUse() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String depreUseIdStr = (String)param.getCustomParam("depreUseId");
        if (StringUtils.isNotBlank((CharSequence)depreUseIdStr)) {
            long depreUseId = Long.parseLong(depreUseIdStr);
            this.getModel().setValue("depreuse", (Object)depreUseId);
        } else {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            long orgId = org.getLong("id");
            DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)orgId);
            if (mainBook == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e3b\u8d26\u7c3f\u6298\u65e7\u7528\u9014\u3002", (String)"FaWorkLoadBatchEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            long depreUseId = mainBook.getLong("depreuse");
            this.getModel().setValue("depreuse", (Object)depreUseId);
        }
    }
}

