/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.constants.MainPageConstant;
import kd.fi.fa.utils.FaFormUtils;

public class MainPageOverviewCard
extends AbstractFormPlugin {
    private static final String ALGO = "kd.fi.fa.formplugin.MainPageOverviewCard";
    private long orgid;
    private long bookid;
    private String currencySign;
    private long curPeriodId;
    private long depreUseId;
    private long beforeInitPeriodId = 0L;
    private long prevPeriodId = 0L;
    private final List<Card> curCardLst = new ArrayList<Card>();
    private boolean hasPrevCard = false;
    private final List<Card> prevCardLst = new ArrayList<Card>();
    private static final int currencyAmtprecision = 2;
    private Format currencyFormat;
    private String unitValue;
    private static final Set<String> REGISTER_CHANGE_LABEL = new HashSet<String>(Arrays.asList("all_unit", "depre_unit", "overage_unit", "new_unit", "delete_unit"));

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        boolean success = this.initCtx();
        if (success) {
            this.initCard();
            this.initFormat();
            this.fillData();
        }
        this.refreshUnit();
    }

    private void initFormat() {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId());
        fobj.getCurrencyFormat().setCurrencySymbols(this.currencySign);
        fobj.getCurrencyFormat().setMinimumFractionDigits(2);
        this.currencyFormat = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(fobj);
    }

    private void fillData() {
        BigDecimal sumNetAmount = this.all();
        this.depre();
        this.overage(sumNetAmount);
        this.fillNewData();
        this.fillDeleteData();
    }

    private void initCard() {
        QFilter prevPeriodFilter = null;
        if (this.prevPeriodId >= this.beforeInitPeriodId) {
            prevPeriodFilter = new QFilter("bizperiod", "<=", (Object)this.prevPeriodId).and(new QFilter("endperiod", ">", (Object)this.prevPeriodId));
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)this.orgid), new QFilter("depreuse", "=", (Object)this.depreUseId), new QFilter("assetbook", "=", (Object)this.bookid), new QFilter("billstatus", "=", (Object)BillStatus.C.toString()), prevPeriodFilter};
            this.hasPrevCard = QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])filters);
        }
        QFilter curPeriodFilter = new QFilter("bizperiod", "<=", (Object)this.curPeriodId).and(new QFilter("endperiod", ">", (Object)this.curPeriodId));
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)this.orgid), new QFilter("depreuse", "=", (Object)this.depreUseId), new QFilter("assetbook", "=", (Object)this.bookid), new QFilter("billstatus", "=", (Object)BillStatus.C.toString()), curPeriodFilter};
        String selectFields = "bizperiod,netamount,monthdepre,preusingamount,depredamount,period,clearperiod,id";
        if (!this.hasPrevCard) {
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"fa_card_fin", (String)selectFields, (QFilter[])filters, (String)"bizperiod asc");){
                for (Row row : ds) {
                    if (row.getLong("bizperiod") > this.prevPeriodId) {
                        this.appendCard(this.curCardLst, row);
                        continue;
                    }
                    this.appendCard(this.prevCardLst, row);
                }
            }
        } else {
            QFilter[] filters1 = new QFilter[5];
            System.arraycopy(filters, 0, filters1, 0, 4);
            filters1[4] = prevPeriodFilter;
            DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"fa_card_fin", (String)selectFields, (QFilter[])filters, (String)"bizperiod asc");
            DataSet ds1 = QueryServiceHelper.queryDataSet((String)ALGO, (String)"fa_card_fin", (String)selectFields, (QFilter[])filters1, (String)"bizperiod asc");
            if (ds != null) {
                ds1 = ds1.union(ds).distinct();
                ds.close();
            }
            for (Row row : ds1) {
                if (row.getLong("bizperiod") > this.prevPeriodId) {
                    this.appendCard(this.curCardLst, row);
                    continue;
                }
                this.appendCard(this.prevCardLst, row);
            }
            ds1.close();
        }
    }

    private void appendCard(List<Card> cardLst, Row row) {
        cardLst.add(new Card(row.getLong("bizperiod"), row.getBigDecimal("netamount"), row.getBigDecimal("monthdepre"), row.getBigDecimal("preusingamount"), row.getBigDecimal("depredamount"), row.getLong("period"), row.getLong("clearperiod")));
    }

    protected boolean initCtx() {
        IDataModel model = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).getModel();
        this.orgid = FaFormUtils.getCardOrg(model);
        this.unitValue = "B";
        if (this.orgid == 0L) {
            return false;
        }
        String fields = "id,basecurrency.sign,basecurrency.amtprecision,periodtype,curperiod,startperiod.periodyear,startperiod.periodnumber,curperiod.periodyear,curperiod.periodnumber, depreuse";
        DynamicObject book = FaBizUtils.getAsstBookByOrg((Long)this.orgid, (String)fields);
        if (book == null) {
            return false;
        }
        this.bookid = book.getLong("id");
        this.currencySign = book.getString("basecurrency.sign");
        long periodTypeId = book.getLong("periodtype");
        this.curPeriodId = book.getLong("curperiod");
        this.depreUseId = book.getLong("depreuse");
        int startPeriodYear = book.getInt("startperiod.periodyear");
        int startPeriodNumber = book.getInt("startperiod.periodnumber");
        int beforeInitYear = startPeriodNumber == 1 ? startPeriodYear - 1 : startPeriodYear;
        int beforeInitPeriodNumber = startPeriodNumber == 1 ? 12 : startPeriodNumber - 1;
        QFilter[] filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("periodyear", "=", (Object)beforeInitYear), new QFilter("periodnumber", "=", (Object)beforeInitPeriodNumber)};
        DynamicObject beforeInitPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])filters);
        this.beforeInitPeriodId = beforeInitPeriod != null ? beforeInitPeriod.getLong("id") : periodTypeId * 10000000L + (long)(beforeInitYear * 1000) + (long)(beforeInitPeriodNumber * 10);
        int curPeriodYear = book.getInt("curperiod.periodyear");
        int curPeriodNumber = book.getInt("curperiod.periodnumber");
        int prevPeriodYear = curPeriodYear - 1;
        filters = new QFilter[]{new QFilter("periodtype", "=", (Object)periodTypeId), new QFilter("periodyear", "=", (Object)prevPeriodYear), new QFilter("periodnumber", "=", (Object)curPeriodNumber)};
        DynamicObject prevPeriod = QueryServiceHelper.queryOne((String)"bd_period", (String)"id", (QFilter[])filters);
        this.prevPeriodId = prevPeriod != null ? prevPeriod.getLong("id") : periodTypeId * 10000000L + (long)(prevPeriodYear * 1000) + (long)(curPeriodNumber * 10);
        return true;
    }

    private void fillDeleteData() {
        BigDecimal prevAmount;
        List curCreateLst = this.curCardLst.stream().filter(v -> v.clearPeriodId == this.curPeriodId).collect(Collectors.toList());
        int count = curCreateLst.size();
        BigDecimal curAmount = curCreateLst.stream().map(v -> v.netAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        String flag = "delete";
        String desc = "-";
        if (this.hasPrevCard && (prevAmount = this.prevCardLst.stream().filter(v -> v.clearPeriodId == this.prevPeriodId).map(v -> v.netAmount).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) > 0) {
            desc = curAmount.subtract(prevAmount).multiply(new BigDecimal("100")).divide(prevAmount, 2, RoundingMode.HALF_UP) + "%";
        }
        this.setLabelText(flag, count, curAmount, String.format(ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f\uff1a%s", (String)"MainPageOverviewCard_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), desc));
    }

    private void fillNewData() {
        BigDecimal prevAmount;
        List curCreateLst = this.curCardLst.stream().filter(v -> v.createPeriodId == this.curPeriodId).collect(Collectors.toList());
        int count = curCreateLst.size();
        BigDecimal curAmount = curCreateLst.stream().map(v -> v.netAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        String flag = "new";
        String desc = "-";
        if (this.hasPrevCard && (prevAmount = this.prevCardLst.stream().filter(v -> v.createPeriodId == this.prevPeriodId).map(v -> v.netAmount).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) > 0) {
            desc = curAmount.subtract(prevAmount).multiply(new BigDecimal("100")).divide(prevAmount, 2, RoundingMode.HALF_UP) + "%";
        }
        this.setLabelText(flag, count, curAmount, String.format(ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f\uff1a%s", (String)"MainPageOverviewCard_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), desc));
    }

    private void overage(BigDecimal sumNetAmount) {
        List overAgeLst = this.curCardLst.stream().filter(v -> v.depredAmount.equals(v.preUsingAmount) && v.clearPeriodId == 0L).collect(Collectors.toList());
        int count = overAgeLst.size();
        BigDecimal overAgeNetAmount = overAgeLst.stream().map(v -> v.netAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        String desc = "-";
        if (sumNetAmount.compareTo(BigDecimal.ZERO) > 0) {
            desc = overAgeNetAmount.multiply(new BigDecimal("100")).divide(sumNetAmount, 2, RoundingMode.HALF_UP) + "%";
        }
        String flag = "overage";
        this.setLabelText(flag, count, overAgeNetAmount, String.format(ResManager.loadKDString((String)"\u903e\u9f84\u5360\u6bd4\uff1a%s", (String)"MainPageOverviewCard_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), desc));
    }

    private void depre() {
        BigDecimal prevAmount;
        List curDepreLst = this.curCardLst.stream().filter(v -> v.bizPeriodId == this.curPeriodId && v.monthDepre.compareTo(BigDecimal.ZERO) > 0).collect(Collectors.toList());
        int count = curDepreLst.size();
        BigDecimal curAmount = curDepreLst.stream().map(v -> v.monthDepre).reduce(BigDecimal.ZERO, BigDecimal::add);
        String flag = "depre";
        String desc = "-";
        if (this.hasPrevCard && (prevAmount = this.prevCardLst.stream().map(v -> v.monthDepre).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) > 0) {
            desc = curAmount.subtract(prevAmount).multiply(new BigDecimal("100")).divide(prevAmount, 2, RoundingMode.HALF_UP) + "%";
        }
        this.setLabelText(flag, count, curAmount, String.format(ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f\uff1a%s", (String)"MainPageOverviewCard_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), desc));
    }

    private BigDecimal all() {
        BigDecimal prevAmount;
        SqlBuilder sql = new SqlBuilder();
        sql.append("select count(1) as count, sum(fnetamount) as sum from t_fa_card_fin t where ", new Object[0]);
        sql.append("forg = ?", new Object[]{this.orgid});
        sql.append(" and fdepreuseid = ?", new Object[]{this.depreUseId});
        sql.append(" and fendperiodid > ?", new Object[]{this.curPeriodId});
        sql.append(" and fbizperiodid <= ?", new Object[]{this.curPeriodId});
        sql.append(" and t.fbillstatus = 'C' and (fbizperiodid < fclearperiodid OR fclearperiodid = 0)", new Object[0]);
        DataSet dataSet = DB.queryDataSet((String)"queryMainPageAll", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sql);
        int count = 0;
        BigDecimal curAmount = new BigDecimal(0);
        if (dataSet.hasNext()) {
            Row data = dataSet.next();
            count = data.getInteger("count");
            curAmount = data.getBigDecimal("sum") == null ? BigDecimal.ZERO : data.getBigDecimal("sum");
        }
        String flag = "all";
        String desc = "-";
        if (this.hasPrevCard && (prevAmount = this.prevCardLst.stream().filter(v -> v.clearPeriodId == 0L || v.clearPeriodId > this.prevPeriodId).map(v -> v.netAmount).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(BigDecimal.ZERO) > 0) {
            desc = curAmount.subtract(prevAmount).multiply(new BigDecimal("100")).divide(prevAmount, 2, RoundingMode.HALF_UP) + "%";
        }
        this.setLabelText(flag, count, curAmount, String.format(ResManager.loadKDString((String)"\u540c\u6bd4\u589e\u957f\uff1a%s", (String)"MainPageOverviewCard_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), desc));
        return curAmount;
    }

    private void setLabelText(String flag, int count, BigDecimal curAmount, String desc) {
        ((Label)this.getControl(flag + "_count")).setText(count + "");
        BigDecimal units = "B".equals(this.unitValue) ? MainPageConstant.UNIT_TEN_THOUSAND : MainPageConstant.UNIT_THOUSAND;
        BigDecimal divide = curAmount.divide(units, 2, RoundingMode.HALF_UP);
        ((Label)this.getControl(flag + "_amount")).setText(this.currencyFormat.format(divide));
        ((Label)this.getControl(flag + "_desc")).setText(desc);
    }

    private void refreshUnit() {
        String unitText = "B".equals(this.unitValue) ? ResManager.loadKDString((String)"\u4e07\u5143", (String)"MainPageOverviewCard_2", (String)"fi-fa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5343\u5143", (String)"MainPageOverviewCard_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        for (String label : REGISTER_CHANGE_LABEL) {
            ((Label)this.getControl(label)).setText(unitText);
        }
    }

    private static class Card {
        protected long bizPeriodId;
        protected BigDecimal netAmount;
        protected BigDecimal monthDepre;
        protected BigDecimal preUsingAmount;
        protected BigDecimal depredAmount;
        protected long createPeriodId;
        protected long clearPeriodId;

        public Card(long bizPeriodId, BigDecimal netAmount, BigDecimal monthDepre, BigDecimal preUsingAmount, BigDecimal depredAmount, long createPeriodId, long clearPeriodId) {
            this.bizPeriodId = bizPeriodId;
            this.netAmount = netAmount;
            this.monthDepre = monthDepre;
            this.preUsingAmount = preUsingAmount;
            this.depredAmount = depredAmount;
            this.createPeriodId = createPeriodId;
            this.clearPeriodId = clearPeriodId;
        }
    }
}

