/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.utils.FaFormUtils;

public class MainPageRiskMonitoringCard
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String ORG = "orgid";
    private static final String ADDROW = "addrow";
    private static final String SETTING_FORMID = "fa_riskmonitoring_setting";
    private static final String RISKENTITY = "riskentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ADDROW});
        EntryGrid entry = (EntryGrid)this.getControl(RISKENTITY);
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.init();
    }

    private void init() {
        DynamicObject mainBook;
        IFormView thisView = this.getView();
        if (thisView == null) {
            return;
        }
        IFormView thisParenView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (thisParenView == null) {
            return;
        }
        IDataModel idm = thisParenView.getModel();
        long orgId = FaFormUtils.getCardOrg(idm);
        long depreUseId = FaFormUtils.getCardDepreUse(idm);
        if (orgId == 0L || depreUseId == 0L) {
            return;
        }
        try {
            mainBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg((Object)orgId);
        }
        catch (KDBizException e) {
            return;
        }
        Long bookid = mainBook.getLong("id");
        DynamicObject basecurrency = mainBook.getDynamicObject("basecurrency");
        if (mainBook.getDynamicObject("curperiod") == null) {
            return;
        }
        Long curperiod = mainBook.getDynamicObject("curperiod").getLong("id");
        DynamicObjectCollection riskData = this.getRiskSettingData(orgId);
        IDataModel model = this.getModel();
        model.deleteEntryData(RISKENTITY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("realcard", new Object[0]);
        vs.addField("unit", new Object[0]);
        vs.addField("qty", new Object[0]);
        vs.addField("netamount", new Object[0]);
        vs.addField("currency", new Object[0]);
        vs.addField("depreperiod", new Object[0]);
        vs.addField("warning", new Object[0]);
        for (DynamicObject db : riskData) {
            int value = db.getInt("value");
            String where = db.getString("condition");
            QFilter finOrgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter depreUseFilter = new QFilter("depreuse", "=", (Object)depreUseId);
            QFilter bookFilter = new QFilter("assetbook", "=", (Object)bookid);
            QFilter finEndPeroidFilter = new QFilter("endperiod", "=", (Object)99999999999L);
            QFilter finStartPeroidFilter = new QFilter("bizperiod", "<=", (Object)curperiod);
            QFilter catFilter = new QFilter("assetcat", "=", (Object)db.getLong("assetcategory"));
            QFilter clearFilter = new QFilter("clearperiod", "=", (Object)0);
            QFilter[] filterArr = new QFilter[]{finOrgFilter, depreUseFilter, bookFilter, finEndPeroidFilter, finStartPeroidFilter, catFilter, clearFilter};
            String selectStr = "realcard,realcard.assetamount qty,realcard.unit unit,netamount,preusingamount,depredamount";
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"fa_card_fin", (String)selectStr, (QFilter[])filterArr);
            for (DynamicObject finDb : coll) {
                Long realCard = finDb.getLong("realcard");
                Long unit = finDb.getLong("unit");
                Integer qty = finDb.getInt("qty");
                BigDecimal netamount = finDb.getBigDecimal("netamount");
                int preusingamount = finDb.getInt("preusingamount");
                int depredamount = finDb.getInt("depredamount");
                Integer depreperiod = preusingamount - depredamount;
                String waring = "1";
                switch (where) {
                    case "=": {
                        if (depreperiod != value) break;
                        waring = "0";
                        vs.addRow(new Object[]{realCard, unit, qty, netamount, basecurrency.getPkValue(), depreperiod, waring});
                        break;
                    }
                    case "<>": {
                        if (depreperiod == value) break;
                        waring = "0";
                        vs.addRow(new Object[]{realCard, unit, qty, netamount, basecurrency.getPkValue(), depreperiod, waring});
                        break;
                    }
                    case ">=": {
                        if (depreperiod < value) break;
                        waring = "0";
                        vs.addRow(new Object[]{realCard, unit, qty, netamount, basecurrency.getPkValue(), depreperiod, waring});
                        break;
                    }
                    case ">": {
                        if (depreperiod <= value) break;
                        waring = "0";
                        vs.addRow(new Object[]{realCard, unit, qty, netamount, basecurrency.getPkValue(), depreperiod, waring});
                        break;
                    }
                    case "<=": {
                        if (depreperiod > value) break;
                        waring = "0";
                        vs.addRow(new Object[]{realCard, unit, qty, netamount, basecurrency.getPkValue(), depreperiod, waring});
                        break;
                    }
                    case "<": {
                        if (depreperiod >= value) break;
                        waring = "0";
                        vs.addRow(new Object[]{realCard, unit, qty, netamount, basecurrency.getPkValue(), depreperiod, waring});
                        break;
                    }
                }
            }
        }
        AbstractFormDataModel model2 = (AbstractFormDataModel)model;
        model2.beginInit();
        model2.batchCreateNewEntryRow(RISKENTITY, vs);
        model2.endInit();
        this.getView().updateView(RISKENTITY);
    }

    private DynamicObjectCollection getRiskSettingData(Long orgId) {
        QFilter userQf = new QFilter("creater", "=", (Object)ContextUtil.getUserId());
        QFilter orgQf = new QFilter("org", "=", (Object)orgId);
        DynamicObjectCollection riskData = QueryServiceHelper.query((String)SETTING_FORMID, (String)"entryentity.assetcategory assetcategory,entryentity.condition condition,entryentity.value value", (QFilter[])new QFilter[]{userQf, orgQf});
        return riskData;
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        Control ctl = (Control)e.getSource();
        switch (key = ctl.getKey()) {
            case "addrow": {
                this.showSettingForm();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("settingform".equalsIgnoreCase(e.getActionId())) {
            this.init();
        }
    }

    private void showSettingForm() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        DynamicObject org = (DynamicObject)parentView.getModel().getValue(ORG);
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(SETTING_FORMID);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "settingform");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("org", String.valueOf(orgId));
        showParameter.setCustomParam("param", param);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        DynamicObject org = (DynamicObject)parentView.getModel().getValue(ORG);
        if (org == null) {
            return;
        }
        Long orgId = org.getLong("id");
        DynamicObject rowData = this.getModel().getEntryRowEntity(RISKENTITY, e.getRowIndex());
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId("fa_card_fin");
        para.setFormId("bos_list");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        para.setCustomParam("org", (Object)String.valueOf(orgId));
        para.setCustomParam("finaccountdate", (Object)"ismainpage");
        DynamicObject mainBook = FaAssetBookDaoFactory.getInstance().queryMainBookByOrg((Object)orgId);
        if (mainBook != null) {
            long depreUseId = mainBook.getDynamicObject("depreuse").getLong("id");
            para.setCustomParam("depreuse", (Object)depreUseId);
        }
        QFilter cardFilter = new QFilter("realcard", "=", (Object)rowData.getDynamicObject("realcard").getLong("id"));
        list.add(cardFilter);
        para.setListFilterParameter(new ListFilterParameter(list, "id"));
        this.getView().showForm((FormShowParameter)para);
    }
}

