/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaFormUtils;

public class MainPageUnFinishedBill
extends AbstractFormPlugin {
    public static final String MAIN_PAGE_UN_FINISH_FILTER = "defortFilter";
    private static final String ALGO = "kd.fi.fa.formplugin.MainPageUnFinishedBill";
    private long orgId;
    private long depreuseId;
    private long curPeriodId;
    private Date beginDate;
    private Date endDate;
    private String[] entityNames = new String[]{"fa_card_fin", "fa_clearbill", "fa_depreadjustbill", "fa_change_dept", "fa_asset_devalue", "fa_asset_card"};
    private Map<String, Supplier<QFilter>> filterSupplierMap = new HashMap<String, Supplier<QFilter>>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(this.entityNames);
    }

    public void afterCreateNewData(EventObject e) {
        boolean success = this.init();
        if (success) {
            this.fillData();
        }
    }

    private boolean init() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        IDataModel model = parentView.getModel();
        this.orgId = FaFormUtils.getCardOrg(model);
        if (this.orgId == 0L) {
            return false;
        }
        String fields = "id,curperiod,depreuse,curperiod.beginDate begindate,curperiod.enddate enddate";
        DynamicObject book = FaBizUtils.getAsstBookByOrg((Long)this.orgId, (String)fields);
        if (book == null) {
            return false;
        }
        this.depreuseId = book.getLong("depreuse");
        this.curPeriodId = book.getLong("curperiod");
        this.beginDate = book.getDate("begindate");
        this.endDate = book.getDate("enddate");
        this.filterSupplierMap.put("fa_asset_card", this::getAssetCardFilter);
        this.filterSupplierMap.put("fa_card_fin", this::getFinCardFilter);
        this.filterSupplierMap.put("fa_clearbill", this::getClearBillFilter);
        this.filterSupplierMap.put("fa_depreadjustbill", this::getDepreAdjustBillFilter);
        this.filterSupplierMap.put("fa_change_dept", this::getChangeBillFilter);
        this.filterSupplierMap.put("fa_asset_devalue", this::getAssetDevalueFilter);
        return true;
    }

    private QFilter getAssetDevalueFilter() {
        return new QFilter("org", "=", (Object)this.orgId).and(new QFilter("depreuse", "=", (Object)this.depreuseId)).and(new QFilter("devalueperiod", "=", (Object)this.curPeriodId)).and(new QFilter("billstatus", "!=", (Object)BillStatus.C.toString()));
    }

    private QFilter getChangeBillFilter() {
        return new QFilter("org", "=", (Object)this.orgId).and(new QFilter("billstatus", "!=", (Object)BillStatus.C.toString())).and(new QFilter("changedate", ">=", (Object)this.beginDate)).and(new QFilter("changedate", "<=", (Object)this.endDate));
    }

    private QFilter getDepreAdjustBillFilter() {
        return new QFilter("org", "=", (Object)this.orgId).and(new QFilter("depreuse", "=", (Object)this.depreuseId)).and(new QFilter("period", "=", (Object)this.curPeriodId)).and(new QFilter("billstatus", "!=", (Object)BillStatus.C.toString()));
    }

    private QFilter getClearBillFilter() {
        return new QFilter("org", "=", (Object)this.orgId).and(new QFilter("billstatus", "!=", (Object)BillStatus.C.toString())).and(new QFilter("cleardate", ">=", (Object)this.beginDate)).and(new QFilter("cleardate", "<=", (Object)this.endDate));
    }

    private QFilter getFinCardFilter() {
        boolean enableCurPeriodSplit = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplit((Long)this.orgId);
        QFilter finFilter = new QFilter("org", "=", (Object)this.orgId).and(new QFilter("depreuse", "=", (Object)this.depreuseId)).and(new QFilter("billstatus", "!=", (Object)BillStatus.C.toString())).and(new QFilter("period", "=", (Object)this.curPeriodId)).and(new QFilter(Fa.dot((String[])new String[]{"realcard", "mergedcard"}), "=", (Object)Boolean.FALSE));
        if (enableCurPeriodSplit) {
            finFilter.and(new QFilter("originaldata", "=", (Object)"1"));
        }
        return finFilter;
    }

    private QFilter getAssetCardFilter() {
        return new QFilter("org", "=", (Object)this.orgId).and(new QFilter("billstatus", "!=", (Object)BillStatus.C.toString())).and(new QFilter("mergedcard", "=", (Object)Boolean.TRUE)).and(new QFilter(Fa.dot((String[])new String[]{"finentry", "fincard", "period"}), "=", (Object)this.curPeriodId));
    }

    private void fillData() {
        for (String entityName : this.entityNames) {
            ((Label)this.getControl(entityName)).setText(this.getCount(entityName) + "");
        }
    }

    private int getCount(String entityName) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)entityName, (String)"count(1) count", (QFilter[])this.filterSupplierMap.get(entityName).get().toArray(), null);){
            if (ds != null && ds.hasNext()) {
                int n = ds.next().getInteger("count");
                return n;
            }
        }
        return 0;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        this.init();
        this.showForm(key);
    }

    private void showForm(String entityName) {
        if (!this.filterSupplierMap.containsKey(entityName)) {
            return;
        }
        ListShowParameter para = new ListShowParameter();
        para.setBillFormId(entityName);
        para.setFormId("bos_list");
        para.setCustomParam("org", (Object)String.valueOf(this.orgId));
        para.setCustomParam("depreuse", (Object)this.depreuseId);
        para.setCustomParam("finaccountdate", (Object)"ismainpage");
        para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        para.getOpenStyle().setTargetKey("_submaintab_");
        para.setCustomParam(MAIN_PAGE_UN_FINISH_FILTER, (Object)this.filterSupplierMap.get(entityName).get().toSerializedString());
        this.getView().showForm((FormShowParameter)para);
    }
}

