/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.assetcard;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.common.util.Fa;

public class FaFinOriginalDataUpgradeGuideEditPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static Log log = LogFactory.getLog(FaFinOriginalDataUpgradeGuideEditPlugin.class);
    private static final String BUTTON_CONFIRM = "confirm";
    private static final String KEY_LOGID = "logId";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_CONFIRM});
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent evt) {
        String fieldKey = evt.getFieldKey();
        int row = evt.getRow();
        if ("step".equals(fieldKey) && row == 0) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setBillFormId("fa_upgraded_assetbook");
            showParameter.setFormId("bos_list");
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        AbstractFormDataModel m = (AbstractFormDataModel)this.getModel();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        List<Map<String, Object>> stepMapList = this.getGuideStepByOpLog();
        HashSet<Integer> alreadyConfirmIndexSet = new HashSet<Integer>(3);
        if (CollectionUtils.isNotEmpty(stepMapList)) {
            int index = 0;
            for (Map<String, Object> stepMap : stepMapList) {
                for (Map.Entry<String, Object> stepEntry : stepMap.entrySet()) {
                    tvs.set(stepEntry.getKey(), stepEntry.getValue(), index);
                    if (!stepEntry.getKey().equals("status") || !Boolean.TRUE.equals(stepEntry.getValue())) continue;
                    alreadyConfirmIndexSet.add(index);
                }
                ++index;
            }
        }
        m.batchCreateNewEntryRow("entryentity", tvs);
        for (Integer index : alreadyConfirmIndexSet) {
            this.getView().setEnable(Boolean.FALSE, index.intValue(), new String[]{"status"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("status".equals(propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            Boolean newVal = (Boolean)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            String stepName = (String)this.getModel().getValue("step", rowIndex);
            if (ResManager.loadKDString((String)"\u5347\u7ea7\u5361\u7247\u539f\u59cb\u6570\u636e", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]).equals(stepName) && newVal.booleanValue()) {
                this.checkHasUnSuccess4Upgrade(true);
            }
            if (newVal.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"status"});
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button button = (Button)evt.getSource();
        String operationKey = button.getKey();
        if (operationKey.equals(BUTTON_CONFIRM)) {
            DynamicObjectCollection stepEntries = this.getModel().getEntryEntity("entryentity");
            ArrayList<Map<String, Object>> stepMapList = new ArrayList<Map<String, Object>>(3);
            boolean hasUnSuccess = this.checkHasUnSuccess4Upgrade(true);
            for (DynamicObject stepObj : stepEntries) {
                HashMap<String, Object> stepMap = new HashMap<String, Object>(4);
                String stepName = stepObj.getString("step");
                DynamicObject opUser = stepObj.getDynamicObject("operateuser");
                Date opTime = stepObj.getDate("operatetime");
                Boolean status = stepObj.getBoolean("status");
                if (ResManager.loadKDString((String)"\u5347\u7ea7\u5361\u7247\u539f\u59cb\u6570\u636e", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]).equals(stepObj.getString("step")) && hasUnSuccess) {
                    status = Boolean.FALSE;
                }
                stepMap.put("step", stepName);
                stepMap.put("status", status);
                stepMap.put("operatetime", status != false && opTime == null ? new Date() : opTime);
                Long opUserId = null;
                if (status.booleanValue()) {
                    opUserId = opUser == null ? Long.valueOf(RequestContext.get().getCurrUserId()) : Long.valueOf(opUser.getLong("id"));
                }
                stepMap.put("operateuser", opUserId);
                stepMapList.add(stepMap);
            }
            this.recordOperationLog(stepMapList);
            this.getView().close();
        }
    }

    private List<Map<String, Object>> getGuideStepByOpLog() {
        LogORM logORM = LogORM.create();
        DynamicObjectCollection logObjs = logORM.query("fa_operation_log", Fa.comma((String[])new String[]{"id", "result_tag"}), new QFilter[]{new QFilter("optype", "=", (Object)FaOperationOpTypeEnum.UPGRADEGUIDECONFIRM.name())}, 1, 0);
        if (CollectionUtils.isEmpty((Collection)logObjs)) {
            return this.initGuideSteps();
        }
        DynamicObject logObj = (DynamicObject)logObjs.get(0);
        if (logObj == null || StringUtils.isEmpty((String)logObj.getString("result_tag"))) {
            return this.initGuideSteps();
        }
        Long logId = logObj.getLong("id");
        this.getPageCache().put(KEY_LOGID, String.valueOf(logId));
        String result = logObj.getString("result_tag");
        List list = (List)JSONArray.parseObject((String)result, List.class);
        return list;
    }

    private List<Map<String, Object>> initGuideSteps() {
        ArrayList<Map<String, Object>> stepMapList = new ArrayList<Map<String, Object>>(3);
        for (int i = 0; i <= 5; ++i) {
            HashMap<String, Object> stepMap = new HashMap<String, Object>();
            String stepName = null;
            switch (i) {
                case 0: {
                    stepName = ResManager.loadKDString((String)"\u5347\u7ea7\u5361\u7247\u539f\u59cb\u6570\u636e", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 1: {
                    stepName = ResManager.loadKDString((String)"\u5347\u7ea7\u5bf9\u8d26\u53d6\u6570\u89c4\u5219", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 2: {
                    stepName = ResManager.loadKDString((String)"\u5347\u7ea7\u7ed3\u8d26\u68c0\u67e5\u9879", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 3: {
                    stepName = ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u66f4\u65b0", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 4: {
                    stepName = ResManager.loadKDString((String)"\u667a\u80fd\u65b9\u6848\u5347\u7ea7", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                    break;
                }
                case 5: {
                    stepName = ResManager.loadKDString((String)"\u4e8c\u5f00\u517c\u5bb9\u786e\u8ba4", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                }
            }
            stepMap.put("step", stepName);
            stepMap.put("operateuser", null);
            stepMap.put("operatetime", null);
            stepMap.put("status", Boolean.FALSE);
            stepMapList.add(stepMap);
        }
        this.recordOperationLog(stepMapList);
        return stepMapList;
    }

    private void recordOperationLog(List<Map<String, Object>> stepMapList) {
        Long logId;
        String logIdStr = this.getPageCache().get(KEY_LOGID);
        Long l = logId = StringUtils.isEmpty((String)logIdStr) ? null : Long.valueOf(Long.parseLong(logIdStr));
        if (logId == null) {
            FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo((String)null, null, null, null, null, null, null, FaOperationOpTypeEnum.UPGRADEGUIDECONFIRM);
            logId = FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertPo, (FaOperationStatusEnum)FaOperationStatusEnum.SUCCESS, (String)JSONArray.toJSONString(stepMapList));
            this.getPageCache().put(KEY_LOGID, String.valueOf(logId));
            log.info("\u65b0\u589e\u5347\u7ea7\u6307\u5f15\u65e5\u5fd7\u6570\u636e");
        } else {
            FaOperationLogUtils.updateOperationLog((Long)logId, (FaOperationStatusEnum)FaOperationStatusEnum.SUCCESS, (String)JSONArray.toJSONString(stepMapList));
            log.info("\u66f4\u65b0id\u4e3a[{}]\u7684\u5347\u7ea7\u6307\u5f15\u65e5\u5fd7\u6570\u636e", (Object)logId);
        }
    }

    private boolean checkHasUnSuccess4Upgrade(boolean needTips) {
        boolean successful = FaAssetBookDataUpgradeLogUtils.allOrgEnableCurPeriodSplit();
        if (!successful && needTips) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd8\u5b58\u5728\u672a\u5347\u7ea7\u539f\u59cb\u6570\u636e\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"FaFinOriginalDataUpgradeGuideEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return !successful;
    }
}

