/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.assetcard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.assetsplit.FaSplitBillAndCardHelper;
import kd.fi.fa.business.card.FaCardDTO;
import kd.fi.fa.business.utils.AttachmentUtils;
import kd.fi.fa.common.util.Fa;

public class FaSplitAssetCardEditPlugin
extends AbstractBillPlugIn
implements TabSelectListener,
ClickListener {
    private static final Log logger = LogFactory.getLog(FaSplitAssetCardEditPlugin.class);
    private static final String SPLIT_ENTRY_INDEX = "split_entry_index";
    private static final String SPLIT_ENTRY_SEQ = "split_entry_seq";
    private static final String ITEM_KEY_CONFIRM = "confirm";
    private static final String ITEM_KEY_LINKQUERY = "linkquery";
    private static final String PAGE_FIRST = "first";
    private static final String PAGE_PREVIOUS = "previous";
    private static final String PAGE_NEXT = "next";
    private static final String PAGE_LAST = "last";
    private static final String PAGE_CACHE_PROPERTY_CHANG_CONFIRMED = "property_change_confirmed";
    private static final String PAGE_CACHE_BILLNO = "cache_billno";
    private static final String PAGE_CACHE_NUMBER = "cache_number";
    private static final String PAGE_CACHE_BARCODE = "cache_barcode";
    private static final String ATTACHMENT_PANEL = "attachmentpanel";
    public static final String PAGE_CACHE_SOURCE_CARD_FLAG = "cache_source_card_flag";
    public static final String PAGE_CACHE_SOURCE_CARD_UNENABLE_FIELDS = "cache_source_card_unenable_fields";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab assetInfoTab = (Tab)this.getView().getControl("assetinfotab");
        assetInfoTab.addTabSelectListener((TabSelectListener)this);
        Vector vector4First = (Vector)this.getView().getControl(PAGE_FIRST);
        Vector vector4Pre = (Vector)this.getView().getControl(PAGE_PREVIOUS);
        Vector vector4Next = (Vector)this.getView().getControl(PAGE_NEXT);
        Vector vector4Last = (Vector)this.getView().getControl(PAGE_LAST);
        vector4First.addClickListener((ClickListener)this);
        vector4Pre.addClickListener((ClickListener)this);
        vector4Next.addClickListener((ClickListener)this);
        vector4Last.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        AttachmentPanel attachmentPanel;
        List attachmentData;
        List tempAttachments;
        String index = this.getPageCache().get(SPLIT_ENTRY_INDEX);
        if (this.parentFormIsSplitBill() && index == null) {
            this.initCardBySplitBill();
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
        if (index != null && CollectionUtils.isNotEmpty((Collection)(tempAttachments = AttachmentUtils.getTempDataFromSources((List)(attachmentData = (attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL)).getAttachmentData()))))) {
            for (Map temp : tempAttachments) {
                attachmentPanel.remove(temp);
            }
        }
        this.cacheCodeRuleFields();
    }

    public void afterBindData(EventObject e) {
        if (this.parentFormIsSplitBill()) {
            this.setEditableAndVisible4Bill(this.getView().getFormShowParameter());
            this.setCodeRuleFieldsVal();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "confirm": {
                this.confirmAssetCard();
            }
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Vector && this.parentFormIsSplitBill()) {
            this.turnPage((Vector)source);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        this.getPageCache().put(PAGE_CACHE_PROPERTY_CHANG_CONFIRMED, "0");
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        if ("fintab".equals(tabKey) && this.parentFormIsSplitBill()) {
            DynamicObject assetCat = (DynamicObject)this.getModel().getValue("assetcat");
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            String finCardPageId = this.getPageCache().get("finCardPageId");
            IFormView finCardView = this.getView().getView(finCardPageId);
            if (assetCat == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u8d44\u4ea7\u7c7b\u522b\u3002", (String)"FaSplitAssetCardEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                finCardView.getFormShowParameter().setStatus(OperationStatus.VIEW);
            } else {
                finCardView.getFormShowParameter().setStatus(OperationStatus.ADDNEW);
            }
            finCardView.updateView();
            this.getView().sendFormAction(finCardView);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String changeConfirmed;
        if (this.parentFormIsSplitBill() && "1".equals(changeConfirmed = this.getPageCache().get(PAGE_CACHE_PROPERTY_CHANG_CONFIRMED))) {
            e.setCheckDataChange(false);
        }
    }

    private void confirmAssetCard() {
        DynamicObject currentObj = this.getModel().getDataEntity(true);
        String finCardPageId = this.getPageCache().get("finCardPageId");
        IFormView finCardView = this.getView().getView(finCardPageId);
        DynamicObject finCard = finCardView.getModel().getDataEntity(true);
        String depreUseCardStr = this.getPageCache().get("depreUseCard");
        Map depreUseCardMap = (Map)SerializationUtils.deSerializeFromBase64((String)depreUseCardStr);
        long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
        if (depreUseId != 0L) {
            depreUseCardMap.put(depreUseId, finCard);
            depreUseCardStr = SerializationUtils.serializeToBase64((Object)depreUseCardMap);
            this.getPageCache().put("depreUseCard", depreUseCardStr);
        }
        this.getPageCache().put(PAGE_CACHE_PROPERTY_CHANG_CONFIRMED, "1");
        List finCards = depreUseCardMap.values().stream().collect(Collectors.toList());
        IFormView splitView = this.getView().getView(this.getView().getFormShowParameter().getParentPageId());
        if (splitView == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u6253\u5f00\u76ee\u6807\u5361\u7247\u518d\u4fdd\u5b58\u3002", (String)"FaSplitAssetCardEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject splitBill = splitView.getModel().getDataEntity(true);
        if (!this.checkSplitStatus(splitBill)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u62c6\u5206\u5355\u624d\u5141\u8bb8\u66f4\u65b0\u76ee\u6807\u5361\u7247\u3002", (String)"FaSplitAssetCardEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        FaSplitBillAndCardHelper helper = new FaSplitBillAndCardHelper();
        helper.cardConvert2SplitBill(new FaCardDTO(null, currentObj, finCards), splitBill, Integer.parseInt(this.getPageCache().get(SPLIT_ENTRY_INDEX)));
        splitView.updateView();
        this.getView().sendFormAction(splitView);
        String uploadingAtt = this.getView().getPageCache().get("UploadingAtt" + this.getView().getPageId());
        if (!StringUtils.isNull((String)uploadingAtt)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"FaSplitAssetCardEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACHMENT_PANEL);
        List attachmentData = attachmentPanel.getAttachmentData();
        List newFinalAttachments = AttachmentUtils.saveTempAndUpload((List)attachmentData, (String)ATTACHMENT_PANEL, (String)"fa_card_real", (Object)this.getModel().getDataEntity().getLong("id"));
        if (CollectionUtils.isNotEmpty((Collection)newFinalAttachments)) {
            attachmentPanel.bindData(newFinalAttachments);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u66f4\u65b0\u5361\u7247\u6570\u636e\u3002", (String)"FaSplitAssetCardEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
    }

    private boolean checkSplitStatus(DynamicObject splitBill) {
        Long splitBillId = splitBill.getLong("id");
        if (splitBillId != null && splitBillId != 0L) {
            DynamicObject splitBillRecord = QueryServiceHelper.queryOne((String)"fa_assetsplitbill", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)splitBillId)});
            String billStatus = splitBillRecord.getString("billstatus");
            return BillStatus.A.name().equals(billStatus);
        }
        return true;
    }

    private void initCardBySplitBill() {
        String cacheKey;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        IAppCache appCache = AppCache.get((String)"fa");
        String indexCardDTOMapStr = (String)appCache.get(cacheKey = (String)customParams.get("cache_real_fin_card"), String.class);
        if (StringUtils.isEmpty((String)indexCardDTOMapStr)) {
            logger.error("\u901a\u8fc7indexCardDTOMapStr[{}]\u672a\u89e3\u6790\u5230\u5b9e\u7269\u5361\u7247+\u8d22\u52a1\u5361\u7247\u6570\u636e\uff01", (Object)indexCardDTOMapStr);
            return;
        }
        Map indexCardDTOMap = (Map)SerializationUtils.deSerializeFromBase64((String)indexCardDTOMapStr);
        List indexList = indexCardDTOMap.keySet().stream().collect(Collectors.toList());
        Integer currentIndex = (Integer)indexList.get(0);
        FaCardDTO realFinCard = (FaCardDTO)indexCardDTOMap.get(currentIndex);
        DynamicObject realCard = realFinCard.getRealCard();
        boolean isSourceCard = realFinCard.isSourceCard();
        List finCards = realFinCard.getFinCardList();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_asset_card");
        Map propertyMap = dataEntityType.getAllFields();
        for (IDataEntityProperty pro : propertyMap.values()) {
            String proName = pro.getName();
            IDataEntityType parent = pro.getParent();
            if (!(parent instanceof MainEntityType) || !realCard.containsProperty(proName) || proName.equals("barcoderule") || proName.equals("billnocoderule") || proName.equals("numberrule")) continue;
            this.getModel().setValue(proName, realCard.get(proName));
        }
        this.getModel().setValue("facility_entry", realCard.get("facility_entry"));
        this.getModel().setValue("id", (Object)realCard.getLong("id"));
        HashMap depreUseCardMap = new HashMap(finCards.size());
        finCards.stream().forEach(t -> {
            Long depreuseId = t.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}));
            depreUseCardMap.put(depreuseId, t);
        });
        String depreUseCardStr = SerializationUtils.serializeToBase64(depreUseCardMap);
        Integer currentSeq = this.getSeqByIndex(currentIndex);
        this.getPageCache().put(SPLIT_ENTRY_INDEX, String.valueOf(currentIndex));
        this.getPageCache().put(SPLIT_ENTRY_SEQ, String.valueOf(currentSeq));
        this.getPageCache().put("depreUseCard", depreUseCardStr);
        this.getPageCache().put(PAGE_CACHE_SOURCE_CARD_FLAG, String.valueOf(isSourceCard));
        this.setBillCount(currentSeq, (Integer)customParams.get("max_seq"));
    }

    private void setEditableAndVisible4Bill(FormShowParameter showParameter) {
        Map customParams = showParameter.getCustomParams();
        Boolean isManualCode = (Boolean)customParams.get("ismanualcode");
        String bizType = (String)customParams.get("biztype");
        String splitBillStatus = (String)customParams.get("fa_assetsplitbill_billstatus");
        if (BillStatus.C.name().equals(splitBillStatus)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ITEM_KEY_LINKQUERY});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ITEM_KEY_LINKQUERY});
        }
        boolean isSourceCard = Boolean.parseBoolean(this.getPageCache().get(PAGE_CACHE_SOURCE_CARD_FLAG));
        if (!BillStatus.A.name().equals(splitBillStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ITEM_KEY_CONFIRM});
        } else if (isSourceCard) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_asset_card");
            Map propertyMap = dataEntityType.getAllFields();
            ArrayList<String> enableField = new ArrayList<String>(16);
            ArrayList<String> unEnableFields = new ArrayList<String>(16);
            for (IDataEntityProperty pro : propertyMap.values()) {
                String proName = pro.getName();
                IDataEntityType parent = pro.getParent();
                if (!(parent instanceof MainEntityType)) continue;
                if ("A".equalsIgnoreCase(bizType) && "assetamount".equals(proName)) {
                    enableField.add(proName);
                    continue;
                }
                unEnableFields.add(proName);
            }
            if (CollectionUtils.isNotEmpty(enableField)) {
                this.getView().setEnable(Boolean.TRUE, enableField.toArray(new String[0]));
            }
            this.getPageCache().put(PAGE_CACHE_SOURCE_CARD_UNENABLE_FIELDS, SerializationUtils.serializeToBase64(unEnableFields));
            this.getView().setEnable(Boolean.FALSE, unEnableFields.toArray(new String[0]));
        } else {
            this.setEnableByChangeItem(showParameter);
            this.getView().setEnable(isManualCode, new String[]{"billno", "number", "barcode"});
        }
        if (!BillStatus.A.name().equals(splitBillStatus) || isSourceCard || OperationStatus.VIEW.equals((Object)showParameter.getStatus())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"facility_entry"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"addrow", "deleterow"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"facility_entry"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"addrow", "deleterow"});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"org", "assetunit", "sourceflag", "realaccountdate"});
        OperationStatus opStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)opStatus) && !isSourceCard) {
            this.getView().setEnable(Boolean.TRUE, new String[]{ATTACHMENT_PANEL});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{ATTACHMENT_PANEL});
        }
    }

    private void cacheCodeRuleFields() {
        String billNo = (String)this.getModel().getValue("billno");
        String number = (String)this.getModel().getValue("number");
        String barCode = (String)this.getModel().getValue("barcode");
        this.getPageCache().put(PAGE_CACHE_BILLNO, billNo);
        this.getPageCache().put(PAGE_CACHE_NUMBER, number);
        this.getPageCache().put(PAGE_CACHE_BARCODE, barCode);
    }

    private void setCodeRuleFieldsVal() {
        String barCode;
        String number;
        String billNo;
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        Boolean isManualCode = (Boolean)customParams.get("ismanualcode");
        String splitBillStatus = (String)customParams.get("fa_assetsplitbill_billstatus");
        if (isManualCode.booleanValue() || BillStatus.C.name().equals(splitBillStatus)) {
            billNo = this.getPageCache().get(PAGE_CACHE_BILLNO);
            number = this.getPageCache().get(PAGE_CACHE_NUMBER);
            barCode = this.getPageCache().get(PAGE_CACHE_BARCODE);
        } else {
            barCode = null;
            number = null;
            billNo = null;
        }
        this.getModel().setValue("billno", (Object)billNo);
        this.getModel().setValue("number", (Object)number);
        this.getModel().setValue("barcode", (Object)barCode);
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicProperty billNoProp = entityType.getProperty("billno");
        DynamicProperty numberProp = entityType.getProperty("number");
        DynamicProperty barCodeProp = entityType.getProperty("barcode");
        DataEntityState entityState = this.getModel().getDataEntity().getDataEntityState();
        entityState.setBizChanged(billNoProp.getOrdinal(), false);
        entityState.setBizChanged(numberProp.getOrdinal(), false);
        entityState.setBizChanged(barCodeProp.getOrdinal(), false);
    }

    private void setEnableByChangeItem(FormShowParameter showParameter) {
        String unEnableFieldsStr4SourceCard;
        Map unEnableFieldMap;
        String splitPageId = (String)showParameter.getCustomParams().get("split_page_id");
        IFormView splitView = this.getView().getView(splitPageId);
        String unenableFieldsStr = splitView.getPageCache().get("page_cache_unenable_fields_card");
        Set unEnableFields = new HashSet(8);
        if (StringUtils.isNotEmpty((String)unenableFieldsStr) && (unEnableFieldMap = (Map)SerializationUtils.deSerializeFromBase64((String)unenableFieldsStr)) != null && !unEnableFieldMap.isEmpty()) {
            unEnableFields = (Set)unEnableFieldMap.get("fa_card_real");
        }
        if (StringUtils.isNotEmpty((String)(unEnableFieldsStr4SourceCard = this.getPageCache().get(PAGE_CACHE_SOURCE_CARD_UNENABLE_FIELDS)))) {
            List unEnableFields4SourceCard;
            List enableFields4NewCard = unEnableFields4SourceCard = (List)SerializationUtils.deSerializeFromBase64((String)unEnableFieldsStr4SourceCard);
            if (CollectionUtils.isNotEmpty(unEnableFields)) {
                enableFields4NewCard.removeAll(unEnableFields);
            }
            this.getView().setEnable(Boolean.TRUE, enableFields4NewCard.toArray(new String[0]));
            this.getView().setEnable(Boolean.FALSE, unEnableFields.toArray(new String[0]));
        } else if (unEnableFields != null && !unEnableFields.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, unEnableFields.toArray(new String[0]));
        }
    }

    private boolean parentFormIsSplitBill() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String parentFormId = showParameter.getParentFormId();
        return StringUtils.isNotEmpty((String)parentFormId) && "fa_assetsplitbill".equals(parentFormId);
    }

    private void turnPage(Vector pageVector) {
        String key;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map seq2IndexMap = (Map)SerializationUtils.deSerializeFromBase64((String)String.valueOf(customParams.get("seq_index_relation")));
        int currentSeq = this.getSeqByIndex(Integer.valueOf(this.getPageCache().get(SPLIT_ENTRY_INDEX)));
        int maxSeq = (Integer)customParams.get("max_seq");
        int newSeq = currentSeq;
        switch (key = pageVector.getKey()) {
            case "first": {
                newSeq = 1;
                break;
            }
            case "previous": {
                newSeq = currentSeq - 1;
                break;
            }
            case "next": {
                newSeq = currentSeq + 1;
                break;
            }
            case "last": {
                newSeq = maxSeq;
            }
        }
        if (newSeq > maxSeq) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u6700\u540e\u4e00\u9875\uff0c\u65e0\u6cd5\u5207\u6362\u5230\u4e0b\u4e00\u5f20\u8d44\u4ea7\u3002", (String)"FaSplitAssetCardEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (newSeq < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u7b2c\u4e00\u9875\uff0c\u65e0\u6cd5\u5207\u6362\u81f3\u4e0a\u4e00\u5f20\u8d44\u4ea7\u3002", (String)"FaSplitAssetCardEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (currentSeq == 1 && newSeq == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4e3a\u7b2c\u4e00\u9875\uff0c\u65e0\u6cd5\u5207\u6362\u81f3\u9996\u9875\u3002", (String)"FaSplitAssetCardEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        if (currentSeq == maxSeq && newSeq == maxSeq) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5230\u6700\u540e\u4e00\u9875\uff0c\u65e0\u6cd5\u5207\u6362\u81f3\u5c3e\u9875\u3002", (String)"FaSplitAssetCardEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        Integer newIndex = (Integer)seq2IndexMap.get(newSeq);
        ArrayList<Integer> indexList = new ArrayList<Integer>(1);
        indexList.add(newIndex);
        FaSplitBillAndCardHelper helper = new FaSplitBillAndCardHelper();
        DynamicObject splitBill = this.getView().getView(this.getView().getFormShowParameter().getParentPageId()).getModel().getDataEntity(true);
        Map indexCardDTOMap = helper.splitBillConvert2RealFinCardMap(splitBill, indexList);
        FaCardDTO cardDTO = (FaCardDTO)indexCardDTOMap.get(newIndex);
        DynamicObject assetCard = helper.realCard2AssetCard(cardDTO.getRealCard());
        List finCards = cardDTO.getFinCardList();
        boolean isSourceCard = cardDTO.isSourceCard();
        HashMap depreUseCardMap = new HashMap(finCards.size());
        finCards.stream().forEach(t -> {
            Long depreuseId = t.getLong(Fa.dot((String[])new String[]{"depreuse", "id"}));
            depreUseCardMap.put(depreuseId, t);
        });
        String depreUseCardStr = SerializationUtils.serializeToBase64(depreUseCardMap);
        this.getPageCache().put(SPLIT_ENTRY_INDEX, String.valueOf(newIndex));
        this.getPageCache().put(SPLIT_ENTRY_SEQ, String.valueOf(newSeq));
        this.getPageCache().put("depreUseCard", depreUseCardStr);
        this.getPageCache().put(PAGE_CACHE_SOURCE_CARD_FLAG, String.valueOf(isSourceCard));
        this.setBillCount(newSeq, maxSeq);
        this.getModel().createNewData((Object)assetCard);
        this.getView().updateView();
    }

    private Integer getSeqByIndex(Integer index) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map seq2IndexMap = (Map)SerializationUtils.deSerializeFromBase64((String)String.valueOf(customParams.get("seq_index_relation")));
        for (Map.Entry entry : seq2IndexMap.entrySet()) {
            if (!((Integer)entry.getValue()).equals(index)) continue;
            return (Integer)entry.getKey();
        }
        return null;
    }

    private void setBillCount(int current, int max) {
        Label label = (Label)this.getView().getControl("billcount");
        label.setText(current + "/" + max);
    }
}

