/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.changebill;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.plugin.AbstractPrintPlugin;
import kd.bos.print.core.plugin.event.AfterLoadDataEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FaAssetChangePrintPlugin
extends AbstractPrintPlugin {
    public void afterLoadData(AfterLoadDataEvent evt) {
        PrtDataSource dataSource = evt.getDataSource();
        if ("fa_change_dept".equals(dataSource.getDsName())) {
            List dataRowSets = evt.getDataRowSets();
            for (DataRowSet dataRowSet : dataRowSets) {
                List fieldEntry = dataRowSet.getCollectionField("fieldentry").getValue();
                for (DataRowSet rowSet : fieldEntry) {
                    Field field = rowSet.getField("field");
                    String fieldValue = (String)field.getValue();
                    String[] split = fieldValue.split("\\.");
                    String billStr = split[0];
                    String fieldStr = split[1];
                    MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billStr);
                    DataEntityPropertyCollection properties = dataEntityType.getProperties();
                    IDataEntityProperty property = (IDataEntityProperty)properties.get((Object)fieldStr);
                    String localeValue = property.getDisplayName().getLocaleValue();
                    field.setDisplayVal(localeValue);
                    String befValue = rowSet.getField("beforevalue").getValue().toString();
                    Field bef = rowSet.getField("beforevalue");
                    String befParseValue = this.parseValue(befValue, property, rowSet);
                    bef.setValue((Object)befParseValue);
                    String aftValue = rowSet.getField("aftervalue").getValue().toString();
                    Field aft = rowSet.getField("aftervalue");
                    String aftParseValue = this.parseValue(aftValue, property, rowSet);
                    aft.setValue((Object)aftParseValue);
                }
            }
        }
    }

    private String parseValue(String rawValue, IDataEntityProperty prop, DataRowSet row) {
        if (prop instanceof BasedataProp) {
            Long rawValueLong;
            String displayProp;
            if (ObjectUtils.isEmpty((Object)rawValue) || "0".equals(rawValue) || "null".equals(rawValue)) {
                return null;
            }
            BasedataProp basedataProp = (BasedataProp)prop;
            DynamicObjectType type = basedataProp.getDynamicComplexPropertyType();
            String entityName = type.getName();
            Map load = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)(displayProp = ((RefEntityType)type).getNameProperty()), (QFilter[])new QFilter("id", "=", (Object)(rawValueLong = Long.valueOf(rawValue))).toArray());
            if (!load.isEmpty()) {
                return ((DynamicObject)load.get(rawValueLong)).getString(displayProp);
            }
            return null;
        }
        if (prop instanceof AmountProp) {
            Integer amtPrecision = (Integer)row.getField("currency1.amtprecision").getValue();
            String sign = row.getField("currency1.sign").getValue().toString();
            StringBuilder fmtSb = new StringBuilder(",###,##0");
            for (int i = 0; i < amtPrecision; ++i) {
                if (i == 0) {
                    fmtSb.append('.');
                }
                fmtSb.append('0');
            }
            DecimalFormat df = new DecimalFormat(fmtSb.toString());
            return sign + df.format(new BigDecimal(rawValue));
        }
        if (prop instanceof BooleanProp) {
            Boolean value = rawValue.equals("1");
            return value != false ? ResManager.loadKDString((String)"\u662f", (String)"FaAssetChangePrintPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"FaAssetChangePrintPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        }
        return rawValue;
    }
}

