/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.dataasset;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.dataasset.DataAssetUtil;
import kd.fi.fa.business.dataasset.DetailStatusEnum;
import kd.fi.fa.business.utils.FaMutexRequireUtil;
import kd.fi.fa.utils.FaF7DeptUtils;

public class DataAssetEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "tbmain"});
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        orgF7.setIsOnlyDisplayOrgLeaves(true);
        DynamicObject assetUnit = (DynamicObject)this.getModel().getValue("org");
        OrgEdit accountOrgF7 = (OrgEdit)this.getControl("accountorg");
        accountOrgF7.addBeforeF7SelectListener(listener -> {
            ListShowParameter params = (ListShowParameter)listener.getFormShowParameter();
            List qFilters = params.getListFilterParameter().getQFilters();
            if (assetUnit == null) {
                qFilters.add(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            } else {
                List fromOrgList = OrgUnitServiceHelper.getFromOrgs((String)"09", (Long)assetUnit.getLong("id"), (String)"10", (boolean)true);
                qFilters.add(new QFilter("id", "in", (Object)fromOrgList));
            }
        });
        DynamicObject org = (DynamicObject)this.getModel().getValue("accountorg");
        BasedataEdit deptF7 = (BasedataEdit)this.getControl("keepdept");
        deptF7.addBeforeF7SelectListener(evt -> FaF7DeptUtils.beforeDeptSelect(evt, org, assetUnit));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.fillEntry();
        this.getModel().setDataChanged(false);
    }

    private void fillEntry() {
        Object id = this.getModel().getValue("id");
        if (id == null || 0L == Long.parseLong(String.valueOf(id))) {
            return;
        }
        String billStatus = (String)this.getModel().getValue("billstatus");
        if ("C".equals(billStatus)) {
            this.getModel().deleteEntryData("entryentity");
            DataAssetUtil.fillEntry((Object)id, (AbstractFormDataModel)((AbstractFormDataModel)this.getModel()), (IFormView)this.getView(), (String)"entryentity", (int)8);
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            entryGrid.setSplitPage(Boolean.FALSE.booleanValue());
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                Date detailMdfTime = ((DynamicObject)entryEntity.get(i)).getDate("detailmdftime");
                this.getModel().setValue("detailmdftimetext", (Object)detailMdfTime.toString(), i);
            }
            entryEntity.sort(Comparator.comparingLong(a -> a.getLong("id")));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tb_modify".equals(itemKey) || "tb_disable".equals(itemKey)) {
            this.showDetail(itemKey);
        } else if ("tb_new".equals(itemKey)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            Object detailMdfTime = this.getModel().getValue("detailmdftime", rowIndex);
            this.getModel().setValue("detailmdftimetext", (Object)String.valueOf(detailMdfTime), rowIndex);
        } else if ("tb_viewlist".equals(itemKey)) {
            this.showDataAssetDetailList("tb_viewlist");
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObjectCollection collection;
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs.length == (collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity")).size()) {
            String message = ResManager.loadKDString((String)"\u6ca1\u6709\u751f\u6548\u7684\u6570\u636e\u660e\u7ec6\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"DataAssetEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(message);
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            this.updateScaleQty();
        } else if ("unaudit".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showDetail(String operationKey) {
        boolean require = FaMutexRequireUtil.requireMutex((String)"fa_dataasset_card", (Object)this.getModel().getValue("id"), (String)"dataasset_mdf", (String)"detailmodify");
        if (require) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("fa_dataassetdetail");
            formShowParameter.getCustomParams().put("dataAssetId", this.getModel().getValue("id"));
            formShowParameter.getCustomParams().put("lastModifyTime", this.getModel().getValue("lastmodifytime"));
            formShowParameter.getCustomParams().put("operationKey", operationKey);
            formShowParameter.getCustomParams().put("scaleUnit", DataAssetUtil.getBaseDataId((IDataModel)this.getModel(), (String)"scaleunit"));
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, operationKey));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(formShowParameter);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u8d44\u4ea7\u6b63\u5728\u8fdb\u884c\u4fee\u6539\u6216\u5931\u6548\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"DataAssetEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (DataAssetUtil.NEED_UPDATE_DETAIL_MDF_TIME_FIELDS.contains(propName)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            long currUserId = RequestContext.get().getCurrUserId();
            this.getModel().setValue("detailmodifer", (Object)currUserId, rowIndex);
        }
        if ("detailqty".equals(propName) || "detailmdftime".equals(propName)) {
            Object newValue;
            if ("detailmdftime".equals(propName) && (newValue = e.getChangeSet()[0].getNewValue()) == null) {
                return;
            }
            this.updateScaleQty();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("tb_modify".equals(actionId) || "tb_disable".equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData != null) {
                Map map = (Map)SerializationUtils.fromJsonString((String)returnData.toString(), Map.class);
                Boolean viewList = (Boolean)map.get("viewlist");
                if (viewList != null && viewList.booleanValue()) {
                    this.showDataAssetDetailList(actionId);
                }
            } else {
                this.fillEntry();
                this.updateScaleQty();
                FaMutexRequireUtil.releaseMutex((Object)this.getModel().getValue("id"), (String)"fa_dataasset_card", (String)"detailmodify");
            }
        }
    }

    private void showDataAssetDetailList(String actionId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("fa_dataassetdetail_base");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        Object dataAssetId = this.getModel().getValue("id");
        qFilters.add(new QFilter("dataasset", "=", dataAssetId));
        showParameter.getCustomParams().put("dataAssetId", dataAssetId);
        showParameter.getCustomParams().put("dataAssetPageId", this.getView().getPageId());
        showParameter.getCustomParams().put("lastModifyTime", this.getModel().getValue("lastmodifytime"));
        showParameter.getCustomParams().put("actionId", actionId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void updateScaleQty() {
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        boolean haveEmptyDetailMdfTime = false;
        for (DynamicObject detail : entryEntity) {
            if (detail.get("detailmdftime") != null) continue;
            haveEmptyDetailMdfTime = true;
        }
        if (haveEmptyDetailMdfTime) {
            return;
        }
        Object newScaleQty = BigDecimal.ZERO;
        Date lastModifyTime = null;
        List list = entryEntity.stream().filter(row -> DetailStatusEnum.ENABLE.getValue().equals(row.get("detailstatus"))).sorted(Comparator.comparing(row -> row.getDate("detailmdftime"))).collect(Collectors.toList());
        if (list.size() > 0) {
            DynamicObject detail = (DynamicObject)list.get(list.size() - 1);
            newScaleQty = detail.get("detailqty");
            lastModifyTime = detail.getDate("detailmdftime");
        }
        this.getModel().setValue("scaleqty", newScaleQty);
        this.getModel().setValue("lastmodifytime", lastModifyTime);
    }

    public void afterImportData(ImportDataEventArgs e) {
        BillModel model = (BillModel)this.getModel();
        model.setValue("assetqty", (Object)BigDecimal.ONE);
        Object scaleUnit = DataAssetUtil.getBaseDataId((IDataModel)this.getModel(), (String)"scaleunit");
        DynamicObjectCollection entryEntity = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject detail : entryEntity) {
            detail.set("detailunit", scaleUnit);
            detail.set("detailstatus", (Object)DetailStatusEnum.ENABLE.getValue());
        }
        Object scaleQty = BigDecimal.ZERO;
        Date lastModifyTime = null;
        List list = entryEntity.stream().sorted(Comparator.comparing(row -> row.getDate("detailmdftime"))).collect(Collectors.toList());
        if (list.size() > 0) {
            DynamicObject detail = (DynamicObject)list.get(list.size() - 1);
            scaleQty = detail.get("detailqty");
            lastModifyTime = detail.getDate("detailmdftime");
        }
        this.getModel().setValue("scaleqty", scaleQty);
        this.getModel().setValue("initqty", scaleQty);
        this.getModel().setValue("lastmodifytime", lastModifyTime);
    }
}

