/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class FaDynamicListDataProvider
extends ListDataProvider {
    private static final String SOURCE_NAME = "sourcename";
    private static final String ENTITY_NAME_CN = "entitynamecn";

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection rows = super.getData(start, limit);
        if (rows.isEmpty()) {
            return rows;
        }
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(SOURCE_NAME, String.class, (Object)""));
        rows.getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty(ENTITY_NAME_CN, String.class, (Object)""));
        Set formIdSet = rows.stream().map(item -> item.getString("entityname")).collect(Collectors.toSet());
        Map<String, String> designFormName = FaDynamicListDataProvider.getDesignFormName(new ArrayList<String>(formIdSet));
        Map<String, List<DynamicObject>> groupBySourceName = rows.stream().collect(Collectors.groupingBy(item -> item.getString("entityname")));
        if (groupBySourceName == null || groupBySourceName.size() == 0) {
            return rows;
        }
        Map<Long, String> billNumber = this.getBillNumber(groupBySourceName);
        for (DynamicObject row : rows) {
            String paramVal;
            long sourceBillId = row.getLong("changebillid");
            String entityName = row.getString("entityname");
            DataEntityPropertyCollection propertys = row.getDataEntityType().getProperties();
            if (!propertys.containsKey((Object)SOURCE_NAME) || Objects.isNull(paramVal = row.getString(SOURCE_NAME))) continue;
            if (!("fa_initAutoSwitch".equals(entityName) || "fa_dyndepre".equals(entityName) || "fa_card_fin".equals(entityName))) {
                row.set(SOURCE_NAME, (Object)billNumber.getOrDefault(sourceBillId, ""));
            }
            row.set(ENTITY_NAME_CN, (Object)designFormName.getOrDefault(entityName, ""));
        }
        return rows;
    }

    public Map<Long, String> getBillNumber(Map<String, List<DynamicObject>> groupBySourceMap) {
        HashMap<Long, String> resultMap = new HashMap<Long, String>(16);
        for (Map.Entry<String, List<DynamicObject>> element : groupBySourceMap.entrySet()) {
            Set<Long> idSet = element.getValue().stream().map(e -> e.getLong("changebillid")).collect(Collectors.toSet());
            Map<Long, String> longStringMap = this.executeQuery(element.getKey(), idSet);
            if (longStringMap == null || longStringMap.size() == 0) continue;
            for (Map.Entry<Long, String> item : longStringMap.entrySet()) {
                resultMap.putIfAbsent(item.getKey(), item.getValue());
            }
        }
        return resultMap;
    }

    public Map<Long, String> executeQuery(String type, Set<Long> idSet) {
        HashMap<Long, String> resultMap = new HashMap(16);
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", idSet)};
        switch (type) {
            case "fa_assetsplitbill": {
                resultMap = this.query("fa_assetsplitbill", qFilters, "id", "billno");
                break;
            }
            case "fa_change_dept": {
                resultMap = this.query("fa_change_dept", qFilters, "id", "billno");
                break;
            }
            case "fa_dispatch_in": {
                resultMap = this.query("fa_dispatch", qFilters, "id", "billno");
                break;
            }
            case "fa_asset_devalue": {
                resultMap = this.query("fa_asset_devalue", qFilters, "id", "billno");
                break;
            }
            case "fa_mergebill": {
                resultMap = this.query("fa_mergebill", qFilters, "id", "billno");
                break;
            }
            case "fa_depreadjustbill": {
                resultMap = this.query("fa_depreadjustbill", qFilters, "id", "billno");
                break;
            }
            default: {
                return Collections.EMPTY_MAP;
            }
        }
        return resultMap;
    }

    private Map<Long, String> query(String entityName, QFilter[] qFilters, String idName, String billNumberName) {
        DynamicObjectCollection queryResultMap = QueryServiceHelper.query((String)entityName, (String)(idName + "," + billNumberName), (QFilter[])qFilters);
        if (CollectionUtils.isEmpty((Collection)queryResultMap)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        for (DynamicObject element : queryResultMap) {
            map.put(element.getLong(idName), element.getString(billNumberName));
        }
        return map;
    }

    private static Map<String, String> getDesignFormName(List<String> formIdList) {
        HashMap<String, String> resultMap = new HashMap<String, String>(8);
        for (String entityName : formIdList) {
            if ("fa_initAutoSwitch".equals(entityName) || "fa_dyndepre".equals(entityName)) {
                resultMap.put(entityName, ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"FaDynamicListDataProvider_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                continue;
            }
            String entry = EntityMetadataCache.getDataEntityType((String)entityName).getDisplayName().toString();
            resultMap.put(entityName, entry);
        }
        return resultMap;
    }
}

