/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.importhandler;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaChangeModeConfUtil;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaCurrencyUtil;
import kd.fi.fa.formplugin.importhandler.CheckResult;

public class ClearBillImportHandler {
    public static final String ERRMSG = "errMsg";
    public static final String ASSETBOOKKEY = "assetbookKey";
    public static final String ORGKEY = "orgKey";
    public static final String formatStr = "%s_%s";

    public void beforeImporChecktData(IFormView view, BeforeImportDataEventArgs e) {
        List<DynamicObject> asseBookList;
        Map<String, DynamicObject> deprePeriodMap;
        Long orgid;
        Map sourceData = e.getSourceData();
        String orgNumber = this.getNumber(sourceData, "org");
        Map<String, Object> orgErrMap = this.checkOrg(orgNumber);
        String orgErrStr = orgErrMap.get(ERRMSG).toString();
        if (!orgErrStr.isEmpty()) {
            e.setCancelMessage(orgErrStr);
            e.setCancel(true);
            return;
        }
        DynamicObject org = (DynamicObject)orgErrMap.get(ORGKEY);
        Object orgPK = org.get("id");
        DynamicObject[] assetBooks = this.getAssetBooks(orgPK);
        Map<Object, Object> asseBookMap = new HashMap();
        Date clearDate = null;
        try {
            clearDate = DateUtil.getShortDate().parse(sourceData.get("cleardate").toString());
        }
        catch (Exception e1) {
            String curErr = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u7684\u65e5\u671f\u4e3a\u7a7a\u6216\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"ClearBillImportHandler_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            e.setCancelMessage(curErr);
            e.setCancel(true);
            return;
        }
        asseBookMap = this.checkAsseBook(assetBooks, clearDate);
        String errStr = asseBookMap.get(ERRMSG).toString();
        if (!errStr.isEmpty()) {
            e.setCancelMessage(errStr);
            e.setCancel(true);
            return;
        }
        List entries = (List)sourceData.get("detail_entry");
        String asseErr = this.checkAssetnum(entries, orgid = Long.valueOf(org.getLong("id")), deprePeriodMap = this.getDeprePeriodMap(asseBookList = Arrays.asList((DynamicObject[])asseBookMap.get(ASSETBOOKKEY))));
        if (!asseErr.isEmpty()) {
            e.setCancelMessage(asseErr);
            e.setCancel(true);
            return;
        }
    }

    Map<String, DynamicObject> getDeprePeriodMap(List<DynamicObject> asseBookList) {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>(asseBookList.size());
        for (DynamicObject assetBook : asseBookList) {
            String depreuseNum = assetBook.getDynamicObject("depreuse").getString("number");
            result.put(depreuseNum, assetBook.getDynamicObject("curperiod"));
        }
        return result;
    }

    private Map<String, Object> checkOrg(String orgNumber) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ERRMSG, "");
        if (orgNumber.isEmpty()) {
            result.put(ERRMSG, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"ClearBillImportHandler_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return result;
        }
        return (Map)ThreadCache.get((Object)("clearBillCheckOrg" + orgNumber), () -> {
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)orgNumber), new QFilter("status", "=", (Object)BillStatus.C)};
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])filters);
            if (org == null) {
                result.put(ERRMSG, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"ClearBillImportHandler_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return result;
            }
            result.put(ORGKEY, org);
            return result;
        });
    }

    DynamicObject[] getAssetBooks(Object orgPK) {
        return (DynamicObject[])ThreadCache.get((Object)("clearBillGetAssetBooks" + orgPK.toString()), () -> {
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", orgPK)};
            String fields = Fa.join((String)",", (String[])new String[]{"curperiod", "periodtype", "ismainbook", "depreuse", "status"});
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)fields, (QFilter[])filters);
            return assetBooks;
        });
    }

    private Map<String, Object> checkAsseBook(DynamicObject[] assetBooks, Date clearDate) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ERRMSG, "");
        result.put(ASSETBOOKKEY, assetBooks);
        if (assetBooks == null || assetBooks.length == 0) {
            result.put(ERRMSG, ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"ClearBillImportHandler_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return result;
        }
        String errmsg = "";
        List usedAssetBooks = Arrays.asList(assetBooks).stream().filter(dy -> BillStatus.C.toString().equals(dy.getString("status")) && dy.getBoolean("ismainbook")).collect(Collectors.toList());
        if (usedAssetBooks.size() == 0) {
            result.put(ERRMSG, ResManager.loadKDString((String)"\u4e3b\u8d26\u7c3f\u672a\u542f\u7528\u3002", (String)"ClearBillImportHandler_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return result;
        }
        DynamicObject mainPeriodDy = ((DynamicObject)usedAssetBooks.get(0)).getDynamicObject("curperiod");
        Date beignDate = mainPeriodDy.getDate("begindate");
        Date endDate = mainPeriodDy.getDate("enddate");
        if (clearDate.compareTo(endDate) > 0 || clearDate.compareTo(beignDate) < 0) {
            errmsg = ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5728\u4e3b\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u8303\u56f4\u5185\u3002", (String)"ClearBillImportHandler_5", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            result.put(ERRMSG, errmsg);
        }
        return result;
    }

    private String checkAssetnum(List<Map<String, Object>> entries, Long orgid, Map<String, DynamicObject> depreusePeriodMap) {
        String errmsg = "";
        if (entries == null || entries.size() == 0) {
            return "";
        }
        StringBuilder checkErrSB = new StringBuilder();
        Boolean isPartClear = entries.get(0).containsKey("depreuse");
        CheckResult assetMsg = this.checkAssetRow(entries);
        if (!assetMsg.Status.booleanValue()) {
            checkErrSB.append(assetMsg.ErrStr).append("\r\n");
            return checkErrSB.toString();
        }
        CheckResult repeatMsg = this.checkRepeatRow(entries, isPartClear);
        if (!repeatMsg.Status.booleanValue()) {
            checkErrSB.append(repeatMsg.ErrStr).append("\r\n");
            return checkErrSB.toString();
        }
        if (isPartClear.booleanValue()) {
            CheckResult depreuseMsg = this.checkDepreuse(entries, depreusePeriodMap);
            if (!depreuseMsg.Status.booleanValue()) {
                checkErrSB.append(depreuseMsg.ErrStr).append("\r\n");
                return checkErrSB.toString();
            }
        }
        CheckResult bizDateMsg = this.checkBizDate(entries, depreusePeriodMap, isPartClear);
        if (!bizDateMsg.Status.booleanValue()) {
            checkErrSB.append(bizDateMsg.ErrStr).append("\r\n");
            return checkErrSB.toString();
        }
        CheckResult numberMsg = this.checkNumber(entries, isPartClear);
        if (!numberMsg.Status.booleanValue()) {
            checkErrSB.append(numberMsg.ErrStr).append("\r\n");
            return checkErrSB.toString();
        }
        ArrayList<String> usefulNums = new ArrayList<String>((Set)repeatMsg.Data);
        CheckResult readyMsg = this.checkRealCard(usefulNums, orgid);
        if (!readyMsg.Status.booleanValue() || readyMsg.Data != null && ((DynamicObject[])readyMsg.Data).length == 0) {
            checkErrSB.append(readyMsg.ErrStr).append("\r\n");
            return checkErrSB.toString();
        }
        DynamicObject[] realCards = (DynamicObject[])readyMsg.Data;
        Map<String, DynamicObject> realCardMap = new HashMap<String, DynamicObject>();
        if (realCards != null && realCards.length > 0) {
            realCardMap = Arrays.asList(realCards).stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy));
        }
        CheckResult finMsg = this.checkFinCard(orgid, depreusePeriodMap, realCardMap);
        if (!finMsg.Status.booleanValue()) {
            checkErrSB.append(finMsg.ErrStr).append("\r\n");
            return checkErrSB.toString();
        }
        if (isPartClear.booleanValue()) {
            List finCards = (List)finMsg.Data;
            ArrayList<String> assWithDeperuses = new ArrayList<String>((Set)repeatMsg.Data1);
            CheckResult allDeperuseResult = this.checkAllDeperuse(finCards, assWithDeperuses);
            if (!allDeperuseResult.Status.booleanValue()) {
                checkErrSB.append(allDeperuseResult.ErrStr).append("\r\n");
                return checkErrSB.toString();
            }
            CheckResult origignalValResult = this.checkOriginalval(finCards, entries);
            if (!origignalValResult.Status.booleanValue()) {
                checkErrSB.append(origignalValResult.ErrStr).append("\r\n");
                return checkErrSB.toString();
            }
        }
        errmsg = checkErrSB.toString();
        return errmsg;
    }

    CheckResult checkAssetRow(List<Map<String, Object>> entries) {
        CheckResult result = new CheckResult();
        result.Status = true;
        Boolean nullFalg = false;
        for (Map<String, Object> entry : entries) {
            if (entry.get("number") != null) continue;
            nullFalg = true;
            break;
        }
        if (nullFalg.booleanValue()) {
            String curErrmsg = ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u5b58\u5728\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClearBillImportHandler_6", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            result.Status = false;
            result.ErrStr = curErrmsg;
        }
        return result;
    }

    CheckResult checkRepeatRow(List<Map<String, Object>> entries, Boolean isPartClear) {
        CheckResult result = new CheckResult();
        result.Status = true;
        HashSet<String> asseNums = new HashSet<String>(entries.size());
        HashSet<String> asseWithDepreuse = new HashSet<String>();
        HashSet<String> repeatSet = new HashSet<String>();
        for (Map<String, Object> entry : entries) {
            String asseNum = entry.get("number").toString();
            String keyStr = this.getRowKey(entry, isPartClear);
            asseNums.add(asseNum);
            if (asseWithDepreuse.contains(keyStr)) {
                repeatSet.add(keyStr);
                continue;
            }
            asseWithDepreuse.add(keyStr);
        }
        result.Data = asseNums;
        result.Data1 = asseWithDepreuse;
        if (repeatSet.size() > 0) {
            String curErrmsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u5b58\u5728\u91cd\u590d\uff1a%s\u3002", (String)"ClearBillImportHandler_7", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", repeatSet));
            result.Status = false;
            result.ErrStr = curErrmsg;
        }
        return result;
    }

    CheckResult checkDepreuse(List<Map<String, Object>> entries, Map<String, DynamicObject> depreusePeriodMap) {
        CheckResult result = new CheckResult();
        result.Status = true;
        HashSet<String> keys = new HashSet<String>();
        for (Map<String, Object> entry : entries) {
            Object depreuseObj = ((Map)entry.get("depreuse")).get("number");
            if (depreuseObj == null) {
                keys.add("null");
                continue;
            }
            String depreuse = depreuseObj.toString();
            if (depreusePeriodMap.containsKey(depreuse)) continue;
            keys.add(depreuse);
        }
        if (keys.size() > 0) {
            String errCaption = ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e3a\u7a7a\u6216\u4e0d\u5b58\u5728\u3002", (String)"ClearBillImportHandler_8", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            String curErrmsg = String.format("%s\uff1a%s", errCaption, String.join((CharSequence)",", keys));
            result.Status = false;
            result.ErrStr = curErrmsg;
        }
        return result;
    }

    CheckResult checkBizDate(List<Map<String, Object>> entries, Map<String, DynamicObject> depreusePeriodMap, Boolean isPartClear) {
        String curErrmsg;
        CheckResult result = new CheckResult();
        result.Status = true;
        HashSet<String> keys = new HashSet<String>();
        HashSet<String> badkeys = new HashSet<String>();
        if (isPartClear.booleanValue()) {
            for (Map<String, Object> entry : entries) {
                String depreuse = ((Map)entry.get("depreuse")).get("number").toString();
                DynamicObject curPeriod = depreusePeriodMap.get(depreuse);
                String keyStr = this.getRowKey(entry, isPartClear);
                try {
                    Date endDate;
                    Date bizDate = DateUtil.getShortDate().parse(entry.get("bizdate").toString());
                    if (bizDate.compareTo(endDate = curPeriod.getDate("enddate")) <= 0) continue;
                    keys.add(keyStr);
                }
                catch (Exception ex) {
                    badkeys.add(keyStr);
                }
            }
        } else {
            for (Map<String, Object> entry : entries) {
                String keyStr = this.getRowKey(entry, isPartClear);
                try {
                    Date bizDate = DateUtil.getShortDate().parse(entry.get("bizdate").toString());
                    Boolean errFlag = false;
                    for (DynamicObject period : depreusePeriodMap.values()) {
                        Date endDate = period.getDate("enddate");
                        if (bizDate.compareTo(endDate) <= 0) continue;
                        errFlag = true;
                        break;
                    }
                    if (!errFlag.booleanValue()) continue;
                    keys.add(keyStr);
                }
                catch (Exception ex) {
                    badkeys.add(keyStr);
                }
            }
        }
        ArrayList<String> errList = new ArrayList<String>();
        if (badkeys.size() > 0) {
            curErrmsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e(yyyy-MM-dd)\uff1a%s\u3002", (String)"ClearBillImportHandler_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", badkeys));
            errList.add(curErrmsg);
        }
        if (keys.size() > 0) {
            curErrmsg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u671f\u95f4\uff1a%s\u3002", (String)"ClearBillImportHandler_10", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", keys));
            errList.add(curErrmsg);
        }
        if (errList.size() > 0) {
            curErrmsg = String.format(" %s", String.join((CharSequence)",", errList));
            result.Status = false;
            result.ErrStr = curErrmsg;
        }
        return result;
    }

    CheckResult checkNumber(List<Map<String, Object>> entries, Boolean isPartClear) {
        String curErrmsg;
        CheckResult result = new CheckResult();
        result.Status = true;
        HashSet<String> clearfare = new HashSet<String>();
        HashSet<String> clearincome = new HashSet<String>();
        HashSet<String> assetvalue = new HashSet<String>();
        for (Map<String, Object> entry : entries) {
            String keyStr = this.getRowKey(entry, isPartClear);
            if (entry.get("clearfare") != null && !this.isNumeric(entry.get("clearfare").toString())) {
                clearfare.add(keyStr);
            }
            if (entry.get("clearincome") != null && !this.isNumeric(entry.get("clearincome").toString())) {
                clearincome.add(keyStr);
            }
            if (!isPartClear.booleanValue() || entry.get("assetvalue") != null && this.isNumeric(entry.get("assetvalue").toString())) continue;
            assetvalue.add(keyStr);
        }
        ArrayList<String> errList = new ArrayList<String>();
        if (clearfare.size() > 0) {
            curErrmsg = String.format(ResManager.loadKDString((String)"\u6e05\u7406\u8d39\u7528\u4e0d\u4e3a\u6570\u5b57\uff1a%s\u3002", (String)"ClearBillImportHandler_11", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", clearfare));
            errList.add(curErrmsg);
        }
        if (clearincome.size() > 0) {
            curErrmsg = String.format(ResManager.loadKDString((String)"\u6e05\u7406\u6536\u5165\u4e0d\u4e3a\u6570\u5b57\uff1a%s\u3002", (String)"ClearBillImportHandler_12", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", clearincome));
            errList.add(curErrmsg);
        }
        if (assetvalue.size() > 0) {
            curErrmsg = String.format(ResManager.loadKDString((String)"\u6e05\u7406\u8d44\u4ea7\u539f\u503c\u4e3a\u7a7a\u6216\u4e0d\u4e3a\u6570\u5b57\uff1a%s\u3002", (String)"ClearBillImportHandler_13", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", assetvalue));
            errList.add(curErrmsg);
        }
        if (errList.size() > 0) {
            curErrmsg = String.format(" %s", String.join((CharSequence)",", errList));
            result.Status = false;
            result.ErrStr = curErrmsg;
        }
        return result;
    }

    public boolean isNumeric(String str) {
        try {
            String bigStr = new BigDecimal(str).toString();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    CheckResult checkRealCard(List<String> usefulNums, Long orgid) {
        DynamicObject[] realCards;
        CheckResult result = new CheckResult();
        result.Status = true;
        QFilter[] realCardfilters = new QFilter[]{new QFilter("org", "=", (Object)orgid), new QFilter("number", "in", usefulNums), new QFilter("isbak", "=", (Object)Character.valueOf('0')), new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY), new QFilter("billstatus", "=", (Object)BillStatus.C)};
        String realFields = Fa.join((String)",", (String[])new String[]{"number", "bizstatus", "billstatus", "org"});
        result.Data = realCards = BusinessDataServiceHelper.load((String)"fa_card_real", (String)realFields, (QFilter[])realCardfilters);
        if (realCards == null || realCards.length == 0) {
            result.Status = false;
            result.ErrStr = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5df2\u5c31\u7eea\u7684\u5b9e\u7269\u5361\u7247\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClearBillImportHandler_14", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            return result;
        }
        Map<String, DynamicObject> realCardMap = Arrays.asList(realCards).stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy));
        Set<String> existsAsseNum = realCardMap.keySet();
        List notExistAsseNums = usefulNums.stream().filter(assenum -> !existsAsseNum.contains(assenum)).collect(Collectors.toList());
        if (notExistAsseNums.size() > 0) {
            result.Status = false;
            result.ErrStr = String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5df2\u5c31\u7eea\u7684\u5b9e\u7269\u5361\u7247:%s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClearBillImportHandler_15", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", notExistAsseNums));
        }
        return result;
    }

    CheckResult checkFinCard(Long orgid, Map<String, DynamicObject> depreusePeriodMap, Map<String, DynamicObject> realCardMap) {
        CheckResult result = new CheckResult();
        result.Status = true;
        ArrayList<String> notMatchPeriodAsseNums = new ArrayList<String>();
        ArrayList<String> usefulNums = new ArrayList<String>(realCardMap.keySet());
        List realCardIds = usefulNums.stream().map(asseNum -> ((DynamicObject)realCardMap.get(asseNum)).getLong("id")).collect(Collectors.toList());
        for (Map.Entry<String, DynamicObject> depreusePeriod : depreusePeriodMap.entrySet()) {
            long periodId = depreusePeriod.getValue().getLong("id");
            QFilter finCardFilter1 = new QFilter("org", "=", (Object)orgid);
            QFilter finCardFilter2 = new QFilter("realcardmasterid", "in", realCardIds);
            QFilter finCardFilter3 = new QFilter("bizperiod", "<=", (Object)periodId);
            QFilter finCardFilter4 = new QFilter("endperiod", ">=", (Object)periodId);
            QFilter[] finCardFilters = new QFilter[]{finCardFilter1, finCardFilter2, finCardFilter3, finCardFilter4};
            String selector = Fa.comma((String[])new String[]{"id", "realcard", "realcardmasterid", "depreuse", "bizperiod", "endperiod", "originalval", "number"});
            DynamicObject[] finCardArr = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])finCardFilters);
            result.Data = new ArrayList<DynamicObject>(Arrays.asList(finCardArr));
            if (finCardArr == null || finCardArr.length == 0) {
                result.Status = false;
                result.ErrStr = ResManager.loadKDString((String)"\u4e0d\u80fd\u6e05\u7406\u672a\u6765\u671f\u95f4\u5361\u7247\u3002", (String)"ClearBillImportHandler_17", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                return result;
            }
            ArrayList<DynamicObject> finCards = new ArrayList<DynamicObject>(Arrays.asList(finCardArr));
            List usefulRealCardIds = finCards.stream().map(dy -> dy.getDynamicObject("realcard").getLong("id")).collect(Collectors.toList());
            for (String asseNum2 : usefulNums) {
                Long curRealCardId = realCardMap.get(asseNum2).getLong("id");
                if (usefulRealCardIds.contains(curRealCardId)) continue;
                notMatchPeriodAsseNums.add(asseNum2);
            }
        }
        if (notMatchPeriodAsseNums.size() > 0) {
            result.Status = false;
            result.ErrStr = String.format(ResManager.loadKDString((String)"\u4e0d\u80fd\u6e05\u7406\u672a\u6765\u671f\u95f4\u5df2\u5b58\u5728\u5361\u7247\u6216\u5b58\u5728\u672a\u6765\u4e1a\u52a1\u5173\u8054\u5355\u636e\uff1a%s\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ClearBillImportHandler_18", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", notMatchPeriodAsseNums));
            return result;
        }
        return result;
    }

    CheckResult checkOriginalval(List<DynamicObject> finCards, List<Map<String, Object>> entries) {
        CheckResult result = new CheckResult();
        result.Status = true;
        HashMap<Object, BigDecimal> finMap = new HashMap<Object, BigDecimal>(finCards.size());
        for (DynamicObject dy : finCards) {
            String keyStr = String.format(formatStr, dy.getString("number"), dy.getDynamicObject("depreuse").getString("number"));
            finMap.put(keyStr, dy.getBigDecimal("originalval"));
        }
        HashSet<String> lessZero = new HashSet<String>(entries.size() / 2);
        HashSet<String> lagerCard = new HashSet<String>(entries.size() / 2);
        for (Map map : entries) {
            String keyStr = this.getRowKey(map, true);
            if (map.get("assetvalue") == null || !finMap.containsKey(keyStr)) continue;
            BigDecimal rowOriginal = this.getBigDecimal(map.get("assetvalue"));
            if (rowOriginal.compareTo(BigDecimal.ZERO) < 0) {
                lessZero.add(keyStr);
                continue;
            }
            if (rowOriginal.compareTo((BigDecimal)finMap.get(keyStr)) <= 0) continue;
            lagerCard.add(keyStr);
        }
        ArrayList<String> errList = new ArrayList<String>();
        if (lessZero.size() > 0) {
            String string = String.format(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5361\u7247\u6e05\u7406\u8d44\u4ea7\u539f\u503c\u4e0d\u80fd\u5c0f\u4e8e0\uff1a%s\u3002", (String)"ClearBillImportHandler_19", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", lessZero));
            errList.add(string);
        }
        if (lagerCard.size() > 0) {
            String string = String.format(ResManager.loadKDString((String)"\u6e05\u7406\u8d44\u4ea7\u539f\u503c\u4e0d\u80fd\u5927\u4e8e\u8d44\u4ea7\u539f\u503c\uff1a%s\u3002", (String)"ClearBillImportHandler_20", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", lagerCard));
            errList.add(string);
        }
        if (errList.size() > 0) {
            String string;
            result.Status = false;
            result.ErrStr = string = String.join((CharSequence)",", errList);
        }
        return result;
    }

    CheckResult checkAllDeperuse(List<DynamicObject> finCards, List<String> assWithDeperuses) {
        CheckResult result = new CheckResult();
        result.Status = true;
        HashSet<String> keySet = new HashSet<String>(finCards.size());
        for (DynamicObject dy : finCards) {
            String keyStr = String.format(formatStr, dy.getString("number"), dy.getDynamicObject("depreuse").getString("number"));
            keySet.add(keyStr);
        }
        keySet.removeAll(assWithDeperuses);
        if (keySet.size() > 0) {
            String curErrmsg;
            result.Status = false;
            result.ErrStr = curErrmsg = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u5bf9\u5e94\u7684\u6298\u65e7\u7528\u9014\u4e0d\u5b8c\u6574\uff1a%s\u3002", (String)"ClearBillImportHandler_21", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", keySet));
        }
        return result;
    }

    DynamicObject[] getFinCard(Long orgid, long period, List<String> usefulNums) {
        CheckResult result = new CheckResult();
        result.Status = true;
        QFilter finCardFilter1 = new QFilter("org", "=", (Object)orgid);
        QFilter finCardFilter2 = new QFilter("number", "in", usefulNums);
        QFilter finCardFilter3 = new QFilter("bizperiod", "<=", (Object)period);
        QFilter finCardFilter4 = new QFilter("endperiod", ">=", (Object)period);
        QFilter[] finCardFilters = new QFilter[]{finCardFilter1, finCardFilter2, finCardFilter3, finCardFilter4};
        String selector = Fa.comma((String[])new String[]{"id", "realcard", "depreuse", "bizperiod", "endperiod", "originalval", "number"});
        DynamicObject[] finCardArr = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])finCardFilters);
        return finCardArr;
    }

    String getRowKey(Map<String, Object> entry, Boolean isPartClear) {
        String asseNum = entry.get("number").toString();
        String depreuse = entry.get("depreuse") == null ? "" : ((Map)entry.get("depreuse")).get("number").toString();
        String keyStr = isPartClear != false ? String.format(formatStr, asseNum, depreuse) : asseNum;
        return keyStr;
    }

    public void setSourceData2Model(IDataModel model) {
        this.setHeadData2Model(model);
        this.setEntry2Model(model);
    }

    public void setHeadData2Model(IDataModel model) {
        long orgId;
        DynamicObject mainBook;
        DynamicObject org = (DynamicObject)model.getValue("org");
        model.setValue("billstatus", (Object)BillStatus.A);
        if (model.getValue("changemode") == null) {
            Long defValue = (Long)ThreadCache.get((Object)("getChangeModeDefaultValue" + org.getLong("id") + "fa_clearbill"), () -> FaChangeModeConfUtil.getChangeModeDefaultValue((Long)((Long)org.getPkValue()), (String)"fa_clearbill"));
            model.setValue("changemode", (Object)defValue);
        }
        model.setValue("clearsource", (Object)FaClearSourceEnum.ADDNEW);
        if (org != null && (mainBook = FaBizUtils.getAsstBookByOrg((Long)(orgId = org.getLong("id")))) != null) {
            model.setValue("clearperiod", (Object)mainBook.getLong("curperiod"));
        }
    }

    public void setEntry2Model(IDataModel model) {
        DynamicObjectCollection entrys = (DynamicObjectCollection)model.getValue("detail_entry");
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        Boolean isPartClear = ((DynamicObject)entrys.get(0)).get("depreuse") != null;
        Map<String, Map<String, Object>> rowMaps = this.getSourceDataMap(entrys, isPartClear);
        ArrayList<String> asseNums = new ArrayList();
        asseNums = entrys.stream().map(row -> row.getString("number")).collect(Collectors.toList());
        long orgId = model.getDataEntity().getLong(Fa.id((String)"org"));
        List realCardLst = FaUtils.getRealCard((Long)orgId, asseNums);
        List realCardIdLst = realCardLst.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        HashSet realCardIdSet = new HashSet(realCardIdLst);
        List<DynamicObject> finCards = FaUtils.queryFinCards(realCardIdSet);
        finCards = this.sortFinCards(finCards, asseNums);
        entrys.clear();
        int seq = 0;
        for (DynamicObject finCard : finCards) {
            this.insertEntryRow(model, finCard, rowMaps, isPartClear, ++seq);
        }
    }

    public List<DynamicObject> sortFinCards(List<DynamicObject> finCards, List<String> asseNums) {
        Map<String, List<DynamicObject>> finCardMap = finCards.stream().collect(Collectors.groupingBy(finCard -> finCard.getString("number")));
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        ArrayList<String> hasSortKeys = new ArrayList<String>();
        for (String asseNum : asseNums) {
            if (finCardMap.get(asseNum) == null || hasSortKeys.contains(asseNum)) continue;
            result.addAll((Collection<DynamicObject>)finCardMap.get(asseNum));
            hasSortKeys.add(asseNum);
        }
        Set lastAssets = asseNums.stream().filter(assetNum -> !hasSortKeys.contains(assetNum)).collect(Collectors.toSet());
        for (String asseNum : lastAssets) {
            if (finCardMap.get(asseNum) == null || hasSortKeys.contains(asseNum)) continue;
            result.addAll((Collection<DynamicObject>)finCardMap.get(asseNum));
            hasSortKeys.add(asseNum);
        }
        return result;
    }

    private void insertEntryRow(IDataModel model, DynamicObject fincard, Map<String, Map<String, Object>> rowMaps, Boolean isPartClear, int seq) {
        DynamicObjectCollection clearBillEntrys = (DynamicObjectCollection)model.getValue("detail_entry");
        DynamicObjectType type = clearBillEntrys.getDynamicObjectType();
        DynamicObject cardEntry = new DynamicObject(type);
        clearBillEntrys.add((Object)cardEntry);
        DynamicObject realCardDy = fincard.getDynamicObject("realcard");
        cardEntry.set("realcard", (Object)realCardDy);
        String asseNum = realCardDy.getString("number");
        String key = isPartClear != false ? String.format(formatStr, asseNum, fincard.getDynamicObject("depreuse").getString("number")) : asseNum;
        cardEntry.set("number", (Object)asseNum);
        cardEntry.set("assetname", (Object)realCardDy.getString("assetname"));
        cardEntry.set("depreuse", (Object)fincard.getDynamicObject("depreuse"));
        cardEntry.set("assetqty", realCardDy.get("assetamount"));
        cardEntry.set("measureunit", (Object)realCardDy.getDynamicObject("unit"));
        DynamicObject baseCurrencyPK = fincard.getDynamicObject(Fa.dot((String[])new String[]{"assetbook", "basecurrency"}));
        cardEntry.set("basecurrency", (Object)baseCurrencyPK);
        cardEntry.set("fincard", (Object)fincard);
        cardEntry.set("seq", (Object)seq);
        Boolean setFlag = false;
        if (rowMaps.containsKey(key)) {
            cardEntry.set("clearfare", rowMaps.get(key).get("clearfare"));
            cardEntry.set("clearincome", rowMaps.get(key).get("clearincome"));
            cardEntry.set("bizdate", rowMaps.get(key).get("bizdate"));
            cardEntry.set("remark", rowMaps.get(key).get("remark"));
            if (isPartClear.booleanValue()) {
                BigDecimal realCardNums = realCardDy.getBigDecimal("assetamount");
                BigDecimal asseValue = BigDecimal.ZERO;
                BigDecimal rate = BigDecimal.ONE;
                BigDecimal originalval = fincard.getBigDecimal("originalval");
                if (realCardNums.compareTo(BigDecimal.ONE) == 0) {
                    asseValue = this.getBigDecimal(rowMaps.get(key).get("assetvalue"));
                    if (asseValue.compareTo(BigDecimal.ZERO) <= 0 || asseValue.compareTo(originalval) >= 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u5206\u6e05\u7406\u6a21\u677f\u5bfc\u5165:\u5b9e\u7269\u5361\u7247\u8d44\u4ea7\u6570\u91cf\u7b49\u4e8e1-\u539f\u503c\u90e8\u5206\u6e05\u7406,\u6e05\u7406\u539f\u503c\u9700\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u8d44\u4ea7\u539f\u503c\u3002", (String)"ClearBillImportHandler_22", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    rate = originalval.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : asseValue.divide(originalval, 10, 4);
                    cardEntry.set("isclearall", (Object)"0");
                    cardEntry.set("clearqty", (Object)realCardDy.getBigDecimal("assetamount"));
                } else {
                    BigDecimal clearQty = (BigDecimal)rowMaps.get(key).get("clearqty");
                    if (clearQty.compareTo(BigDecimal.ZERO) <= 0 || clearQty.compareTo(realCardNums) >= 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u90e8\u5206\u6e05\u7406\u6a21\u677f\u5bfc\u5165:\u5b9e\u7269\u5361\u7247\u8d44\u4ea7\u6570\u91cf\u5927\u4e8e1-\u6570\u91cf\u90e8\u5206\u6e05\u7406,\u6e05\u7406\u6570\u91cf\u9700\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u5b9e\u7269\u5361\u7247\u8d44\u4ea7\u6570\u91cf\u3002", (String)"ClearBillImportHandler_23", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    }
                    rate = clearQty.divide(realCardNums, 10, 4);
                    asseValue = originalval.multiply(rate);
                    cardEntry.set("isclearall", (Object)"2");
                    cardEntry.set("clearqty", (Object)clearQty);
                }
                cardEntry.set("clearrate", (Object)rate);
                asseValue = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrencyPK, (BigDecimal)asseValue);
                cardEntry.set("assetvalue", (Object)asseValue);
                BigDecimal accm_depre_bd = fincard.getBigDecimal("accumdepre").multiply(rate);
                accm_depre_bd = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrencyPK, (BigDecimal)accm_depre_bd);
                cardEntry.set("addupdepre", (Object)accm_depre_bd);
                BigDecimal decvalbd = fincard.getBigDecimal("decval").multiply(rate);
                decvalbd = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrencyPK, (BigDecimal)decvalbd);
                cardEntry.set("decval", (Object)decvalbd);
                BigDecimal netamountbd = fincard.getBigDecimal("netamount").multiply(rate);
                netamountbd = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrencyPK, (BigDecimal)netamountbd);
                cardEntry.set("netamount", (Object)netamountbd);
                BigDecimal preresidualvalbd = fincard.getBigDecimal("preresidualval").multiply(rate);
                preresidualvalbd = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)baseCurrencyPK, (BigDecimal)preresidualvalbd);
                cardEntry.set("preresidualval", (Object)preresidualvalbd);
                setFlag = true;
            }
        }
        if (!setFlag.booleanValue()) {
            cardEntry.set("assetvalue", (Object)fincard.getBigDecimal("originalval"));
            cardEntry.set("addupdepre", (Object)fincard.getBigDecimal("accumdepre"));
            cardEntry.set("decval", (Object)fincard.getBigDecimal("decval"));
            cardEntry.set("netamount", (Object)fincard.getBigDecimal("netamount"));
            cardEntry.set("preresidualval", (Object)fincard.getBigDecimal("preresidualval"));
            cardEntry.set("clearrate", (Object)1);
            cardEntry.set("isclearall", (Object)"1");
            cardEntry.set("clearqty", (Object)realCardDy.getBigDecimal("assetamount"));
        }
    }

    Map<String, Map<String, Object>> getSourceDataMap(DynamicObjectCollection entrys, Boolean isPartClear) {
        HashMap<String, Map<String, Object>> rowMaps = new HashMap<String, Map<String, Object>>();
        if (entrys == null || entrys.size() == 0) {
            return rowMaps;
        }
        for (DynamicObject detail : entrys) {
            String asseNum = detail.getString("number");
            String depreUse = detail.getDynamicObject("depreuse") == null ? "" : detail.getDynamicObject("depreuse").getString("number");
            String key = isPartClear != false ? String.format(formatStr, asseNum, depreUse) : asseNum;
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            rowMap.put("number", detail.getString("number"));
            rowMap.put("clearfare", detail.get("clearfare"));
            rowMap.put("clearincome", detail.get("clearincome"));
            rowMap.put("remark", detail.getString("remark"));
            Date bizDate = detail.getDate("bizdate");
            rowMap.put("bizdate", bizDate);
            if (isPartClear.booleanValue()) {
                rowMap.put("assetvalue", detail.get("assetvalue"));
                rowMap.put("depreuse", depreUse);
                rowMap.put("clearqty", detail.getBigDecimal("clearqty"));
            }
            rowMaps.put(key, rowMap);
        }
        return rowMaps;
    }

    private String getNumber(Map<String, Object> sourceData, String prop) {
        if (!sourceData.containsKey(prop)) {
            return "";
        }
        return this.getPropSimpleValue(sourceData, prop, "number");
    }

    private String getPropSimpleValue(Map<String, Object> sourceData, String prop, String property) {
        return (String)((Map)sourceData.get(prop)).get(property);
    }

    public BigDecimal getBigDecimal(Object value) {
        BigDecimal ret = BigDecimal.ZERO;
        if (value != null) {
            if (value instanceof BigDecimal) {
                ret = (BigDecimal)value;
            } else if (value instanceof String) {
                ret = new BigDecimal((String)value);
            } else if (value instanceof BigInteger) {
                ret = new BigDecimal((BigInteger)value);
            } else if (value instanceof Number) {
                ret = BigDecimal.valueOf(((Number)value).doubleValue());
            } else {
                throw new ClassCastException("Not possible to coerce [" + value + "] from class " + value.getClass() + " into a BigDecimal.");
            }
        }
        return ret;
    }
}

