/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.importhandler;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaDepreAdjustUtils;
import kd.fi.fa.common.util.Fa;

public class DepreAdjustBillImportHandler {
    private String getNumber(Map<String, Object> sourceData, String prop) {
        return (String)((Map)sourceData.get(prop)).get("number");
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        String orgNumber = this.getNumber(sourceData, "org");
        String depreuseNumber = this.getNumber(sourceData, "depreuse");
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter("number", "=", (Object)orgNumber).toArray());
        DynamicObject depreuse = QueryServiceHelper.queryOne((String)"fa_depreuse", (String)"id", (QFilter[])new QFilter("number", "=", (Object)depreuseNumber).toArray());
        if (org == null) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"DepreAdjustBillImportHandler_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (depreuse == null) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u5b58\u5728\u3002", (String)"DepreAdjustBillImportHandler_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Object orgPK = org.get("id");
        Object depreusePK = depreuse.get("id");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", orgPK), new QFilter("depreuse", "=", depreusePK)};
        String fields = Fa.join((String)",", (String[])new String[]{"curperiod", "status"});
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)fields, (QFilter[])filters);
        if (assetBook != null) {
            Set workLoadCards;
            if (!BillStatus.C.toString().equals(assetBook.getString("status"))) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8d26\u7c3f\u672a\u542f\u7528\u3002", (String)"DepreAdjustBillImportHandler_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            DynamicObject period = assetBook.getDynamicObject("curperiod");
            Object periodPk = period.getPkValue();
            List entries = (List)sourceData.get("entryentity");
            HashMap<String, Integer> cardNumberMaps = new HashMap<String, Integer>(entries.size());
            int rowIndex = 0;
            HashSet<String> dulpNumbers = new HashSet<String>(3);
            for (Map entry : entries) {
                String number = this.getNumber(entry, "realcard");
                if (cardNumberMaps.containsKey(number)) {
                    dulpNumbers.add(number);
                }
                cardNumberMaps.put(number, rowIndex++);
            }
            if (dulpNumbers.size() > 0) {
                for (String dulpNumber : dulpNumbers) {
                    e.addCancelMessage((Integer)cardNumberMaps.get(dulpNumber), Integer.valueOf(0), ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\u3002", (String)"DepreAdjustBillImportHandler_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                e.setCancel(true);
            }
            Set rCardNumbers = cardNumberMaps.keySet();
            QFilter billFilter = new QFilter("number", "in", cardNumberMaps.keySet());
            QFilter bakFilter = new QFilter("isbak", "=", (Object)Character.valueOf('0'));
            QFilter orgFilter = new QFilter("org", "=", orgPK);
            DynamicObjectCollection rCards = QueryServiceHelper.query((String)"fa_card_real", (String)"id,number", (QFilter[])new QFilter[]{billFilter, bakFilter, orgFilter});
            HashMap<String, Long> idMap = new HashMap<String, Long>(rCards.size());
            for (Object realCard : rCards) {
                idMap.put(realCard.getString("number"), realCard.getLong("id"));
            }
            Map realCard = null;
            for (Map entry : entries) {
                realCard = (Map)entry.get("realcard");
                realCard.put("id", idMap.get(realCard.get("number")));
            }
            Set rCardPKs = rCards.stream().map(v -> v.get("id")).collect(Collectors.toSet());
            List existsCardId = FaDepreAdjustUtils.getAlreadyDepAdjustCard((Object)orgPK, (Object)depreusePK, (Object)periodPk, rCardPKs, sourceData.get("id"));
            if (existsCardId != null) {
                for (Map.Entry cardNumberMap : cardNumberMaps.entrySet()) {
                    DynamicObject[] cardNumber = (DynamicObject[])cardNumberMap.getKey();
                    if (!existsCardId.contains(cardNumber)) continue;
                    e.addCancelMessage((Integer)cardNumberMap.getValue(), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a%s\u5f53\u671f\u5b58\u5728\u6298\u65e7\u8c03\u6574\u4e1a\u52a1\uff0c\u4e0d\u53ef\u505a\u4e1a\u52a1\u3002", (String)"DepreAdjustBillImportHandler_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), new Object[]{cardNumber}));
                }
                e.setCancel(true);
            }
            filters = new QFilter[]{new QFilter("assetbook", "=", assetBook.getPkValue()), new QFilter("bizperiod", "=", period.getPkValue()), new QFilter("isneeddepre", "=", (Object)false), new QFilter("monthdepre", "!=", (Object)0), new QFilter("realcardmasterid", "in", rCardPKs)};
            fields = Fa.join((String)",", (String[])new String[]{"number", "realcard.id", "monthdepre", "isneeddepre", "depremethod.type"});
            DynamicObject[] fCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)fields, (QFilter[])filters);
            HashSet<String> existsNumber = new HashSet<String>(fCards.length);
            for (DynamicObject card : fCards) {
                existsNumber.add(card.getString("number"));
            }
            if (rCardNumbers.size() != fCards.length) {
                rCardNumbers.removeAll(existsNumber);
                for (String errNum : rCardNumbers) {
                    e.addCancelMessage((Integer)cardNumberMaps.get(errNum), Integer.valueOf(0), ResManager.loadKDString((String)"\u90e8\u5206\u5361\u7247\u4e0d\u7b26\u5408\u5f15\u5165\u6761\u4ef6\uff0c\u9700\u8981\u91cd\u65b0\u8ba1\u63d0\uff0c\u6216\u8005\u5b58\u5728\u672c\u671f\u6298\u65e7\u989d\u4e3a0\u7684\u5361\u7247\u3002", (String)"DepreAdjustBillImportHandler_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                e.setCancel(true);
            }
            if (!(workLoadCards = Stream.of(fCards).filter(v -> v.getString("depremethod.type").equals("5")).collect(Collectors.toSet())).isEmpty()) {
                for (DynamicObject workCard : workLoadCards) {
                    e.addCancelMessage((Integer)cardNumberMaps.get(workCard.getString("number")), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u5de5\u4f5c\u91cf\u6cd5\u7684\u5361\u7247\u8bf7\u901a\u8fc7\u8c03\u6574\u672c\u671f\u5de5\u4f5c\u91cf\u6765\u8c03\u6574\u6298\u65e7\u3002", (String)"DepreAdjustBillImportHandler_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                e.setCancel(true);
            }
        } else {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728", (String)"DepreAdjustBillImportHandler_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterImportData(IDataModel model, ImportDataEventArgs e) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue()), new QFilter("depreuse", "=", depreuse.getPkValue())};
        String fields = Fa.join((String)",", (String[])new String[]{"id", "curperiod", "basecurrency"});
        DynamicObject assetBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)fields, (QFilter[])filters);
        long periodId = assetBook.getLong("curperiod");
        model.setValue("period", (Object)periodId);
        long currencyId = assetBook.getLong("basecurrency");
        model.setValue("currency", (Object)currencyId);
        DynamicObjectCollection entries = model.getEntryEntity("entryentity");
        Set rCardPKs = entries.stream().map(v -> v.get("realcard.id")).collect(Collectors.toSet());
        filters = new QFilter[]{new QFilter("assetbook", "=", (Object)assetBook.getLong("id")), new QFilter("bizperiod", "=", (Object)periodId), new QFilter("isneeddepre", "=", (Object)false), new QFilter("monthdepre", ">", (Object)0), new QFilter("realcardmasterid", "in", rCardPKs)};
        fields = Fa.join((String)",", (String[])new String[]{"realcard.id", "monthdepre", "realcardmasterid"});
        DynamicObject[] fCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)fields, (QFilter[])filters);
        Map<Long, BigDecimal> depreAmtCache = Stream.of(fCards).collect(Collectors.toMap(v -> v.getLong("realcardmasterid"), v -> v.getBigDecimal("monthdepre")));
        model.forceClearNoDataRow();
        int entryRowCount = model.getEntryRowCount("entryentity");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject rCard = (DynamicObject)model.getValue("realcard", i);
            if (!depreAmtCache.containsKey(rCard.getPkValue())) continue;
            model.setValue("bfrdepreamount", (Object)depreAmtCache.get(rCard.getPkValue()), i);
        }
    }
}

