/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.importhandler;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.business.utils.FaAssetUnitAndUseDeptUnits;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaDepreSplitUtil;

public class DepreSplitSetUpImportHandler {
    public static final String ERRMSG = "errMsg";
    public static final String ASSETBOOKKEY = "assetbookKey";
    public static final String ORGKEY = "orgKey";
    public static final String REALCARDKEY = "realCardKey";
    public static final String PERCENTKEY = "percentKey";
    public static final String FLAG_ASSISTANT = "[2]";
    public static final String ENTITY_DEPREUSE = "fa_depreuse";
    public static final String DEPREUSEKEY = "depreUseKey";
    public static final String ENTITY_ASSTACTTYPE = "bd_asstacttype";
    public static final String ENTITY_BOSORG = "bos_org";
    public static final String ENTITY_ORG_DUTY = "bos_org_duty";
    public static final String ENTITY_PERIOD = "bd_period";
    public static final String ENTITY_ASSISTANTDATADETAIL = "bos_assistantdata_detail";
    public static final String PERIODKEY = "periodKey";
    public static final String ASSTACTTYPE = "asstacttype";
    public static final String LESSCACHE_FAVALIDDIMKEY = "fi-fa-depresplitsetupdim";
    public static final String KEY_FAVALIDDIMKEY = "fi-fa-depresplitsetupdim-value";
    public static final String LESSCACHE_ORGPERMNKEY = "fi-fa-orgperm";
    public static final String KEY_ORGPERMISSSIONKEY = "fi-fa-orgperm-value-";
    public static final String BOS_COSTCENTER = "bos_costcenter";

    public void beforeImporChecktData(String pageId, BeforeImportDataEventArgs e) {
        Object objRealCard;
        Object objDrepreUse;
        Map sourceData = e.getSourceData();
        Object inputOrg = sourceData.get("createorg");
        if (null == inputOrg) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String orgNumber = this.getNumber(sourceData, "createorg");
        Map<String, Object> orgErrMap = this.checkOrg(pageId, orgNumber, e);
        String orgErrStr = orgErrMap.get(ERRMSG).toString();
        if (StringUtils.isNotEmpty((CharSequence)orgErrStr)) {
            e.setCancelMessage(orgErrStr);
            e.setCancel(true);
            return;
        }
        DynamicObject org = (DynamicObject)orgErrMap.get(ORGKEY);
        Object orgPK = org.get("id");
        Object objSourceDepreUse = sourceData.get("depreuse");
        if (null != objSourceDepreUse) {
            String depreuseNumber = (String)((Map)objSourceDepreUse).get("number");
            Map<String, Object> drepreUseMap = this.checkDepreUse(depreuseNumber);
            String drepreUseErr = drepreUseMap.get(ERRMSG).toString();
            if (StringUtils.isNotEmpty((CharSequence)drepreUseErr)) {
                e.setCancelMessage(drepreUseErr);
                e.setCancel(true);
                return;
            }
            objDrepreUse = drepreUseMap.get(DEPREUSEKEY);
        } else {
            objDrepreUse = null;
        }
        Map<String, Object> asseBookErrMap = this.checkAsseBook(orgPK, objDrepreUse);
        String errStr = asseBookErrMap.get(ERRMSG).toString();
        if (StringUtils.isNotEmpty((CharSequence)errStr)) {
            e.setCancelMessage(errStr);
            e.setCancel(true);
            return;
        }
        Object objSourcePeriod = sourceData.get("beginperiod");
        if (null == objDrepreUse && null != objSourcePeriod) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        if (null != objDrepreUse && null != objSourcePeriod) {
            String nameNumber = (String)((Map)objSourcePeriod).get("name");
            DynamicObject dyAsstBook = (DynamicObject)asseBookErrMap.get(ASSETBOOKKEY);
            Long periodTypeId = dyAsstBook.getLong(Fa.dot((String[])new String[]{"periodtype", "id"}));
            String curPeriod = dyAsstBook.getString("curperiod.number");
            Map<String, Object> periodErrMap = this.checkPeriodNum(nameNumber, curPeriod, periodTypeId);
            String periodErr = periodErrMap.get(ERRMSG).toString();
            if (StringUtils.isNotEmpty((CharSequence)periodErr)) {
                e.setCancelMessage(periodErr);
                e.setCancel(true);
                return;
            }
            DynamicObject dyPeriod = (DynamicObject)periodErrMap.get(PERIODKEY);
            Map sourcePeriodMap = (Map)objSourcePeriod;
            sourcePeriodMap.put("id", dyPeriod.get("id"));
            sourcePeriodMap.put("importprop", "id");
        }
        if (null == (objRealCard = sourceData.get("realcard"))) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        String realCardNumber = (String)((Map)objRealCard).get("number");
        Long orgid = org.getLong("id");
        Long depreuseId = ((DynamicObject)asseBookErrMap.get(ASSETBOOKKEY)).getLong("depreuse_id");
        Map<String, Object> asseMap = this.checkAssetnum(realCardNumber, orgid);
        String asseErr = asseMap.get(ERRMSG).toString();
        if (StringUtils.isNotEmpty((CharSequence)asseErr)) {
            e.setCancelMessage(asseErr);
            e.setCancel(true);
            return;
        }
        Object inputAssentries = sourceData.get("assentry");
        if (null == inputAssentries) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u6298\u65e7\u5206\u644a\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        List assertEntries = (List)inputAssentries;
        String assType = "";
        String orgduty = "";
        String percent = "";
        ArrayList<BigDecimal> percentList = new ArrayList<BigDecimal>();
        for (Map assertMap : assertEntries) {
            Object inputAssinfoImport = assertMap.get("assinfoimport");
            if (null == inputAssinfoImport) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u6a2a\u8868\u7ec4\u5408\u4fe1\u606f(\u5f15\u5165)\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            assType = inputAssinfoImport.toString();
            Object inputOrgduty = assertMap.get("orgduty");
            if (null == inputOrgduty) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u90e8\u95e8\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            orgduty = this.getNumber(assertMap, "orgduty");
            Object inputPercent = assertMap.get("percent");
            if (null == inputPercent) {
                e.setCancelMessage(ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            percent = inputPercent.toString();
            Map<String, Object> assetDim = this.checkAssetDims(assType, orgid, depreuseId);
            String assetDimError = assetDim.get(ERRMSG).toString();
            if (StringUtils.isNotEmpty((CharSequence)assetDimError)) {
                e.setCancelMessage(assetDimError);
                e.setCancel(true);
                return;
            }
            String dutyErr = this.checkOrgDuty(orgduty);
            if (StringUtils.isNotEmpty((CharSequence)dutyErr)) {
                e.setCancelMessage(dutyErr);
                e.setCancel(true);
                return;
            }
            String percentErr = this.checkPercent(percent, percentList);
            if (!StringUtils.isNotEmpty((CharSequence)percentErr)) continue;
            e.setCancelMessage(percentErr);
            e.setCancel(true);
            return;
        }
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal bgMaxPercent = new BigDecimal("100");
        for (BigDecimal bgPercent : percentList) {
            total = total.add(bgPercent);
        }
        if (total.compareTo(bgMaxPercent) != 0) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u540c\u4e00\u6838\u7b97\u7ec4\u7ec7\u7684\u5b9e\u7269\u5361\u7247\u5206\u644a\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100%\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
    }

    public void setSourceDataToModel(IDataModel model, IFormView view) {
        this.setVourcherDataToModel(model, view);
    }

    private void setVourcherDataToModel(IDataModel model, IFormView view) {
        boolean exists;
        DynamicObject dyPeriod;
        QFilter otherFilter;
        DynamicObject org = (DynamicObject)model.getValue("createorg");
        DynamicObject mdyRealCard = (DynamicObject)model.getValue("realcard");
        Object objDepreUse = model.getValue("depreuse");
        if (null != objDepreUse) {
            DynamicObject dyDrepreUse = (DynamicObject)objDepreUse;
            otherFilter = new QFilter("depreuse", "=", dyDrepreUse.getPkValue());
        } else {
            otherFilter = new QFilter("ismainbook", "=", (Object)true);
        }
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter[] filters = new QFilter[]{orgFilter, otherFilter};
        String assetBookFields = Fa.join((String)",", (String[])new String[]{"curperiod", "periodtype", "depreuse", "status", Fa.dot((String[])new String[]{"periodtype", "id"})});
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)assetBookFields, (QFilter[])filters);
        Object objPeriod = model.getValue("beginperiod");
        if (null != objPeriod) {
            DynamicObject dyTempPeriod = (DynamicObject)objPeriod;
            String namePeriod = dyTempPeriod.getString("name");
            Long periodTypeId = assetBook.getLong(Fa.dot((String[])new String[]{"periodtype", "id"}));
            QFilter numFilter = new QFilter("name", "=", (Object)namePeriod);
            QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
            QFilter[] periodFilters = new QFilter[]{numFilter, periodTypeFilter};
            dyPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_PERIOD, (String)"id,name,number", (QFilter[])periodFilters);
        } else {
            dyPeriod = assetBook.getDynamicObject("curperiod");
        }
        boolean fromDb = model.getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDb && (exists = QueryServiceHelper.exists((String)"fa_depresplitsetup", (QFilter[])new QFilter[]{new QFilter("depreuse", "=", assetBook.getDynamicObject("depreuse").getPkValue()), new QFilter("beginperiod", "=", dyPeriod.getPkValue()), new QFilter("realcard", "=", mdyRealCard.getPkValue())}))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5361\u7247\u7f16\u53f7%s\u5df2\u5b58\u5728\u5f53\u671f\u5206\u644a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_8", (String)"fi-fa-formplugin", (Object[])new Object[0]), mdyRealCard.getString("billno")));
        }
        DynamicObject dyEndPeriod = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_PERIOD);
        dyEndPeriod.set("id", (Object)99999999999L);
        model.beginInit();
        model.setValue("org", (Object)org);
        model.setValue("status", (Object)"A");
        model.setValue("ctrlstrategy", (Object)"7");
        model.setValue("enable", (Object)"1");
        model.setValue("creator", (Object)ContextUtil.getUserId());
        model.setValue("depreuse", (Object)assetBook.getDynamicObject("depreuse"));
        model.setValue("beginperiod", (Object)dyPeriod);
        model.setValue("endperiod", (Object)dyEndPeriod);
        model.setValue("number", (Object)mdyRealCard.getString("number"));
        model.setValue("name", (Object)mdyRealCard.getString("assetname"));
        model.setValue("realcard", (Object)mdyRealCard);
        model.endInit();
        this.setEntryDataToModel(model);
    }

    private void setEntryDataToModel(IDataModel model) {
        String[] subDimArray;
        String[] dimArray;
        DynamicObjectCollection assEntrys = (DynamicObjectCollection)model.getValue("assentry");
        String assinfo = "";
        String deptName = "";
        String percent = "";
        String asstNumber = "";
        String subDimNumber = "";
        String dimTableName = "";
        HashSet<String> dimSet = new HashSet<String>();
        StringBuilder sbMsg = new StringBuilder();
        for (DynamicObject assertEntry : assEntrys) {
            assinfo = assertEntry.getString("assinfoimport");
            for (String dimStr : dimArray = assinfo.split(",")) {
                subDimArray = dimStr.split(":");
                if (subDimArray[0].startsWith(FLAG_ASSISTANT)) {
                    subDimArray[0] = subDimArray[0].substring(3);
                }
                dimSet.add(subDimArray[0]);
            }
        }
        QFilter numberFilter = new QFilter("number", "in", dimSet);
        Map dyAssetTypeMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_ASSTACTTYPE, (String)"id,number,name,valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{numberFilter});
        HashMap<String, String> dyNumberTableMap = new HashMap<String, String>();
        HashMap<String, String> dyNumberDimNameMap = new HashMap<String, String>();
        DynamicObjectCollection assTypeCols = (DynamicObjectCollection)model.getValue("asstypes");
        assTypeCols.clear();
        DynamicObjectType objType = assTypeCols.getDynamicObjectType();
        for (Map.Entry entry : dyAssetTypeMap.entrySet()) {
            DynamicObject dyAssetType = new DynamicObject(objType);
            dyAssetType.set("fbasedataid", entry.getValue());
            dyAssetType.set("fbasedataid_id", entry.getKey());
            assTypeCols.add((Object)dyAssetType);
            Iterator dyCurAssetType = (DynamicObject)entry.getValue();
            DynamicObject dyAssistant = dyCurAssetType.getDynamicObject("assistanttype");
            if (null != dyAssistant) {
                dyNumberTableMap.put(dyCurAssetType.getString("number"), dyAssistant.getString("id"));
                dyNumberDimNameMap.put(dyCurAssetType.getString("number"), dyCurAssetType.getString("assistanttype.name"));
                continue;
            }
            DynamicObject dySubDim = dyCurAssetType.getDynamicObject("valuesource");
            String subDimTable = dySubDim.getString("number");
            dyNumberTableMap.put(dyCurAssetType.getString("number"), subDimTable);
            dyNumberDimNameMap.put(dyCurAssetType.getString("number"), dyCurAssetType.getString("valuesource.name"));
        }
        Map allFields = model.getDataEntityType().getAllFields();
        DecimalProp percentProp = (DecimalProp)allFields.get("percent");
        int percentScale = percentProp.getScale();
        for (DynamicObject assertEntry : assEntrys) {
            StringBuilder sbAssInfo = new StringBuilder();
            percent = assertEntry.getBigDecimal("percent").setScale(percentScale, RoundingMode.HALF_UP).toString();
            deptName = assertEntry.getDynamicObject("orgduty").getString("name");
            sbMsg.append(deptName).append(' ').append(percent).append("% ");
            DynamicObjectCollection subAssertEntries = assertEntry.getDynamicObjectCollection("asssubentry");
            subAssertEntries.clear();
            DynamicObjectType subDimType = subAssertEntries.getDynamicObjectType();
            assinfo = assertEntry.getString("assinfoimport");
            dimArray = assinfo.split(",");
            int flagIndex = 1;
            long orgId = (Long)model.getValue(Fa.id((String)"createorg"));
            for (String dimStr : dimArray) {
                DynamicObject dyDimInfo;
                subDimArray = dimStr.split(":");
                asstNumber = subDimArray[0];
                subDimNumber = subDimArray[1];
                QFilter numFilter = new QFilter("number", "=", (Object)subDimNumber);
                if (asstNumber.startsWith(FLAG_ASSISTANT)) {
                    asstNumber = asstNumber.substring(3);
                    String groupIdStr = (String)dyNumberTableMap.get(asstNumber);
                    QFilter assisFilter = new QFilter("group", "=", (Object)Long.parseLong(groupIdStr));
                    dimTableName = (String)dyNumberTableMap.get(asstNumber);
                    dyDimInfo = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_ASSISTANTDATADETAIL, (String)"id", (QFilter[])new QFilter[]{numFilter, assisFilter});
                } else {
                    dimTableName = (String)dyNumberTableMap.get(asstNumber);
                    dyDimInfo = BusinessDataServiceHelper.loadSingleFromCache((String)dimTableName, (String)"id,name", (QFilter[])new QFilter[]{numFilter, BaseDataServiceHelper.getBaseDataFilter((String)dimTableName, (Long)orgId)});
                }
                if (dyDimInfo == null) {
                    String errorInfo = ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u6709\u6743\u9650\u4f7f\u7528\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u5206\u644a\u7ef4\u5ea6\u503c\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u586b\u5199\u6709\u8bef\u3002", (String)"DepreSplitSetUpImportHandler_9", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                    throw new KDBizException(String.format(errorInfo, subDimNumber));
                }
                DynamicObject dySubEntry = new DynamicObject(subDimType);
                dySubEntry.set("asstype", (Object)dimTableName);
                dySubEntry.set("assid", dyDimInfo.getPkValue());
                dySubEntry.set("seq", (Object)(subAssertEntries.size() + 1));
                subAssertEntries.add((Object)dySubEntry);
                DynamicObjectType dynamicObjectType = dyDimInfo.getDynamicObjectType();
                String nameProp = "name";
                if (dynamicObjectType instanceof BasedataEntityType) {
                    BasedataEntityType entityType = (BasedataEntityType)dynamicObjectType;
                    nameProp = entityType.getNameProperty();
                }
                sbMsg.append((String)dyNumberDimNameMap.get(asstNumber)).append('-').append(dyDimInfo.getString(nameProp));
                if (flagIndex < dimArray.length) {
                    sbMsg.append("/");
                }
                sbAssInfo.append(dimTableName).append('|').append(dyDimInfo.getPkValue()).append(';');
                ++flagIndex;
            }
            sbMsg.append(";");
            if (sbAssInfo.length() > 0) {
                sbAssInfo.deleteCharAt(sbAssInfo.length() - 1);
            }
            assertEntry.set("assinfo", (Object)sbAssInfo.toString());
        }
        if (sbMsg.length() > 0) {
            sbMsg.deleteCharAt(sbMsg.length() - 1);
        }
        model.beginInit();
        String msgStr = sbMsg.toString();
        if (msgStr.length() > 500) {
            msgStr = msgStr.substring(0, 496) + "...";
        }
        model.setValue("msg", (Object)msgStr);
        model.endInit();
    }

    private Map<String, Object> checkOrg(String pageId, String orgNumber, BeforeImportDataEventArgs e) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ERRMSG, "");
        QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)orgNumber), new QFilter("status", "=", (Object)BillStatus.C)};
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_BOSORG, (String)"id", (QFilter[])filters);
        if (org == null) {
            result.put(ERRMSG, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"DepreSplitSetUpImportHandler_10", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return result;
        }
        String cacheKey = KEY_ORGPERMISSSIONKEY + ((BillModel)e.getSource()).getPageId() + orgNumber;
        IAppCache lessCache = AppCache.get((String)"fa");
        String cacheValue = (String)lessCache.get(cacheKey, String.class);
        List<Object> orgIds = new ArrayList();
        if (StringUtils.isEmpty((CharSequence)cacheValue)) {
            orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)pageId, (String)"fa_depresplitsetup", (String)"47156aff000000ac");
            cacheValue = Fa.join(orgIds, (String)",");
            lessCache.put(cacheKey, (Object)cacheValue);
        } else {
            String[] caValues = cacheValue.split(",");
            orgIds = Arrays.asList(caValues).stream().map(p -> Long.parseLong(p)).collect(Collectors.toList());
        }
        if (!orgIds.contains(org.getLong("id"))) {
            result.put(ERRMSG, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u65e0\u6743\u9650\u3002", (String)"DepreSplitSetUpImportHandler_11", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        result.put(ORGKEY, org);
        return result;
    }

    private Map<String, Object> checkDepreUse(String depreUseNumber) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ERRMSG, "");
        if (StringUtils.isNotEmpty((CharSequence)depreUseNumber)) {
            QFilter filter = new QFilter("number", "=", (Object)depreUseNumber);
            String selectFields = Fa.join((String)",", (String[])new String[]{"id", "number,name"});
            DynamicObject dyDepreUse = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_DEPREUSE, (String)selectFields, (QFilter[])new QFilter[]{filter});
            if (dyDepreUse == null) {
                result.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u7f16\u7801%s\u7684\u6298\u65e7\u7528\u9014\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_12", (String)"fi-fa-formplugin", (Object[])new Object[0]), depreUseNumber));
                return result;
            }
            result.put(DEPREUSEKEY, dyDepreUse);
        } else {
            result.put(DEPREUSEKEY, null);
        }
        return result;
    }

    private Map<String, Object> checkAsseBook(Object orgPK, Object objDrepreUse) {
        QFilter otherFilter;
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ERRMSG, "");
        QFilter orgFilter = new QFilter("org", "=", orgPK);
        if (objDrepreUse != null) {
            DynamicObject dyDrepreUse = (DynamicObject)objDrepreUse;
            otherFilter = new QFilter("depreuse", "=", dyDrepreUse.getPkValue());
        } else {
            otherFilter = new QFilter("ismainbook", "=", (Object)true);
        }
        QFilter[] filters = new QFilter[]{orgFilter, otherFilter};
        String fields = Fa.join((String)",", (String[])new String[]{"curperiod", "periodtype", "depreuse", "status", Fa.dot((String[])new String[]{"periodtype", "id"})});
        DynamicObject assetBooks = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)fields, (QFilter[])filters);
        if (assetBooks == null) {
            result.put(ERRMSG, ResManager.loadKDString((String)"\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"DepreSplitSetUpImportHandler_13", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return result;
        }
        result.put(ASSETBOOKKEY, assetBooks);
        return result;
    }

    private Map<String, Object> checkPeriodNum(String inputName, String curNumber, Long periodTypeId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(ERRMSG, "");
        result.put(PERIODKEY, null);
        QFilter numFilter = new QFilter("name", "=", (Object)inputName);
        QFilter periodTypeFilter = new QFilter("periodtype", "=", (Object)periodTypeId);
        QFilter[] filters = new QFilter[]{numFilter, periodTypeFilter};
        DynamicObject dyPeriod = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_PERIOD, (String)"id,number", (QFilter[])filters);
        if (null == dyPeriod) {
            result.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u540d\u79f0%s\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_14", (String)"fi-fa-formplugin", (Object[])new Object[0]), inputName));
        } else {
            Long inputNumberL = dyPeriod.getLong("number");
            Long curNumberL = Long.valueOf(curNumber);
            if (inputNumberL < curNumberL) {
                result.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u540d\u79f0%s\u7684\u4f1a\u8ba1\u671f\u95f4\u4e0d\u5728\u751f\u6548\u671f\u95f4\u5185\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_15", (String)"fi-fa-formplugin", (Object[])new Object[0]), inputName));
                return result;
            }
            result.put(PERIODKEY, dyPeriod);
        }
        return result;
    }

    private Map<String, Object> checkAssetnum(String number, Long orgid) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder checkErrSB = new StringBuilder();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgid);
        QFilter billNoFilter = new QFilter("number", "=", (Object)number);
        orgFilter.and(billNoFilter);
        QFilter[] realCardfilters = orgFilter.toArray();
        String realFields = Fa.join((String)",", (String[])new String[]{"number", "assetname", "headusedept", "bizstatus", "headuseperson", "storeplace", "billstatus", "org"});
        DynamicObject realCard = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_card_real", (String)realFields, (QFilter[])realCardfilters);
        if (realCard == null) {
            DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgid, (String)ENTITY_BOSORG);
            String orgName = org == null ? "" : org.getString("name");
            checkErrSB.append(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7 %1$s \u4e0b\u4e0d\u5b58\u5728\u8d44\u4ea7\u7f16\u7801\u4e3a %2$s \u7684\u5b9e\u7269\u5361\u7247\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_16", (String)"fi-fa-formplugin", (Object[])new Object[0]), orgName, number)).append("\r\n");
            result.put(ERRMSG, checkErrSB.toString());
            return result;
        }
        result.put(REALCARDKEY, realCard);
        result.put(ERRMSG, "");
        return result;
    }

    private Map<String, Object> checkAssetDims(String number, Long orgid, Object depreusePk) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        HashSet<String> assetTypeNumber = new HashSet<String>();
        String error = "";
        String dimNumber = "";
        String selectFields = "id,number,valuesource,assistanttype";
        String[] assetTypes = number.contains(",") ? number.trim().split(",") : new String[]{number};
        retMap.put(ERRMSG, error);
        for (String item : assetTypes) {
            DynamicObject dySubDimTable;
            DynamicObject dySubDim;
            QFilter vtFilter;
            QFilter dimFilter;
            DynamicObject dyAssetType;
            error = this.checkAssetTypeFormat(item, assetTypeNumber);
            if (StringUtils.isNotEmpty((CharSequence)error)) {
                retMap.put(ERRMSG, error);
                return retMap;
            }
            String[] subAssertType = item.split(":");
            boolean isAssistantType = false;
            dimNumber = subAssertType[0];
            if (dimNumber.startsWith(FLAG_ASSISTANT)) {
                dimNumber = dimNumber.substring(3);
                isAssistantType = true;
            }
            if ((dyAssetType = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_ASSTACTTYPE, (String)selectFields, (QFilter[])new QFilter[]{dimFilter = new QFilter("number", "=", (Object)dimNumber), vtFilter = new QFilter("valuetype", "!=", (Object)"3")})) == null) {
                retMap.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_17", (String)"fi-fa-formplugin", (Object[])new Object[0]), subAssertType[0]));
                return retMap;
            }
            QFilter sumDimFilter = new QFilter("number", "=", (Object)subAssertType[1]);
            if (isAssistantType) {
                dySubDim = dyAssetType.getDynamicObject("assistanttype");
                if (dySubDim == null) {
                    retMap.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u7c7b\u578b\u4e0d\u662f\u8f85\u52a9\u8d44\u6599\u6216\u7f3a\u5c11\u8f85\u52a9\u503c\u6765\u6e90\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_26", (String)"fi-fa-formplugin", (Object[])new Object[0]), dimNumber));
                    return retMap;
                }
                QFilter assisFilter = new QFilter("group", "=", dySubDim.getPkValue());
                dySubDimTable = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_ASSISTANTDATADETAIL, (String)"id", (QFilter[])new QFilter[]{sumDimFilter, assisFilter});
            } else {
                QFilter costCenterFilter;
                boolean departSharing;
                if (dyAssetType.getDynamicObject("assistanttype") != null) {
                    retMap.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u7c7b\u578b\u662f\u8f85\u52a9\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_28", (String)"fi-fa-formplugin", (Object[])new Object[0]), dimNumber));
                    return retMap;
                }
                dySubDim = dyAssetType.getDynamicObject("valuesource");
                if (dySubDim == null) {
                    retMap.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\u7c7b\u578b\u4e0d\u662f\u8f85\u52a9\u8d44\u6599\u4e14\u7f3a\u5c11\u503c\u6765\u6e90\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_27", (String)"fi-fa-formplugin", (Object[])new Object[0]), dimNumber));
                    return retMap;
                }
                String subDimTable = dySubDim.getString("number");
                dySubDimTable = BusinessDataServiceHelper.loadSingleFromCache((String)subDimTable, (String)"id", (QFilter[])new QFilter[]{sumDimFilter});
                if (subDimTable.equals(BOS_COSTCENTER) && !(departSharing = FaAssetUnitAndUseDeptUnits.checkDepartSharingByOrgId((long)orgid)) && null == (dySubDimTable = BusinessDataServiceHelper.loadSingleFromCache((String)subDimTable, (String)"id", (QFilter[])new QFilter[]{sumDimFilter, costCenterFilter = new QFilter("accountorg", "=", (Object)orgid)}))) {
                    retMap.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u6210\u672c\u4e2d\u5fc3\u4e0d\u662f\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u53ef\u7528\u7684\u6210\u672c\u4e2d\u5fc3,\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_18", (String)"fi-fa-formplugin", (Object[])new Object[0]), subAssertType[1]));
                }
            }
            if (null == dySubDimTable && retMap.get(ERRMSG) == null) {
                retMap.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7f16\u7801\u4e3a%s\u7684\u5b50\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_19", (String)"fi-fa-formplugin", (Object[])new Object[0]), subAssertType[1]));
                return retMap;
            }
            retMap.put(dyAssetType.getString("id"), dyAssetType);
        }
        Set<String> itemSet = this.getAssTypeFilter(orgid, depreusePk);
        for (Map.Entry next : retMap.entrySet()) {
            if (ERRMSG.equals(next.getKey()) || itemSet.contains(next.getKey())) continue;
            DynamicObject dyAssertType = (DynamicObject)retMap.get(next.getKey());
            String name = dyAssertType.getString("name");
            String code = dyAssertType.getString("number");
            retMap.put(ERRMSG, String.format(ResManager.loadKDString((String)"\u4f1a\u8ba1\u79d1\u76ee\u4e2d\u672a\u67e5\u8be2\u5230\u540d\u79f0\u4e3a%1$s\uff0c\u7f16\u7801\u4e3a%2$s\u7684\u53ef\u4f7f\u7528\u6838\u7b97\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_20", (String)"fi-fa-formplugin", (Object[])new Object[0]), name, code));
            return retMap;
        }
        return retMap;
    }

    private String checkAssetTypeFormat(String number, Set<String> assetTypeNumber) {
        StringBuilder checkErrSB = new StringBuilder();
        String formatError = ResManager.loadKDString((String)"\u6298\u65e7\u5206\u644a\u7ef4\u5ea6\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u6309\u7167\u7ed9\u5b9a\u683c\u5f0f\u586b\u5145\u3002", (String)"DepreSplitSetUpImportHandler_21", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        String repeatError = ResManager.loadKDString((String)"\u6298\u65e7\u5206\u644a\u7ef4\u5ea6\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_22", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        if (!number.contains(":")) {
            return checkErrSB.append(formatError).append("\r\n").toString();
        }
        String[] subAssetTypes = number.split(":");
        if (subAssetTypes == null || subAssetTypes.length != 2) {
            return checkErrSB.append(formatError).append("\r\n").toString();
        }
        if (assetTypeNumber.contains(subAssetTypes[0])) {
            return checkErrSB.append(repeatError).append("\r\n").toString();
        }
        assetTypeNumber.add(subAssetTypes[0]);
        return "";
    }

    private Set<String> getAssTypeFilter(long orgPk, Object depreusePk) {
        Set<String> allItems;
        String cackeKey;
        IAppCache lessCache = AppCache.get((String)"fa");
        String cacheValues = (String)lessCache.get(cackeKey = "fi-fa-depresplitsetupdim-value-" + orgPk + "|" + depreusePk, String.class);
        if (StringUtils.isEmpty((CharSequence)cacheValues)) {
            List<QFilter> assTypeFilter = FaDepreSplitUtil.getAssTypeFilter(orgPk);
            DynamicObjectCollection assType = QueryServiceHelper.query((String)ENTITY_ASSTACTTYPE, (String)"id", (QFilter[])assTypeFilter.toArray(new QFilter[0]));
            allItems = assType.stream().map(v -> v.getString("id")).collect(Collectors.toSet());
            String values = Fa.join(allItems, (String)",");
            lessCache.put(cackeKey, (Object)values);
        } else {
            String[] caValues = cacheValues.split(",");
            allItems = new HashSet<String>(Arrays.asList(caValues));
        }
        return allItems;
    }

    private String checkOrgDuty(String number) {
        String error = "";
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject dyOrgDuty = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_ORG_DUTY, (String)"id", (QFilter[])new QFilter[]{numberFilter});
        if (null == dyOrgDuty) {
            error = String.format(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u90e8\u95e8\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_23", (String)"fi-fa-formplugin", (Object[])new Object[0]), number);
        }
        return error;
    }

    private String checkPercent(String percent, List<BigDecimal> percentList) {
        String error = "";
        BigDecimal bgPercent = new BigDecimal(percent);
        BigDecimal bgMaxPercent = new BigDecimal("100");
        if (bgPercent.compareTo(BigDecimal.ZERO) <= 0) {
            error = ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_24", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        } else if (bgPercent.compareTo(bgMaxPercent) > 0) {
            error = ResManager.loadKDString((String)"\u5206\u644a\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DepreSplitSetUpImportHandler_25", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        } else {
            percentList.add(bgPercent);
        }
        return error;
    }

    private String getNumber(Map<String, Object> sourceData, String prop) {
        return this.getPropSimpleValue(sourceData, prop, "number");
    }

    private String getPropSimpleValue(Map<String, Object> sourceData, String prop, String property) {
        return (String)((Map)sourceData.get(prop)).get(property);
    }
}

