/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.importhandler;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.utils.CheckFaFinCardDataUtil;
import kd.fi.fa.cache.FaBusinessImportCardThreadCacheUtil;
import kd.fi.fa.cache.FaImportCardThreadCacheUtil;

public class FinCardImportHandler {
    public void handleImport(BillModel model, ImportDataEventArgs e) {
        this.setDefaultValue(model);
    }

    protected void setDefaultValue(BillModel model) {
        int periodNumber;
        BigDecimal depreAmount;
        Object number;
        Object depredAmount;
        Object preUsingAmountObj;
        Object workLoadUnit;
        Object depreMethod;
        Set errorMsgSet;
        BigDecimal yearVal;
        BigDecimal accumVal;
        model.setValue("isimport", (Object)true);
        DynamicObject assetBook = this.getAssetBook4Import(model);
        model.setValue("assetbook", assetBook.getPkValue());
        DynamicObject periodType = assetBook.getDynamicObject("periodtype");
        BigDecimal oriVal = (BigDecimal)model.getValue("originalval");
        model.setValue("basecurrency", assetBook.getDynamicObject("basecurrency").getPkValue());
        if (model.getValue("currency") == null) {
            model.setValue("currency", model.getValue("basecurrency"));
            model.setValue("currencyrate", (Object)BigDecimal.ONE);
            model.setValue("originalamount", (Object)oriVal);
        }
        if ("fa_card_fin".equals(model.getDataEntity().getDynamicObjectType().getName())) {
            model.setValue("yearorigvalchg", (Object)oriVal);
            model.setValue("monthdeprechg", (Object)BigDecimal.ZERO);
            model.setValue("monthorigvalchg", (Object)oriVal);
        }
        BigDecimal bigDecimal = accumVal = model.getValue("accumdepre") == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("accumdepre");
        if (accumVal.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"FinCardImportHandler_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        BigDecimal netWorth = oriVal.subtract(accumVal);
        if (netWorth.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u503c\u4e0d\u80fd\u5c0f\u4e8e\u7d2f\u8ba1\u6298\u65e7\u3002", (String)"FinCardImportHandler_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        model.setValue("networth", (Object)netWorth);
        BigDecimal bigDecimal2 = yearVal = model.getValue("addupyeardepre") == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("addupyeardepre");
        if (accumVal.compareTo(yearVal) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u91d1\u989d\u3002", (String)"FinCardImportHandler_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        BigDecimal decVal = model.getValue("decval") == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("decval");
        BigDecimal netAmount = netWorth.subtract(decVal);
        if (netAmount.compareTo(BigDecimal.ZERO) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u539f\u503c\u4e0d\u80fd\u5c0f\u4e8e\u7d2f\u8ba1\u6298\u65e7\u4e0e\u51cf\u503c\u51c6\u5907\u4e4b\u548c", (String)"FinCardImportHandler_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        model.setValue("netamount", (Object)netAmount);
        if (!"fa_initcard_fin".equalsIgnoreCase(model.getDataEntityType().getName())) {
            model.setValue("billstatus", (Object)BillStatus.A);
        }
        model.setValue("auditor", model.getValue("creator"));
        Date date = new Date();
        model.setValue("createtime", (Object)date);
        model.setValue("auditdate", (Object)date);
        BigDecimal preUsingAmount = (BigDecimal)model.getValue("preusingamount");
        if (preUsingAmount == null || BigDecimal.ZERO.compareTo(preUsingAmount) == 0) {
            QFilter filterRe = new QFilter("number", "=", model.getValue("number"));
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"fa_initcard_real", (String)"assetcat", (QFilter[])new QFilter[]{filterRe});
            if (StringUtils.isBlank((Object)dynamicObject)) {
                String errorMsg = String.format(ResManager.loadKDString((String)"%s\uff1a\u8d22\u52a1\u5361\u7247\u53ea\u80fd\u66f4\u65b0\u5f15\u5165\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u3002", (String)"FinCardImportHandler_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), model.getValue("number"));
                throw new KDBizException(errorMsg);
            }
            DynamicObject assetcat = dynamicObject.getDynamicObject("assetcat");
            long depresystemId = assetBook.getDynamicObject("depresystem").getLong("id");
            DynamicObject assetPolicyEntry = this.getAssetPolicyEntryByBook(depresystemId, assetcat);
            String depreMethodType = "";
            Object depreMethodObj = model.getValue("depremethod");
            if (Objects.nonNull(depreMethodObj)) {
                depreMethodType = ((DynamicObject)depreMethodObj).getString("type");
            }
            if (assetPolicyEntry != null) {
                Calendar ca = Calendar.getInstance();
                ca.setTime(model.getDataEntity().getDate("finaccountdate"));
                int yearPeriodType = FaBusinessImportCardThreadCacheUtil.getYearPeriodType((int)Calendar.getInstance().get(1), (long)periodType.getLong("id"));
                BigDecimal expectUse = assetPolicyEntry.getBigDecimal("expectuse");
                if ("5".equals(depreMethodType)) {
                    model.setValue("preusingamount", (Object)expectUse);
                } else {
                    model.setValue("preusingamount", (Object)expectUse.multiply(new BigDecimal(yearPeriodType)));
                }
            }
        }
        if ((errorMsgSet = CheckFaFinCardDataUtil.checkPreUsingAmountAndDepredAmount((Object)(depreMethod = model.getValue("depremethod")), (Object)(workLoadUnit = model.getValue("workloadunit")), (Object)(preUsingAmountObj = model.getValue("preusingamount")), (Object)(depredAmount = model.getValue("depredamount")), (Object)(number = model.getValue("number")))).size() > 0) {
            throw new KDBizException((String)errorMsgSet.iterator().next());
        }
        BigDecimal bigDecimal3 = depreAmount = model.getValue("depredamount") == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("depredamount");
        if (depreAmount.compareTo(BigDecimal.ZERO) == 0 && accumVal.compareTo(BigDecimal.ZERO) != 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u548c\u7d2f\u8ba1\u6298\u65e7\u5e94\u540c\u65f6\u4e3a0\u6216\u540c\u65f6\u4e0d\u4e3a0\u3002", (String)"FinCardImportHandler_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if (depreAmount.compareTo(BigDecimal.ZERO) != 0 && accumVal.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u548c\u7d2f\u8ba1\u6298\u65e7\u5e94\u540c\u65f6\u4e3a0\u6216\u540c\u65f6\u4e0d\u4e3a0\u3002", (String)"FinCardImportHandler_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        model.setValue("depredamount", (Object)depreAmount);
        model.setValue("isneeddepre", (Object)"1");
        Date finAccountDate = (Date)model.getValue("finaccountdate");
        if (!this.ifInitFincard()) {
            DynamicObject bizPeriod = FaImportCardThreadCacheUtil.getBizPeriod(periodType.getPkValue(), finAccountDate);
            if (bizPeriod == null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f\u201c%s\u201d\u5728\u7cfb\u7edf\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u671f\u95f4\uff0c\u8bf7\u7ef4\u62a4\u671f\u95f4\u540e\u518d\u8bd5\u3002", (String)"FinCardImportHandler_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), dateFormat.format(finAccountDate)));
            }
            model.setValue("period", bizPeriod.get("id"));
            model.setValue("bizperiod", bizPeriod.get("id"));
            periodNumber = bizPeriod.getInt("periodnumber");
            if (periodNumber == 1 && yearVal.compareTo(BigDecimal.ZERO) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5165\u8d26\u65e5\u671f\u4e3a\u672c\u5e74\u7b2c\u4e00\u671f\uff0c\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u5fc5\u987b\u7b49\u4e8e0\u3002", (String)"FinCardImportHandler_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            Date begindate = assetBook.getDynamicObject("startperiod").getDate("begindate");
            if (finAccountDate.compareTo(begindate) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5165\u8d26\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"FinCardImportHandler_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            Date bookBiginDate = assetBook.getDynamicObject("curperiod").getDate("begindate");
            if (finAccountDate.compareTo(bookBiginDate) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5165\u8d26\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u8d26\u7c3f\u7684\u5f53\u524d\u671f\u95f4\u7684\u5f00\u59cb\u65e5\u671f\u3002", (String)"FinCardImportHandler_9", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        } else {
            boolean fromDatabase = model.getDataEntity().getDataEntityState().getFromDatabase();
            if (!fromDatabase) {
                model.setValue("bizperiod_id", (Object)0L);
                model.setValue("period_id", (Object)0L);
            }
            if ((periodNumber = assetBook.getDynamicObject("startperiod").getInt("periodnumber")) == 1 && yearVal.compareTo(BigDecimal.ZERO) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u4e3a\u7b2c\u4e00\u671f\uff0c\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7\u5fc5\u987b\u7b49\u4e8e0\u3002", (String)"FinCardImportHandler_10", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
        }
        model.setValue("endperiod_id", (Object)99999999999L);
    }

    protected DynamicObject getAssetPolicyEntryByBook(long depresystemId, DynamicObject assetCat) {
        DynamicObject dyn = null;
        dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)depresystemId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_depresystem"));
        DynamicObjectCollection entrysDOC = dyn.getDynamicObjectCollection("assetpolicy_entry");
        DynamicObject selectedRow = null;
        int index = 999;
        for (int i = 0; i < entrysDOC.size(); ++i) {
            String rowAssetCatNumber;
            DynamicObject wholeRow = (DynamicObject)entrysDOC.get(i);
            DynamicObject rowAssetCat = (DynamicObject)wholeRow.get("assetcat");
            String cardAssetNumber = assetCat.getString("longnumber");
            if (cardAssetNumber.indexOf(rowAssetCatNumber = rowAssetCat.getString("longnumber")) != 0) continue;
            int differenceLength = cardAssetNumber.length() - rowAssetCatNumber.length();
            if (differenceLength == 0) {
                selectedRow = wholeRow;
                break;
            }
            if (differenceLength >= index) continue;
            index = differenceLength;
            selectedRow = wholeRow;
        }
        return selectedRow;
    }

    protected String getEntityName() {
        return "fa_card_fin";
    }

    protected String getRealCardEntityName() {
        return "fa_card_real";
    }

    private DynamicObject getAssetBook4Import(BillModel model) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinCardImportHandler_11", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
        if (depreuse == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FinCardImportHandler_12", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject assetBook = FaImportCardThreadCacheUtil.getAssetBook(org.get("id"), depreuse.get("id"));
        if (assetBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7ec4\u7ec7\u201d\u548c\u201c\u6298\u65e7\u7528\u9014\u201d\u5bf9\u5e94\u7684\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FinCardImportHandler_13", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        this.verifyAssetBook(model, assetBook);
        return assetBook;
    }

    protected void verifyAssetBook(BillModel model, DynamicObject assetBook) {
    }

    protected boolean ifInitFincard() {
        return false;
    }
}

