/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.calc.DataModelWrapper;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.lease.LeaseContractCal;
import kd.fi.fa.common.util.Fa;

public abstract class AbstractLeaseContractImportPlugin
extends AbstractBillPlugIn {
    protected static final Log logger = LogFactory.getLog(AbstractLeaseContractImportPlugin.class);

    public void afterImportData(ImportDataEventArgs e) {
        this.fillCommonFields(e);
        this.fillCustomFields();
        this.fillSysSwitchDate(e);
        List<String> errorInfo = this.validate();
        if (!errorInfo.isEmpty()) {
            int rowNum = e.getSourceData().getOrDefault("rowNum", 0);
            Map cancelMessages = e.getCancelMessages();
            List<String> msgList = (List<String>)cancelMessages.get(rowNum);
            if (msgList == null) {
                msgList = errorInfo;
            } else {
                msgList.addAll(errorInfo);
            }
            e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), msgList);
            e.setCancel(true);
            logger.info(String.format("lease contract import error: rowNum -> %s, msg -> %s", rowNum, msgList));
        }
    }

    private void fillCommonFields(ImportDataEventArgs e) {
        this.setCurrencyAndSysSwitchDate(e);
        this.setLeaseMonths();
        this.setFreeLeaseMonths();
        this.setInitConfirmDate();
        this.setLeaseTermStartDate();
        this.setIsExempt(e);
        this.setTransitionPlan();
        this.setDepreMonths();
        Object discountRateObj = e.getSourceData().get("discountrate");
        if (discountRateObj == null || StringUtils.isBlank((CharSequence)discountRateObj.toString())) {
            this.setDiscountRate();
        }
        this.setDailyDiscountRate();
    }

    protected void fillCustomFields() {
    }

    protected void fillSysSwitchDate(ImportDataEventArgs e) {
    }

    protected abstract List<String> validate();

    private void setCurrencyAndSysSwitchDate(ImportDataEventArgs e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            QFilter[] filters = new QFilter[]{new QFilter("org", "=", org.getPkValue())};
            DynamicObject leaseInit = QueryServiceHelper.queryOne((String)"fa_lease_init", (String)Fa.comma((String[])new String[]{"basecurrency", "systemswitchday", "status"}), (QFilter[])filters);
            if (leaseInit == null) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u672a\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u5408\u540c\u3002", (String)"AbstractLeaseContractImportPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                long baseCurrencyId = leaseInit.getLong("basecurrency");
                this.getModel().setValue("currency", (Object)baseCurrencyId);
                String status = leaseInit.getString("status");
                String entityName = this.getModel().getDataEntityType().getName();
                if ("fa_lease_contract_init".equals(entityName)) {
                    Date sysSwitchDate = leaseInit.getDate("systemswitchday");
                    if (sysSwitchDate == null) {
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u7cfb\u7edf\u5207\u6362\u65e5\u672a\u7ef4\u62a4\uff0c\u8bf7\u5148\u7ef4\u62a4\u79df\u8d41\u521d\u59cb\u5316\u4e2d\u6570\u636e\u3002", (String)"AbstractLeaseContractImportPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    this.getModel().setValue("sysswitchdate", (Object)sysSwitchDate);
                    if ("C".equals(status)) {
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u79df\u8d41\u521d\u59cb\u5316\u5df2\u542f\u7528\uff0c\u4e0d\u80fd\u65b0\u589e\u521d\u59cb\u5316\u79df\u8d41\u5408\u540c\u3002", (String)"AbstractLeaseContractImportPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                }
            }
        } else {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"AbstractLeaseContractImportPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void setLeaseMonths() {
        LeaseContractCal.setLeaseMonths((IObjWrapper)this.buildObjWrapper());
    }

    private void setFreeLeaseMonths() {
        LeaseContractCal.setFreeLeaseMonths((IObjWrapper)this.buildObjWrapper());
    }

    private void setInitConfirmDate() {
        LeaseContractCal.setInitConfirmDate((IObjWrapper)this.buildObjWrapper());
    }

    private void setLeaseTermStartDate() {
        LeaseContractCal.setLeaseTermStartDate((IObjWrapper)this.buildObjWrapper());
    }

    protected void setIsExempt(ImportDataEventArgs e) {
        LeaseContractCal.setIsExempt((IObjWrapper)this.buildObjWrapper());
    }

    private void setTransitionPlan() {
        LeaseContractCal.setTransitionPlan((IObjWrapper)this.buildObjWrapper());
    }

    private void setDepreMonths() {
        LeaseContractCal.setDepreMonths((IObjWrapper)this.buildObjWrapper());
    }

    private void setDiscountRate() {
        LeaseContractCal.setDiscountRate((IObjWrapper)this.buildObjWrapper());
    }

    private void setDailyDiscountRate() {
        LeaseContractCal.setDailyDiscountRate((IObjWrapper)this.buildObjWrapper());
    }

    private IObjWrapper buildObjWrapper() {
        return new DataModelWrapper(this.getModel());
    }
}

