/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.lease.utils.LeaseChangeUtil;
import kd.fi.fa.common.util.Fa;

public class LeaseBizRecordTabHandler {
    private static final Log logger = LogFactory.getLog(LeaseBizRecordTabHandler.class);
    private static final String BISSINESS_RECORD_AP = "bissinessrecordap";
    private static final String RENT_SETTLE_LIST_AP = "rentsettlelistap";
    private final IFormView view;

    public LeaseBizRecordTabHandler(IFormView view) {
        this.view = view;
    }

    public void handle() {
        this.handleSrcContractTab();
        this.handleRentSettleTab();
        this.handleLeaseTerminationTab();
        this.handleLeaseChangeTab();
        this.setTabCollapse();
        this.view.getModel().setDataChanged(false);
    }

    private void handleSrcContractTab() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.view.getModel();
        DynamicObject srcContract = (DynamicObject)model.getValue("srccontract");
        if (srcContract == null) {
            return;
        }
        model.beginInit();
        model.deleteEntryData("srccontractentity");
        TableValueSetter setter = new TableValueSetter(new String[]{"srccontractshow"});
        setter.set("srccontractshow", srcContract.getPkValue(), 0);
        model.batchCreateNewEntryRow("srccontractentity", setter);
        model.endInit();
    }

    private void handleRentSettleTab() {
        DynamicObject contract = this.view.getModel().getDataEntity();
        long id = contract.getLong("id");
        BillList rentSettleList = (BillList)this.view.getControl(RENT_SETTLE_LIST_AP);
        rentSettleList.setFilter(new QFilter("leasecontract", "=", (Object)id));
        rentSettleList.setOrderBy("billno asc");
    }

    private void handleLeaseTerminationTab() {
        DynamicObject clearBill;
        AbstractFormDataModel model = (AbstractFormDataModel)this.view.getModel();
        String bizStatus = (String)model.getValue("bizstatus");
        if (!LeaseContractBizStatus.B.name().equals(bizStatus)) {
            return;
        }
        long leaseContractId = (Long)model.getValue("id");
        Date terminationDate = (Date)model.getValue("leaseterminationdate");
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "=", (Object)leaseContractId), new QFilter("undotermination", "=", (Object)Boolean.FALSE)};
        String selectFields = Fa.comma((String[])new String[]{"amortizationdate", "termoperuser"});
        DynamicObject terminationRecords = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_lease_term_records", (String)selectFields, (QFilter[])filters);
        if (terminationRecords == null) {
            logger.error("\u672a\u627e\u5230\u5408\u540c\u5bf9\u5e94\u7684\u7ec8\u6b62\u8bb0\u5f55\uff0c\u5408\u540cid[{}]", (Object)leaseContractId);
            return;
        }
        Date termAmortizationDate = terminationRecords.getDate("amortizationdate");
        DynamicObject termOperUser = terminationRecords.getDynamicObject("termoperuser");
        model.beginInit();
        model.deleteEntryData("terminationentry");
        TableValueSetter setter = new TableValueSetter(new String[]{"leaseterminationdateshow", "termamortizationdate", "leaseliaboribalanceshow", "leaseliabbalanceshow", "terminationagent", "clearbillshow", "renewalcontractshow"});
        setter.set("leaseterminationdateshow", (Object)terminationDate, 0);
        setter.set("termamortizationdate", (Object)termAmortizationDate, 0);
        setter.set("leaseliaboribalanceshow", model.getValue("leaseliaboribalance"), 0);
        setter.set("leaseliabbalanceshow", model.getValue("leaseliabbalance"), 0);
        if (termOperUser != null) {
            setter.set("terminationagent", termOperUser.getPkValue(), 0);
        }
        if ((clearBill = (DynamicObject)model.getValue("clearbill")) != null) {
            setter.set("clearbillshow", clearBill.getPkValue(), 0);
        }
        Object renewalContractId = model.getValue("renewalcontractid");
        setter.set("renewalcontractshow", renewalContractId, 0);
        model.batchCreateNewEntryRow("terminationentry", setter);
        model.endInit();
    }

    private void handleLeaseChangeTab() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.view.getModel();
        long contractId = (Long)model.getValue("id");
        if (contractId == 0L) {
            return;
        }
        DynamicObject[] leaseChangeBillArr = this.queryAllLeaseChangeBill(contractId);
        if (leaseChangeBillArr == null || leaseChangeBillArr.length == 0) {
            return;
        }
        long contractMasterId = (Long)model.getValue("masterid");
        Map<Object, DynamicObject> contractMap = this.queryAllContractMap(contractMasterId);
        model.beginInit();
        model.deleteEntryData("leasechangeentry");
        TableValueSetter setter = new TableValueSetter(new String[]{"leasechangebillno", "leasechangebillid", "changeeffectivedate", "chgamortizationdate", "leasechangeitem", "befvalue", "aftvalue", "befchangeversion", "befchgcontractid", "leasechangeauditor"});
        for (DynamicObject changeBill : leaseChangeBillArr) {
            long changeBillId = changeBill.getLong("id");
            String changeBillNo = changeBill.getString("billno");
            Date effectiveDate = changeBill.getDate("effectivedate");
            Date amortizationDate = changeBill.getDate("amortizationdate");
            DynamicObjectCollection changeItems = changeBill.getDynamicObjectCollection("changeitems");
            long auditorId = changeBill.getLong(Fa.id((String)"auditor"));
            long befContractId = changeBill.getLong(Fa.id((String)"befcontract"));
            DynamicObject befContract = contractMap.get(befContractId);
            String befChangeVersion = befContract.getString("version");
            long aftContractId = changeBill.getLong(Fa.id((String)"aftcontract"));
            DynamicObject aftContract = contractMap.get(aftContractId);
            for (DynamicObject dyn : changeItems) {
                DynamicObject item = dyn.getDynamicObject("fbasedataid");
                String itemNumber = item.getString("number");
                String befValue = LeaseChangeUtil.parsePropValue((DynamicObject)befContract, (String)itemNumber);
                String aftValue = LeaseChangeUtil.parsePropValue((DynamicObject)aftContract, (String)itemNumber);
                long itemId = item.getLong("id");
                setter.addRow(new Object[]{changeBillNo, changeBillId, effectiveDate, amortizationDate, itemId, befValue, aftValue, befChangeVersion, befContractId, auditorId});
            }
        }
        model.batchCreateNewEntryRow("leasechangeentry", setter);
        model.endInit();
    }

    private DynamicObject[] queryAllLeaseChangeBill(long contractId) {
        String selectFields = Fa.comma((String[])new String[]{"id", "billno", "changeitems", "effectivedate", "leasecontract", "befcontract", "aftcontract", "auditor", "amortizationdate"});
        QFilter[] filters = new QFilter[]{new QFilter("leasecontract", "=", (Object)contractId), new QFilter("billstatus", "=", (Object)BillStatus.C.name())};
        return BusinessDataServiceHelper.load((String)"fa_lease_change_bill", (String)selectFields, (QFilter[])filters, (String)"auditdate DESC");
    }

    private Map<Object, DynamicObject> queryAllContractMap(long contractMasterId) {
        QFilter filter = new QFilter("masterid", "=", (Object)contractMasterId);
        return BusinessDataServiceHelper.loadFromCache((String)"fa_lease_contract", (QFilter[])filter.toArray());
    }

    private void setTabCollapse() {
        Object srcContract = this.view.getModel().getValue("srccontract");
        boolean hasSrcContract = srcContract != null;
        Object pk = this.view.getModel().getDataEntity().getPkValue();
        QFilter[] rentSettleFilter = new QFilter[]{new QFilter("leasecontract", "=", pk)};
        boolean existsRentSettle = QueryServiceHelper.exists((String)"fa_lease_rent_settle", (QFilter[])rentSettleFilter);
        String bizStatus = (String)this.view.getModel().getValue("bizstatus");
        boolean isTermination = LeaseContractBizStatus.B.name().equals(bizStatus);
        int leaseChangeEntryCount = this.view.getModel().getEntryRowCount("leasechangeentry");
        boolean hasLeaseChange = leaseChangeEntryCount > 0;
        boolean isCollapse = !hasSrcContract && !existsRentSettle && !isTermination && !hasLeaseChange;
        ((Container)this.view.getControl(BISSINESS_RECORD_AP)).setCollapse(isCollapse);
    }
}

