/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.formplugin.lease.LeaseChgExportUtil;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaFormUtils;

public class LeaseChangeListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(LeaseChangeListPlugin.class);
    private static final List<String> REFRESH_FIELD = Arrays.asList("generateassetchange", "deleteassetchange");
    private static final String PAGE_CACHE_SELECTED_DATA = "selectedData";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        try {
            String jsonString = FaFormUtils.linkOrgContainerInit(this.getPageCache(), this.getView(), "org");
            this.getPageCache().put("org", jsonString);
        }
        catch (IOException e) {
            logger.error(ThrowableHelper.toString((Throwable)e));
        }
        FaFormPermissionUtil.filterContainerInitV2(args, this.getPageCache(), this.getView().getPageId());
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FaFormPermissionUtil.filterContainerSearchClick(args, this.getPageCache());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        FaFormPermissionUtil.filterContainerBeforeF7SelectV2(e, this.getView().getPageId(), "fa_lease_change_bill");
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("leasechange_excel".equals(evt.getItemKey())) {
            IFormView view = this.getView();
            LeaseChgExportUtil export = new LeaseChgExportUtil();
            ArrayList<String> fieldList = new ArrayList<String>(16);
            fieldList.add("leasechg_billno");
            fieldList.add("leasechg_org.number");
            fieldList.add("leasechg_leasecontract.number");
            fieldList.add("leasechg_effectivedate");
            fieldList.add("leasechg_creator");
            fieldList.add("leasechg_remark");
            String url = export.export(fieldList, ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355\u6a21\u677f", (String)"LeaseChangeListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), null);
            export.openUrl(url, view);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Donothing doNothing;
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (args.getSource() instanceof Donothing && REFRESH_FIELD.contains(operateKey = (doNothing = (Donothing)source).getOperateKey())) {
            ListSelectedRowCollection listSelectedData = args.getListSelectedData();
            ArrayList<Object> selectedContractIdList = new ArrayList<Object>(10);
            for (ListSelectedRow row : listSelectedData) {
                Object pk = row.getPrimaryKeyValue();
                selectedContractIdList.add(pk);
            }
            String selectedDataJson = SerializationUtils.toJsonString(selectedContractIdList);
            this.getPageCache().put(PAGE_CACHE_SELECTED_DATA, selectedDataJson);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Donothing doNothing;
        String operateKey;
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (args.getSource() instanceof Donothing && REFRESH_FIELD.contains(operateKey = (doNothing = (Donothing)source).getOperateKey())) {
            String selectedDataJson = this.getPageCache().get(PAGE_CACHE_SELECTED_DATA);
            List selectedData = SerializationUtils.fromJsonStringToList((String)selectedDataJson, Object.class);
            ListSelectedRowCollection selectedRowList = new ListSelectedRowCollection();
            for (Object selectedPk : selectedData) {
                ListSelectedRow selectedRow = new ListSelectedRow(selectedPk);
                selectedRowList.add((Object)selectedRow);
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.putSelectedRows(selectedRowList);
            billList.refresh();
            this.getPageCache().remove(PAGE_CACHE_SELECTED_DATA);
        }
    }
}

