/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.fa.cache.CacheHelper;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFDataValidationConstraint;
import org.apache.poi.xssf.usermodel.XSSFDataValidationHelper;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class LeaseChgExportUtil {
    public void openUrl(String url, IFormView formView) {
        ((IClientViewProxy)formView.getService(IClientViewProxy.class)).addAction("openUrl", (Object)url);
    }

    public String export(List<String> fieldList, String caption, List<Long> exportDataId) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet("sheet1");
        sheet.setDefaultColumnWidth(20);
        sheet.setDefaultRowHeight((short)400);
        this.setTableHead(wb, sheet);
        this.setTable(wb, sheet, fieldList, null);
        try {
            return this.writeFile(wb, caption);
        }
        catch (IOException e) {
            throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private void setTableHead(XSSFWorkbook wb, XSSFSheet sheet) {
        XSSFCellStyle style = this.getColumnStyle(wb);
        XSSFCellStyle style1 = wb.createCellStyle();
        XSSFFont font1 = wb.createFont();
        font1.setFontName(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"LeaseChgExportUtil_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        font1.setFontHeightInPoints((short)12);
        font1.setColor(IndexedColors.RED.index);
        style1.setFont((Font)font1);
        XSSFRow row = sheet.createRow(0);
        XSSFRow row1 = sheet.createRow(1);
        row1.setHeight((short)1200);
        XSSFCell cell = row.createCell(0);
        XSSFCell cell1 = row1.createCell(0);
        cell.setCellValue(ResManager.loadKDString((String)"\u79df\u8d41\u53d8\u66f4\u5355 # fa_lease_change_bill", (String)"LeaseChgExportUtil_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        cell.setCellStyle((CellStyle)style);
        cell1.setCellValue(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c422\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb53\u3001\u7b2c\u4e8c\u884c\u7b2c\u4e00\u4e2a\u5355\u5143\u683c\u8f93\u5165#SetNULL\uff0c\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5\u3002", (String)"LeaseChgExportUtil_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        cell1.setCellStyle((CellStyle)style1);
    }

    private void setTable(XSSFWorkbook wb, XSSFSheet sheet, List<String> fieldList, DynamicObjectCollection dataRows) {
        DynamicProperty property;
        String number2;
        XSSFCellStyle style = this.getColumnStyle(wb);
        XSSFCellStyle style1 = wb.createCellStyle();
        style1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style1.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        XSSFFont font1 = wb.createFont();
        font1.setFontName("Calibri");
        font1.setFontHeightInPoints((short)11);
        style1.setFont((Font)font1);
        XSSFRow row = sheet.createRow(2);
        XSSFRow row1 = sheet.createRow(3);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"fa_lease_contract");
        DataEntityPropertyCollection propetyCol = dataEntityType.getProperties();
        QFilter qchangeType = new QFilter("topic", "=", (Object)"fa_lease_contract");
        Map changeitemCol = BusinessDataServiceHelper.loadFromCache((String)"fa_change_item", (QFilter[])new QFilter[]{qchangeType});
        for (Map.Entry dy : changeitemCol.entrySet()) {
            DynamicObject value = (DynamicObject)dy.getValue();
            number2 = value.getString("number");
            fieldList.add(number2);
        }
        ArrayList<String> importEntryList = new ArrayList<String>(1);
        int index = 0;
        for (int i = 0; i < fieldList.size(); ++i) {
            number2 = fieldList.get(i);
            property = (DynamicProperty)propetyCol.get((Object)number2);
            if (null != property && property instanceof EntryProp) {
                importEntryList.add(property.getName());
                continue;
            }
            XSSFCell cell = row.createCell(index);
            cell.setCellStyle((CellStyle)style);
            XSSFCell cell1 = row1.createCell(index);
            cell1.setCellStyle((CellStyle)style1);
            switch (number2) {
                case "leasechg_billno": {
                    cell.setCellValue("billno");
                    cell1.setCellValue(ResManager.loadKDString((String)"*\u5355\u636e\u7f16\u53f7", (String)"LeaseChgExportUtil_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "leasechg_org.number": {
                    cell.setCellValue("org.number");
                    cell1.setCellValue(ResManager.loadKDString((String)"*\u8d44\u4ea7\u7ec4\u7ec7", (String)"LeaseChgExportUtil_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "leasechg_leasecontract.number": {
                    cell.setCellValue("leasecontract.number");
                    cell1.setCellValue(ResManager.loadKDString((String)"*\u539f\u5408\u540c", (String)"LeaseChgExportUtil_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "leasechg_effectivedate": {
                    cell.setCellValue("effectivedate");
                    cell1.setCellValue(ResManager.loadKDString((String)"*\u53d8\u66f4\u751f\u6548\u65e5", (String)"LeaseChgExportUtil_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "leasechg_creator": {
                    cell.setCellValue("creator");
                    cell1.setCellValue(ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"LeaseChgExportUtil_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    break;
                }
                case "leasechg_remark": {
                    cell.setCellValue("remark");
                    cell1.setCellValue(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"LeaseChgExportUtil_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    break;
                }
            }
            if (property != null) {
                LocaleString name;
                String exprotProp;
                String changeitems = "changeitems_";
                String changeName = ResManager.loadKDString((String)"\u53ef\u53d8\u66f4\u9879\u76ee_", (String)"LeaseChgExportUtil_9", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                if (property instanceof BasedataProp) {
                    exprotProp = changeitems + property.getName() + ".number";
                    name = property.getDisplayName();
                    cell.setCellValue(exprotProp);
                    cell1.setCellValue(changeName + name.getLocaleValue());
                } else {
                    exprotProp = changeitems + property.getName();
                    name = property.getDisplayName();
                    cell.setCellValue(exprotProp);
                    cell1.setCellValue(changeName + name.getLocaleValue());
                }
            }
            ++index;
        }
        for (String number2 : importEntryList) {
            property = (DynamicProperty)propetyCol.get((Object)number2);
            if (!(property instanceof EntryProp)) continue;
            int lastCellNum = row.getLastCellNum();
            String entryName = property.getName();
            DynamicObjectType entryPropType = ((EntryProp)property).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection entryProps = entryPropType.getProperties();
            XSSFRow topRow = sheet.getRow(0);
            XSSFCell entryCell = topRow.createCell(lastCellNum);
            entryCell.setCellValue(entryName);
            entryCell.setCellStyle((CellStyle)style);
            for (IDataEntityProperty entry : entryProps) {
                XSSFCell cell1;
                XSSFCell cell;
                LocaleString name;
                String entryExprotProp;
                boolean importable;
                if (entry instanceof AmountProp) {
                    importable = ((AmountProp)entry).isImportable();
                    if (!importable) continue;
                    entryExprotProp = entry.getName();
                    name = entry.getDisplayName();
                    cell = row.createCell(lastCellNum);
                    cell1 = row1.createCell(lastCellNum);
                    cell.setCellValue(entryExprotProp);
                    cell.setCellStyle((CellStyle)style);
                    cell1.setCellValue(name.getLocaleValue());
                    cell1.setCellStyle((CellStyle)style1);
                    ++lastCellNum;
                    continue;
                }
                if (entry instanceof ComboProp) {
                    importable = ((ComboProp)entry).isImportable();
                    if (!importable) continue;
                    entryExprotProp = entry.getName();
                    name = entry.getDisplayName();
                    cell = row.createCell(lastCellNum);
                    cell1 = row1.createCell(lastCellNum);
                    cell.setCellValue(entryExprotProp);
                    cell.setCellStyle((CellStyle)style);
                    cell1.setCellValue(name.getLocaleValue());
                    cell1.setCellStyle((CellStyle)style1);
                    int size = 10000;
                    List items = ((ComboProp)entry).getComboItems();
                    ArrayList<String> dropDownBoxList = new ArrayList<String>(16);
                    for (ValueMapItem item : items) {
                        String localeValue = item.getName().getLocaleValue();
                        dropDownBoxList.add(localeValue);
                    }
                    String[] dropDownBoxArray = new String[dropDownBoxList.size()];
                    this.dropDownBox(sheet, size, lastCellNum, lastCellNum, dropDownBoxList.toArray(dropDownBoxArray));
                    ++lastCellNum;
                    continue;
                }
                if (entry instanceof BasedataProp) {
                    importable = ((BasedataProp)entry).isImportable();
                    if (!importable) continue;
                    entryExprotProp = entry.getName() + ".number";
                    name = entry.getDisplayName();
                    cell = row.createCell(lastCellNum);
                    cell1 = row1.createCell(lastCellNum);
                    cell.setCellValue(entryExprotProp);
                    cell.setCellStyle((CellStyle)style);
                    cell1.setCellValue(name.getLocaleValue());
                    cell1.setCellStyle((CellStyle)style1);
                    ++lastCellNum;
                    continue;
                }
                if (!(entry instanceof FieldProp) || !(importable = ((FieldProp)entry).isImportable())) continue;
                ((FieldProp)entry).isImportable();
                entryExprotProp = entry.getName();
                name = entry.getDisplayName();
                cell = row.createCell(lastCellNum);
                cell1 = row1.createCell(lastCellNum);
                cell.setCellValue(entryExprotProp);
                cell.setCellStyle((CellStyle)style);
                cell1.setCellValue(name.getLocaleValue());
                cell1.setCellStyle((CellStyle)style1);
                ++lastCellNum;
            }
        }
    }

    private void dropDownBox(XSSFSheet sheet, int size, int beginCol, int endCol, String[] dropDownBoxValue) {
        XSSFDataValidationHelper dvHelper = new XSSFDataValidationHelper(sheet);
        XSSFDataValidationConstraint dvConstraint = (XSSFDataValidationConstraint)dvHelper.createExplicitListConstraint(dropDownBoxValue);
        CellRangeAddressList addressList = new CellRangeAddressList(1, size, beginCol, endCol);
        XSSFDataValidation validation = (XSSFDataValidation)dvHelper.createValidation((DataValidationConstraint)dvConstraint, addressList);
        sheet.addValidationData((DataValidation)validation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(XSSFWorkbook wb, String formName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheHelper.getTempFileCache().saveAsUrl(this.getTempFilename(formName), (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private String getTempFilename(String formName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddhhmmssSSS");
        String currDateTime = dateFormat.format(new Date());
        String userName = RequestContext.get().getUserName();
        return formName + "-" + currDateTime + "-" + userName + ".xlsx";
    }

    private XSSFCellStyle getColumnStyle(XSSFWorkbook wb) {
        XSSFCellStyle columnStyle = wb.createCellStyle();
        columnStyle.setAlignment(HorizontalAlignment.LEFT);
        XSSFFont font = wb.createFont();
        font.setFontName(ResManager.loadKDString((String)"\u5b8b\u4f53", (String)"LeaseChgExportUtil_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        font.setFontHeightInPoints((short)12);
        columnStyle.setFont((Font)font);
        return columnStyle;
    }
}

