/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.validator.lease.LeaseContractValidator;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.ThrowableHelper;
import kd.fi.fa.utils.FaFormPermissionUtil;
import kd.fi.fa.utils.FaFormUtils;

public class LeaseContractListPlugin
extends AbstractListPlugin {
    private static final String KEY_PUSH = "push";
    private static final String KEY_RENT_SETTLE = "rentsettle";
    private static final String KEY_QUERY_RENT_SETTLE = "queryrentsettle";
    private static final String KEY_QUERY_INTEREST_DETAIL = "queryinterestdetail";
    public static final String PARAM_CONTRACT_ID = "param_contract_id";
    private static final String KEY_FULL_TERMINATION = "fulltermination";
    private static final String KEY_UNDO_TERMINATION = "undotermination";
    private static final int LEASE_TERMINATION_MAX_DEAL_NUM = 200;
    private static final String CALL_BACK_REFRESH = "call_back_refresh";
    private static Log logger = LogFactory.getLog(LeaseContractListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        try {
            String jsonString = FaFormUtils.linkOrgContainerInit(this.getPageCache(), this.getView(), "assetunit");
            this.getPageCache().put("assetunits", jsonString);
        }
        catch (IOException e) {
            logger.error(ThrowableHelper.toString((Throwable)e));
        }
        FaFormPermissionUtil.filterContainerInitV2(args, this.getPageCache(), this.getView().getPageId());
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        FaFormPermissionUtil.filterContainerSearchClick(args, this.getPageCache());
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        FaFormPermissionUtil.filterContainerBeforeF7SelectV2(e, this.getView().getPageId(), "fa_lease_contract");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        List<Object> errorInfo = new ArrayList(10);
        switch (operateKey) {
            case "push": {
                errorInfo = this.validate4Push();
                break;
            }
            case "queryrentsettle": {
                errorInfo = this.validate4LinkQuery();
                break;
            }
            case "queryinterestdetail": {
                ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
                Set selectContractIds = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                if (selectContractIds.size() > 1) {
                    errorInfo.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u5408\u540c\u8fdb\u884c\u8054\u67e5\u3002", (String)"LeaseContractListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    break;
                }
                errorInfo = this.validate4LinkQuery();
                break;
            }
        }
        if (!errorInfo.isEmpty()) {
            args.setCancel(true);
            this.getView().showTipNotification(String.join((CharSequence)" ", errorInfo));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        switch (operateKey) {
            case "rentsettle": {
                if (opResult == null || !opResult.isSuccess()) break;
                this.showRentSettleList();
                break;
            }
            case "queryrentsettle": {
                this.showRentSettleList();
                break;
            }
            case "queryinterestdetail": {
                this.showInterestDetail();
                break;
            }
            case "fulltermination": {
                if (opResult == null || !opResult.isSuccess()) break;
                this.showFullTerminationForm();
                break;
            }
            case "undotermination": {
                if (opResult == null || !opResult.isSuccess()) break;
                this.showUndoTerminationForm();
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (CALL_BACK_REFRESH.equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private List<String> validate4Push() {
        ArrayList<String> errorInfo = new ArrayList<String>(10);
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        Stream<Object> idStream = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue);
        Map contractFromCache = BusinessDataServiceHelper.loadFromCache((Object[])idStream.toArray(Object[]::new), (String)"fa_lease_contract");
        ArrayList contracts = new ArrayList(contractFromCache.values());
        List res = LeaseContractValidator.validateForPush(contracts);
        if (!res.isEmpty()) {
            errorInfo.addAll(res);
        }
        return errorInfo;
    }

    private List<String> validate4LinkQuery() {
        ArrayList<String> errorInfo = new ArrayList<String>(10);
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        Stream<Object> idStream = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue);
        Map contractFromCache = BusinessDataServiceHelper.loadFromCache((Object[])idStream.toArray(Object[]::new), (String)"fa_lease_contract");
        ArrayList contracts = new ArrayList(contractFromCache.values());
        List res = LeaseContractValidator.validateForLinkQuery(contracts);
        if (!res.isEmpty()) {
            errorInfo.addAll(res);
        }
        return errorInfo;
    }

    private void showRentSettleList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ArrayList<Long> contractIdList = new ArrayList<Long>(1);
        HashSet<String> orgIdList = new HashSet<String>(1);
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            long contractId = (Long)selectedRow.getPrimaryKeyValue();
            contractIdList.add(contractId);
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(1);
            filterList.add(new QFilter("id", "in", (Object)contractId));
            DynamicObject leaseContract = QueryServiceHelper.queryOne((String)"fa_lease_contract", (String)"id,org", (QFilter[])filterList.toArray(new QFilter[0]));
            String orgId = leaseContract.getString("org");
            orgIdList.add(orgId);
        }
        parameter.getCustomParams().put("contractIdList", SerializationUtils.toJsonString(contractIdList));
        parameter.getCustomParams().put("leaseContractOrgIdList", orgIdList);
        parameter.setBillFormId("fa_lease_rent_settle");
        parameter.setHasRight(Boolean.TRUE.booleanValue());
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showInterestDetail() {
        BillShowParameter param = new BillShowParameter();
        param.setFormId("fa_interest_detail");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setStatus(OperationStatus.VIEW);
        param.setBillStatus(BillOperationStatus.VIEW);
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        QFilter filter = new QFilter("leasecontract", "=", selectedRows.get(0).getPrimaryKeyValue());
        DynamicObject interestDetail = QueryServiceHelper.queryOne((String)"fa_interest_detail", (String)"id", (QFilter[])new QFilter[]{filter});
        param.setPkId((Object)interestDetail.getLong("id"));
        param.setHasRight(Boolean.TRUE.booleanValue());
        this.getView().showForm((FormShowParameter)param);
    }

    private void showFullTerminationForm() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        List contractIdList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", contractIdList), new QFilter("status", "=", (Object)BillStatus.C.name()), new QFilter("bizstatus", "=", (Object)LeaseContractBizStatus.A.name())};
        String selectFields = Fa.comma((String[])new String[]{"id", "leaseenddate"});
        DynamicObjectCollection contracts = QueryServiceHelper.query((String)"fa_lease_contract", (String)selectFields, (QFilter[])filters, null, (int)200);
        Map<Long, Date> contractMap = contracts.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getDate("leaseenddate")));
        String contractMapStr = SerializationUtils.toJsonString(contractMap);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fa_lease_termination");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam(PARAM_CONTRACT_ID, (Object)contractMapStr);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_REFRESH));
        this.getView().showForm(param);
    }

    private void showUndoTerminationForm() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        List contractIdList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", contractIdList), new QFilter("bizstatus", "=", (Object)LeaseContractBizStatus.B.name())};
        String selectFields = Fa.comma((String[])new String[]{"id", "renewalcontractid"});
        DynamicObjectCollection contracts = QueryServiceHelper.query((String)"fa_lease_contract", (String)selectFields, (QFilter[])filters, null, (int)200);
        Map<Long, Long> contractMap = contracts.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v.getLong("renewalcontractid")));
        String contractMapStr = SerializationUtils.toJsonString(contractMap);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fa_lease_undo_termination");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam(PARAM_CONTRACT_ID, (Object)contractMapStr);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_REFRESH));
        this.getView().showForm(param);
    }
}

