/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FaFormPermissionUtil;

public class LeaseRentSettleFilterList
extends AbstractListPlugin {
    private static final String SHOW_TERMINATION_DATA = "showTerminationData";
    private static final String STR_TRUE = "true";

    public void filterContainerInit(FilterContainerInitArgs filtercontainerinitargs) {
        super.filterContainerInit(filtercontainerinitargs);
        FaFormPermissionUtil.setOrgDefaultValuesForSelectV2(this.getView().getPageId(), filtercontainerinitargs);
        List listFilterColumns = filtercontainerinitargs.getFilterContainerInitEvent().getCommonFilterColumns();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        for (FilterColumn listFilter : listFilterColumns) {
            String field;
            CommonFilterColumn commFilter = (CommonFilterColumn)listFilter;
            switch (field = commFilter.getFieldName()) {
                case "org.name": {
                    List orgIdList = (List)paramMap.get("leaseContractOrgIdList");
                    if (orgIdList == null || orgIdList.size() <= 0) break;
                    commFilter.setDefaultValues(orgIdList);
                    break;
                }
                case "settledate": {
                    if (!paramMap.containsKey("leaseContractOrgIdList")) break;
                    commFilter.setDefaultValue("");
                    break;
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        if (StringUtils.equals((CharSequence)"org.id", (CharSequence)e.getFieldName())) {
            FaFormPermissionUtil.filterContainerBeforeF7SelectOnlyOrgV2(e, "fa_lease_rent_settle", this.getView().getPageId());
        }
        if (StringUtils.equals((CharSequence)"leasecontract.number", (CharSequence)e.getFieldName())) {
            FaFormPermissionUtil.filterLeaseContractBeforeF7SelectByOrgV2(e, "fa_lease_rent_settle", this.getView().getPageId());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        filters.add(new QFilter(Fa.dot((String[])new String[]{"leasecontract", "isbak"}), "=", (Object)Boolean.FALSE));
        String contractIdListStr = (String)this.getView().getFormShowParameter().getCustomParam("contractIdList");
        if (StringUtils.isNotBlank((CharSequence)contractIdListStr)) {
            List contractIdList = SerializationUtils.fromJsonStringToList((String)contractIdListStr, Long.class);
            filters.add(new QFilter("leasecontract", "in", (Object)contractIdList));
        }
        this.processDataAfterTerminationPeriod(e);
        String orderBy = "leasecontract asc,billno asc";
        e.setOrderBy(orderBy);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if (Fa.join((String)"_", (String[])new String[]{"leasecontract", "number"}).equals(fieldName)) {
            this.showLeaseContract(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("genvoucher_dn".equals(operateKey) || "deletevoucher_dn".equals(operateKey)) {
            this.getView().updateView("billlistap");
        }
    }

    private void showLeaseContract(HyperLinkClickArgs args) {
        args.setCancel(true);
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        ListSelectedRow row = ((BillListHyperLinkClickEvent)evt).getCurrentRow();
        Object rentSettlePk = row.getPrimaryKeyValue();
        DynamicObject rentSettle = BusinessDataServiceHelper.loadSingleFromCache((Object)rentSettlePk, (String)"fa_lease_rent_settle");
        DynamicObject leaseContract = rentSettle.getDynamicObject("leasecontract");
        Object leaseContractPk = leaseContract.getPkValue();
        BillShowParameter param = new BillShowParameter();
        param.setFormId("fa_lease_contract");
        param.setPkId(leaseContractPk);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private void processDataAfterTerminationPeriod(SetFilterEvent e) {
        QFilter[] filters = new QFilter[]{new QFilter("entity", "=", (Object)"fa_lease_rent_settle"), new QFilter("param", "=", (Object)SHOW_TERMINATION_DATA), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject billParam = QueryServiceHelper.queryOne((String)"fa_billparam", (String)"value", (QFilter[])filters);
        if (billParam == null) {
            return;
        }
        String paramValue = billParam.getString("value");
        if (STR_TRUE.equals(paramValue)) {
            return;
        }
        List mergeFilters = e.getMergeQFilters();
        String selectFields = Fa.comma((String[])new String[]{"id", "leasecontract", "amortizationperiod"});
        DynamicObjectCollection preRentSettleList = QueryServiceHelper.query((String)"fa_lease_rent_settle", (String)selectFields, (QFilter[])mergeFilters.toArray(new QFilter[0]));
        Set preContractIdSet = preRentSettleList.stream().map(v -> v.getLong("leasecontract")).collect(Collectors.toSet());
        Map amortizationPeriodIdMap = LeaseUtil.calTerminationAmortizationPeriodId(preContractIdSet);
        ArrayList<Long> rentSettleIdList = new ArrayList<Long>(preRentSettleList.size());
        for (DynamicObject rentSettle : preRentSettleList) {
            long rentSettleId = rentSettle.getLong("id");
            long leaseContractId = rentSettle.getLong("leasecontract");
            Long termAmortizationPeriodId = (Long)amortizationPeriodIdMap.get(leaseContractId);
            if (termAmortizationPeriodId == null) {
                rentSettleIdList.add(rentSettleId);
                continue;
            }
            long amortizationPeriodId = rentSettle.getLong("amortizationperiod");
            if (amortizationPeriodId > termAmortizationPeriodId) continue;
            rentSettleIdList.add(rentSettleId);
        }
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("id", "in", rentSettleIdList));
    }
}

