/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.utils.FaShowFormUtils;

public class LeaseTerminationEditPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        try {
            this.initData();
        }
        catch (ParseException parseException) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"LeaseTerminationEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        if ("leasecontract".equals(fieldName)) {
            this.showLeaseContractForm(rowIndex);
        }
    }

    private void initData() throws ParseException {
        FormShowParameter param = this.getView().getFormShowParameter();
        String contractMapStr = (String)param.getCustomParam("param_contract_id");
        if (StringUtils.isEmpty((CharSequence)contractMapStr)) {
            return;
        }
        Map contractMap = (Map)SerializationUtils.fromJsonString((String)contractMapStr, Map.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter setter = new TableValueSetter(new String[]{"leasecontract", "leaseterminationdate"});
        int index = 0;
        for (Map.Entry entry : contractMap.entrySet()) {
            long contractId = Long.parseLong((String)entry.getKey());
            Date leaseEndDate = DateUtil.getShortDate().parse((String)entry.getValue());
            Date defaultTerminationDate = DateUtil.addDay((Date)leaseEndDate, (int)1);
            setter.set("leasecontract", (Object)contractId, index);
            setter.set("leaseterminationdate", (Object)defaultTerminationDate, index);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void showLeaseContractForm(int rowIndex) {
        DynamicObject leaseContract = (DynamicObject)this.getModel().getValue("leasecontract", rowIndex);
        long contractId = leaseContract.getLong("id");
        FaShowFormUtils.showSingleBillForm(this.getView(), "fa_lease_contract", contractId, ShowType.Modal);
    }
}

