/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.lease;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.fa.utils.FaShowFormUtils;

public class LeaseUndoTerminationEditPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.initData();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        int rowIndex = evt.getRowIndex();
        switch (fieldName) {
            case "leasecontract": {
                this.showLeaseContractForm(rowIndex);
                break;
            }
            case "clearbillno": {
                this.showClearBillForm(rowIndex);
                break;
            }
            case "renewalcontractno": {
                this.showRenewalContractForm(rowIndex);
                break;
            }
        }
    }

    private void initData() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String contractMapStr = (String)param.getCustomParam("param_contract_id");
        if (StringUtils.isEmpty((CharSequence)contractMapStr)) {
            return;
        }
        Map contractMap = (Map)SerializationUtils.fromJsonString((String)contractMapStr, Map.class);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        TableValueSetter setter = new TableValueSetter(new String[]{"leasecontract", "renewalcontract"});
        int index = 0;
        for (Map.Entry entry : contractMap.entrySet()) {
            setter.set("leasecontract", (Object)Long.parseLong((String)entry.getKey()), index);
            setter.set("renewalcontract", entry.getValue(), index);
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void showLeaseContractForm(int rowIndex) {
        DynamicObject leaseContract = (DynamicObject)this.getModel().getValue("leasecontract", rowIndex);
        long contractId = leaseContract.getLong("id");
        FaShowFormUtils.showSingleBillForm(this.getView(), "fa_lease_contract", contractId, ShowType.Modal);
    }

    private void showClearBillForm(int rowIndex) {
        DynamicObject leaseContract = (DynamicObject)this.getModel().getValue("leasecontract", rowIndex);
        DynamicObject clearBill = leaseContract.getDynamicObject("clearbill");
        long clearBillId = clearBill.getLong("id");
        FaShowFormUtils.showSingleBillForm(this.getView(), "fa_clearbill", clearBillId, ShowType.Modal);
    }

    private void showRenewalContractForm(int rowIndex) {
        DynamicObject renewalContract = (DynamicObject)this.getModel().getValue("renewalcontract", rowIndex);
        long renewalContractId = renewalContract.getLong("id");
        FaShowFormUtils.showSingleBillForm(this.getView(), "fa_lease_contract", renewalContractId, ShowType.Modal);
    }
}

