/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.mediate;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class FaRptMediateListPlugin
extends AbstractListPlugin {
    private static final String CHANGE_TYPE_CACHE_KEY = "changeType";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if ("updatechangemode".equals(operateKey)) {
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            HashSet<Object> ids = new HashSet<Object>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                ids.add(selectedRow.getPrimaryKeyValue());
            }
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"fa_rpt_mediate", (String)"changetype", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            Set changeTypes = collection.stream().map(v -> v.get("changetype")).collect(Collectors.toSet());
            if (changeTypes.size() > 1) {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76f8\u540c\u589e\u51cf\u7c7b\u578b\u7684\u6570\u636e\u3002", (String)"FaRptMediateListPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            Object[] changeTypeArr = changeTypes.toArray();
            this.getPageCache().put(CHANGE_TYPE_CACHE_KEY, String.valueOf(changeTypeArr[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("updatechangemode".equals(key)) {
            OperationResult result = args.getOperationResult();
            boolean success = result.isSuccess();
            if (!success) {
                return;
            }
            ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
            HashSet<Object> ids = new HashSet<Object>(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                ids.add(selectedRow.getPrimaryKeyValue());
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("fa_rpt_updatechangemode");
            parameter.getCustomParams().put("ids", SerializationUtils.serializeToBase64(ids));
            parameter.getCustomParams().put(CHANGE_TYPE_CACHE_KEY, this.getPageCache().get(CHANGE_TYPE_CACHE_KEY));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "updatechangemode"));
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setHasRight(true);
            this.getView().showForm(parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if ("updatechangemode".equals(actionId)) {
            Map returnData = (Map)e.getReturnData();
            if (returnData == null) {
                this.getView().invokeOperation("refresh");
                return;
            }
            Object successObj = returnData.get("success");
            boolean success = Boolean.parseBoolean(String.valueOf(successObj));
            String message = String.valueOf(returnData.get("message"));
            if (success) {
                this.getView().showSuccessNotification(message);
                this.getView().invokeOperation("refresh");
            } else {
                this.getView().showErrorNotification(message);
            }
        }
    }
}

