/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.constants.FaAssetDrawback;
import kd.fi.fa.business.constants.FaAssetTranfer;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.utils.FapHomeUtil;
import kd.fi.fa.utils.FapUtils;

public class FapAssetHomePagePlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String APPLY_ASSET = "apply_asset";
    private static final String TRANSFER_ASSET = "transfer_asset";
    private static final String DRAWBACK_ASSET = "drawback_asset";
    private static final String LAB_MYASSET_CNT = "lab_myasset_cnt";
    private static final String LAB_APPLY_CNT = "lab_apply_cnt";
    private static final String LAB_DRAWBACK_CNT = "lab_drawback_cnt";
    private static final String LAB_TRANSFER_CNT = "lab_transfer_cnt";
    private static final String LAB_INVENTORY_CNT = "lab_inventory_cnt";
    private static final String LAB_REPAIRING_CNT = "lab_repairing_cnt";
    private static final String HOVER_ASSETNAME = "hov_assetname";
    private static final String HOVER_NUMBER = "hov_number";
    private static final String HOVER_MODEL = "hov_model";
    private static final String HOVER_TIME = "hov_time";
    private static final String ASSET_NAME = "assetname";
    private static final String ASSET_IMG = "assetimg";
    private static final String ASSET_ID = "realcardid";
    private static final String ASSET_STATUS = "cardstatus";
    private static final String ASSET_UNIT = "assetunit";
    private static final String ASSET_STOREPLACE = "storeplace";
    private static final String BTN_TRANS = "btn_trans";
    private static final String BTN_DRAWBACK = "btn_drawback";
    private static final String BTN_REPAIR = "btn_repair";

    public void registerListener(EventObject e) {
        Tab apptabs = (Tab)this.getView().getControl("_submaintab_");
        apptabs.addTabSelectListener((TabSelectListener)this);
        super.registerListener(e);
        this.addClickListeners(new String[]{APPLY_ASSET, TRANSFER_ASSET, DRAWBACK_ASSET, LAB_APPLY_CNT, LAB_DRAWBACK_CNT, LAB_TRANSFER_CNT, BTN_TRANS, BTN_DRAWBACK, BTN_REPAIR, LAB_INVENTORY_CNT});
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        int index = 0;
        switch (key = source.getKey()) {
            case "apply_asset": {
                this.showBillForm(this.getView(), "fa_asset_apply", null, null, null, null);
                break;
            }
            case "transfer_asset": {
                break;
            }
            case "drawback_asset": {
                break;
            }
            case "lab_apply_cnt": {
                this.showBillListForm(this.getView(), "fa_asset_apply");
                break;
            }
            case "lab_drawback_cnt": {
                this.showBillListForm(this.getView(), "fa_asset_drawback");
                break;
            }
            case "lab_transfer_cnt": {
                this.showBillListForm(this.getView(), "fa_asset_transfer");
                break;
            }
            case "lab_inventory_cnt": {
                this.showBillListForm(this.getView(), "fa_inventory_backlog");
                break;
            }
            case "btn_trans": {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.showBillForm(this.getView(), "fa_asset_transfer", this.getModel().getValue(ASSET_ID, index), (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), this.getModel().getValue(ASSET_STOREPLACE, index), this.getModel().getValue(ASSET_STATUS, index));
                break;
            }
            case "btn_drawback": {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.showBillForm(this.getView(), "fa_asset_drawback", this.getModel().getValue(ASSET_ID, index), (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), this.getModel().getValue(ASSET_STOREPLACE, index), this.getModel().getValue(ASSET_STATUS, index));
                break;
            }
            case "btn_repair": {
                index = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.showBillForm(this.getView(), "fa_apply_repair", this.getModel().getValue(ASSET_ID, index), (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), this.getModel().getValue(ASSET_STOREPLACE, index), this.getModel().getValue(ASSET_STATUS, index));
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArrayList qFilters = new ArrayList(0);
        DynamicObject params = FaBillParamUtils.queryOne((String)"fap_params", qFilters);
        boolean isNewVersion = params == null ? false : params.getBoolean("value");
        if (isNewVersion) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap1", "flexpanelap2"});
        } else {
            this.loadAssetData();
            this.loadDoingData();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"gridcontainerap", "cardcontainer"});
        }
    }

    private void loadDoingData() {
        Long userId = RequestContext.get().getCurrUserId();
        int assetApplyCount = FapUtils.findFaAssetApplyByApplyerIdAndBillStatus(userId, BillStatus.A, BillStatus.B);
        int assetTransferCount = FapUtils.findFaAssetTransferByApplyerIdAndBizStatus(userId, FaAssetTranfer.BizStatusEnum.SUBMITTED, FaAssetTranfer.BizStatusEnum.TEMPORARY);
        int assetDrawbackCount = FapUtils.findFaAssetDrawbackByApplyerIdAndBizStatus(userId, FaAssetDrawback.BizStatusEnum.SUBMITTED, FaAssetDrawback.BizStatusEnum.TEMPORARY);
        int assetInventoryCount = FapUtils.getInventoryCount(userId);
        int repairingCount = FapUtils.countFaAssetRepairingByApplyerIdAndBizStatus(userId);
        Label labelAp = (Label)this.getView().getControl(LAB_APPLY_CNT);
        labelAp.setText(String.valueOf(assetApplyCount));
        Label labelTr = (Label)this.getView().getControl(LAB_TRANSFER_CNT);
        labelTr.setText(String.valueOf(assetTransferCount));
        Label labelDb = (Label)this.getView().getControl(LAB_DRAWBACK_CNT);
        labelDb.setText(String.valueOf(assetDrawbackCount));
        Label labelIt = (Label)this.getView().getControl(LAB_INVENTORY_CNT);
        labelIt.setText(String.valueOf(assetInventoryCount));
        Label labelRepair = (Label)this.getView().getControl(LAB_REPAIRING_CNT);
        labelRepair.setText(String.valueOf(repairingCount));
    }

    private void loadAssetData() {
        List<QFilter> qFilters = this.getQfilters();
        DynamicObjectCollection loadsCollection = QueryServiceHelper.query((String)"fa_card_real", (String)"id,assetunit,storeplace,number,assetname,model,picturefield,bizstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
        DynamicObject[] loads = (DynamicObject[])loadsCollection.toArray((Object[])new DynamicObject[0]);
        LinkedList realcardIds = new LinkedList();
        Stream.of(loads).forEach(load -> realcardIds.add(load.getPkValue()));
        FapHomeUtil.loadData(this.getModel());
        this.getView().updateView("entryentity");
        this.setMyAssetCount(loads.length);
    }

    private List<QFilter> getQfilters() {
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        qFilters.add(new QFilter("headuseperson", "=", (Object)ContextUtil.getUserId()));
        qFilters.add(new QFilter("isbak", "=", (Object)false));
        qFilters.add(new QFilter("isstoraged", "=", (Object)false));
        qFilters.add(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.toString()));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        return qFilters;
    }

    private void setMyAssetCount(int length) {
        Label label = (Label)this.getView().getControl(LAB_MYASSET_CNT);
        label.setText(String.valueOf(length));
    }

    private void showBillListForm(IFormView view, String formId) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String[] statusList = new String[]{"A", "B"};
        parameter.getCustomParams().put("status", Arrays.asList(statusList));
        parameter.setBillFormId(formId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showBillForm(IFormView view, String formId, Object realcardId, DynamicObject assetunit, Object storeplaceid, Object cardstatus) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.getCustomParams().put(ASSET_ID, realcardId);
        showParameter.getCustomParams().put(ASSET_STATUS, cardstatus);
        showParameter.getCustomParams().put("assetunitid", assetunit == null ? "" : String.valueOf(assetunit.getPkValue()));
        showParameter.getCustomParams().put("storeplaceid", storeplaceid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)showParameter);
    }

    public void tabSelected(TabSelectEvent e) {
        String key = e.getTabKey();
        if (key.equals("appmiantab") || key.equals("tabpageap")) {
            this.refreshView();
        }
    }

    private void refreshView() {
        this.getModel().createNewData();
    }
}

