/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset;

import java.text.Format;
import java.util.Collections;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.IFormView;
import kd.bos.form.control.Image;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.utils.FaAddHeadPicture;
import kd.fi.fa.utils.FaQFilter;

public class RequisitionInfoFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String OP_SAVE = "save";
    private static final String OP_SUBMIT = "submit";

    public void registerListener(EventObject e) {
        BasedataEdit realCardF7 = (BasedataEdit)this.getControl("real_card");
        realCardF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        DynamicObject user = (DynamicObject)this.getModel().getValue("req_user");
        if (user == null) {
            this.getModel().setValue("req_user", (Object)ContextUtil.getUserId());
            user = (DynamicObject)this.getModel().getValue("req_user");
        }
        Image userImage = (Image)this.getControl("picturefield");
        String imageFullUrl = ImageUtil.getImageTruePath((String)user.getString("picturefield"));
        userImage.setUrl(imageFullUrl);
        Long creatorId = user.getLong("id");
        this.getModel().setValue("creator", (Object)creatorId);
        long pk = 0L;
        DynamicObject reqDObject = this.getView().getModel().getDataEntity();
        if (reqDObject != null) {
            pk = reqDObject.getLong("asset_apply_bill_id");
        }
        if (pk != 0L) {
            this.showApplyList(pk);
            DynamicObject applyDObject = FaBaseDaoFactory.getInstance((String)"fa_asset_apply").queryOne((Object)pk);
            this.getModel().setValue("req_department", applyDObject.get("department"));
            this.getModel().setValue("org", applyDObject.get("org"));
            this.getModel().setDataChanged(false);
        } else {
            Map<String, Object> dpt = FaAddHeadPicture.getDptNameByUserId(creatorId);
            this.getModel().setValue("req_department", dpt.get("dpt"));
            Map depParent = OrgUnitServiceHelper.getCompanyfromOrg((Object)dpt.get("dpt"));
            this.getModel().setValue("org", depParent.get("id"));
            this.getModel().setDataChanged(false);
        }
        IFormView view = this.getView();
        DynamicObject bill = view.getModel().getDataEntity();
        if (bill.getString("billstatus").equals(BillStatus.D.toString())) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            view.setVisible(Boolean.FALSE, new String[]{"bar_del"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"real_card")) {
            DynamicObject realCard = (DynamicObject)e.getChangeSet()[0].getDataEntity().get("real_card");
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (realCard != null) {
                String msg = FaUtils.checkRealCardBizStatus(Collections.singleton(realCard.getLong("id")));
                if (!msg.isEmpty()) {
                    this.getModel().setValue("store_place", null, rowIndex);
                    this.getModel().setValue("use_state", null, rowIndex);
                    this.getView().showErrorNotification(msg);
                    return;
                }
                this.getModel().setValue("store_place", realCard.getDynamicObject("storeplace").getPkValue(), rowIndex);
                this.getModel().setValue("use_state", realCard.get("usestatus"), rowIndex);
            }
        }
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
    }

    private void showApplyList(Object pk) {
        FormatObject fobj = InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId());
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(fobj);
        DynamicObject applyDObject = FaBaseDaoFactory.getInstance((String)"fa_asset_apply").queryOne(pk);
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)applyDObject.get("entryentity");
        if (entryEntity != null) {
            this.getModel().deleteEntryData("apply_entry_entity");
            this.getModel().batchCreateNewEntryRow("apply_entry_entity", entryEntity.size());
            for (int i = 0; i < entryEntity.size(); ++i) {
                this.getModel().setValue("apply_asset_name", ((DynamicObject)entryEntity.get(i)).get("asset_name"), i);
                this.getModel().setValue("apply_number", (Object)format.format(((DynamicObject)entryEntity.get(i)).getBigDecimal("number")), i);
            }
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"apply_entry_entity"});
    }

    public void beforeF7Select(BeforeF7SelectEvent arg) {
        String property_name = arg.getProperty().getName();
        if ("real_card".equals(property_name)) {
            FaQFilter.realCardQFilter(this.getModel(), arg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Long pk;
        DynamicObject reqDObject;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ((OP_SAVE.equals(operateKey) || OP_SUBMIT.equals(operateKey)) && (reqDObject = this.getView().getModel().getDataEntity()) != null && (pk = Long.valueOf(reqDObject.getLong("asset_apply_bill_id"))) != 0L) {
            this.showApplyList(pk);
        }
    }
}

