/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.homepage;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.ContextUtil;

public class AssetDataCardFormPlugin
extends AbstractFormPlugin {
    private static final String LAB_MYASSET_CNT = "lab_myasset_cnt";

    public void afterCreateNewData(EventObject e) {
        this.loadAssetData();
    }

    private void loadAssetData() {
        List<QFilter> qFilters = this.getQfilters();
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"fa_card_real", (String)"id,assetunit,storeplace,number,assetname,model,picturefield,bizstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
        LinkedList realcardIds = new LinkedList();
        Stream.of(loads).forEach(load -> realcardIds.add(load.getPkValue()));
        QFilter qCardId = new QFilter("entryentity.real_card", "in", realcardIds);
        DynamicObject[] reqs = BusinessDataServiceHelper.load((String)"fa_asset_requisition", (String)"auditdate,entryentity.real_card", (QFilter[])new QFilter[]{qCardId});
        HashMap id_auditdates = new HashMap();
        String formatStr = InteServiceHelper.getDateFormat((Long)ContextUtil.getUserId());
        SimpleDateFormat sdf = new SimpleDateFormat(formatStr);
        for (DynamicObject req : reqs) {
            DynamicObjectCollection entryentitys = req.getDynamicObjectCollection("entryentity");
            Date auditdate = req.getDate("auditdate");
            entryentitys.stream().forEach(entry -> {
                String dateString = "";
                if (auditdate != null) {
                    dateString = sdf.format(auditdate);
                }
                id_auditdates.put((Long)entry.getDynamicObject("real_card").getPkValue(), dateString);
            });
        }
        this.setMyAssetCount(loads.length);
    }

    public List<QFilter> getQfilters() {
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        qFilters.add(new QFilter("headuseperson", "=", (Object)ContextUtil.getUserId()));
        qFilters.add(new QFilter("isbak", "=", (Object)false));
        qFilters.add(new QFilter("isstoraged", "=", (Object)false));
        qFilters.add(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.toString()));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        return qFilters;
    }

    private void setMyAssetCount(int length) {
        Label label = (Label)this.getView().getControl(LAB_MYASSET_CNT);
        label.setText(String.valueOf(length));
    }
}

