/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.homepage;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.fi.fa.business.constants.FaAssetDrawback;
import kd.fi.fa.business.constants.FaAssetTranfer;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.utils.FapUtils;

public class AssetProcessInfoCardFormPlugin
extends AbstractFormPlugin {
    private static final String LAB_APPLY_CNT = "lab_apply_cnt";
    private static final String LAB_DRAWBACK_CNT = "lab_drawback_cnt";
    private static final String LAB_TRANSFER_CNT = "lab_transfer_cnt";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{LAB_APPLY_CNT, LAB_DRAWBACK_CNT, LAB_TRANSFER_CNT});
    }

    public void afterCreateNewData(EventObject e) {
        this.loadDoingData();
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        boolean index = false;
        switch (key = source.getKey()) {
            case "lab_apply_cnt": {
                this.showBillListForm(this.getView(), "fa_asset_apply");
                break;
            }
            case "lab_drawback_cnt": {
                this.showBillListForm(this.getView(), "fa_asset_drawback");
                break;
            }
            case "lab_transfer_cnt": {
                this.showBillListForm(this.getView(), "fa_asset_transfer");
                break;
            }
        }
    }

    private void loadDoingData() {
        Long userId = ContextUtil.getUserId();
        int assetApplyCount = FapUtils.findFaAssetApplyByApplyerIdAndBillStatus(userId, BillStatus.A, BillStatus.B);
        int assetTransferCount = FapUtils.findFaAssetTransferByApplyerIdAndBizStatus(userId, FaAssetTranfer.BizStatusEnum.SUBMITTED, FaAssetTranfer.BizStatusEnum.TEMPORARY);
        int assetDrawbackCount = FapUtils.findFaAssetDrawbackByApplyerIdAndBizStatus(userId, FaAssetDrawback.BizStatusEnum.SUBMITTED, FaAssetDrawback.BizStatusEnum.TEMPORARY);
        Label labelAp = (Label)this.getView().getControl(LAB_APPLY_CNT);
        labelAp.setText(String.valueOf(assetApplyCount));
        Label labelTr = (Label)this.getView().getControl(LAB_TRANSFER_CNT);
        labelTr.setText(String.valueOf(assetTransferCount));
        Label labelDb = (Label)this.getView().getControl(LAB_DRAWBACK_CNT);
        labelDb.setText(String.valueOf(assetDrawbackCount));
    }

    private void showBillListForm(IFormView view, String formId) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String[] statusList = new String[]{"A", "B"};
        parameter.getCustomParams().put("status", Arrays.asList(statusList));
        parameter.setBillFormId(formId);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

