/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.mobile;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.utils.FaAssetUnitUtils;
import kd.fi.fa.utils.FaUserUtil;

public class AssetApplyConfirmFormPlugin
extends AbstractMobFormPlugin {
    private static int arrayListSize = 10;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"b_edit", "btn_sub", "btn_add", "b_add_asset", "b_cancel", "b_submit"});
        BasedataEdit department = (BasedataEdit)this.getView().getControl("department");
        department.addBeforeF7SelectListener(event -> {
            DynamicObject user = (DynamicObject)this.getModel().getValue("applyuser");
            DynamicObjectCollection orgEntrys = user.getDynamicObjectCollection("entryentity");
            List deptList = orgEntrys.stream().map(dynamicObject -> (DynamicObject)dynamicObject.get("dpt")).collect(Collectors.toList());
            List deptIds = deptList.stream().map(dept -> (Long)dept.getPkValue()).collect(Collectors.toList());
            event.getFormShowParameter().setCustomParam("range", deptIds);
            event.getFormShowParameter().setCustomParam("mustInput", (Object)Boolean.TRUE);
        });
        department.addAfterF7SelectListener(event -> {
            Long deptId = (Long)event.getListSelectedRowCollection().get(0).getPrimaryKeyValue();
            Map depParent = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
            if (depParent == null || depParent.isEmpty()) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u516c\u53f8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u7533\u8bf7\u3002", (String)"AssetApplyConfirmFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("org", depParent.get("id"));
            Long assetOrgId = FaAssetUnitUtils.getAssetOrg(this.getView(), deptId);
            this.getModel().setValue("assetorg", (Object)assetOrgId);
        });
    }

    public void afterCreateNewData(EventObject e) {
        this.initPage();
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        switch (control.getKey()) {
            case "btn_sub": {
                int rowsub = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("number", (Object)((Integer)this.getModel().getValue("number") - 1), rowsub);
                if (!this.getModel().getValue("number").equals(0)) break;
                this.getModel().deleteEntryRow("entryentity", rowsub);
                Label label = (Label)this.getControl("entery_num");
                label.setText(String.valueOf(this.getModel().getEntryRowCount("entryentity")));
                break;
            }
            case "btn_add": {
                int rowadd = this.getModel().getEntryCurrentRowIndex("entryentity");
                this.getModel().setValue("number", (Object)((Integer)this.getModel().getValue("number") + 1), rowadd);
                break;
            }
            case "b_add_asset": {
                this.addAsset();
                break;
            }
            case "b_cancel": {
                this.getView().close();
                break;
            }
            case "b_submit": {
                if (this.getModel().getEntryRowCount("entryentity") <= 0) break;
                this.getView().close();
                break;
            }
        }
    }

    private void addAsset() {
        IDataModel model = this.getModel();
        ArrayList<Object> assetList = new ArrayList<Object>(arrayListSize);
        int row = model.getEntryRowCount("entryentity");
        assetList.add("add_asset");
        for (int i = 0; i < row; ++i) {
            assetList.add(model.getValue("asset_name", i));
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("fa_assetapply_mob");
        parameter.getOpenStyle().setShowType(ShowType.Floating);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fa_assetapply_mob"));
        parameter.setCustomParam("add_asset", assetList);
        this.getView().showForm(parameter);
    }

    private void initPage() {
        this.setUserInfo();
        this.setEntryEntity();
    }

    private void setEntryEntity() {
        List LParam = (List)this.getView().getFormShowParameter().getCustomParam("assetList");
        Label label = (Label)this.getControl("entery_num");
        System.err.println(LParam.size());
        label.setText(String.valueOf(LParam.size()));
        if (LParam != null && LParam.size() != 0) {
            this.getModel().deleteEntryRow("entryentity", 0);
            IDataModel dataModel = this.getModel();
            dataModel.batchCreateNewEntryRow("entryentity", LParam.size());
            for (int i = 0; i < LParam.size(); ++i) {
                dataModel.setValue("asset_name", LParam.get(i), i);
            }
        }
    }

    private void setUserInfo() {
        this.getModel().setValue("applyuser", (Object)ContextUtil.getUserId());
        DynamicObject user = (DynamicObject)this.getModel().getValue("applyuser");
        DynamicObject dep = FaUserUtil.getFirstDeptment(user);
        if (dep == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u4e3b\u804c\u90e8\u95e8\u3002", (String)"AssetApplyConfirmFormPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("department", (Object)dep);
        long deptId = dep.getLong("id");
        Map depParent = OrgUnitServiceHelper.getCompanyfromOrg((Long)deptId);
        if (depParent == null || depParent.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u516c\u53f8\uff0c\u65e0\u6cd5\u8fdb\u884c\u8d44\u4ea7\u7533\u8bf7\u3002", (String)"AssetApplyConfirmFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("org", depParent.get("id"));
        Long assetOrgId = FaAssetUnitUtils.getAssetOrg(this.getView(), deptId);
        if (assetOrgId != null && assetOrgId != 0L) {
            this.getModel().setValue("assetorg", (Object)assetOrgId);
        } else {
            this.getModel().setValue("assetorg", null);
        }
        Image userImage = (Image)this.getControl("user_image");
        userImage.setUrl(user.getString("picturefield"));
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Label userName = (Label)this.getControl("lab_applier");
        userName.setText(dataEntity.getDynamicObject("applyuser").getString("name"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("fa_assetapply_mob".equals(actionId)) {
            List returnData = (List)closedCallBackEvent.getReturnData();
            this.showAddAsset(returnData);
        }
    }

    private void showAddAsset(List<Object> LParam) {
        IDataModel model = this.getModel();
        if (LParam == null) {
            return;
        }
        if (!LParam.isEmpty()) {
            int row = model.getEntryRowCount("entryentity");
            for (int j = 0; j < row; ++j) {
                Iterator<Object> iterator = LParam.iterator();
                while (iterator.hasNext()) {
                    Object next = iterator.next();
                    if (!next.equals(model.getValue("asset_name", j))) continue;
                    model.setValue("number", (Object)((Integer)model.getValue("number", j) + 1), j);
                    iterator.remove();
                }
            }
            for (int i = 0; i < LParam.size(); ++i) {
                int createrow = model.createNewEntryRow("entryentity");
                model.setValue("asset_name", LParam.get(i), createrow);
            }
        }
        Label label = (Label)this.getControl("entery_num");
        label.setText(String.valueOf(model.getEntryRowCount("entryentity")));
    }
}

