/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.mobile;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.list.MobileListShowParameter;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.dao.IFaBaseDao;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.model.ReturnDataBean;
import kd.fi.fa.business.utils.FaUserUtils;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.utils.FaStorekeeperMatchUtil;
import kd.fi.fa.utils.FapUtils;

public class FaAssetDrawbackMobPlugin
extends AbstractMobFormPlugin {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject applier = dataEntity.getDynamicObject("applier");
        Object assetOrgId = this.getView().getFormShowParameter().getCustomParam("assetunit");
        DynamicObject adminOrg = FaUserUtils.getAdminOrgByUser((DynamicObject)applier);
        this.getModel().setValue("applierdept", (Object)adminOrg);
        this.getModel().setValue("assetorg", assetOrgId);
        DynamicObject storekeeper = FapUtils.checkStoreKeeper(this.getView(), Long.parseLong(assetOrgId.toString()));
        if (storekeeper == null) {
            return;
        }
        this.getModel().setValue("operator", (Object)storekeeper);
        this.getModel().setValue("signer", (Object)storekeeper);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long realCardId = (Long)formShowParameter.getCustomParam("id");
        DynamicObject realCard = FaBaseDaoFactory.getInstance((String)"fa_card_real_base").queryOne((Object)realCardId);
        if (realCard != null) {
            Long storeKeeperId = FaStorekeeperMatchUtil.getStoreKeeperId(realCard, assetOrgId.toString());
            String bizStatus = realCard.getString("bizstatus");
            if (!"READY".equalsIgnoreCase(bizStatus)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u4e0d\u662f\u5c31\u7eea\u72b6\u6001\uff0c\u65e0\u6cd5\u8fdb\u884c\u9000\u5e93\u64cd\u4f5c\u3002", (String)"FaAssetDrawbackMobPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().close();
                return;
            }
            DynamicObject storeplace = realCard.getDynamicObject("storeplace");
            this.getModel().setValue("new_storeplace", (Object)storeplace);
            int rowIndex = this.getModel().createNewEntryRow("assetdrawbackentry");
            this.getModel().setValue("storekeeper", (Object)storeKeeperId, rowIndex);
            this.getModel().setValue("realcard", (Object)realCard, rowIndex);
            this.getModel().setValue("store_place", (Object)storeplace, rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("new_storeplace".equals(e.getProperty().getName())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("assetdrawbackentry");
            ChangeData changeData = e.getChangeSet()[0];
            this.getModel().setValue("store_place", changeData.getNewValue(), rowIndex);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit storeplace = (BasedataEdit)this.getView().getControl("new_storeplace");
        storeplace.addBeforeF7SelectListener(evt -> {
            FormShowParameter showParameter = evt.getFormShowParameter();
            if (showParameter instanceof MobileListShowParameter) {
                ((MobileListShowParameter)showParameter).setMustInput(Boolean.TRUE.booleanValue());
            }
        });
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject applier = (DynamicObject)this.getModel().getValue("applier");
        if (applier != null) {
            this.getLabelByKey("lab_name").setText(applier.getString("name"));
            this.getLabelByKey("lab_telephone").setText(applier.getString("phone"));
            this.getImageByKey("img_applier").setUrl(ImageUtil.getImageTruePath((String)applier.getString("picturefield")));
        }
        BasedataEdit storeplace = (BasedataEdit)this.getView().getControl("new_storeplace");
        storeplace.setMustInput(true);
    }

    private Label getLabelByKey(String key) {
        return (Label)this.getView().getControl(key);
    }

    private Image getImageByKey(String key) {
        return (Image)this.getView().getControl(key);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && "submit".equals(key = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey())) {
            ReturnDataBean returnDataBean = new ReturnDataBean(ReturnDataBean.ActionCode.CloseAndUpdate);
            this.getView().returnDataToParent((Object)returnDataBean);
            this.getView().close();
        }
    }

    private void updateRealCardBizStatus(Object pkValue) {
        IFaBaseDao realCardDao = FaBaseDaoFactory.getInstance((String)"fa_card_real");
        DynamicObject realCard = realCardDao.queryOne(pkValue);
        realCard.set("bizstatus", (Object)BizStatusEnum.DRAWBACKING);
        realCardDao.updateOne(realCard);
    }
}

