/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.mobile;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.constants.FaAssetTranfer;
import kd.fi.fa.business.dao.IFaBillDao;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.model.ReturnDataBean;
import kd.fi.fa.business.utils.FaFormUtils;
import kd.fi.fa.common.util.ContextUtil;

public class FaAssetTransferBillMobPlugin
extends AbstractMobFormPlugin {
    private Log log = LogFactory.getLog(FaAssetTransferBillMobPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_sign"});
    }

    public void afterCreateNewData(EventObject e) {
        Object transferbillPkID = this.getView().getFormShowParameter().getCustomParam("id");
        if (transferbillPkID != null) {
            this.fillTransferBill(transferbillPkID);
            FaFormUtils.showApprovalRecordByBillPKId((IFormView)this.getView(), (String)"approvalrecordap", (String)String.valueOf(transferbillPkID), (boolean)false);
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u63a5\u6536\u5230\u7236\u9875\u9762\u4f20\u9012\u8fc7\u6765\u7684\u79fb\u4ea4\u5355\u5355\u636eid\u3002", (String)"FaAssetTransferBillMobPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private void fillTransferBill(Object transferbillPkID) {
        DynamicObject transferBill = FaBillDaoFactory.getInstance((String)"fa_asset_transfer").queryOne(transferbillPkID);
        IFaBillDao realCardDao = FaBillDaoFactory.getInstance((String)"fa_card_real");
        FaFormUtils.setModelHeadFromDO((IDataModel)this.getModel(), (DynamicObject)transferBill, Arrays.asList("receiver", "assetorg", "receiver_dpt", "billno", "applydate", "reason", "id"));
        if (transferBill.getString("bizstatus").equalsIgnoreCase(FaAssetTranfer.BizStatusEnum.SUBMITTED.getValue()) && String.valueOf(ContextUtil.getUserId()).equals(String.valueOf(transferBill.getDynamicObject("receiver").getPkValue()))) {
            this.getModel().setValue("isshowsign", (Object)"1");
        } else {
            this.getModel().setValue("isshowsign", (Object)"0");
        }
        List realCardIds = transferBill.getDynamicObjectCollection("assettransferentry").stream().map(row -> row.getDynamicObject("realcard").getPkValue()).collect(Collectors.toList());
        DynamicObject[] realCards = realCardDao.query(new QFilter("id", "in", realCardIds));
        HashMap<String, String> modelAndDOKeyMap = new HashMap<String, String>();
        modelAndDOKeyMap.put("realaccountdate", "realaccountdate");
        modelAndDOKeyMap.put("realcard", "id");
        FaFormUtils.setModelEntryFromDOs((IDataModel)this.getModel(), (DynamicObject[])realCards, (String)"assettransferentry", modelAndDOKeyMap);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Control && "btn_sign".equalsIgnoreCase(((Control)source).getKey())) {
            Object transferBillPkID = this.getModel().getValue("id");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btn_sign"});
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"sign", (String)"fa_asset_transfer", (Object[])new Object[]{transferBillPkID}, (OperateOption)OperateOption.create());
            if (operationResult.isSuccess()) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"tol_sign"});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f", (String)"FaAssetTransferBillMobPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                ReturnDataBean returnDataBean = new ReturnDataBean(ReturnDataBean.ActionCode.Close);
                this.getView().returnDataToParent((Object)returnDataBean);
                this.getView().close();
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7b7e\u6536\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaAssetTransferBillMobPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"btn_sign"});
            }
        }
    }
}

