/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.mobile;

import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractMobFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.constants.FaAssetDrawback;
import kd.fi.fa.business.constants.FaAssetTranfer;
import kd.fi.fa.business.dao.IFaBillDao;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.model.ReturnDataBean;
import kd.fi.fa.business.utils.FaFormUtils;
import kd.fi.fa.business.utils.FaMyAssetUtils;
import kd.fi.fa.common.util.ContextUtil;

public class FaMyAssetScheduleMobFormPlugin
extends AbstractMobFormPlugin
implements RowClickEventListener,
ICloseCallBack {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_sign", "btn_myasset", "transfer_entry", "req_button"});
        ((CardEntry)this.getControl("transfer_entry_applier")).addRowClickListener((RowClickEventListener)this);
        ((CardEntry)this.getControl("transfer_entry")).addRowClickListener((RowClickEventListener)this);
        ((CardEntry)this.getControl("entryentity_finished")).addRowClickListener((RowClickEventListener)this);
        ((CardEntry)this.getControl("entry_assetdrawback")).addRowClickListener((RowClickEventListener)this);
        ((CardEntry)this.getControl("entry_assetapply")).addRowClickListener((RowClickEventListener)this);
        ((CardEntry)this.getControl("req_entry")).addRowClickListener((RowClickEventListener)this);
        ((CardEntry)this.getControl("entry_assetrepair")).addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof Button) {
            Button button = (Button)source;
            switch (button.getKey()) {
                case "btn_sign": {
                    this.signAssetTransferBill();
                    break;
                }
                case "req_button": {
                    this.signReqBill();
                    break;
                }
                case "btn_myasset": {
                    this.getView().returnDataToParent((Object)new ReturnDataBean(ReturnDataBean.ActionCode.Update));
                    this.getView().close();
                    break;
                }
                case "btn_invertory": {
                    this.getView().returnDataToParent((Object)new ReturnDataBean(ReturnDataBean.ActionCode.Update));
                    this.getView().close();
                }
            }
        }
    }

    private void signAssetTransferBill() {
        int selectedIndex = this.getModel().getEntryCurrentRowIndex("transfer_entry");
        Object selectedTransferBillPkID = this.getModel().getValue("assettransferid", selectedIndex);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"sign", (String)"fa_asset_transfer", (Object[])new Object[]{selectedTransferBillPkID}, (OperateOption)OperateOption.create());
        DynamicObject assetTransferBill = FaBillDaoFactory.getInstance((String)"fa_asset_transfer").queryOne(selectedTransferBillPkID);
        if (BillStatus.C.toString().equals(assetTransferBill.getString("billstatus"))) {
            this.getModel().deleteEntryRow("transfer_entry", selectedIndex);
            this.updateInDoingBillCount();
            this.getView().updateView();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f\uff01", (String)"FaMyAssetScheduleMobFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    private void signReqBill() {
        int selectedIndex = this.getModel().getEntryCurrentRowIndex("req_entry");
        Object pk = this.getModel().getValue("reqbillpk", selectedIndex);
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"fa_asset_requisition", (Object[])new Object[]{pk}, (OperateOption)OperateOption.create());
        if (operationResult.isSuccess()) {
            this.getModel().deleteEntryRow("req_entry", selectedIndex);
            this.getView().updateView();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7b7e\u6536\u6210\u529f\uff01", (String)"FaMyAssetScheduleMobFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showOperationResult(operationResult);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.initDoingTransferBill();
        this.iniFinishedTransferBill();
        this.iniDoingDrawbackBill();
        this.initFinishedDrawbackBill();
        this.initDoingAssetApplyBill();
        this.initFinishedAssetApplyBill();
        this.initDoingReqBill();
        this.iniFinishedReqBill();
        this.updateInDoingBillCount();
        this.initDoingRepairApplyBill();
    }

    private void updateInDoingBillCount() {
        Label countLab = (Label)this.getControl("lab_indoingbills");
        int count = FaMyAssetUtils.findInDoingMyAssetBillsCountByUserId((Long)ContextUtil.getUserId());
        FaFormUtils.updateCountLable((Label)countLab, (int)count);
    }

    private void initFinishedAssetApplyBill() {
        IFaBillDao assetApplyDao = FaBillDaoFactory.getInstance((String)"fa_asset_apply");
        IDataModel model = this.getModel();
        QFilter qApplier = new QFilter("applyuser", "=", (Object)ContextUtil.getUserId());
        QFilter qBillStatus = new QFilter("billstatus", "=", (Object)BillStatus.C.toString());
        DynamicObject[] assetApplyBills = assetApplyDao.query(qBillStatus.and(qApplier));
        if (assetApplyBills != null && assetApplyBills.length > 0) {
            Arrays.sort(assetApplyBills, (a, b) -> a.getDate("apply_date").after(b.getDate("apply_date")) ? -1 : 1);
        }
        if (assetApplyBills != null && assetApplyBills.length > 0) {
            for (DynamicObject assetApply : assetApplyBills) {
                int index = model.createNewEntryRow("entryentity_finished");
                model.setValue("fld_picicon_finished", (Object)"/icons/mobile/label/label_ask_for_asset_32_32.png", index);
                model.setValue("fld_billname_finished", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u7533\u8bf7\u5355", (String)"FaMyAssetScheduleMobFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), index);
                model.setValue("fld_reason_finished", assetApply.get("apply_reason"), index);
                model.setValue("fld_billno_finished", assetApply.get("billno"), index);
                model.setValue("fld_applydate_finished", assetApply.get("apply_date"), index);
                model.setValue("fld_pkid_finished", assetApply.getPkValue(), index);
                model.setValue("fld_showformid_finished", (Object)"fa_assetapply_detail", index);
            }
        }
    }

    private void initDoingAssetApplyBill() {
        QFilter qBizStatus;
        IFaBillDao applyDao = FaBillDaoFactory.getInstance((String)"fa_asset_apply");
        IDataModel dataModel = this.getView().getModel();
        QFilter qUser = new QFilter("applyuser", "=", (Object)ContextUtil.getUserId());
        DynamicObject[] assetApplyBills = applyDao.query(qUser.and(qBizStatus = new QFilter("billstatus", "=", (Object)BillStatus.B.toString())));
        if (assetApplyBills != null && assetApplyBills.length > 0) {
            Arrays.sort(assetApplyBills, (a, b) -> a.getDate("apply_date").after(b.getDate("apply_date")) ? -1 : 1);
        }
        if (assetApplyBills != null && assetApplyBills.length > 0) {
            for (DynamicObject assetApplyBill : assetApplyBills) {
                int index = dataModel.createNewEntryRow("entry_assetapply");
                dataModel.setValue("fld_assetapplyid", assetApplyBill.getPkValue(), index);
                dataModel.setValue("fld_reason_apply", assetApplyBill.get("apply_reason"), index);
                dataModel.setValue("fld_applydate_apply", assetApplyBill.get("apply_date"), index);
                StringBuilder sBuilder = new StringBuilder();
                DynamicObjectCollection dynamicObjectCollection = assetApplyBill.getDynamicObjectCollection("entryentity");
                if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                    dynamicObjectCollection.forEach(row -> {
                        String assetName = row.getString("asset_name");
                        if (sBuilder.length() > 0) {
                            sBuilder.append(", ");
                        }
                        sBuilder.append(assetName);
                    });
                }
                dataModel.setValue("fld_assetnames_apply", (Object)sBuilder.toString(), index);
            }
        }
    }

    private void initFinishedDrawbackBill() {
        QFilter qBizStatus;
        IFaBillDao assetDrawbackDao = FaBillDaoFactory.getInstance((String)"fa_asset_drawback");
        IDataModel model = this.getModel();
        QFilter qApplier = new QFilter("applier", "=", (Object)ContextUtil.getUserId());
        DynamicObject[] assetDrawbackBills = assetDrawbackDao.query(qApplier.and(qBizStatus = new QFilter("bizstatus", "=", (Object)FaAssetDrawback.BizStatusEnum.SIGNED.getValue())));
        if (assetDrawbackBills != null && assetDrawbackBills.length > 0) {
            Arrays.sort(assetDrawbackBills, (a, b) -> a.getDate("applydate").after(b.getDate("applydate")) ? -1 : 1);
        }
        if (assetDrawbackBills != null && assetDrawbackBills.length > 0) {
            for (DynamicObject assetDrawbackBill : assetDrawbackBills) {
                int index = model.createNewEntryRow("entryentity_finished");
                model.setValue("fld_picicon_finished", (Object)"/icons/mobile/label/label_give_asset_back_32_32.png", index);
                model.setValue("fld_billname_finished", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u9000\u5e93\u5355", (String)"FaMyAssetScheduleMobFormPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), index);
                model.setValue("fld_reason_finished", assetDrawbackBill.get("reason"), index);
                model.setValue("fld_billno_finished", assetDrawbackBill.get("billno"), index);
                model.setValue("fld_applydate_finished", assetDrawbackBill.get("applydate"), index);
                model.setValue("fld_pkid_finished", assetDrawbackBill.getPkValue(), index);
                model.setValue("fld_showformid_finished", (Object)"fa_drawbackdetail_mob", index);
            }
        }
    }

    private void iniDoingDrawbackBill() {
        QFilter qBizStatus;
        IFaBillDao drawbackDao = FaBillDaoFactory.getInstance((String)"fa_asset_drawback");
        IDataModel dataModel = this.getView().getModel();
        QFilter qUser = new QFilter("applier", "=", (Object)ContextUtil.getUserId());
        DynamicObject[] assetDrawbackBills = drawbackDao.query(qUser.and(qBizStatus = new QFilter("bizstatus", "=", (Object)FaAssetDrawback.BizStatusEnum.SUBMITTED.getValue())));
        if (assetDrawbackBills != null && assetDrawbackBills.length > 0) {
            Arrays.sort(assetDrawbackBills, (a, b) -> a.getDate("applydate").after(b.getDate("applydate")) ? -1 : 1);
        }
        if (assetDrawbackBills != null && assetDrawbackBills.length > 0) {
            for (DynamicObject assetDrawback : assetDrawbackBills) {
                int index = dataModel.createNewEntryRow("entry_assetdrawback");
                dataModel.setValue("fld_assetdrawbackid", assetDrawback.getPkValue(), index);
                dataModel.setValue("fld_reason_drawback", assetDrawback.get("reason"), index);
                dataModel.setValue("fld_applydate_drawback", assetDrawback.get("applydate"), index);
                StringBuilder sBuilder = new StringBuilder();
                DynamicObjectCollection dynamicObjectCollection = assetDrawback.getDynamicObjectCollection("assetdrawbackentry");
                if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                    dynamicObjectCollection.forEach(row -> {
                        String assetName = row.getDynamicObject("realcard").getString("assetname");
                        if (sBuilder.length() > 0) {
                            sBuilder.append(", ");
                        }
                        sBuilder.append(assetName);
                    });
                }
                dataModel.setValue("fld_assetnames_drawback", (Object)sBuilder.toString(), index);
            }
        }
    }

    private void iniFinishedTransferBill() {
        IFaBillDao assetTransferDao = FaBillDaoFactory.getInstance((String)"fa_asset_transfer");
        IDataModel model = this.getModel();
        Long currentUserId = ContextUtil.getUserId();
        QFilter qSender = new QFilter("sender", "=", (Object)currentUserId);
        QFilter qReceiver = new QFilter("receiver", "=", (Object)currentUserId);
        QFilter qBizStatus = new QFilter("bizstatus", "=", (Object)FaAssetTranfer.BizStatusEnum.SIGNED.getValue());
        DynamicObject[] assetTransferBills = assetTransferDao.query(qBizStatus.and(qSender.or(qReceiver)));
        if (assetTransferBills != null && assetTransferBills.length > 0) {
            Arrays.sort(assetTransferBills, (a, b) -> a.getDate("applydate").after(b.getDate("applydate")) ? -1 : 1);
        }
        if (assetTransferBills != null && assetTransferBills.length > 0) {
            for (DynamicObject assetTransferBill : assetTransferBills) {
                int index = model.createNewEntryRow("entryentity_finished");
                model.setValue("fld_picicon_finished", (Object)"/icons/mobile/label/label_asset_transfer_32_32.png", index);
                model.setValue("fld_billname_finished", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u79fb\u4ea4\u5355", (String)"FaMyAssetScheduleMobFormPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), index);
                model.setValue("fld_reason_finished", assetTransferBill.get("reason"), index);
                model.setValue("fld_billno_finished", assetTransferBill.get("billno"), index);
                model.setValue("fld_applydate_finished", assetTransferBill.get("applydate"), index);
                model.setValue("fld_pkid_finished", assetTransferBill.getPkValue(), index);
                model.setValue("fld_showformid_finished", (Object)"fa_assettransferbill_mob", index);
            }
        }
    }

    private void initDoingTransferBill() {
        QFilter qBizStatus;
        IFaBillDao dao = FaBillDaoFactory.getInstance((String)"fa_asset_transfer");
        IDataModel dataModel = this.getView().getModel();
        QFilter qReceiver = new QFilter("receiver", "=", (Object)ContextUtil.getUserId());
        DynamicObject[] assetTransfers = dao.query(new QFilter[]{qReceiver, qBizStatus = new QFilter("bizstatus", "=", (Object)FaAssetTranfer.BizStatusEnum.SUBMITTED.getValue())});
        if (assetTransfers != null && assetTransfers.length > 0) {
            Arrays.sort(assetTransfers, (a, b) -> a.getDate("applydate").after(b.getDate("applydate")) ? -1 : 1);
        }
        this.fillValueToDataModel(dataModel, assetTransfers, "transfer_entry", "fld_reason", "fld_applydate", "assettransferid", "lab_assetnames", null, "fld_applier");
        QFilter qApplier = new QFilter("sender", "=", (Object)ContextUtil.getUserId());
        DynamicObject[] assetTransferByReceiver = dao.query(new QFilter[]{qApplier, qBizStatus});
        if (assetTransferByReceiver != null && assetTransferByReceiver.length > 0) {
            Arrays.sort(assetTransferByReceiver, (a, b) -> a.getDate("applydate").after(b.getDate("applydate")) ? -1 : 1);
        }
        this.fillValueToDataModel(dataModel, assetTransferByReceiver, "transfer_entry_applier", "fld_reason_applier", "fld_applydate_applier", "assettransferid_applier", "lab_assetnames_applier", "fld_receiver", null);
    }

    private void iniFinishedReqBill() {
        IFaBillDao dao = FaBillDaoFactory.getInstance((String)"fa_asset_requisition");
        IDataModel model = this.getModel();
        DynamicObject[] reqBills = dao.query(new QFilter[]{new QFilter("req_user", "=", (Object)ContextUtil.getUserId()), new QFilter("billstatus", "=", (Object)"C")});
        if (reqBills != null && reqBills.length > 0) {
            Arrays.sort(reqBills, (a, b) -> a.getDate("sign_date").after(b.getDate("sign_date")) ? -1 : 1);
        }
        if (reqBills != null && reqBills.length > 0) {
            for (DynamicObject reqBill : reqBills) {
                int index = model.createNewEntryRow("entryentity_finished");
                model.setValue("fld_picicon_finished", (Object)"/icons/mobile/label/label_asset_order_32_32.png", index);
                model.setValue("fld_billname_finished", (Object)ResManager.loadKDString((String)"\u8d44\u4ea7\u9886\u7528\u5355", (String)"FaMyAssetScheduleMobFormPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), index);
                model.setValue("fld_reason_finished", reqBill.get("apply_reason"), index);
                model.setValue("fld_billno_finished", reqBill.get("billno"), index);
                model.setValue("fld_applydate_finished", reqBill.get("sign_date"), index);
                model.setValue("fld_pkid_finished", reqBill.getPkValue(), index);
                model.setValue("fld_showformid_finished", (Object)"fa_asset_req_mob", index);
            }
        }
    }

    private void initDoingReqBill() {
        QFilter qBizStatus;
        IFaBillDao dao = FaBillDaoFactory.getInstance((String)"fa_asset_requisition");
        IDataModel dataModel = this.getModel();
        QFilter qApplier = new QFilter("req_user", "=", (Object)ContextUtil.getUserId());
        DynamicObject[] reqBills = dao.query(new QFilter[]{qApplier, qBizStatus = new QFilter("billstatus", "=", (Object)"B")});
        if (reqBills != null && reqBills.length > 0) {
            Arrays.sort(reqBills, (a, b) -> a.getDate("operate_date").after(b.getDate("operate_date")) ? -1 : 1);
        }
        if (reqBills != null && reqBills.length > 0) {
            Arrays.stream(reqBills).forEach(reqBill -> {
                int index = dataModel.createNewEntryRow("req_entry");
                dataModel.setValue("req_reason", (Object)reqBill.getString("apply_reason"), index);
                dataModel.setValue("req_applydate", (Object)reqBill.getDate("operate_date"), index);
                dataModel.setValue("reqbillpk", reqBill.getPkValue(), index);
                StringBuilder sBuilder = new StringBuilder();
                DynamicObjectCollection dynamicObjectCollection = reqBill.getDynamicObjectCollection("entryentity");
                if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                    dynamicObjectCollection.forEach(row -> {
                        String assetName = row.getDynamicObject("real_card").getString("assetname");
                        if (sBuilder.length() > 0) {
                            sBuilder.append(", ");
                        }
                        sBuilder.append(assetName);
                    });
                }
                dataModel.setValue("req_assetname", (Object)sBuilder.toString(), index);
            });
        }
    }

    private void fillValueToDataModel(IDataModel dataModel, DynamicObject[] assetTransfers, String entityKey, String reasonKey, String applyDateKey, String assetTransferIdKey, String assetNamesKey, String reveiverKey, String applierKey) {
        if (assetTransfers != null && assetTransfers.length > 0) {
            Arrays.stream(assetTransfers).forEach(assetTransfer -> {
                int index = dataModel.createNewEntryRow(entityKey);
                dataModel.setValue(reasonKey, (Object)assetTransfer.getString("reason"), index);
                dataModel.setValue(applyDateKey, (Object)assetTransfer.getDate("applydate"), index);
                dataModel.setValue(assetTransferIdKey, assetTransfer.getPkValue(), index);
                if (reveiverKey != null && !reasonKey.trim().equals("")) {
                    dataModel.setValue(reveiverKey, assetTransfer.getDynamicObject("receiver").getPkValue(), index);
                }
                if (applierKey != null && !applierKey.trim().equals("")) {
                    dataModel.setValue(applierKey, assetTransfer.getDynamicObject("sender").getPkValue(), index);
                }
                StringBuilder sBuilder = new StringBuilder();
                DynamicObjectCollection dynamicObjectCollection = assetTransfer.getDynamicObjectCollection("assettransferentry");
                if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                    dynamicObjectCollection.forEach(row -> {
                        String assetName = row.getDynamicObject("realcard").getString("assetname");
                        if (sBuilder.length() > 0) {
                            sBuilder.append(", ");
                        }
                        sBuilder.append(assetName);
                    });
                }
                dataModel.setValue(assetNamesKey, (Object)sBuilder.toString(), index);
            });
        }
    }

    private void initDoingRepairApplyBill() {
        IFaBillDao assetRepairDao = FaBillDaoFactory.getInstance((String)"fa_apply_repair");
        IDataModel model = this.getModel();
        QFilter qApplier = new QFilter("applier", "=", (Object)ContextUtil.getUserId());
        QFilter qBillStatus = new QFilter("billstatus", "=", (Object)BillStatus.B.toString());
        DynamicObject[] repairApplyBills = assetRepairDao.query(new QFilter[]{qBillStatus, qApplier});
        if (repairApplyBills != null && repairApplyBills.length > 0) {
            Arrays.sort(repairApplyBills, (a, b) -> a.getDate("applydate").after(b.getDate("applydate")) ? -1 : 1);
        }
        if (repairApplyBills != null && repairApplyBills.length > 0) {
            for (DynamicObject repairApply : repairApplyBills) {
                int index = model.createNewEntryRow("entry_assetrepair");
                model.setValue("fld_assetrepairid", repairApply.get("id"), index);
                model.setValue("fld_applydate_repair", repairApply.get("applydate"), index);
                model.setValue("fld_reason_repair", repairApply.get("reason"), index);
                StringBuilder sBuilder = new StringBuilder();
                DynamicObjectCollection dynamicObjectCollection = repairApply.getDynamicObjectCollection("entryentity");
                if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                    dynamicObjectCollection.forEach(row -> {
                        String assetName = row.getDynamicObject("realcard").getString("assetname");
                        if (sBuilder.length() > 0) {
                            sBuilder.append(", ");
                        }
                        sBuilder.append(assetName);
                    });
                }
                this.getModel().setValue("fld_assetnames_repair", (Object)sBuilder.toString(), index);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int selectedRowIndex = evt.getRow();
        Object source = evt.getSource();
        if (source instanceof CardEntry) {
            String entryKey;
            CardEntry cardEntry = (CardEntry)source;
            switch (entryKey = cardEntry.getEntryKey()) {
                case "transfer_entry_applier": {
                    this.showBillDetailForm(this.getView(), "fa_assettransferbill_mob", this.getModel().getValue("assettransferid_applier", selectedRowIndex));
                    break;
                }
                case "transfer_entry": {
                    this.showBillDetailForm(this.getView(), "fa_assettransferbill_mob", this.getModel().getValue("assettransferid", selectedRowIndex));
                    break;
                }
                case "entryentity_finished": {
                    this.showBillDetailForm(this.getView(), (String)this.getModel().getValue("fld_showformid_finished", selectedRowIndex), this.getModel().getValue("fld_pkid_finished", selectedRowIndex));
                    break;
                }
                case "entry_assetdrawback": {
                    this.showBillDetailForm(this.getView(), "fa_drawbackdetail_mob", this.getModel().getValue("fld_assetdrawbackid", selectedRowIndex));
                    break;
                }
                case "entry_assetapply": {
                    this.showBillDetailForm(this.getView(), "fa_assetapply_detail", this.getModel().getValue("fld_assetapplyid", selectedRowIndex));
                    break;
                }
                case "req_entry": {
                    this.showBillDetailForm(this.getView(), "fa_asset_req_mob", this.getModel().getValue("reqbillpk", selectedRowIndex));
                    break;
                }
                case "entry_assetrepair": {
                    this.showBillDetailForm(this.getView(), "fa_repairdetail_mobile", this.getModel().getValue("fld_assetrepairid", selectedRowIndex));
                    break;
                }
            }
        }
    }

    private void showBillDetailForm(IFormView thisFormView, String formId, Object billPKId) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("id", billPKId);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showformdetail"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ReturnDataBean returnDataBean;
        Object data = closedCallBackEvent.getReturnData();
        if (data instanceof ReturnDataBean && (returnDataBean = (ReturnDataBean)data).getActionCode() == ReturnDataBean.ActionCode.Close) {
            this.getView().returnDataToParent((Object)new ReturnDataBean(ReturnDataBean.ActionCode.Update));
            this.getView().close();
        }
    }
}

