/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.widget;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.utils.FapHomeUtil;

public class FaAssetCardListWidgetPlugin
extends AbstractFormPlugin {
    private static final String APPLY_ASSET = "apply_asset";
    private static final String ASSET_ID = "realcardid";
    private static final String ASSET_STATUS = "cardstatus";
    private static final String ASSET_UNIT = "assetunit";
    private static final String ASSET_STOREPLACE = "storeplace";
    private static final Set<Long> exitRepairRealIds = new HashSet<Long>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{APPLY_ASSET});
        final EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addDataBindListener(new EntryGridBindDataListener(){

            public void entryGridBindData(EntryGridBindDataEvent e) {
                super.entryGridBindData(e);
                List rows = e.getRows();
                for (RowDataEntity row : rows) {
                    ArrayList<String> opList = new ArrayList<String>(1);
                    DynamicObject entry = row.getDataEntity();
                    if (exitRepairRealIds.contains(entry.getDynamicObject(FaAssetCardListWidgetPlugin.ASSET_ID).getLong("id"))) {
                        opList.add("repair");
                        entryGrid.hideOperateItems("operationcolumnap", row.getRowIndex() - e.getStartIndex(), opList);
                    }
                    String cardstatus = entry.getString(FaAssetCardListWidgetPlugin.ASSET_STATUS);
                    if (BizStatusEnum.READY.name().equals(cardstatus)) continue;
                    opList.add("withdraw");
                    opList.add("transfer");
                    entryGrid.hideOperateItems("operationcolumnap", row.getRowIndex() - e.getStartIndex(), opList);
                }
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        String assetId = ((DynamicObject)this.getModel().getValue(ASSET_ID, index)).getString("id");
        String storePlaceId = ((DynamicObject)this.getModel().getValue(ASSET_STOREPLACE, index)).getString("id");
        if (operateKey.equals("withdraw")) {
            String status = this.getModel().getValue(ASSET_STATUS, index).toString();
            this.showBillForm(this.getView(), "fa_asset_drawback", assetId, (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), storePlaceId, status);
        } else if (operateKey.equals("transfer")) {
            String status = this.getModel().getValue(ASSET_STATUS, index).toString();
            this.showBillForm(this.getView(), "fa_asset_transfer", assetId, (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), storePlaceId, status);
        } else if (operateKey.equals("repair")) {
            this.showBillForm(this.getView(), "fa_apply_repair", assetId, (DynamicObject)this.getModel().getValue(ASSET_UNIT, index), storePlaceId, this.getModel().getValue(ASSET_STATUS, index));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (itemKey.equals("apply")) {
            this.showBillForm(this.getView(), "fa_asset_apply", null, null, null, null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] onePageEntities;
        super.afterCreateNewData(e);
        exitRepairRealIds.clear();
        FapHomeUtil.loadData(this.getModel());
        this.getView().updateView("entryentity");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        List realcardid = entryentity.stream().map(v -> v.getDynamicObject(ASSET_ID).getLong("id")).collect(Collectors.toList());
        List ids = QueryServiceHelper.query((String)"fa_apply_repair", (String)Fa.dot((String[])new String[]{"entryentity", "realcard"}), (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"entryentity", "realcard"}), "in", realcardid), new QFilter("billstatus", "=", (Object)BillStatus.B).or("billstatus", "=", (Object)BillStatus.A)}).stream().map(v -> v.getLong(Fa.dot((String[])new String[]{"entryentity", "realcard"}))).collect(Collectors.toList());
        exitRepairRealIds.addAll(ids);
        for (DynamicObject entry : onePageEntities = this.getModel().getEntryEntity("entryentity", 0, entryGrid.getPageRow())) {
            ArrayList<String> opList = new ArrayList<String>(1);
            if (exitRepairRealIds.contains(entry.getDynamicObject(ASSET_ID).getLong("id"))) {
                opList.add("repair");
                entryGrid.hideOperateItems("operationcolumnap", entryentity.indexOf((Object)entry), opList);
            }
            String cardstatus = entry.getString(ASSET_STATUS);
            if (BizStatusEnum.READY.name().equals(cardstatus)) continue;
            opList.add("withdraw");
            opList.add("transfer");
            entryGrid.hideOperateItems("operationcolumnap", entryentity.indexOf((Object)entry), opList);
        }
    }

    private void showBillForm(IFormView view, String formId, Object realcardId, DynamicObject assetunit, Object storeplaceid, Object cardstatus) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.getCustomParams().put(ASSET_ID, realcardId);
        showParameter.getCustomParams().put(ASSET_STATUS, cardstatus);
        showParameter.getCustomParams().put("assetunitid", assetunit == null ? "" : String.valueOf(assetunit.getPkValue()));
        showParameter.getCustomParams().put("storeplaceid", storeplaceid);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        view.showForm((FormShowParameter)showParameter);
    }
}

