/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.widget;

import java.util.EventObject;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.fa.business.constants.FaAssetDrawback;
import kd.fi.fa.business.constants.FaAssetTranfer;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.utils.FapUtils;

public class FaAssetFlowInfoWidgetPlugin
extends AbstractFormPlugin {
    private static final String LAB_APPLY_CNT = "lab_apply_cnt";
    private static final String LAB_DRAWBACK_CNT = "lab_drawback_cnt";
    private static final String LAB_TRANSFER_CNT = "lab_transfer_cnt";
    private static final String LAB_INVENTORY_CNT = "lab_inventory_cnt";
    private static final String LAB_REPAIRING = "lab_repairing_cnt";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadDoingData();
    }

    private void loadDoingData() {
        Long userId = ContextUtil.getUserId();
        int assetApplyCount = FapUtils.findFaAssetApplyByApplyerIdAndBillStatus(userId, BillStatus.A, BillStatus.B);
        int assetTransferCount = FapUtils.findFaAssetTransferByApplyerIdAndBizStatus(userId, FaAssetTranfer.BizStatusEnum.SUBMITTED, FaAssetTranfer.BizStatusEnum.TEMPORARY);
        int assetDrawbackCount = FapUtils.findFaAssetDrawbackByApplyerIdAndBizStatus(userId, FaAssetDrawback.BizStatusEnum.SUBMITTED, FaAssetDrawback.BizStatusEnum.TEMPORARY);
        int assetInventoryCount = FapUtils.getInventoryCount(userId);
        int assetRepairingCount = FapUtils.countFaAssetRepairingByApplyerIdAndBizStatus(userId);
        Label labelAp = (Label)this.getView().getControl(LAB_APPLY_CNT);
        labelAp.setText(String.valueOf(assetApplyCount));
        Label labelTr = (Label)this.getView().getControl(LAB_TRANSFER_CNT);
        labelTr.setText(String.valueOf(assetTransferCount));
        Label labelDb = (Label)this.getView().getControl(LAB_DRAWBACK_CNT);
        labelDb.setText(String.valueOf(assetDrawbackCount));
        Label labelIt = (Label)this.getView().getControl(LAB_INVENTORY_CNT);
        labelIt.setText(String.valueOf(assetInventoryCount));
        Label labelRpairing = (Label)this.getView().getControl(LAB_REPAIRING);
        labelRpairing.setText(String.valueOf(assetRepairingCount));
    }
}

