/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.myasset.widget;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.ContextUtil;

public class FaMyAssetCountWidgetPlugin
extends AbstractFormPlugin {
    private static final String LAB_MYASSET_CNT = "lab_myasset_cnt";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadAssetData();
    }

    private void loadAssetData() {
        List<QFilter> qFilters = this.getQfilters();
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"fa_card_real", (String)"id,assetunit,storeplace,number,assetname,model,picturefield,bizstatus", (QFilter[])qFilters.toArray(new QFilter[0]));
        LinkedList realcardIds = new LinkedList();
        Stream.of(loads).forEach(load -> realcardIds.add(load.getPkValue()));
        this.setMyAssetCount(loads.length);
    }

    private List<QFilter> getQfilters() {
        LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
        qFilters.add(new QFilter("headuseperson", "=", (Object)ContextUtil.getUserId()));
        qFilters.add(new QFilter("isbak", "=", (Object)false));
        qFilters.add(new QFilter("isstoraged", "=", (Object)false));
        qFilters.add(new QFilter("bizstatus", "!=", (Object)BizStatusEnum.DELETE.toString()));
        qFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        return qFilters;
    }

    private void setMyAssetCount(int length) {
        Label label = (Label)this.getView().getControl(LAB_MYASSET_CNT);
        label.setText(String.valueOf(length));
    }
}

