/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.params;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.fa.business.billmapping.PageShowHelper;
import kd.fi.fa.business.strategy.FilterStrategy;
import kd.fi.fa.business.strategy.IColsSelectStrategy;
import kd.fi.fa.business.strategy.TypeSelectStategy;
import kd.fi.fa.business.utils.BillFieldMappingBlackListUtils;

public class FaBillFieldMappingFormPlugin
extends AbstractFormPlugin {
    private static final String TARGET_OBJ_COL_CB = "targetObjColCB";
    private static final String SOURCE_BILL_COL_CB = "sourceBillColCB";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"targetobjcolno", "sourcebillcolno", "buttonap"});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "targetobjcolno": {
                this.clickTargetObjCol(evt);
                break;
            }
            case "sourcebillcolno": {
                this.clickSourceBillCol(evt);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "targetObjColCB": {
                this.targetObjColCloseCallBack(e);
                break;
            }
            case "sourceBillColCB": {
                this.sourceBillColCloseCallBack(e);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("colsmap");
        Boolean isSysInit = (Boolean)model.getValue("issysinite", index);
        if (isSysInit.booleanValue()) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e\u6570\u636e\u65e0\u6cd5\u5220\u9664\u3002", (String)"FaBillFieldMappingFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void clickTargetObjCol(EventObject evt) {
        DynamicObject targetObj = (DynamicObject)this.getModel().getValue("targetobj");
        if (targetObj == null) {
            return;
        }
        String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010%s\u3011\u5b57\u6bb5\u3002", (String)"FaBillFieldMappingFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), targetObj.getString("name"));
        PageShowHelper.showColsTreePage((IFormView)this.getView(), (String)targetObj.getString("number"), (IColsSelectStrategy)this.buildTargetObjSelectStrategy(), (CloseCallBack)new CloseCallBack((IFormPlugin)this, TARGET_OBJ_COL_CB), (String)caption);
    }

    protected IColsSelectStrategy buildTargetObjSelectStrategy() {
        String targetEntityName = ((DynamicObject)this.getModel().getValue("targetobj")).getString("number");
        HashSet<String> filterFieldSet = new HashSet<String>(16);
        filterFieldSet.addAll(BillFieldMappingBlackListUtils.getBlacklist((String)targetEntityName));
        DynamicObjectCollection colsMap = this.getModel().getEntryEntity("colsmap");
        for (DynamicObject colMap : colsMap) {
            String targetObjCol = colMap.getString("targetobjcol");
            if (!StringUtils.isNotEmpty((CharSequence)targetObjCol)) continue;
            String[] splitKey = targetObjCol.split("\\.");
            if (splitKey.length > 1) {
                targetObjCol = splitKey[splitKey.length - 1];
            }
            filterFieldSet.add(targetObjCol);
        }
        return new FilterStrategy(filterFieldSet, true);
    }

    private void clickSourceBillCol(EventObject evt) {
        int index;
        IDataModel model = this.getModel();
        String selectType = (String)model.getValue("selecttype", index = model.getEntryCurrentRowIndex("colsmap"));
        if (!"0".equals(selectType)) {
            String message = ResManager.loadKDString((String)"\u53d6\u503c\u65b9\u5f0f\u975e\u6e90\u5355\u5b57\u6bb5\uff0c\u65e0\u6cd5\u9009\u62e9\u5b57\u6bb5\u540d\u79f0\u3002", (String)"FaBillFieldMappingFormPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        DynamicObject sourceBill = (DynamicObject)model.getValue("sourcebill");
        if (sourceBill == null) {
            String message = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"FaBillFieldMappingFormPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        String sourcebilltype = sourceBill.getString("number");
        DynamicObject targetObj = (DynamicObject)model.getValue("targetobj");
        String targetObjtype = targetObj.getString("number");
        String prop = (String)model.getValue("targetobjcol", index);
        if (StringUtils.isEmpty((CharSequence)prop)) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u4e1a\u52a1\u5b9e\u4f53\u540d\u79f0\u3002", (String)"FaBillFieldMappingFormPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)targetObjtype);
        String[] props = prop.split("\\.");
        if (props.length > 1) {
            prop = props[props.length - 1];
        }
        IDataEntityProperty property = dataEntityType.findProperty(prop);
        String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u3010%s\u3011\u7684\u6620\u5c04\u5b57\u6bb5\u3002", (String)"FaBillFieldMappingFormPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), property.getDisplayName().getLocaleValue());
        PageShowHelper.showColsTreePage((IFormView)this.getView(), (String)sourcebilltype, (IColsSelectStrategy)new TypeSelectStategy(property), (CloseCallBack)new CloseCallBack((IFormPlugin)this, SOURCE_BILL_COL_CB), (String)caption);
    }

    private void targetObjColCloseCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("colsmap");
        JSONArray data = this.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        model.beginInit();
        JSONObject info = data.getJSONObject(0);
        model.setValue("targetobjcol", (Object)info.getString("id"), index);
        model.setValue("targetobjcolno", (Object)info.getString("text"), index);
        model.setValue("sourcebillcol", null, index);
        model.setValue("sourcebillcolno", null, index);
        model.endInit();
        this.getView().updateView("colsmap");
    }

    private void sourceBillColCloseCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("colsmap");
        JSONArray data = this.parseReturnData(e);
        if (data == null || data.isEmpty()) {
            return;
        }
        model.beginInit();
        JSONObject info = data.getJSONObject(0);
        model.setValue("sourcebillcol", (Object)info.getString("id"), index);
        model.setValue("sourcebillcolno", (Object)info.getString("text"), index);
        model.endInit();
        this.getView().updateView("colsmap");
    }

    private JSONArray parseReturnData(ClosedCallBackEvent evt) {
        Object data = evt.getReturnData();
        try {
            return JSON.parseArray((String)((String)data));
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a%1$s \u53c2\u6570\uff1a%2$s\u3002", (String)"FaBillFieldMappingFormPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), e.getMessage(), data));
        }
    }
}

