/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.params;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.billmapping.SelectParams;

public class FaColstreeSelectFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static Log logger = LogFactory.getLog(FaColstreeSelectFormPlugin.class);
    private static final String CACHE_SELECTED_NODE_IDS = "selectedNodeIds";
    private static final String BT_CANCEL = "cancel";
    private static final String BT_OK = "ok";
    private static final String C_TREE = "tree";
    private static final String C_SEARCH = "search";
    private static final String AP_FILTER = "filterap";
    private SelectParams params;

    private SelectParams getParams() {
        if (this.params == null) {
            this.params = new SelectParams();
            this.params.fillByFormShowParameter(this.getView().getFormShowParameter().getCustomParams());
        }
        return this.params;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindTree();
    }

    private void bindTree() {
        TreeNode rootNode = this.parseTree();
        TreeView tree = (TreeView)this.getView().getControl(C_TREE);
        tree.addNode(rootNode);
        boolean isMulti = this.getParams().isMulti();
        tree.setMulti(isMulti);
        this.getView().setEnable(Boolean.valueOf(!isMulti), new String[]{AP_FILTER});
        this.getView().setVisible(Boolean.valueOf(!isMulti), new String[]{AP_FILTER});
    }

    private TreeNode parseTree() {
        String treeStr = this.getParams().getJsonTree();
        if (StringUtils.isBlank((String)treeStr)) {
            return new TreeNode("", "0", ResManager.loadKDString((String)"\u6ca1\u6709\u6307\u5b9a\u5b9e\u4f53\u5bf9\u8c61\u3002", (String)"FaColstreeSelectFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        TreeNode rootNode = null;
        try {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)treeStr, TreeNode.class);
        }
        catch (Exception e) {
            rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5b57\u6bb5\u6811\u89e3\u6790\u5931\u8d25\u3002", (String)"FaColstreeSelectFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            logger.error("\u5b57\u6bb5\u6811\u89e3\u6790\u5931\u8d25:jsonTree[{}]", (Object)treeStr, (Object)e);
        }
        return rootNode;
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "ok": {
                this.clickOK(evt);
                break;
            }
            case "cancel": {
                this.clickCancel(evt);
                break;
            }
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        super.click((EventObject)evt);
        this.clickOK((EventObject)evt);
    }

    private void clickCancel(EventObject evt) {
        this.getView().close();
    }

    private void clickOK(EventObject evt) {
        List<String> ids = this.getSelectedNodeId();
        JSONArray returnInfo = this.getReturnInfo(ids);
        this.getView().returnDataToParent((Object)returnInfo.toJSONString());
        this.getView().close();
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.getParams().isMulti()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if (StringUtils.isBlank((String)currNodeId)) {
            currNodeId = "";
        }
        this.getPageCache().put(CACHE_SELECTED_NODE_IDS, currNodeId);
    }

    private List<String> getSelectedNodeId() {
        TreeView tree = (TreeView)this.getControl(C_TREE);
        TreeView.TreeState treeState = tree.getTreeState();
        if (this.getParams().isMulti()) {
            return treeState.getCheckedNodeIds();
        }
        ArrayList<String> ids = new ArrayList<String>();
        String nodeId = treeState.getFocusNodeId();
        ids.add(nodeId);
        return ids;
    }

    private JSONArray getReturnInfo(List<String> ids) {
        JSONArray infos = new JSONArray();
        if (ids == null) {
            return infos;
        }
        TreeNode tree = this.parseTree();
        TreeNode node = null;
        for (String id : ids) {
            if ("0".equals(id) || (node = tree.getTreeNode(id, 6)) == null) continue;
            JSONObject info = new JSONObject(2);
            info.put("id", (Object)node.getId());
            info.put("text", (Object)node.getText());
            infos.add((Object)info);
        }
        return infos;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BT_CANCEL, BT_OK});
        Search search = (Search)this.getControl(C_SEARCH);
        search.addEnterListener((SearchEnterListener)this);
        TreeView tree = (TreeView)this.getControl(C_TREE);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        tree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void search(SearchEnterEvent e) {
        String searchText = e.getText();
        TreeNode rootNode = this.parseTree();
        List treeNodes = new ArrayList(16);
        IPageCache pageCache = this.getPageCache();
        String pageId = this.getView().getPageId();
        String searchNodesCacheKey = pageId + "_searchNodes";
        String matchNodesCacheKey = pageId + "_matchNodes";
        String oldSearchTextCacheKey = pageId + "_oldSearchText";
        String searchIndexCacheKey = pageId + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        if (oldSearchText != null && !oldSearchText.equals(searchText) || StringUtils.isEmpty((String)matchNodesCache)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            if (StringUtils.isNotEmpty((String)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            } else if (StringUtils.isNotEmpty((String)matchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class);
            }
        }
        if (CollectionUtils.isEmpty(treeNodes)) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"FaColstreeSelectFormPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        } else {
            TreeView treeView = (TreeView)this.getView().getControl(C_TREE);
            if (StringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache < treeNodes.size()) {
                    treeView.treeNodeClick(((TreeNode)treeNodes.get(indexCache)).getParentid(), ((TreeNode)treeNodes.get(indexCache)).getId());
                    treeView.showNode(((TreeNode)treeNodes.get(indexCache)).getParentid());
                    treeView.focusNode((TreeNode)treeNodes.get(indexCache));
                    pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\u3002", (String)"FaColstreeSelectFormPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
            } else {
                treeView.treeNodeClick(((TreeNode)treeNodes.get(0)).getParentid(), ((TreeNode)treeNodes.get(0)).getId());
                treeView.showNode(((TreeNode)treeNodes.get(0)).getParentid());
                treeView.focusNode((TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
    }
}

