/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.realcard;

import java.util.List;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.util.CodeRuleInfoUtil;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.formplugin.realcard.base.CodeRulePlugin;

public abstract class BaseRealCardCodeRuleFormPlugin
extends CodeRulePlugin {
    @Override
    protected String getClassName() {
        return "fa_card_real";
    }

    @Override
    public void updateViewForBillNo(String readNumber) {
        this.getModel().setValue(this.getBillNoField(), (Object)readNumber);
    }

    @Override
    public CodeRuleInfo getCodeRuleInfo() {
        DynamicObject realCard = this.getModel().getDataEntity();
        this.setRuleField(realCard);
        this.setCodeRuleFieldsChanged();
        List allCodeRule = new CodeRuleServiceHelper().getAllCodeRuleByEntity("fa_card_real");
        if (allCodeRule == null || allCodeRule.isEmpty()) {
            return null;
        }
        Long orgId = CodeRuleInfoUtil.getUserOrgId((DynamicObject)realCard, null);
        return CodeRuleInfoUtil.getUsableCodeRuleId((List)allCodeRule, (String)"fa_card_real", (Long)orgId, (DynamicObject)realCard);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (result != null && result.isSuccess()) {
            this.setCodeRuleFieldsChanged();
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String barcode;
        String number;
        String billNo = (String)this.getModel().getValue("billno");
        if (StringUtils.isNotBlank((CharSequence)billNo)) {
            this.getModel().setValue("billnorecovery", (Object)"1");
        }
        if (StringUtils.isNotBlank((CharSequence)(number = (String)this.getModel().getValue("number")))) {
            this.getModel().setValue("numberrecovery", (Object)"1");
        }
        if (StringUtils.isNotBlank((CharSequence)(barcode = (String)this.getModel().getValue("barcode")))) {
            this.getModel().setValue("barcoderecovery", (Object)"1");
        }
    }

    protected abstract void setRuleField(DynamicObject var1);

    private void setCodeRuleFieldsChanged() {
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicProperty billNoProp = entityType.getProperty("billnocoderule");
        DynamicProperty numberProp = entityType.getProperty("numberrule");
        DynamicProperty barcodeProp = entityType.getProperty("barcoderule");
        DataEntityState entityState = this.getModel().getDataEntity().getDataEntityState();
        entityState.setBizChanged(billNoProp.getOrdinal(), false);
        entityState.setBizChanged(numberProp.getOrdinal(), false);
        entityState.setBizChanged(barcodeProp.getOrdinal(), false);
    }

    protected boolean isSplit() {
        String sourceFlag = (String)this.getModel().getValue("sourceflag");
        return SourceFlagEnum.SPLIT.name().equals(sourceFlag);
    }
}

