/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.realcard.base;

import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ConditionEntryInfo;
import kd.bos.coderule.opplugin.pagecache.BillNoChangeCache;
import kd.bos.coderule.opplugin.pagecache.CodeRuleCache;
import kd.bos.coderule.opplugin.pagecache.MainOrgCache;
import kd.bos.coderule.opplugin.pagecache.PageCreateDataCache;
import kd.bos.coderule.opplugin.pagecache.PageLoadCache;
import kd.bos.coderule.opplugin.pagecache.RecycleCache;
import kd.bos.coderule.opplugin.pagecache.UseCodeRuleCache;
import kd.bos.coderule.opplugin.util.DynamicObjUtil;
import kd.bos.coderule.opplugin.util.FormViewUtil;
import kd.bos.coderule.opplugin.util.OrgUtil;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.coderule.util.CodeRuleSystemParam;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.MainOrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.CodeRulePluginUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;

public class AbstractCodeRulePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(kd.bos.form.plugin.AbstractCodeRulePlugin.class);
    public static final String SKIPBILLNOVALIDATOR = "skipbillnovalidator";
    private static final String SKIPBILLNOVALIDATOR_VALUE = "skipbillnovalidator_value";
    private CodeRuleServiceImp codeRuleService = new CodeRuleServiceImp();
    private DynamicObject dynamicObject;
    private MainEntityType mainEntityType;
    private String billNoField;
    private boolean isSettedNumber = false;
    private BillNoChangeCache billChangeCache;
    private CodeRuleCache codeRuleCache;
    private MainOrgCache mainOrgCache;
    private PageLoadCache pageLoadCache;
    private RecycleCache recycleCache;
    private UseCodeRuleCache useCodeRuleCache;
    private PageCreateDataCache pageCreateDataCache;

    private String getEntityId() {
        return "fa_card_real";
    }

    protected String getSkipbillnovalidator() {
        return SKIPBILLNOVALIDATOR + this.getClassName();
    }

    protected String getSkipbillnovalidatorValue() {
        return SKIPBILLNOVALIDATOR_VALUE + this.getClassName();
    }

    public void initialize() {
        this.billChangeCache = new BillNoChangeCache(this.getPageCache(), this.getClassName());
        this.codeRuleCache = new CodeRuleCache(this.getPageCache(), this.getClassName());
        this.mainOrgCache = new MainOrgCache(this.getPageCache(), this.getClassName());
        this.pageLoadCache = new PageLoadCache(this.getPageCache(), this.getClassName());
        this.recycleCache = new RecycleCache(this.getPageCache(), this.getClassName());
        this.useCodeRuleCache = new UseCodeRuleCache(this.getPageCache(), this.getClassName());
        this.pageCreateDataCache = new PageCreateDataCache(this.getPageCache(), this.getClassName());
        this.loadAllCodeRuleFieldCache();
    }

    protected String getClassName() {
        return "AbstractCodeRule";
    }

    private void loadAllCodeRuleFieldCache() {
        if (this.pageLoadCache.isLoad()) {
            return;
        }
        this.pageLoadCache.load();
        List allCodeRuleByEntity = this.codeRuleService.getAllCodeRuleByEntity(this.getEntityId());
        this.codeRuleCache.saveCodeRuleNum(String.valueOf(allCodeRuleByEntity.size()));
        HashMap<String, Set> relateFields = new HashMap<String, Set>();
        for (CodeRuleInfo codeRuleInfo : allCodeRuleByEntity) {
            for (CodeRuleEntryInfo codeRuleEntry : codeRuleInfo.getRuleEntry()) {
                if (!StringUtils.isNotBlank((CharSequence)codeRuleEntry.getValueAtribute())) continue;
                relateFields.computeIfAbsent(codeRuleInfo.getId(), s -> new HashSet()).add(codeRuleEntry.getValueAtribute().split("\\.")[0]);
            }
            List conditionEntry = codeRuleInfo.getConditionEntry();
            if (conditionEntry == null || conditionEntry.size() <= 0) continue;
            for (ConditionEntryInfo entryInfo : conditionEntry) {
                String conditionPropKey = entryInfo.getProperty();
                relateFields.computeIfAbsent(codeRuleInfo.getId(), s -> new HashSet()).add(conditionPropKey);
            }
        }
        this.codeRuleCache.saveRelateFields(relateFields);
    }

    public void registerListener(EventObject e) {
        MainOrgEdit mainOrgEdit;
        super.registerListener(e);
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        String mainOrgKey = dataEntityType.getMainOrg();
        if (kd.bos.util.StringUtils.isNotEmpty((String)mainOrgKey) && (mainOrgEdit = (MainOrgEdit)this.getView().getControl(mainOrgKey)) != null) {
            mainOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object value;
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)this.getModel().getDataEntityType().getMainOrg()) && (value = this.getModel().getValue(fieldKey)) != null) {
            this.mainOrgCache.save((DynamicObject)value);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.pageCreateDataCache.save();
    }

    private void createNewNumber() {
        logger.info("[AbstractCodeRulePlugin]\u8fdb\u5165\u8868\u5355\u63d2\u4ef6\u7684\u521d\u59cb\u5316");
        this.initData();
        if (!this.validateCommon()) {
            this.injectBillnoToPageCache();
            return;
        }
        CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
        if (codeRuleInfo == null || !codeRuleInfo.getIsAddView().booleanValue()) {
            this.injectBillnoToPageCache();
            return;
        }
        this.updateBillNo(codeRuleInfo);
        this.injectBillnoToPageCache();
    }

    public void afterCopyData(EventObject e) {
        this.createNewNumber();
    }

    protected CodeRuleInfo getCodeRuleInfo() {
        CodeRuleInfo codeRuleInfo = CodeRulePluginUtil.getCodeRuleInfoByDynamicObj((DynamicObject)this.dynamicObject);
        return codeRuleInfo;
    }

    private void injectBillnoToPageCache() {
        if (StringUtils.isBlank((CharSequence)this.getBillNoField()) || this.mainEntityType.getProperty(this.getBillNoField()) == null) {
            return;
        }
        String billno = this.dynamicObject.getString(this.getBillNoField());
        if (StringUtils.isNotEmpty((CharSequence)billno)) {
            this.billChangeCache.saveValue(billno);
            return;
        }
        this.billChangeCache.saveEmpty();
    }

    private void initData() {
        try {
            this.dynamicObject = this.getModel().getDataEntity();
            this.mainEntityType = (MainEntityType)this.dynamicObject.getDataEntityType();
            this.billNoField = DynamicObjUtil.getNumField((MainEntityType)this.mainEntityType);
        }
        catch (KDException e) {
            logger.error(e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u672a\u521d\u59cb\u5316, \u8bf7\u5173\u6ce8\u9875\u9762\u6253\u5f00\u65f6\u7684\u9519\u8bef\u63d0\u793a\u4fe1\u606f, \u5e76\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"AbstractCodeRulePlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean validateCommon() {
        IBillModel billModel;
        this.codeRuleCache.isHave();
        if (StringUtils.isBlank((CharSequence)this.getBillNoField()) || this.mainEntityType.getProperty(this.getBillNoField()) == null) {
            return false;
        }
        return !(this.getModel() instanceof IBillModel) || !(billModel = (IBillModel)this.getModel()).isFromImport();
    }

    protected String getBillNoField() {
        return this.billNoField;
    }

    public void updateBillNo(CodeRuleInfo codeRuleInfo) {
        if (this.isSettedNumber) {
            return;
        }
        String readNumber = null;
        try {
            logger.info("[AbstractCodeRulePlugin]\u8c03\u7528\u670d\u52a1\u9884\u8bfb\u7f16\u53f7");
            readNumber = CodeRuleServiceHelper.readNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)this.dynamicObject);
        }
        catch (KDException e) {
            if (e.getErrorCode().equals((Object)"CodeRule_Specific_PageCacheKey_propertiesMap")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u4e0d\u5bf9,\u4e0d\u80fd\u751f\u6210\u6821\u9a8c\u7801", (String)"AbstractCodeRulePlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            }
            if ("ERRCODE_CODERULE_VALIDATE_NUMBER".equals(e.getErrorCode().getCode())) {
                this.getView().showTipNotification(e.getErrorCode().getMessage());
                return;
            }
            throw new KDException(e.getErrorCode(), new Object[0]);
        }
        this.useCodeRuleCache.tagForUseCodeRule();
        this.useCodeRuleCache.saveUsedCodeRuleId(codeRuleInfo.getId());
        this.updateViewForBillNo(readNumber);
    }

    protected void updateViewForBillNo(String readNumber) {
        if (CodeRuleSystemParam.getMcParam((String)"abstract_coderule_plugin.update_view_for_billno")) {
            this.getModel().setValue(this.getBillNoField(), (Object)readNumber);
        } else {
            this.getModel().beginInit();
            this.getModel().setValue(this.getBillNoField(), (Object)readNumber);
            this.getModel().endInit();
            this.getView().updateView(this.getBillNoField());
        }
    }

    public void afterLoadData(EventObject e) {
        this.initData();
        this.injectBillnoToPageCache();
    }

    public void afterBindData(EventObject e) {
        CodeRuleInfo codeRuleInfo;
        String newOrgObjId;
        DynamicObject org;
        String mainOrg;
        if (this.pageCreateDataCache.isCreate()) {
            logger.info("[AbstractCodeRulePlugin]\u65b0\u5efa\u6d41\u7a0b");
            boolean dataChanged = this.getModel().getDataChanged();
            this.createNewNumber();
            this.getModel().setDataChanged(dataChanged);
            this.pageCreateDataCache.clear();
        }
        boolean pushChanged = this.getModel().getDataEntity().getDataEntityState().isPushChanged();
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (pushChanged && !fromDatabase) {
            logger.info("[AbstractCodeRulePlugin]\u4e0b\u63a8\u6d41\u7a0b");
            boolean dataChanged = this.getModel().getDataChanged();
            this.createNewNumber();
            this.getModel().setDataChanged(dataChanged);
        }
        this.initData();
        if (!this.validateCommon()) {
            return;
        }
        String orgObjId = this.mainOrgCache.get();
        if (kd.bos.util.StringUtils.isNotEmpty((String)orgObjId) && kd.bos.util.StringUtils.isNotEmpty((String)(mainOrg = this.getModel().getDataEntityType().getMainOrg())) && (org = (DynamicObject)this.getModel().getValue(mainOrg)) != null && !StringUtils.equals((CharSequence)orgObjId, (CharSequence)(newOrgObjId = org.getPkValue().toString()))) {
            this.mainOrgCache.save(newOrgObjId);
            this.getView().setEnable(Boolean.TRUE, new String[]{this.getBillNoField()});
            FormViewUtil.clearEmptyTips((IFormView)this.getView(), (String)this.getBillNoField());
            FormViewUtil.clearLockEmptyTips((IFormView)this.getView(), (String)this.getBillNoField());
            this.useCodeRuleCache.tagForUnUseCodeRule();
        }
        if ((codeRuleInfo = this.getCodeRuleInfo()) != null) {
            this.getView().setEnable(codeRuleInfo.getIsModifiable(), new String[]{this.getBillNoField()});
            FormViewUtil.updateEmptyTips((IFormView)this.getView(), (String)this.getBillNoField());
            FormViewUtil.updateLockEmptyTips((IFormView)this.getView(), (String)this.getBillNoField());
            this.useCodeRuleCache.tagForUseCodeRule();
            this.useCodeRuleCache.saveUsedCodeRuleId(codeRuleInfo.getId());
            if (codeRuleInfo.isUpdateRecover() && StringUtils.isNotBlank((CharSequence)this.dynamicObject.getString(this.getBillNoField()))) {
                logger.info("[CodeRulePlugin]\u5f53\u524d\u60c5\u51b5\u4fee\u6539\u65f6\u91cd\u65b0\u7f16\u7801\u5e76\u4e14\u7f16\u7801\u4e0d\u4e3a\u7a7a ");
                this.isSettedNumber = true;
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        this.initData();
        if (!this.validateCommon() || e.getProperty().getParent() instanceof EntryProp) {
            return;
        }
        this.recordRecycleBillNo(e.getProperty().getName());
    }

    private void recordRecycleBillNo(String propertyName) {
        CodeRuleInfo codeRuleInfo;
        if (propertyName.equals(this.getBillNoField())) {
            CodeRuleInfo codeRuleInfo2 = this.getCodeRuleInfo();
            if (codeRuleInfo2 == null) {
                return;
            }
            this.recordRecycleNumber(codeRuleInfo2);
            return;
        }
        Map codeRuleFieldsMap = this.codeRuleCache.getRelateFields();
        if (CollectionUtils.isEmpty((Map)codeRuleFieldsMap)) {
            return;
        }
        Set propSetAll = codeRuleFieldsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (propSetAll.contains(propertyName)) {
            codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return;
            }
            Set propSet = (Set)codeRuleFieldsMap.get(codeRuleInfo.getId());
            if (codeRuleInfo.isUpdateRecover() && !CollectionUtils.isEmpty((Collection)propSet) && propSet.contains(propertyName)) {
                logger.info("[CodeRulePlugin]\u53d1\u73b0\u7f16\u7801\u7684\u7ec4\u6210\u5c5e\u6027\u53d1\u751f\u4e86\u53d8\u5316");
                this.recordRecycleNumber(codeRuleInfo);
                return;
            }
        }
        if (propertyName.equals(this.mainEntityType.getMainOrg()) && StringUtils.isNotBlank((CharSequence)OrgUtil.getMainOrgId((DynamicObject)this.dynamicObject, (String)this.mainEntityType.getMainOrg()))) {
            codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return;
            }
            logger.info("[CodeRulePlugin]\u53d1\u73b0\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u5c5e\u6027\u53d1\u751f\u53d8\u5316");
            this.recordRecycleNumber(codeRuleInfo);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!this.validateCommon() || e.getProperty().getParent() instanceof EntryProp) {
            return;
        }
        if (this.validateUpdateBillNo(e.getProperty().getName())) {
            CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
            if (CodeRuleSystemParam.getMcParam((String)"abstract_coderule_plugin.propertyChanged") && !this.dynamicObject.getDataEntityState().getFromDatabase() && !codeRuleInfo.getIsAddView().booleanValue()) {
                return;
            }
            boolean hasSaved = this.dynamicObject.getDataEntityState().getFromDatabase();
            if (!hasSaved || hasSaved && codeRuleInfo != null && codeRuleInfo.isUpdateRecover()) {
                this.updateBillNo(codeRuleInfo);
                this.injectBillnoToPageCache();
            }
        }
    }

    private boolean validateUpdateBillNo(String propertyName) {
        CodeRuleInfo codeRuleInfo;
        if (propertyName.equals(this.getBillNoField())) {
            return false;
        }
        Map codeRuleFieldsMap = this.codeRuleCache.getRelateFields();
        if (CollectionUtils.isEmpty((Map)codeRuleFieldsMap)) {
            return false;
        }
        Set propSetAll = codeRuleFieldsMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        if (propSetAll.contains(propertyName)) {
            codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return false;
            }
            Set propSet = (Set)codeRuleFieldsMap.get(codeRuleInfo.getId());
            if (!CollectionUtils.isEmpty((Collection)propSet) && propSet.contains(propertyName) && this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
                logger.info("[CodeRulePlugin]\u5f53\u524d\u662f\u65b0\u589e\u5355\u636e, \u53d1\u73b0\u7f16\u7801\u7684\u7ec4\u6210\u5c5e\u6027\u53d1\u751f\u4e86\u53d8\u5316");
                return true;
            }
            if (codeRuleInfo.isUpdateRecover() && !CollectionUtils.isEmpty((Collection)propSet) && propSet.contains(propertyName)) {
                logger.info("[CodeRulePlugin]\u53d1\u73b0\u7f16\u7801\u7684\u7ec4\u6210\u5c5e\u6027\u53d1\u751f\u4e86\u53d8\u5316");
                return true;
            }
        }
        if (propertyName.equals(this.mainEntityType.getMainOrg()) && StringUtils.isNotBlank((CharSequence)OrgUtil.getMainOrgId((DynamicObject)this.dynamicObject, (String)this.mainEntityType.getMainOrg()))) {
            codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return false;
            }
            logger.info("[CodeRulePlugin]\u53d1\u73b0\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u5c5e\u6027\u53d1\u751f\u53d8\u5316");
            return true;
        }
        return false;
    }

    private void recordRecycleNumber(CodeRuleInfo codeRuleInfo) {
        boolean fromDatabase = this.dynamicObject.getDataEntityState().getFromDatabase();
        if (fromDatabase && this.recycleCache.isEmpty() && StringUtils.isNotBlank((CharSequence)this.dynamicObject.getString(this.getBillNoField()))) {
            this.recycleCache.saveRecycleNumberAndDynamicObj(this.dynamicObject.getString(this.getBillNoField()), DynamicObjUtil.getSimpleDynamicObject((CodeRuleInfo)codeRuleInfo, (DynamicObject)this.dynamicObject));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!this.validateBillStateForCodeRule()) {
            args.setCancel(true);
            return;
        }
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue(this.getSkipbillnovalidator(), String.valueOf(false));
        if (this.validateOperateKey(operate.getType())) {
            logger.info("[AbstractCodeRulePlugin][beforeDoOperation]\u5f53\u524d\u64cd\u4f5c\u7c7b\u578b\u7b26\u5408\u6821\u9a8c");
            this.initData();
            this.recycleCache.convertPageCacheToOperate(operate.getOption());
            if (StringUtils.isNotEmpty((CharSequence)this.getBillNoField())) {
                this.billChangeCache.convertPageCacheToOperate(operate.getOption(), this.dynamicObject.getString(this.getBillNoField()));
            }
            if (this.useCodeRuleCache.checkUseCodceRule()) {
                logger.info("[AbstractCodeRulePlugin][beforeDoOperation]\u8868\u5355\u63d2\u4ef6\u6709\u8c03\u7528\u5230\u7f16\u7801\u89c4\u5219\u751f\u6210\u7f16\u53f7");
                if (!this.billChangeCache.isChange(operate.getOption())) {
                    logger.info("[AbstractCodeRulePlugin][beforeDoOperation]\u8868\u5355\u63d2\u4ef6\u751f\u6210\u7684\u7f16\u53f7\u7528\u6237\u672a\u4fee\u6539");
                    boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
                    if (!fromDatabase) {
                        logger.info("[AbstractCodeRulePlugin][beforeDoOperation]\u6807\u8bb0\u6807\u7b7e\u53ca\u8bbe\u7f6e\u7f16\u53f7\u7a7a\u503c");
                        this.tagForOperation(operate);
                    }
                }
            }
        }
    }

    private boolean validateBillStateForCodeRule() {
        if (!CodeRuleSystemParam.getMcParam((String)"abstract_coderule_plugin.validate_bill_state_for_coderule")) {
            return true;
        }
        this.initData();
        boolean useFlag = this.useCodeRuleCache.checkUseCodceRule();
        String usedCodeRuleId = this.useCodeRuleCache.getUsedCodeRuleId();
        if (useFlag && !this.checkUseCodeRuleCacheEnable(usedCodeRuleId) && !this.checkUseCodeRuleCacheEnable(usedCodeRuleId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u89c4\u5219\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u5bf9\u5e94\u7684\u7f16\u7801\u89c4\u5219\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractCodeRulePlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkUseCodeRuleCacheEnable(String codeRuleId) {
        String entityId = this.getEntityId();
        List enableCodeRuleInfo = this.codeRuleService.getAllCodeRuleByEntity(entityId);
        boolean isEnable = false;
        for (CodeRuleInfo codeRuleInfo : enableCodeRuleInfo) {
            if (!codeRuleId.equals(codeRuleInfo.getId())) continue;
            isEnable = true;
            break;
        }
        return isEnable;
    }

    protected void tagForOperation(FormOperate operate) {
        operate.getOption().setVariableValue(this.getSkipbillnovalidatorValue(), (String)this.getModel().getValue(this.getBillNoField()));
        operate.getOption().setVariableValue(this.getSkipbillnovalidator(), String.valueOf(true));
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().setValue(this.getBillNoField(), (Object)"");
        this.getModel().setDataChanged(dataChanged);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        if (this.validateOperateKey(formOperate.getType()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            logger.info("[AbstractCodeRulePlugin][afterDoOperation]\u79fb\u9664\u9700\u8981\u56de\u6536\u7f16\u53f7\u7684\u6807\u8bb0");
            this.recycleCache.clear();
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBillNoField())) {
            this.getView().updateView(this.getBillNoField());
        }
        FormOperate operate = (FormOperate)args.getSource();
        String skipBillnoValidator = this.getSkipbillnovalidator();
        boolean haveSkipbillnoValidator = operate.getOption().tryGetVariableValue(skipBillnoValidator, new RefObject());
        if (haveSkipbillnoValidator && operate.getOption().getVariableValue(skipBillnoValidator).equals(String.valueOf(true)) && this.getModel().getValue(this.getBillNoField()).toString().equals("")) {
            logger.info("[AbstractCodeRulePlugin][afterDoOperation]\u8fd8\u539f\u88ab\u8bbe\u7f6e\u4e3a\u7a7a\u7684\u7f16\u53f7");
            boolean dataChanged = this.getModel().getDataChanged();
            this.getModel().setValue(this.getBillNoField(), (Object)operate.getOption().getVariableValue(this.getSkipbillnovalidatorValue()));
            this.getModel().setDataChanged(dataChanged);
        }
        if (this.validateOperateKey(formOperate.getType())) {
            this.clearBillNoIfOperateError(args);
        }
    }

    protected boolean validateOperateKey(String operateKey) {
        return StringUtils.equals((CharSequence)"save", (CharSequence)operateKey) || StringUtils.equals((CharSequence)"submit", (CharSequence)operateKey);
    }

    private void clearBillNoIfOperateError(AfterDoOperationEventArgs args) {
        if (!CodeRuleSystemParam.getMcParam((String)"abstract_coderule_plugin.clear_billno_if_operate_error")) {
            return;
        }
        this.initData();
        boolean fromDatabase = this.dynamicObject.getDataEntityState().getFromDatabase();
        FormOperate formOperate = (FormOperate)args.getSource();
        boolean operateStatusFlag = this.validateOperateKey(formOperate.getType()) && args.getOperationResult() != null && !args.getOperationResult().isSuccess();
        boolean useCodceRuleFlag = this.useCodeRuleCache.checkUseCodceRule();
        if (!fromDatabase && operateStatusFlag && useCodceRuleFlag) {
            CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo();
            if (codeRuleInfo == null) {
                return;
            }
            Boolean isAddView = codeRuleInfo.getIsAddView();
            Boolean isModifiable = codeRuleInfo.getIsModifiable();
            boolean billChangeFlag = this.billChangeCache.isChange(formOperate.getOption());
            if (!isAddView.booleanValue() && !isModifiable.booleanValue()) {
                this.updateViewForBillNo("");
            }
            if (!isAddView.booleanValue() && isModifiable.booleanValue() && !billChangeFlag) {
                this.updateViewForBillNo("");
            }
        }
    }
}

