/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.formplugin.rptmediate;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.Button;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaRptMediateUpgradeUtil;

public class FaRptMediateUpgradeEditPlugin
extends AbstractFormPlugin {
    private static final String PERIOD = "period";
    private static final String ORG = "org";
    private static final String DEPREUSE = "depreuse";
    private static final String BTN_OK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit orgEdit = (MulBasedataEdit)this.getControl(ORG);
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter parameters = (ListShowParameter)evt.getFormShowParameter();
        });
        BasedataEdit depreuseEdit = (BasedataEdit)this.getControl(DEPREUSE);
        depreuseEdit.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORG);
            if (orgs.isEmpty()) {
                evt.addCustomQFilter(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            } else {
                ArrayList<Long> orgIds = new ArrayList<Long>(orgs.size());
                for (DynamicObject org : orgs) {
                    orgIds.add(org.getDynamicObject("fbasedataid").getLong("id"));
                }
                List books = FaBizUtils.getEnableAssetBooksByOrgs(orgIds);
                HashSet<Long> depreuseIds = new HashSet<Long>(books.size());
                for (DynamicObject book : books) {
                    depreuseIds.add(book.getLong(DEPREUSE));
                }
                evt.addCustomQFilter(new QFilter("id", "in", depreuseIds));
            }
        });
        BasedataEdit period = (BasedataEdit)this.getControl(PERIOD);
        period.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORG);
            DynamicObject depreuse = (DynamicObject)this.getModel().getValue(DEPREUSE);
            if (orgs != null && !orgs.isEmpty() && depreuse != null) {
                ArrayList<Long> orgIds = new ArrayList<Long>(orgs.size());
                for (DynamicObject org : orgs) {
                    orgIds.add(org.getDynamicObject("fbasedataid").getLong("id"));
                }
                List books = FaBizUtils.getEnableAssetBooksByOrgsAndDepreuse(orgIds, (Long)depreuse.getLong("id"));
                ArrayList<Long> periodTypeIds = new ArrayList<Long>(books.size());
                long minId = Long.MAX_VALUE;
                long maxId = Long.MIN_VALUE;
                for (DynamicObject book : books) {
                    minId = Long.min(book.getLong("startperiod"), minId);
                    maxId = Long.max(book.getLong("curperiod"), maxId);
                    periodTypeIds.add(book.getLong("periodtype"));
                }
                evt.addCustomQFilter(new QFilter("periodtype", "in", periodTypeIds).and("id", ">=", (Object)minId).and("id", "<=", (Object)maxId));
            } else {
                evt.addCustomQFilter(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            }
        });
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        Button source;
        super.click(evt);
        if (evt.getSource() instanceof Button && BTN_OK.equals((source = (Button)evt.getSource()).getKey())) {
            LocaleString upgradeTip = ResManager.getLocaleString((String)"\u5347\u7ea7\u4e2d", (String)"FaRptMediateUpgradeEditPlugin_0", (String)"fi-fa-formplugin");
            DynamicObject period = (DynamicObject)this.getModel().getValue(PERIOD);
            DynamicObject depreUse = (DynamicObject)this.getModel().getValue(DEPREUSE);
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue(ORG);
            ArrayList<Long> orgIds = new ArrayList<Long>(orgs.size());
            for (Object org : orgs) {
                orgIds.add(org.getDynamicObject("fbasedataid").getLong("id"));
            }
            if (period != null) {
                int count = 0;
                for (Long orgId : orgIds) {
                    if (this.existLog(orgId, depreUse.getLong("id"), period.getLong("id"))) {
                        ++count;
                        continue;
                    }
                    TXHandle tx = TX.required();
                    Throwable throwable = null;
                    try {
                        try {
                            FaRptMediateUpgradeUtil.upgradeDataByOrg((Long)period.getLong("id"), (Long)depreUse.getLong("id"), (Long)orgId);
                            this.addLog(orgId, depreUse.getLong("id"), period.getLong("id"), 1, "");
                            tx.commit();
                            ++count;
                        }
                        catch (Exception e) {
                            tx.markRollback();
                            this.addLog(orgId, depreUse.getLong("id"), period.getLong("id"), 0, e.getMessage());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                this.getModel().setValue(PERIOD, null);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u4e2a\u7ec4\u7ec7\u6240\u9009\u671f\u95f4\u6570\u636e\u5347\u7ea7\u6210\u529f\u3002", (String)"FaRptMediateUpgradeEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), count);
                this.getView().showSuccessNotification(msg);
            } else {
                String msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"FaRptMediateUpgradeEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
            }
        }
    }

    private void addLog(Long orgId, Long depreUseId, Long periodId, int status, String errMsg) {
        MainEntityType logType = EntityMetadataCache.getDataEntityType((String)"fa_upgraded_assetbook");
        DynamicObject logObj = new DynamicObject((DynamicObjectType)logType);
        logObj.set(ORG, (Object)orgId);
        logObj.set(DEPREUSE, (Object)depreUseId);
        logObj.set("purpose", (Object)("rptMediateUpgrade" + periodId));
        logObj.set("opdate", (Object)new Date());
        logObj.set("errormsg", (Object)errMsg);
        logObj.set("status", (Object)(status == 1 ? "SUCCESS" : "ERROR"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logObj});
    }

    private boolean existLog(Long orgId, Long depreUseId, Long periodId) {
        QFilter qFilter = new QFilter(ORG, "=", (Object)orgId);
        qFilter.and(DEPREUSE, "=", (Object)depreUseId);
        qFilter.and("purpose", "=", (Object)("rptMediateUpgrade" + periodId));
        qFilter.and("status", "=", (Object)"SUCCESS");
        return QueryServiceHelper.exists((String)"fa_upgraded_assetbook", (QFilter[])qFilter.toArray());
    }
}

