/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.CurrencyProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.UserEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.constants.InventoryTaskRule;
import kd.fi.fa.constants.InventoryTaskRuleRow;
import kd.fi.fa.utils.FaAssetTypeUtils;

public class FaInventoryTaskRuleSetPlugin
extends AbstractFormPlugin {
    public static final String FORMID = "fa_inventory_taskrule";
    public static final String PARAMKEY_PARAMJSON = "entryjson";
    public static final String PARAMKEY_ASSETUNIT = "assetunit";
    public static final String PARAMKEY_TASKSTATUS = "taskstatus";
    private static final String KEY_ADDROW = "addrow";
    private static final String KEY_DELETEROW = "deleterow";
    private static final String KEY_FILLROW = "fillrow";
    private static final String KEY_BTNOK = "btnok";
    private static final String KEY_BTNCANCEL = "btncancel";
    private static final String KEY_RULENAME = "rulename";
    private static final String KEY_SPLITFIELDS = "splitfields";
    private static final String KEY_TASKRULEENTITY = "taskruleentity";
    private static final String KEY_ASSETCAT = "assetcat";
    private static final String KEY_INVENTPERSON = "inventperson";
    private static final String KEY_TASKSTATUS = "taskstatus";
    private static final String KEY_TASKID = "taskid";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTNOK, KEY_BTNCANCEL});
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"taskrule"});
        BasedataEdit assettypesF7 = (BasedataEdit)this.getControl(KEY_ASSETCAT);
        UserEdit chargeperson = (UserEdit)this.getControl(KEY_INVENTPERSON);
        chargeperson.addBeforeF7SelectListener(listener -> {
            ListShowParameter showParam = (ListShowParameter)listener.getFormShowParameter();
            ListFilterParameter filterParam = showParam.getListFilterParameter();
            filterParam.getQFilters().add(new QFilter("entryentity.ispartjob", "=", (Object)Boolean.FALSE));
            showParam.setMultiSelect(false);
        });
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillBillCombo();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object entryJsonParam = formShowParameter.getCustomParam(PARAMKEY_PARAMJSON);
        if (null != entryJsonParam) {
            String entryJsonParamStr = (String)this.getView().getFormShowParameter().getCustomParam(PARAMKEY_PARAMJSON);
            InventoryTaskRule inventoryTaskRule = (InventoryTaskRule)SerializationUtils.fromJsonString((String)entryJsonParamStr, InventoryTaskRule.class);
            this.setInitData(inventoryTaskRule);
            this.setVisiable(inventoryTaskRule);
        }
        this.setEnable();
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if (entryName.equals(KEY_TASKRULEENTITY)) {
            int[] rows = e.getRowIndexs();
            if (rows == null || rows.length == 0) {
                return;
            }
            ArrayList<String> errorRows = new ArrayList<String>();
            for (int i : rows) {
                String taskStatus = this.getModel().getValue("taskstatus", i).toString();
                if ("A".equalsIgnoreCase(taskStatus) || "Z".equalsIgnoreCase(taskStatus)) continue;
                String rowNo = String.valueOf(i + 1);
                errorRows.add(rowNo);
            }
            if (errorRows.size() > 0) {
                String errorStr = String.format(ResManager.loadKDString((String)"\u884c [%s] \u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u672a\u4e0b\u8fbe\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"FaInventoryTaskRuleSetPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errorRows));
                this.getView().showErrorNotification(errorStr);
                e.setCancel(true);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String type = ((AbstractOperate)args.getSource()).getOperateKey();
        if (type.equalsIgnoreCase("batchfillentry")) {
            // empty if block
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String property = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (KEY_SPLITFIELDS.equalsIgnoreCase(property)) {
            this.changedSplitField(changeData);
        }
    }

    private void changedSplitField(ChangeData changeData) {
        String fields = (String)changeData.getNewValue();
        fields = fields == null ? "" : fields;
        fields = this.removeBlankItem(fields);
        List<String> showFields = Arrays.asList(fields.split(","));
        this.setVisiableFields(showFields);
    }

    private void setVisiableFields(List<String> showFields) {
        Map<String, LocaleString> entryCols = this.getComboMapData();
        List<String> hiddenFields = entryCols.keySet().stream().filter(key -> !showFields.contains(key)).collect(Collectors.toList());
        if (showFields.size() > 0) {
            this.setVisiable(true, showFields, this.getView());
        }
        if (hiddenFields.size() > 0) {
            this.setVisiable(false, hiddenFields, this.getView());
        }
    }

    private void setInitData(InventoryTaskRule inventoryTaskRule) {
        IDataModel model = this.getModel();
        model.setValue(KEY_RULENAME, (Object)inventoryTaskRule.getRulename());
        String splitfields = inventoryTaskRule.getSplitfields();
        if (StringUtils.isNotEmpty((String)splitfields)) {
            model.setValue(KEY_SPLITFIELDS, (Object)splitfields);
        }
        List<String> splitfieldList = Arrays.asList(splitfields.split(","));
        model.deleteEntryData(KEY_TASKRULEENTITY);
        for (InventoryTaskRuleRow row : inventoryTaskRule.getEntryRows()) {
            int rowIndex = model.createNewEntryRow(KEY_TASKRULEENTITY);
            for (String field : splitfieldList) {
                if (StringUtils.isBlank((String)field)) continue;
                Boolean isMulBaseFlag = this.isMulBasedata(field);
                if (isMulBaseFlag.booleanValue()) {
                    String mulBaseStr;
                    if (row.getSplitFieldMap() == null || row.getSplitFieldMap().get(field) == null || StringUtils.isEmpty((String)(mulBaseStr = this.removeBlankItem(row.getSplitFieldMap().get(field))))) continue;
                    Object[] assetTypeArray = Arrays.stream(mulBaseStr.split(",")).map(Long::valueOf).toArray();
                    model.setValue(field, (Object)assetTypeArray, rowIndex);
                    continue;
                }
                String str = row.getSplitFieldMap().get(field);
                if (!StringUtils.isNotEmpty((String)str)) continue;
                model.setValue(field, (Object)Long.valueOf(str), rowIndex);
            }
            model.setValue(KEY_INVENTPERSON, (Object)row.getInventperson(), rowIndex);
            String taskStatus = StringUtils.isEmpty((String)row.getTaskStatus()) ? "A" : row.getTaskStatus();
            model.setValue("taskstatus", (Object)taskStatus, rowIndex);
            model.setValue(KEY_TASKID, (Object)row.getTaskId(), rowIndex);
        }
    }

    private void setVisiable(InventoryTaskRule inventoryTaskRule) {
        IDataModel model = this.getModel();
        String fields = inventoryTaskRule.getSplitfields();
        ArrayList<String> showFields = new ArrayList<String>();
        if (!StringUtils.isBlank((String)fields)) {
            String[] fieldArr = fields.split(",");
            Map<String, LocaleString> entryCols = this.getComboMapData();
            for (String field : fieldArr) {
                if (!entryCols.containsKey(field)) continue;
                showFields.add(field);
            }
        }
        this.setVisiableFields(showFields);
    }

    private void setEnable() {
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(KEY_TASKRULEENTITY);
        IFormView view = this.getView();
        Boolean enableFlag = Boolean.TRUE;
        if (rowCount > 0) {
            List<String> entryCols = this.getEntryCols(false);
            entryCols.add(KEY_INVENTPERSON);
            for (int i = 0; i < rowCount; ++i) {
                String taskStatus = model.getValue("taskstatus", i).toString();
                Boolean assigned = !"A".equalsIgnoreCase(taskStatus) && !"Z".equalsIgnoreCase(taskStatus);
                if (assigned.booleanValue()) {
                    enableFlag = Boolean.FALSE;
                }
                for (String field : entryCols) {
                    view.setEnable(Boolean.valueOf(assigned == false), i, new String[]{field});
                }
            }
        }
        view.setEnable(enableFlag, new String[]{KEY_SPLITFIELDS});
    }

    private void setVisiable(Boolean vi, List<String> keys, IFormView view) {
        ArrayList allfieldMap = new ArrayList(keys.size());
        for (String key : keys) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            fieldMap.put("k", key);
            fieldMap.put("vi", vi);
            allfieldMap.add(fieldMap);
        }
        HashMap<String, Object> fieldMaps = new HashMap<String, Object>();
        fieldMaps.put("v", allfieldMap);
        fieldMaps.put("o", "126");
        Object[] fieldArr = new Object[]{fieldMaps};
        IClientViewProxy clientViewProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(KEY_TASKRULEENTITY, "visible", new Object[]{fieldArr});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (KEY_BTNOK.equalsIgnoreCase(ctlSource.getKey())) {
            Boolean checkResult = this.checkSetData();
            if (checkResult.booleanValue()) {
                this.setReturnData();
            }
        } else if (KEY_BTNCANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private void setReturnData() {
        IDataModel model = this.getModel();
        InventoryTaskRule taskRule = new InventoryTaskRule();
        if (null != model.getValue(KEY_RULENAME)) {
            taskRule.setRulename(model.getValue(KEY_RULENAME).toString().trim());
        }
        if (null != model.getValue(KEY_SPLITFIELDS)) {
            taskRule.setSplitfields(this.removeBlankItem(model.getValue(KEY_SPLITFIELDS).toString()));
        }
        List<String> splitfieldList = Arrays.asList(taskRule.getSplitfields().split(","));
        ArrayList<InventoryTaskRuleRow> rows = new ArrayList<InventoryTaskRuleRow>();
        int rowCount = model.getEntryRowCount(KEY_TASKRULEENTITY);
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                InventoryTaskRuleRow row = new InventoryTaskRuleRow();
                row.setSplitFieldMap(new LinkedHashMap<String, String>());
                for (String field : splitfieldList) {
                    Set<Long> pks = this.getFieldPKs(field, i);
                    Set pkStrs = pks.stream().map(pk -> pk.toString()).collect(Collectors.toSet());
                    row.getSplitFieldMap().put(field, String.join((CharSequence)",", pkStrs));
                }
                row.setInventperson(Long.valueOf(this.getModel().getValue(Fa.join((String)"_", (String[])new String[]{KEY_INVENTPERSON, "Id"}), i).toString()));
                row.setTaskStatus(this.getModel().getValue("taskstatus", i).toString());
                Object taskId = this.getModel().getValue(KEY_TASKID, i);
                if (taskId != null && !StringUtils.isEmpty((String)taskId.toString())) {
                    row.setTaskId(StringUtils.isEmpty((String)taskId.toString()) ? 0L : Long.parseLong(taskId.toString()));
                }
                rows.add(row);
            }
        }
        taskRule.setEntryRows(rows);
        String jsonStr = SerializationUtils.toJsonString((Object)taskRule);
        this.getView().returnDataToParent((Object)jsonStr);
        this.getView().close();
    }

    private Boolean checkSetData() {
        IDataModel model = this.getModel();
        model.clearNoDataRow();
        String ruleName = model.getValue(KEY_RULENAME).toString().trim();
        if (StringUtils.isEmpty((String)ruleName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaInventoryTaskRuleSetPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object splitFieldsObj = model.getValue(KEY_SPLITFIELDS);
        if (splitFieldsObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62c6\u5206\u4f9d\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaInventoryTaskRuleSetPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return false;
        }
        String splitFields = this.removeBlankItem(splitFieldsObj.toString());
        List<String> splitfieldList = Arrays.asList(splitFields.split(","));
        int rowCount = model.getEntryRowCount(KEY_TASKRULEENTITY);
        if (rowCount == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4efb\u52a1\u62c6\u5206\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaInventoryTaskRuleSetPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> unionKeys = new ArrayList<String>();
        Map<Long, List<Long>> subAssetTypeMap = FaAssetTypeUtils.getSubAssetTypeMap();
        Map<String, Set<Long>> allFieldValue = this.getAllFieldValue(splitfieldList, subAssetTypeMap);
        for (int i = 0; i < rowCount; ++i) {
            Boolean isEmptyRow = this.isEmptyRow(i, splitfieldList);
            if (isEmptyRow.booleanValue()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u62c6\u5206\u4f9d\u636e\u5b57\u6bb5\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"FaInventoryTaskRuleSetPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            List<String> curRowKVs = this.getFieldRowStr(i, splitfieldList, subAssetTypeMap, allFieldValue);
            Boolean repeatFlag = curRowKVs.stream().anyMatch(kvStr -> unionKeys.contains(kvStr));
            if (repeatFlag.booleanValue()) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u4efb\u52a1\u62c6\u5206\u5b58\u5728\u91cd\u590d\u3002", (String)"FaInventoryTaskRuleSetPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]), i + 1));
                return false;
            }
            unionKeys.addAll(curRowKVs);
            Object inventperson = this.getModel().getValue(KEY_INVENTPERSON, i);
            if (inventperson != null) continue;
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u76d8\u70b9\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaInventoryTaskRuleSetPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), i + 1));
            return false;
        }
        return true;
    }

    private Map<String, Set<Long>> getAllFieldValue(List<String> fields, Map<Long, List<Long>> subAssetTypeMap) {
        Map<String, Set<Long>> result = new HashMap<String, Set<Long>>();
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount(KEY_TASKRULEENTITY);
        for (int i = 0; i < rowCount; ++i) {
            for (String field : fields) {
                HashSet<Long> curIdSet = new HashSet<Long>();
                Set<Long> pks = this.getFieldPKs(field, i);
                curIdSet.addAll(pks);
                if (field.equalsIgnoreCase(KEY_ASSETCAT)) {
                    for (long pk : pks) {
                        List<Long> allSubAssetTypes = FaAssetTypeUtils.getAllSubAssetTypes(subAssetTypeMap, pk);
                        curIdSet.addAll(allSubAssetTypes);
                    }
                }
                result = this.putFieldValue(field, curIdSet, result);
            }
        }
        return result;
    }

    private Map<String, Set<Long>> putFieldValue(String key, Set<Long> curIds, Map<String, Set<Long>> fieldMap) {
        Map<String, Set<Long>> result = fieldMap;
        if (fieldMap.containsKey(key)) {
            fieldMap.get(key).addAll(curIds);
        } else {
            HashSet<Long> curSet = new HashSet<Long>();
            curSet.addAll(curIds);
            fieldMap.put(key, curSet);
        }
        return result;
    }

    private Set<Long> getFieldPKs(String field, int index) {
        HashSet<Long> result = new HashSet();
        Boolean mulBaseFlag = this.isMulBasedata(field);
        if (mulBaseFlag.booleanValue()) {
            result = this.getMulDyPKs(field, index);
        } else {
            Long pkId = this.getDyPK(field, index);
            if (pkId != 0L) {
                result.add(pkId);
            }
        }
        return result;
    }

    private Set<Long> getMulDyPKs(String field, int index) {
        HashSet<Long> result = new HashSet<Long>();
        DynamicObjectCollection dys = (DynamicObjectCollection)this.getModel().getValue(field, index);
        if (dys != null && dys.size() > 0) {
            for (DynamicObject dy : dys) {
                Long id = dy.getLong("fbasedataid_id");
                result.add(id);
            }
        }
        return result;
    }

    private Long getDyPK(String field, int index) {
        Object fieldDy = this.getModel().getValue(field, index);
        Long fieldValue = fieldDy == null ? 0L : ((DynamicObject)fieldDy).getLong("id");
        return fieldValue;
    }

    private List<String> getFieldRowStr(int index, List<String> fields, Map<Long, List<Long>> subAssetTypeMap, Map<String, Set<Long>> getAllFieldValue) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> tempRowStrs = new ArrayList<String>();
        for (String field : fields) {
            if (getAllFieldValue.get(field).size() == 0) continue;
            HashSet<Long> curFieldIdSet = new HashSet<Long>();
            Set<Long> pks = this.getFieldPKs(field, index);
            if (pks.size() == 0) {
                curFieldIdSet.addAll((Collection)getAllFieldValue.get(field));
            } else if (field.equalsIgnoreCase(KEY_ASSETCAT)) {
                for (long pk : pks) {
                    List<Long> allSubAssetTypes = FaAssetTypeUtils.getAllSubAssetTypes(subAssetTypeMap, pk);
                    curFieldIdSet.addAll(allSubAssetTypes);
                }
            } else {
                curFieldIdSet.addAll(pks);
            }
            if (result.size() == 0) {
                for (Long dyPK : curFieldIdSet) {
                    result.add(String.format("%s:%s", field, dyPK));
                }
                continue;
            }
            for (Long dyPK : curFieldIdSet) {
                String curPKStr = String.format("%s:%s", field, dyPK);
                for (String tempRowStr : result) {
                    tempRowStrs.add(String.format("%s,%s", tempRowStr, curPKStr));
                }
            }
            result.clear();
            result.addAll(tempRowStrs);
        }
        return result;
    }

    Boolean isEmptyRow(int index, List<String> fields) {
        Boolean result = true;
        for (String field : fields) {
            if (StringUtils.isBlank((String)field)) continue;
            Boolean isNumbaseFalg = this.isMulBasedata(field);
            if (isNumbaseFalg.booleanValue()) {
                DynamicObjectCollection assetTypes = (DynamicObjectCollection)this.getModel().getValue(field, index);
                if (assetTypes.size() <= 0) continue;
                result = false;
                break;
            }
            Object fieldDy = this.getModel().getValue(field, index);
            if (fieldDy == null) continue;
            result = false;
            break;
        }
        return result;
    }

    String removeBlankItem(String splitfields) {
        String[] fieldArr = splitfields.trim().split(",");
        ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fieldArr));
        List resultList = fieldList.stream().filter(str -> !StringUtils.isEmpty((String)str)).collect(Collectors.toList());
        return String.join((CharSequence)",", resultList);
    }

    private void fillBillCombo() {
        Map<String, LocaleString> itemDatas = this.getComboMapData();
        List<String> entryCols = this.getEntryCols(false);
        ArrayList<ComboItem> billItems = new ArrayList<ComboItem>(entryCols.size());
        for (String col : entryCols) {
            if (!itemDatas.containsKey(col)) continue;
            ComboItem billItem = new ComboItem();
            billItem.setValue(col);
            billItem.setCaption(new LocaleString(Lang.get().toString(), (Object)itemDatas.get(col)));
            billItems.add(billItem);
        }
        ComboEdit billEditor = (ComboEdit)this.getView().getControl(KEY_SPLITFIELDS);
        billEditor.setComboItems(billItems);
    }

    private List<String> getEntryCols(Boolean allFalg) {
        ArrayList<String> result = new ArrayList<String>();
        DynamicObjectType dyTypes = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_TASKRULEENTITY).getDynamicObjectType();
        List<String> noMatchFields = Arrays.asList(KEY_INVENTPERSON, "taskstatus", KEY_TASKID);
        for (IDataEntityProperty property : dyTypes.getProperties()) {
            String name = property.getName();
            if (allFalg.booleanValue()) {
                result.add(name);
                continue;
            }
            Boolean isBaseField = property instanceof MulBasedataProp || property instanceof BasedataProp;
            if (!isBaseField.booleanValue() || noMatchFields.contains(name)) continue;
            result.add(name);
        }
        return result;
    }

    private Boolean isMulBasedata(String propertyName) {
        Boolean result = true;
        DynamicObjectType dyTypes = this.getModel().getDataEntity().getDynamicObjectCollection(KEY_TASKRULEENTITY).getDynamicObjectType();
        DataEntityPropertyCollection propertys = dyTypes.getProperties();
        IDataEntityProperty property = (IDataEntityProperty)propertys.get((Object)propertyName);
        result = property instanceof MulBasedataProp;
        return result;
    }

    ArrayList<Map.Entry<String, LocaleString>> getComboData() {
        Map<String, LocaleString> comboItemMap = this.getComboMapData();
        ArrayList<Map.Entry<String, LocaleString>> result = this.sortComboMap(comboItemMap);
        return result;
    }

    private ArrayList<Map.Entry<String, LocaleString>> sortComboMap(Map<String, LocaleString> map) {
        ArrayList<Map.Entry<String, LocaleString>> entries = new ArrayList<Map.Entry<String, LocaleString>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, LocaleString>>(){

            @Override
            public int compare(Map.Entry<String, LocaleString> obj1, Map.Entry<String, LocaleString> obj2) {
                return obj1.getKey().compareTo(obj2.getKey());
            }
        });
        return entries;
    }

    private Map<String, LocaleString> getComboMapData() {
        LinkedHashMap<String, LocaleString> result = new LinkedHashMap<String, LocaleString>();
        ArrayList removeFields = new ArrayList();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
        Map fieldsMap = mainType.getFields();
        for (Map.Entry property : fieldsMap.entrySet()) {
            DynamicProperty prop = (DynamicProperty)property.getValue();
            String name = prop.getName();
            if (removeFields != null && removeFields.contains(name) || !(prop instanceof BasedataProp) && !(prop instanceof AssistantProp) && !(prop instanceof OrgProp) && !(prop instanceof MulBasedataProp) && !(prop instanceof MainOrgProp) && !(prop instanceof CreaterProp) && !(prop instanceof ModifierProp) && !(prop instanceof UserProp) && !(prop instanceof UnitProp) && !(prop instanceof CurrencyProp)) continue;
            result.put(prop.getName(), prop.getDisplayName());
        }
        return result;
    }
}

