/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.barcode;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.PrintMetadata;
import kd.bos.metadata.print.control.Barcode;
import kd.bos.metadata.print.control.BaseControl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.utils.FaUtils;

public class FaRealCardBarCodeCheckUtil {
    private static String getEncodeMode() {
        String encodeMode = null;
        Barcode control = null;
        String teplateKey = "fa_card_real_printsetting";
        String defaultTemplateId = FaUtils.getRealCardPrint((String)teplateKey);
        PrintMetadata meta = (PrintMetadata)MetadataDao.readMeta((String)defaultTemplateId, (MetaCategory)MetaCategory.Form);
        if (meta == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u7269\u5957\u6253\u6a21\u7248id\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaRealCardBarCodeCheckUtil_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        List items = meta.getItems();
        for (BaseControl item : items) {
            if (!(item instanceof Barcode)) continue;
            control = (Barcode)item;
            break;
        }
        if (control != null && StringUtils.isEmpty((CharSequence)(encodeMode = control.getEncodeMode()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u7269\u5957\u6253\u6a21\u7248\u7f16\u7801\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaRealCardBarCodeCheckUtil_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return encodeMode;
    }

    public static String checkPrint(IFormView view) {
        String error = null;
        String encodeMode = FaRealCardBarCodeCheckUtil.getEncodeMode();
        if (encodeMode == null) {
            return null;
        }
        switch (encodeMode) {
            case "ean-13": {
                Object[] key = null;
                if (view instanceof IListView) {
                    ListSelectedRowCollection rows = ((IListView)view).getSelectedRows();
                    key = rows.getPrimaryKeyValues();
                } else if (view instanceof IFormView) {
                    key = new Object[]{view.getModel().getDataEntity().getPkValue()};
                }
                DynamicObject[] realCards = BusinessDataServiceHelper.load((String)"fa_card_real", (String)"id,barcode,number,assetname", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)key)});
                error = FaRealCardBarCodeCheckUtil.innerCheckPrint(realCards);
                break;
            }
        }
        return error;
    }

    private static String innerCheckPrint(DynamicObject[] realCards) {
        String error = null;
        String regex = "^[0-9]{13}$";
        Pattern p = Pattern.compile(regex);
        for (DynamicObject realCard : realCards) {
            String barCode = realCard.getString("barcode");
            String number = realCard.getString("number");
            String assetname = realCard.getString("assetname");
            Matcher m = p.matcher(barCode);
            if (m.matches()) continue;
            error = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7f16\u7801\u4e3a%1$s\uff0c\u8d44\u4ea7\u540d\u79f0\u4e3a\uff1a%2$s\u7684\u5b9e\u7269\u5361\u7247\uff0c\u6761\u5f62\u7801\u4e0d\u7b26\u5408ean-13\u7684\u7801\u5236\uff0c\u8bf7\u8c03\u6574\u6761\u5f62\u7801\u3002", (String)"FaRealCardBarCodeCheckUtil_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), number, assetname);
            break;
        }
        return error;
    }
}

