/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.invdiffer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.OrgField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.constants.FaDynamicField;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.TypeConverUtil;
import kd.fi.fa.utils.FaInventoryUtils;

public class FaInvdifferSchemeTaskFormPlugin
extends AbstractFormPlugin {
    private static final String FA_INVDIFFER_SCHEME_TASK = "fa_invdiffer_scheme_task";
    private static final String SCHEMETASKENTRYENTITY = "schemetaskentryentity";
    private static final String BTN_CONFIRM = "btn_confirm";
    private final Map<String, Map<String, Object>> baseEntityIdMap = FaInventoryUtils.getBaseEntityIdMap();
    private final Map<String, Map<Long, String>> resultMap = new HashMap<String, Map<Long, String>>(16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObjectCollection inventoryTasks;
        if (this.getPageCache().get("inventasks") != null && (inventoryTasks = (DynamicObjectCollection)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("inventasks"))) != null) {
            this.fillList(inventoryTasks);
        }
    }

    public void fillList(DynamicObjectCollection dynamicObjects) {
        this.getModel().deleteEntryData(SCHEMETASKENTRYENTITY);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        Map<Long, Map<String, Integer>> progress = FaInventoryUtils.updateProgress(dynamicObjects);
        HashMap<String, Set<Long>> queryMap = new HashMap<String, Set<Long>>(this.baseEntityIdMap.size(), 1.0f);
        for (String s : this.baseEntityIdMap.keySet()) {
            queryMap.put(s, new HashSet());
        }
        dynamicObjects.forEach(v -> {
            Map<Object, Object> baseDataMap = new HashMap(16);
            String splitFieldValue = v.getString("splitfieldvalue");
            if (StringUtils.isNotEmpty((CharSequence)splitFieldValue)) {
                baseDataMap = FaInventoryUtils.transferSplitFieldValue(splitFieldValue);
            }
            for (Map.Entry entry : baseDataMap.entrySet()) {
                Set ids = (Set)queryMap.get(entry.getKey());
                ids.addAll((Collection)entry.getValue());
                queryMap.put((String)entry.getKey(), ids);
            }
        });
        FaInventoryUtils.setResultMapValue(queryMap, this.baseEntityIdMap, this.resultMap);
        TableValueSetter setter = new TableValueSetter(new String[]{"inventorytask", "inventscheme"});
        for (int i = 0; i < dynamicObjects.size(); ++i) {
            String splitFieldValue;
            DynamicObject dyn = (DynamicObject)dynamicObjects.get(i);
            setter.set("inventscheme", (Object)dyn.getLong("inventschemeid"), i);
            setter.set("inventorytask", (Object)dyn.getLong("id"), i);
            setter.set("assetunit", (Object)dyn.getLong(Fa.dot((String[])new String[]{"inventsscopeid", "assetunit", "id"})), i);
            if (!progress.isEmpty() && progress.get(dyn.getLong("id")) != null) {
                setter.set("inventprogress", (Object)progress.get(dyn.getLong("id")).get("inventRate"), i);
                setter.set("auditprogress", (Object)progress.get(dyn.getLong("id")).get("auditRate"), i);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(splitFieldValue = dyn.getString("splitfieldvalue")))) continue;
            Map<String, Set<Long>> map = FaInventoryUtils.transferSplitFieldValue(splitFieldValue);
            for (Map.Entry<String, Set<Long>> entry : map.entrySet()) {
                Map<Long, String> idAndNames = this.resultMap.get(entry.getKey());
                if (idAndNames.isEmpty()) continue;
                List<String> names = idAndNames.entrySet().stream().filter(v -> ((Set)entry.getValue()).contains(v.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
                setter.set(entry.getKey(), (Object)FaInventoryUtils.getAllNamesString(names), i);
            }
        }
        model.batchCreateNewEntryRow(SCHEMETASKENTRYENTITY, setter);
        model.endInit();
        this.getView().updateView(SCHEMETASKENTRYENTITY);
    }

    public void click(EventObject evt) {
        super.click(evt);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(SCHEMETASKENTRYENTITY);
        ArrayList rsList = new ArrayList();
        int[] rowKeys = grid.getEntryState().getSelectedRows();
        if (rowKeys.length > 0) {
            for (int row : rowKeys) {
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                IDataModel model = this.getModel();
                DynamicObject inventschemeDyn = (DynamicObject)model.getValue("inventscheme", row);
                paramMap.put("inventscheme", inventschemeDyn.getPkValue());
                DynamicObject inventorytaskDyn = (DynamicObject)model.getValue("inventorytask", row);
                paramMap.put("inventorytask", inventorytaskDyn.getPkValue());
                DynamicObject assetunitDyn = (DynamicObject)model.getValue("assetunit", row);
                paramMap.put("assetunit", assetunitDyn.getPkValue());
                rsList.add(paramMap);
            }
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"FaInvdifferSchemeTaskFormPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().returnDataToParent(rsList);
        this.getView().close();
    }

    private EntryAp createEntryAp() {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(SCHEMETASKENTRYENTITY);
        EntryFieldAp number = new EntryFieldAp();
        number.setId("number");
        number.setKey("number");
        number.setName(new LocaleString(ResManager.loadKDString((String)"\u7f16\u7801", (String)"FaInvdifferSchemeTaskFormPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        BasedataField taskField = new BasedataField();
        taskField.setBaseEntityNumber("fa_inventory_task");
        taskField.setViewDetail(false);
        number.setField((Field)taskField);
        entryAp.getItems().add(number);
        EntryFieldAp assetunit = new EntryFieldAp();
        assetunit.setId("assetunit");
        assetunit.setKey("assetunit");
        assetunit.setName(new LocaleString(ResManager.loadKDString((String)"\u8d44\u4ea7\u7ec4\u7ec7", (String)"FaInvdifferSchemeTaskFormPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        OrgField orgField = new OrgField();
        assetunit.setField((Field)orgField);
        entryAp.getItems().add(assetunit);
        EntryFieldAp inventperson = new EntryFieldAp();
        inventperson.setId("inventperson");
        inventperson.setKey("inventperson");
        inventperson.setName(new LocaleString(ResManager.loadKDString((String)"\u76d8\u70b9\u8d1f\u8d23\u4eba", (String)"FaInvdifferSchemeTaskFormPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        inventperson.setField((Field)taskField);
        entryAp.getItems().add(inventperson);
        EntryFieldAp status = new EntryFieldAp();
        status.setId("status");
        status.setKey("status");
        status.setName(new LocaleString(ResManager.loadKDString((String)"\u72b6\u6001", (String)"FaInvdifferSchemeTaskFormPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        status.setField((Field)taskField);
        entryAp.getItems().add(status);
        EntryFieldAp inventprogress = new EntryFieldAp();
        inventprogress.setId("inventprogress");
        inventprogress.setKey("inventprogress");
        inventprogress.setName(new LocaleString(ResManager.loadKDString((String)"\u76d8\u70b9\u8fdb\u5ea6\uff08%\uff09", (String)"FaInvdifferSchemeTaskFormPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        IntegerField integerField = new IntegerField();
        integerField.setZeroShow(true);
        inventprogress.setField((Field)integerField);
        entryAp.getItems().add(inventprogress);
        EntryFieldAp auditprogress = new EntryFieldAp();
        auditprogress.setId("auditprogress");
        auditprogress.setKey("auditprogress");
        auditprogress.setName(new LocaleString(ResManager.loadKDString((String)"\u5ba1\u6838\u8fdb\u5ea6\uff08%\uff09", (String)"FaInvdifferSchemeTaskFormPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0])));
        auditprogress.setField((Field)integerField);
        entryAp.getItems().add(auditprogress);
        return entryAp;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainEntityType = e.getOriginalEntityType();
        MainEntityType newEntityType = null;
        try {
            newEntityType = (MainEntityType)oldMainEntityType.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new KDBizException((Throwable)ex, new ErrorCode("getEntityType", ex.getMessage()), new Object[0]);
        }
        this.registerEntityType(newEntityType);
        e.setNewEntityType(newEntityType);
    }

    private void registerEntityType(MainEntityType newMainType) {
        if (this.getPageCache().get("inited") != null) {
            return;
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(SCHEMETASKENTRYENTITY);
        DynamicObjectCollection inventTasks = this.getInventTasks();
        this.getPageCache().put("inventasks", SerializationUtils.serializeToBase64((Object)inventTasks));
        Set<String> splitFields = FaInventoryUtils.getSplitFields(inventTasks);
        ArrayList<Object> list = new ArrayList<Object>(splitFields.size());
        for (String splitField : splitFields) {
            FaDynamicField field = new FaDynamicField();
            field.setEntityId(this.baseEntityIdMap.get(splitField).get("entityId").toString());
            field.setFieldKey(splitField);
            field.setFieldName(new LocaleString(this.baseEntityIdMap.get(splitField).get("displayName").toString()));
            list.add(field);
        }
        EntryAp entryAp = this.createEntryAp();
        EntryAp newAp = new EntryAp();
        newAp.setKey("newAp");
        for (FaDynamicField faDynamicField : list) {
            EntryFieldAp entryFieldAp = new EntryFieldAp();
            entryFieldAp.setKey(faDynamicField.getFieldKey());
            entryFieldAp.setName(faDynamicField.getFieldName());
            TextField textField = new TextField();
            textField.setFieldName(faDynamicField.getFieldKey());
            entryFieldAp.setField((Field)textField);
            entryAp.getItems().add(entryFieldAp);
            newAp.getItems().add(entryFieldAp);
            TextProp textProp = new TextProp();
            textProp.setName(faDynamicField.getFieldKey());
            entryType.registerSimpleProperty((DynamicSimpleProperty)textProp);
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(SCHEMETASKENTRYENTITY);
        List list2 = entryGrid.getItems();
        List controls = ((Container)newAp.buildRuntimeControl()).getItems();
        for (Control control : controls) {
            control.setView(this.getView());
            list2.add(control);
        }
        HashMap meta = new HashMap();
        meta.put("columns", entryAp.createControl().get("columns"));
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.preInvokeControlMethod(SCHEMETASKENTRYENTITY, "createGridColumns", new Object[]{meta});
        this.getPageCache().put("inited", "true");
    }

    private DynamicObjectCollection getInventTasks() {
        FormShowParameter param = this.getView().getFormShowParameter();
        String schemeTaskJson = (String)param.getCustomParam("jsonstringschemetaskform");
        Map schemeTask = (Map)SerializationUtils.fromJsonString((String)schemeTaskJson, HashMap.class);
        Long orgId = TypeConverUtil.ObjToLong(schemeTask.get("org"));
        Long inventschemeId = TypeConverUtil.ObjToLong(schemeTask.get("inventscheme"));
        List allToUnitOrg = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"09", (Long)orgId, (boolean)true);
        QFilter[] filters = new QFilter("assetunit", "in", (Object)allToUnitOrg).toArray();
        DynamicObjectCollection inventorySope = QueryServiceHelper.query((String)"fa_inventory_sope", (String)"id,assetunit", (QFilter[])filters);
        ArrayList fentryIds = new ArrayList();
        if (inventorySope != null) {
            inventorySope.forEach(r -> fentryIds.add(r.getLong("id")));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("inventschemeid", "=", (Object)inventschemeId));
        qFilters.add(new QFilter("inventsscopeid", "in", fentryIds));
        if (((List)schemeTask.get("inventorytask")).size() > 0) {
            List taskIds = (List)schemeTask.get("inventorytask");
            qFilters.add(new QFilter("id", "not in", (Object)taskIds.toArray()));
        }
        String selectFields = Fa.comma((String[])new String[]{"id", "inventschemeid", "splitfieldvalue", Fa.dot((String[])new String[]{"inventsscopeid", "assetunit", "id"}), "status"});
        DynamicObjectCollection inventoryTasks = QueryServiceHelper.query((String)"fa_inventory_task", (String)selectFields, (QFilter[])qFilters.toArray(new QFilter[0]));
        return inventoryTasks;
    }
}

