/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.sql.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.form.ClientMethod;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.mvc.form.MobileFormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.inventory.mobile.bean.Scheme;

public class FaInventMobUtil {
    private static String inventoryReportTable = "t_fa_inventory_record";
    private static final String FIELDS = "realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,difference,inventorystate";
    private static final String ENTRUSTFIELDS = "realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name";
    private static final String[] INVVENTORYFIFLDS = "consignor,consignee,consignor.name,consignee.name,crealcard,recordid,recordid.inventorystate,recordid.difference,cpicturefield,cassetcategory,cassetname,cmodel".split(",");
    private static final String[] CONSINORFIFLDS = "consignor,consignee,consignor.name,consignee.name".split(",");
    private static final String algoKey = "kd.fi.fa.inventory.mobile.FaInventMobUtil";

    public static Scheme getLatestSchemeId(Long userId) {
        new LinkedList();
        QFilter qFilter = new QFilter("realCard.headuseperson", "=", (Object)userId);
        DynamicObjectCollection inventorySchemes = ORM.create().query("fa_inventory_record", "id,inventschemeentry.id,inventschemeentry.name", new QFilter[]{qFilter}, "inventschemeentry.createtime desc", 1);
        if (inventorySchemes.size() > 0) {
            DynamicObject inventoryScheme = (DynamicObject)inventorySchemes.get(0);
            return new Scheme(inventoryScheme.getLong("inventschemeentry.id"), inventoryScheme.getString("inventschemeentry.name"));
        }
        return null;
    }

    public static Scheme getLatestSchemeId(String userId) {
        return FaInventMobUtil.getLatestSchemeId(Long.valueOf(userId));
    }

    public static void scanInventory(MobileFormView view, Long userId, Object recordId, String schemeId, String schemeName) {
        QFilter fuserid = new QFilter("userid", "=", (Object)userId);
        DynamicObject eg = BusinessDataServiceHelper.loadSingle((String)"fa_table_firstinvent", (String)"showeg", (QFilter[])new QFilter[]{fuserid});
        if (eg == null) {
            FaInventMobUtil.showBillForm((IFormView)view, "fa_mobile_eg", recordId, null, schemeId, schemeName, null, null);
            return;
        }
        boolean showEg = eg.getBoolean("showeg");
        if (!showEg) {
            FaInventMobUtil.showBillForm((IFormView)view, "fa_mobile_eg", recordId, null, schemeId, schemeName, null, null);
            return;
        }
        view.callClientAppMethod(ClientMethod.ScanQRCode, null);
    }

    public static void scanInventory(MobileFormView view, String userId, Object recordId, String schemeId, String schemeName) {
        FaInventMobUtil.scanInventory(view, Long.valueOf(userId), recordId, schemeId, schemeName);
    }

    public static void updateRecord(IFormView view, String barCode, String curSchemeId, String schemename2) {
        QFilter qBarCode = new QFilter("realcard.barcode", "=", (Object)barCode);
        Long user = ContextUtil.getUserId();
        QFilter qUser = new QFilter("realcard.headuseperson", "=", (Object)user);
        QFilter qscheme = new QFilter("inventschemeentry.billstate", "!=", (Object)"C");
        SqlBuilder selectCheckerSqlSb = new SqlBuilder();
        selectCheckerSqlSb.append("select fdetailid from t_fa_invent_taskrule_chk where ", new Object[0]);
        selectCheckerSqlSb.append("fbasedataid= ? ", new Object[]{user});
        DataSet InventorycheckerDs = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)selectCheckerSqlSb);
        HashSet<Long> InventorycheckerSet = new HashSet<Long>(1);
        for (Row row : InventorycheckerDs) {
            Long fdetailid = row.getLong("fdetailid");
            InventorycheckerSet.add(fdetailid);
        }
        QFilter qInventorychecker = new QFilter("inventorytask.id", "in", InventorycheckerSet);
        String selectProperties = FaInventMobUtil.getSelectField2();
        DynamicObjectCollection records = ORM.create().query("fa_inventory_record", selectProperties, new QFilter[]{qBarCode, qscheme, qUser.or(qInventorychecker)}, "inventschemeentry.createtime desc", 1);
        DynamicObject[] InventoryEntrust = FaInventMobUtil.queryInventEntrustRecord(ContextUtil.getUserId(), barCode);
        if ((records == null || records.size() == 0) && InventoryEntrust.length == 0) {
            qBarCode = new QFilter("barcode", "=", (Object)barCode);
            DynamicObject card = BusinessDataServiceHelper.loadSingle((String)"fa_card_real", (String)"headuseperson", (QFilter[])new QFilter[]{qBarCode});
            if (card == null) {
                String tip = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8be5\u8d44\u4ea7\u5728\u5f53\u524d\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"FaInventMobUtil_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), barCode);
                FaInventMobUtil.showBillForm(view, "fa_mobile_nocard", null, null, curSchemeId, schemename2, tip, null);
                return;
            }
            if (user.equals(card.getLong("headuseperson.id"))) {
                String errorTip = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8d44\u4ea7\u65e0\u9700\u76d8\u70b9\u3002", (String)"FaInventMobUtil_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), barCode);
                String detailTip = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8be5\u8d44\u4ea7\u672c\u6b21\u65e0\u9700\u76d8\u70b9\uff0c\u8bf7\u626b\u63cf\u5f85\u76d8\u8d44\u4ea7\u7684\u6761\u7801\u3002", (String)"FaInventMobUtil_2", (String)"fi-fa-formplugin", (Object[])new Object[0]), barCode);
                FaInventMobUtil.showBillForm(view, "fa_mobile_inventerror", null, card.getPkValue(), curSchemeId, schemename2, errorTip, detailTip);
                return;
            }
            String errorTip = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u975e\u672c\u4eba\u8d44\u4ea7\u3002", (String)"FaInventMobUtil_3", (String)"fi-fa-formplugin", (Object[])new Object[0]), barCode);
            String detailTip = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\uff08\u7f16\u7801\uff1a%s\uff09\u4e0d\u5728\u4f60\u540d\u4e0b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FaInventMobUtil_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), barCode);
            FaInventMobUtil.showBillForm(view, "fa_mobile_inventerror", null, card.getPkValue(), curSchemeId, schemename2, errorTip, detailTip);
            return;
        }
        DynamicObject record = new DynamicObject();
        if (InventoryEntrust.length > 0) {
            long recordId = InventoryEntrust[0].getLong("recordid.id");
            QFilter qRecord = new QFilter("id", "=", (Object)recordId);
            record = BusinessDataServiceHelper.loadSingle((String)"fa_inventory_record", (String)(selectProperties + ",inventoryuser.id"), (QFilter[])new QFilter[]{qBarCode, qRecord});
        } else if (null != records) {
            record = (DynamicObject)records.get(0);
        }
        boolean toError = FaInventMobUtil.toErrorPage(view, record, curSchemeId, schemename2, barCode);
        if (toError) {
            String recordId = String.valueOf(record.getPkValue());
            boolean status = FaInventMobUtil.updateRecordSuccess(recordId, user);
            if (status) {
                String schemeId = record.getString("inventschemeentry.id");
                String schemeName = record.getString("inventschemeentry.name");
                FaInventMobUtil.showBillForm(view, "fa_mobile_inventsuccess", recordId, null, curSchemeId, schemeName, null, null);
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6267\u884csql\uff0c\u66f4\u65b0\u6570\u636e\u5e93\u5931\u8d25\u3002", (String)"FaInventMobUtil_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
        }
    }

    private static boolean toErrorPage(IFormView view, DynamicObject record, String curSchemeId, String schemename2, String barCode) {
        String errorTip = "";
        String detailTip = "";
        String recordId = String.valueOf(record.getPkValue());
        Long userId = record.getLong("realcard.headuseperson.id");
        String schemeId = record.getString("inventschemeentry.id");
        String schemeName = record.getString("inventschemeentry.name");
        Long realcardId = record.getLong("realcard.id");
        Boolean isEntrust = Boolean.FALSE;
        QFilter qConsignor = new QFilter("consignor", "=", (Object)userId);
        QFilter qRealCard = new QFilter("realcard", "=", (Object)realcardId);
        boolean isExistConsignationRecord = QueryServiceHelper.exists((String)"fa_inventory_entrust", (QFilter[])new QFilter[]{qConsignor, qRealCard});
        String status = record.getString("inventorystate");
        int difference = record.getInt("difference");
        if ("A".equals(status)) {
            if (difference < 0) {
                return true;
            }
            errorTip = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8d44\u4ea7\u5df2\u626b\u63cf\u3002", (String)"FaInventMobUtil_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), barCode);
            detailTip = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u8be5\u8d44\u4ea7\u4f60\u5df2\u7ecf\u626b\u8fc7\u4e86\uff0c\u8bf7\u626b\u63cf\u5f85\u76d8\u8d44\u4ea7\u7684\u6761\u7801\u3002", (String)"FaInventMobUtil_7", (String)"fi-fa-formplugin", (Object[])new Object[0]), barCode);
            FaInventMobUtil.showBillForm(view, "fa_mobile_inventerror", recordId, null, schemeId, schemeName, errorTip, detailTip);
            return false;
        }
        return true;
    }

    private static boolean updateRecordSuccess(Object recordId, Long userId) {
        String sql = "update " + inventoryReportTable + " set finventorystate = 'A',finventoryway = 'A',finventoryquantity = 1,finventorytime = ?,fdifference = 1-fbookquantity,freason=' ',finventoryuser = ? where  fid = '" + recordId + "'";
        return DB.execute((DBRoute)DBRoute.of((String)"fa"), (String)sql, (Object[])new Object[]{new Date(new java.util.Date().getTime()), userId});
    }

    private static String getSelectField2() {
        StringBuilder fields = new StringBuilder();
        fields.append("realcard.number,").append("id,").append("realcard.billno,").append("realcard.id,").append("realcard.assetname,").append("realcard.picturefield,").append("realcard.model,").append("realcard.assetcat.name,").append("inventschemeentry.id,").append("inventschemeentry.name,").append("realcard.headuseperson.id,").append("difference,").append("inventorystate");
        return fields.toString();
    }

    public static void showBillForm(IFormView thisFormView, String formId, Object recordId, Object cardId, String schemeId, String schemeName, Object errorTip, Object detailTip) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("recordid", recordId);
        showParameter.setCustomParam("realcardid", cardId);
        showParameter.setCustomParam("schemeid", (Object)schemeId);
        showParameter.setCustomParam("schemename", (Object)schemeName);
        showParameter.setCustomParam("errortip", errorTip);
        showParameter.setCustomParam("detailtip", detailTip);
        if ("fa_mobile_nocard".equals(formId)) {
            showParameter.setCustomParam("labelap1", errorTip);
        }
        thisFormView.showForm((FormShowParameter)showParameter);
    }

    public static void showFaInventoryBillMobForm(IFormView view, String schemeId, String schemeName) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId("fa_mobile_inventpage");
        mobileFormShowParameter.setCustomParam("schemeid", (Object)schemeId);
        mobileFormShowParameter.setCustomParam("schemename", (Object)schemeName);
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm((FormShowParameter)mobileFormShowParameter);
    }

    public static DynamicObjectCollection queryInventRecord(List<Long> recordId) {
        QFilter qRecordId = new QFilter("id", "in", recordId);
        DynamicObjectCollection InventoryRecords = QueryServiceHelper.query((String)"fa_inventory_record", (String)"realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,difference,inventorystate,id,inventschemeentry.id,inventorytask.id", (QFilter[])new QFilter[]{qRecordId});
        return InventoryRecords;
    }

    public static DataSet queryNotCloseInventRecordByDataset(Long userId) {
        QFilter qFilter = new QFilter("realcard.headuseperson", "=", (Object)userId);
        QFilter qFilterEable = new QFilter("inventschemeentry.billstate", "!=", (Object)"C");
        DataSet InventoryRecords = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_record", (String)"realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,difference,inventorystate,id,inventschemeentry.id,inventorytask.id", (QFilter[])new QFilter[]{qFilter, qFilterEable}, (String)"inventorystate desc");
        return InventoryRecords;
    }

    public static DataSet queryNotCloseAndNotStockedInventRecord(Long userId, Boolean isneedStocked) {
        QFilter qFilter = new QFilter("realCard.headuseperson", "=", (Object)userId);
        QFilter qFilterEable = new QFilter("inventschemeentry.billstate", "!=", (Object)"C");
        if (isneedStocked.booleanValue()) {
            QFilter qNotStocked = new QFilter("inventorystate", "!=", (Object)"A");
            DataSet InventoryRecords = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_record", (String)"realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,difference,inventorystate,id,inventschemeentry.id,inventorytask.id", (QFilter[])new QFilter[]{qFilter, qFilterEable, qNotStocked}, (String)"inventorystate desc");
            return InventoryRecords;
        }
        DataSet InventoryRecords = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_record", (String)"realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,difference,inventorystate,id,inventschemeentry.id,inventorytask.id", (QFilter[])new QFilter[]{qFilter, qFilterEable}, (String)"inventorystate desc");
        return InventoryRecords;
    }

    public static DataSet queryInventEntrust(Long userId) {
        QFilter qConsignee = new QFilter("consignee", "=", (Object)userId);
        QFilter qConsignor = new QFilter("consignor", "=", (Object)userId);
        QFilter qInventschemeentry = new QFilter("inventschemeentry.billstate", "!=", (Object)"C");
        qConsignee = qConsignee.or(qConsignor);
        DataSet InventoryEntrust = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_entrust", (String)"realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,recordid,recordid.inventorystate,recordid.difference,inventschemeentry.id,consignor,consignee,consignor.name,consignee.name,realcard.id crealcard,realcard.picturefield as cpicturefield,realcard.assetcat.name as cassetcategory,realcard.assetname as cassetname,realcard.model as cmodel", (QFilter[])new QFilter[]{qConsignee, qInventschemeentry}, (String)"consignee,recordid.inventorystate desc");
        return InventoryEntrust;
    }

    public static DataSet queryInventEntrustByConsignor(Long userId) {
        QFilter qConsignor = new QFilter("consignor", "=", (Object)userId);
        QFilter qNotStocked = new QFilter("recordid.inventorystate", "!=", (Object)"A");
        QFilter qInventschemeentry = new QFilter("inventschemeentry.billstate", "!=", (Object)"C");
        DataSet InventoryEntrust = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_entrust", (String)"realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,recordid,recordid.inventorystate,recordid.difference,inventschemeentry.id,consignor,consignee,consignor.name,consignee.name", (QFilter[])new QFilter[]{qConsignor, qInventschemeentry, qNotStocked}, (String)"consignee,recordid.inventorystate desc");
        return InventoryEntrust;
    }

    public static DataSet queryInventorTaskRecord(Long userId) {
        QFilter qStatus = new QFilter("status", "=", (Object)"C");
        SqlBuilder selectCheckerSqlSb = new SqlBuilder();
        selectCheckerSqlSb.append("select fdetailid from t_fa_invent_taskrule_chk where ", new Object[0]);
        selectCheckerSqlSb.append("fbasedataid= ? ", new Object[]{userId});
        DataSet InventorycheckerDs = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)selectCheckerSqlSb);
        HashSet<Long> InventorycheckerSet = new HashSet<Long>(1);
        for (Row row : InventorycheckerDs) {
            Long fdetailid = row.getLong("fdetailid");
            InventorycheckerSet.add(fdetailid);
        }
        QFilter qInventoryTaskId = new QFilter("id", "in", InventorycheckerSet);
        QFilter qFilterEable = new QFilter("inventschemeid.billstate", "!=", (Object)"C");
        DataSet inventoryTaskDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_task", (String)"id,inventschemeid,inventorychecker", (QFilter[])new QFilter[]{qStatus, qFilterEable, qInventoryTaskId}, null);
        HashSet<Long> taskSet = new HashSet<Long>(16);
        for (Row row : inventoryTaskDs) {
            if (null == row.getLong("id")) continue;
            taskSet.add(row.getLong("id"));
        }
        QFilter qTask = new QFilter("inventorytask.id", "in", taskSet);
        DataSet recordDs = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_record", (String)"realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,difference,inventorystate,id,inventschemeentry.id,inventorytask.id", (QFilter[])new QFilter[]{qTask}, (String)"inventorystate desc");
        return recordDs;
    }

    public static DynamicObject[] queryInventEntrustRecord(Long userId, String barCode) {
        new LinkedList();
        QFilter qConsignee = new QFilter("consignee", "=", (Object)userId);
        QFilter qBarCode = new QFilter("realcard.barcode", "=", (Object)barCode);
        QFilter qscheme = new QFilter("inventschemeentry.billstate", "!=", (Object)"C");
        DynamicObject[] InventoryEntrust = BusinessDataServiceHelper.load((String)"fa_inventory_entrust", (String)"realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,consignor,consignee,recordid", (QFilter[])new QFilter[]{qConsignee, qBarCode, qscheme}, (String)"inventschemeentry.createtime desc");
        return InventoryEntrust;
    }

    public static DataSet queryMobileInventAll(Long userId, Boolean isInventEntrust, Boolean isneedStocked) {
        if (isInventEntrust.booleanValue()) {
            DataSet inventoryRecords = FaInventMobUtil.queryNotCloseInventRecordByDataset(userId);
            DataSet recordDs = FaInventMobUtil.queryInventorTaskRecord(userId);
            inventoryRecords = inventoryRecords.union(recordDs).distinct();
            DataSet inventoryEntrust = FaInventMobUtil.queryInventEntrust(userId);
            DataSet assetInventoryDs = inventoryRecords.join(inventoryEntrust, JoinType.FULL).on("id", "recordid").on("realcard.id", "realcard.id").select(inventoryRecords.getRowMeta().getFieldNames(), INVVENTORYFIFLDS).finish();
            return assetInventoryDs;
        }
        DataSet assetInventoryDs = FaInventMobUtil.queryNotCloseAndNotStockedInventRecord(userId, isneedStocked);
        DataSet recordDs = FaInventMobUtil.queryInventorTaskRecord(userId);
        assetInventoryDs = assetInventoryDs.union(recordDs).distinct();
        DataSet consignorDs = FaInventMobUtil.queryInventEntrustByConsignor(userId);
        assetInventoryDs = assetInventoryDs.join(consignorDs, JoinType.FULL).on("id", "recordid").on("realcard.id", "realcard.id").select(assetInventoryDs.getRowMeta().getFieldNames(), CONSINORFIFLDS).finish();
        return assetInventoryDs;
    }

    public static Set<Long> queryInventSchemeList(Long userId) {
        DataSet rocordList = FaInventMobUtil.queryMobileInventAll(userId, Boolean.FALSE, Boolean.FALSE);
        HashSet<Long> taskSet = new HashSet<Long>(16);
        for (Row record : rocordList) {
            taskSet.add(record.getLong("inventorytask.id"));
        }
        return taskSet;
    }
}

