/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.util.EventObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.MobileFormView;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.inventory.mobile.FaInventMobUtil;
import kd.fi.fa.inventory.mobile.FaInventoryTemplateUtil;
import kd.fi.fa.inventory.mobile.updaterecord.AbstractFaMobFormPlugin;

public class FaInventoryDetailPlugin
extends AbstractFaMobFormPlugin {
    private static Log log = LogFactory.getLog(FaInventoryDetailPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"lossasset", "scaninvent"});
    }

    public void afterCreateNewData(EventObject e) {
        MobileFormShowParameter mobileFormShowParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String schemeId = (String)mobileFormShowParameter.getCustomParam("schemeid");
        String schemeName = (String)mobileFormShowParameter.getCustomParam("schemename");
        Long realCardId = (Long)mobileFormShowParameter.getCustomParam("realCardId");
        String recordId = (String)mobileFormShowParameter.getCustomParam("recordid");
        this.getPageCache().put("schemeid", schemeId);
        this.getPageCache().put("schemename", schemeName);
        this.getPageCache().put("recordid", recordId);
        FaInventoryTemplateUtil.updateRealCardShowInfo(this.getView(), log, recordId, realCardId);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String recordId = this.getPageCache().get("recordid");
        switch (key) {
            case "lossasset": {
                this.showBillForm("fa_mobile_lossreason", recordId);
                break;
            }
            case "scaninvent": {
                MobileFormView view = (MobileFormView)this.getView();
                String schemeId = this.getPageCache().get("schemeid");
                String schemeName = this.getPageCache().get("schemename");
                FaInventMobUtil.scanInventory(view, ContextUtil.getUserId(), (Object)recordId, schemeId, schemeName);
                break;
            }
        }
    }

    private void showBillForm(String formId, Object recordId) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("recordid", recordId);
        showParameter.setCustomParam("schemeid", (Object)this.getPageCache().get("schemeid"));
        showParameter.setCustomParam("schemename", (Object)this.getPageCache().get("schemename"));
        log.info("FaInventoryDetailPlugin.showBillForm----schemeid\uff1a" + this.getPageCache().get("schemeid"));
        log.info("FaInventoryDetailPlugin.showBillForm----schemename\uff1a" + this.getPageCache().get("schemename"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showformdetail"));
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

