/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.inventory.mobile;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.fs.util.StringUtils;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractMobListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.fi.fa.business.InventMobileEnum;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.ImageUtil;
import kd.fi.fa.inventory.mobile.FaInventMobUtil;

public class FaSelectEntrustMobilePlugin
extends AbstractMobListPlugin
implements RowClickEventListener,
SelectRowsEventListener {
    private static final String FIELDS = "id,realcard.number,realcard.billno,realcard.id,realcard.assetname,realcard.picturefield,realcard.model,realcard.assetcat.name,difference,inventorystate";
    private static final String CHERKER = "realcard.headuseperson";
    private static final String INVENTORYED = "A";
    private static final String INVENTORYLOSS = "B";
    private static final String FORSORT = "forsort";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"cancle", "submit"});
        ((CardEntry)this.getControl("entryentity")).addRowClickListener((RowClickEventListener)this);
        ((CardEntry)this.getControl("entryentity")).addSelectRowsListener((SelectRowsEventListener)this);
        BasedataEdit selectMan = (BasedataEdit)this.getControl("selectman");
        selectMan.addBeforeF7SelectListener(evt -> FaSelectEntrustMobilePlugin.beforeSelectManSelect(evt, ContextUtil.getUserId()));
    }

    public void afterCreateNewData(EventObject e) {
        this.initEntryEntity();
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "submit": {
                DynamicObject[] save;
                Long userId = ContextUtil.getUserId();
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
                DynamicObject selectMan = this.getModel().getDataEntity().getDynamicObject("selectman");
                if (null == selectMan) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u53d7\u6258\u4eba\u3002", (String)"FaSelectEntrustMobilePlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                ArrayList<Long> inventoryTaskPks = new ArrayList<Long>(entryEntity.size());
                Object selectManId = selectMan.get("id");
                ArrayList<DynamicObject> saveData = new ArrayList<DynamicObject>(entryEntity.size());
                String ids = (String)this.getView().getFormShowParameter().getCustomParam("recordid");
                List recordid = SerializationUtils.fromJsonStringToList((String)ids, Long.TYPE);
                DynamicObjectCollection records = FaInventMobUtil.queryInventRecord(recordid);
                HashMap<Long, DynamicObject> recordMap = new HashMap<Long, DynamicObject>();
                for (DynamicObject dy : records) {
                    recordMap.put(dy.getLong("id"), dy);
                }
                if (entryEntity.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u65e0\u76d8\u70b9\u6570\u636e\u3002", (String)"FaSelectEntrustMobilePlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                for (DynamicObject dy : entryEntity) {
                    Object realCardId = dy.get("asset_cardid");
                    DynamicObject[] recordId = Long.valueOf(Long.parseLong(dy.getString("recordid")));
                    DynamicObject consignationRecord = BusinessDataServiceHelper.newDynamicObject((String)"fa_inventory_entrust");
                    consignationRecord.set("realcard", realCardId);
                    consignationRecord.set("consignor", (Object)userId);
                    consignationRecord.set("consignee", selectManId);
                    consignationRecord.set("recordid", (Object)recordId);
                    saveData.add(consignationRecord);
                    Long inventschemeentry = 0L;
                    Long taskId = 0L;
                    if (recordMap.containsKey(recordId)) {
                        inventschemeentry = ((DynamicObject)recordMap.get(recordId)).getLong("inventschemeentry.id");
                        taskId = ((DynamicObject)recordMap.get(recordId)).getLong("inventorytask.id");
                    }
                    consignationRecord.set("inventschemeentry", (Object)inventschemeentry);
                    consignationRecord.set("inventorytask", (Object)taskId);
                    inventoryTaskPks.add(taskId);
                }
                QFilter qRecordId = new QFilter("recordid", "in", (Object)recordid);
                DeleteServiceHelper.delete((String)"fa_inventory_entrust", (QFilter[])new QFilter[]{qRecordId});
                if (saveData.size() > 0 && (save = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])saveData.toArray(new DynamicObject[0]))).length > 0) {
                    DynamicObject[] InventoryBacklogs;
                    HashMap<Long, Long> map = new HashMap<Long, Long>(save.length);
                    for (DynamicObject dynamicObject : save) {
                        map.put(dynamicObject.getLong("recordid"), dynamicObject.getLong("id"));
                    }
                    for (DynamicObject inventoryBacklog : InventoryBacklogs = BusinessDataServiceHelper.load((String)"fa_inventory_backlog", (String)"id,inventoryentrust", (QFilter[])new QFilter[]{new QFilter("id", "in", map.keySet())})) {
                        inventoryBacklog.set("inventoryentrust", map.get(inventoryBacklog.getLong("id")));
                    }
                    SaveServiceHelper.update((DynamicObject[])InventoryBacklogs);
                    DynamicObject user = QueryServiceHelper.queryOne((String)"bos_user", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)userId)});
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u5c06%2$s\u4e2a\u8d44\u4ea7\u59d4\u6258\u7ed9\u60a8\u76d8\u70b9\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"FaSelectEntrustMobilePlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]), user.getString("name"), entryEntity.size());
                    String title = ResManager.loadKDString((String)"\u59d4\u6258\u76d8\u70b9\u901a\u77e5", (String)"FaSelectEntrustMobilePlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                    this.sendMessage(msg, title, selectMan.getLong("id"), inventoryTaskPks);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u59d4\u6258\u6210\u529f\u3002", (String)"FaSelectEntrustMobilePlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                }
                FaSelectEntrustMobilePlugin.showFaInventoryMobForm(this.getView());
                break;
            }
            case "cancle": {
                FaSelectEntrustMobilePlugin.showFaInventoryMobForm(this.getView());
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        CardEntry cardEntry;
        String entryKey;
        Object source = evt.getSource();
        if (source instanceof CardEntry && "entryentity".equals(entryKey = (cardEntry = (CardEntry)source).getEntryKey())) {
            int selectedIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String recordId = (String)this.getModel().getValue("recordid", selectedIndex);
            String state = (String)this.getModel().getValue("stateidentify", selectedIndex);
            if (INVENTORYED.equals(state)) {
                FaInventMobUtil.showBillForm(this.getView(), "fa_mobile_inventsuccess", recordId, null, null, null, null, null);
            } else if (INVENTORYLOSS.equals(state)) {
                this.showLossBillForm("fa_mobile_inventloss", recordId);
            } else {
                this.showBillDetailForm("fa_mobile_inventdetail", this.getModel().getValue("recordid", selectedIndex));
            }
        }
    }

    public static void showFaInventoryMobForm(IFormView view) {
        MobileFormShowParameter mobileFormShowParameter = new MobileFormShowParameter();
        mobileFormShowParameter.setFormId("fa_mobile_inventpage");
        mobileFormShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm((FormShowParameter)mobileFormShowParameter);
    }

    private void initEntryEntity() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
        String recordid = (String)this.getView().getFormShowParameter().getCustomParam("recordid");
        List ids = SerializationUtils.fromJsonStringToList((String)recordid, Long.TYPE);
        QFilter qRecordId = new QFilter("id", "in", (Object)ids);
        DataSet assetInventDataSet = QueryServiceHelper.queryDataSet((String)FaSelectEntrustMobilePlugin.class.getName(), (String)"fa_inventory_record", (String)FIELDS, (QFilter[])new QFilter[]{qRecordId}, null);
        DataSet dataSet = assetInventDataSet.addField("case when inventorystate != 'A' then 1 else case when difference >= 0 then 3 else 2 end end", FORSORT);
        DataSet result = dataSet.orderBy(new String[]{FORSORT});
        this.setEntryRows(model, result);
    }

    private void setEntryRows(AbstractFormDataModel model, DataSet assetInventorys) {
        model.beginInit();
        TableValueSetter setter = new TableValueSetter(new String[]{"asset_cardid"});
        int index = 0;
        for (Row assetInventory : assetInventorys) {
            String picture = assetInventory.getString("realcard.picturefield");
            if (!kd.bos.util.StringUtils.isEmpty((String)picture)) {
                picture = ImageUtil.getImageTruePath((String)assetInventory.getString("realcard.picturefield"));
            }
            setter.set("assetpicture", (Object)picture, index);
            setter.set("assetname", (Object)assetInventory.getString("realcard.assetname"), index);
            setter.set("assetnumber", (Object)assetInventory.getString("realcard.number"), index);
            setter.set("specification", (Object)assetInventory.getString("realcard.model"), index);
            setter.set("assetcategory", (Object)assetInventory.getString("realcard.assetcat.name"), index);
            setter.set("asset_cardid", (Object)assetInventory.getString("realcard.id"), index);
            setter.set("recordid", (Object)assetInventory.getLong("id"), index);
            int forSort = assetInventory.getInteger(FORSORT);
            switch (forSort) {
                case 1: {
                    setter.set("completestate", (Object)InventMobileEnum.WAITINVENTORY.getName(), index);
                    break;
                }
                case 2: {
                    setter.set("completestate", (Object)InventMobileEnum.INVENTORYLOSS.getName(), index);
                    setter.set("stateidentify", (Object)INVENTORYLOSS, index);
                    break;
                }
                case 3: {
                    setter.set("completestate", (Object)InventMobileEnum.INVENTORYED.getName(), index);
                    setter.set("stateidentify", (Object)INVENTORYED, index);
                    break;
                }
            }
            ++index;
        }
        model.batchCreateNewEntryRow("entryentity", setter);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private void sendMessage(String content, String title, Long userId, List<Long> inventoryTaskPks) {
        MessageInfo message = new MessageInfo();
        message.setType("message");
        if (StringUtils.isNotEmpty((String)title)) {
            message.setTitle(title);
        } else {
            message.setTitle(ResManager.loadKDString((String)"\u4eba\u4eba\u8d44\u4ea7-\u76d8\u70b9", (String)"FaSelectEntrustMobilePlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        for (Long inventoryTaskPk : inventoryTaskPks) {
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(userId);
            message.setUserIds(userIds);
            message.setSenderId(ContextUtil.getUserId());
            message.setSendTime(new Date(System.currentTimeMillis()));
            message.setEntityNumber("fa_inventory_task");
            message.setBizDataId(inventoryTaskPk);
            message.setTag(ResManager.loadKDString((String)"\u4eba\u4eba\u8d44\u4ea7", (String)"FaSelectEntrustMobilePlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            String clientUrl = UrlService.getDomainContextUrl();
            StringBuilder urlWithEncodedParams = new StringBuilder(clientUrl);
            if (!clientUrl.trim().endsWith("/")) {
                urlWithEncodedParams.append("/");
            }
            String strMobContentUrl = "%sintegration/yzjShareOpen.do?mb_formId=fa_mobile_inventpage&pkId=%s&device=mob&accountId=%s";
            message.setMobContentUrl(String.format(strMobContentUrl, urlWithEncodedParams.toString(), inventoryTaskPk, RequestContext.get().getAccountId()));
            String strContentUrl = "%sindex.html?formId=fa_inventory_task&pkId=%s";
            message.setContentUrl(String.format(strContentUrl, urlWithEncodedParams.toString(), inventoryTaskPk));
            message.setContent(content);
            message.setPubaccNumber("systempubacc");
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
            this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u9001\u666e\u901a\u7ed9[\u7cfb\u7edf\u7ea7\u6d88\u606f\u52a9\u624b]\u6210\u529f", (String)"FaSelectEntrustMobilePlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private void showBillDetailForm(String formId, Object recordId) {
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("recordid", recordId);
        showParameter.setCustomParam("schemeid", (Object)this.getPageCache().get("schemeid"));
        showParameter.setCustomParam("schemename", (Object)this.getPageCache().get("schemename"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showformdetail"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showLossBillForm(String formId, String recordId) {
        QFilter qrecord = new QFilter("id", "=", (Object)recordId);
        DynamicObject record = BusinessDataServiceHelper.loadSingle((String)"fa_inventory_record", (String)"reason", (QFilter[])new QFilter[]{qrecord});
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId(formId);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        showParameter.setCustomParam("recordid", (Object)recordId);
        showParameter.setCustomParam("schemeid", (Object)this.getPageCache().get("schemeid"));
        showParameter.setCustomParam("schemename", (Object)this.getPageCache().get("schemename"));
        showParameter.setCustomParam("detailreason", (Object)record.getString("reason"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public static void beforeSelectManSelect(BeforeF7SelectEvent evt, Long userId) {
        QFilter qFilter = new QFilter("id", "!=", (Object)userId);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(qFilter);
    }
}

