/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.split;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SubEntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.assetsplit.FaSplitBillAndCardHelper;
import kd.fi.fa.business.billmapping.BillFieldMappingConvertHelper;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.BillFieldMappingBlackListUtils;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaFinCardUtil;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.formplugin.FaBillBaseFormPlugin;
import kd.fi.fa.split.FieldEntry;
import kd.fi.fa.split.ScaleEntry;
import kd.fi.fa.utils.FaF7CostCenterUtils;
import kd.fi.fa.utils.FaF7DeptUtils;
import kd.fi.fa.utils.FaFormCurPeriodBizUtils;
import kd.fi.fa.utils.FaQFilter;

public class FaSplitCardBillEditPlugin
extends FaBillBaseFormPlugin
implements RowClickEventListener {
    private static Log logger = LogFactory.getLog(FaSplitCardBillEditPlugin.class);
    private static final String KEY_CALLBACK_SPLIYSCALE = "callback_splitscale";
    private static final String KEY_BAR_AVGSPLIT = "bar_avgsplit";
    private static final String KEY_BAR_SCALESPLIT = "bar_scalesplit";
    private static final String AUTO_SPLIT_ERROR_FLAG = "SPLIT_LAST_INVALIDE";
    private static final String PAGE_CACHE_UNENABLE_FIELDS_SPLIT = "page_cache_unenable_fields_split";
    public static final String PAGE_CACHE_UNENABLE_FIELDS_CARD = "page_cache_unenable_fields_card";
    private static final String ADVCONTOOLBARAP1 = "advcontoolbarap1";
    private static final String TARGET_CARD = "targetcard";
    public static final String KEY_CACHE_REAL_FIN_CARD = "cache_real_fin_card";
    public static final String KEY_SPLIT_PAGE_ID = "split_page_id";
    public static final String KEY_SEQ_INDEX_RELATION = "seq_index_relation";
    public static final String KEY_MAX_SEQ = "max_seq";
    private static final List<String> PARTY_SPLIT_EDIT_FIELD = Arrays.asList("aft_assetamount", "aft_originalval", "aft_accumdepre", "aft_decval", "aft_preresidualval", "aft_incometax");
    private static final String KEY_CALLBACK_TARGET_CARD = "callback_targetcard";
    private static final String KEY_IMPORT_ORG2ASSETBOOKS = "import_org2assetbooks";
    private static final String KEY_IMPORT_ORGMAINASSETBOOK = "import_orgmainassetbook";

    @Override
    public void afterCreateNewData(EventObject eventobject) {
        IPageCache parentPageCache;
        String pram;
        super.afterCreateNewData(eventobject);
        this.initValue();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null && !kd.bos.util.StringUtils.isEmpty((String)(pram = (parentPageCache = parentView.getPageCache()).get("fa_splitcardguide")))) {
            DynamicObject splitGuide = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)pram);
            DynamicObject splitBill = this.getModel().getDataEntity();
            DataEntityPropertyCollection properties = splitBill.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                splitBill.set(property, splitGuide.get(property));
            }
            this.avgSplit();
            parentPageCache.remove("fa_splitcardguide");
            this.cacheEnableOnInit();
            this.setDepUseVisible();
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("closeguide", (Object)FaBillParamUtils.getBooleanValue(null, null, null, (String)"SplitGuideSwitch"));
        IDataModel model = this.getModel();
        this.setDataRange();
        this.getModel().setDataChanged(false);
        DynamicObject realDy = model.getDataEntity().getDynamicObject("split_realcard");
        if (realDy == null) {
            return;
        }
        this.cacheEnableOnInit();
        this.setEnableWhenOne(realDy);
        this.setAftSplitEnable();
        this.setDepUseVisible();
        this.setEnable4CloseGuide();
    }

    private void setEnable4CloseGuide() {
        int count;
        boolean hasCloseGuide = FaBillParamUtils.getBooleanValue(null, null, null, (String)"SplitGuideSwitch");
        if (hasCloseGuide && (count = this.getModel().getEntryRowCount("subassetsplitentry")) > 0) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isautocarry", "splittype", "biztype", "splitqty", "split_realcard", "isavgsplit", "ismanualcode"});
        }
    }

    private void setDepUseVisible() {
        long orgId = this.getModel().getDataEntity().getLong(Fa.id((String)"org"));
        DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"id", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId)});
        if (assetBooks.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bef_depreuse", "aft_depreuse"});
        }
    }

    private void setAftSplitEnable() {
        this.cacheEnableOnInit();
        DynamicObject splitBill = this.getModel().getDataEntity(Boolean.TRUE.booleanValue());
        DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject befSplit : befSplitEntry) {
            DynamicObject befFinCard = befSplit.getDynamicObject("bef_fincard");
            if (befFinCard == null) continue;
            Object assetBookPk = befFinCard.getDynamicObject("assetbook").getPkValue();
            DynamicObject assetBook4DB = null;
            DynamicObjectCollection aftSplitEntry = befSplit.getDynamicObjectCollection("subassetsplitentry");
            for (DynamicObject aftSplit : aftSplitEntry) {
                Object depSystemId;
                DynamicObject targetPolicy;
                String decPolicy;
                DynamicObject assetCat = aftSplit.getDynamicObject("aft_assetcat");
                if (assetCat == null) continue;
                if (assetBook4DB == null) {
                    assetBook4DB = BusinessDataServiceHelper.loadSingleFromCache((Object)assetBookPk, (String)"fa_assetbook");
                }
                boolean canDecVal = "2".equals(decPolicy = (targetPolicy = AssetPolicyUtil.getByDepreSystemAndCat((Object)(depSystemId = assetBook4DB.getDynamicObject("depresystem").getPkValue()), (Object)assetCat.getPkValue())).getString("decpolicy")) || "3".equals(decPolicy) || "4".equals(decPolicy);
                boolean noDepre = targetPolicy.getBoolean("nodepre");
                aftSplit.set("enabledecval", (Object)canDecVal);
                aftSplit.set("enabledep", (Object)(!noDepre ? 1 : 0));
            }
        }
        this.setCodeRuleFieldsChanged();
        this.setEnableByChangeItem();
    }

    private void cacheEnableOnInit() {
        String unenableFieldsStr = this.getPageCache().get(PAGE_CACHE_UNENABLE_FIELDS_SPLIT);
        if (unenableFieldsStr == null) {
            this.cachePageEnableField();
        }
    }

    private void cachePageEnableField() {
        FaSplitBillAndCardHelper helper = new FaSplitBillAndCardHelper();
        boolean isOpenManualCode = this.getModel().getDataEntity().getBoolean("ismanualcode");
        boolean isQuantitySplit = "A".equals(this.getModel().getDataEntity().getString("splittype"));
        Set enableFields = helper.getEnableFields4Split(isOpenManualCode, isQuantitySplit);
        HashSet<String> aftFields = new HashSet<String>();
        MainEntityType splitEntityType = EntityMetadataCache.getDataEntityType((String)"fa_assetsplitbill");
        for (IDataEntityProperty pro : splitEntityType.getAllFields().values()) {
            String proName = pro.getName();
            IDataEntityType parent = pro.getParent();
            if (!"subassetsplitentry".equals(parent.getName())) continue;
            aftFields.add(proName);
        }
        HashSet<String> unEnableFields = aftFields;
        unEnableFields.removeAll(enableFields);
        this.getPageCache().put(PAGE_CACHE_UNENABLE_FIELDS_SPLIT, SerializationUtils.serializeToBase64(unEnableFields));
        this.cacheEnable4Card(helper, isOpenManualCode, isQuantitySplit);
    }

    private void cacheEnable4Card(FaSplitBillAndCardHelper helper, boolean isOpenManualCode, boolean isQuantitySplit) {
        String unenableFieldsStr = this.getPageCache().get(PAGE_CACHE_UNENABLE_FIELDS_CARD);
        if (unenableFieldsStr == null) {
            HashMap unEnableFieldMap = new HashMap(2);
            Map enableFieldMap = helper.getEnableFields4Card(isOpenManualCode, isQuantitySplit);
            Set realEnableFields = (Set)enableFieldMap.get("fa_card_real");
            Set finEnableFields = (Set)enableFieldMap.get("fa_card_fin");
            HashSet<String> realFields = new HashSet<String>();
            MainEntityType realEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_real");
            for (IDataEntityProperty pro : realEntityType.getAllFields().values()) {
                String proName = pro.getName();
                IDataEntityType parent = pro.getParent();
                if (!(parent instanceof MainEntityType)) continue;
                realFields.add(proName);
            }
            HashSet<String> realUnEnableFields = realFields;
            realUnEnableFields.removeAll(realEnableFields);
            HashSet<String> finFields = new HashSet<String>();
            MainEntityType finEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
            for (IDataEntityProperty pro : finEntityType.getAllFields().values()) {
                String proName = pro.getName();
                IDataEntityType finParent = pro.getParent();
                if (!(finParent instanceof MainEntityType)) continue;
                finFields.add(proName);
            }
            HashSet<String> finUnEnableFields = finFields;
            finUnEnableFields.removeAll(finEnableFields);
            unEnableFieldMap.put("fa_card_real", realUnEnableFields);
            unEnableFieldMap.put("fa_card_fin", finUnEnableFields);
            this.getPageCache().put(PAGE_CACHE_UNENABLE_FIELDS_CARD, SerializationUtils.serializeToBase64(unEnableFieldMap));
        }
    }

    private void setEnableByChangeItem() {
        SubEntryGrid subEntryGrid;
        int rowCount;
        DynamicObject befSplit;
        DynamicObjectCollection aftSplitEntry;
        String unenableFieldsStr = this.getPageCache().get(PAGE_CACHE_UNENABLE_FIELDS_SPLIT);
        Set unEnableFields = new HashSet(0);
        if (kd.bos.util.StringUtils.isNotEmpty((String)unenableFieldsStr)) {
            unEnableFields = (Set)SerializationUtils.deSerializeFromBase64((String)unenableFieldsStr);
        }
        int sourceIndex = 0;
        DynamicObjectCollection befSplitEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("assetsplitentry");
        if (!befSplitEntry.isEmpty() && !(aftSplitEntry = (befSplit = (DynamicObject)befSplitEntry.get(0)).getDynamicObjectCollection("subassetsplitentry")).isEmpty()) {
            int index = 0;
            for (DynamicObject aftSplit : aftSplitEntry) {
                if (aftSplit.getBoolean("issourcecard")) {
                    sourceIndex = index;
                    break;
                }
                ++index;
            }
        }
        if ((rowCount = ((Integer)(subEntryGrid = (SubEntryGrid)this.getView().getControl("subassetsplitentry")).getEntryData().getData().get("rowcount")).intValue()) > 1) {
            String bizType = this.getModel().getDataEntity().getString("biztype");
            for (int i = 0; i <= rowCount - 1; ++i) {
                if (i == sourceIndex) {
                    Set<String> aftEntryFields = this.getAftSplitField2Prop().keySet();
                    if ("A".equals(bizType)) {
                        aftEntryFields.removeAll(PARTY_SPLIT_EDIT_FIELD);
                    }
                    this.getView().setEnable(Boolean.FALSE, i, aftEntryFields.toArray(new String[0]));
                    continue;
                }
                this.getView().setEnable(Boolean.FALSE, i, unEnableFields.toArray(new String[0]));
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.setEnableByChangeItem();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit realCardEdit = (BasedataEdit)this.getView().getControl("split_realcard");
        realCardEdit.addBeforeF7SelectListener(this::beforeF7RealCardSelect);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener(evt -> this.beforeOrgSelect(evt));
        BasedataEdit headUseDept = (BasedataEdit)this.getControl("aft_headusedept");
        DynamicObject splitRealCard = this.getModel().getDataEntity().getDynamicObject("split_realcard");
        if (splitRealCard != null) {
            headUseDept.addBeforeF7SelectListener(evt -> {
                FaF7DeptUtils.beforeDeptSelect(evt, splitRealCard.getDynamicObject("org"), splitRealCard.getDynamicObject("assetunit"));
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
            });
        }
        BasedataEdit inCostCenter = (BasedataEdit)this.getControl("aft_costcentrer");
        if (splitRealCard != null) {
            inCostCenter.addBeforeF7SelectListener(evt -> {
                FaF7CostCenterUtils.beforeCostCenterSelect(evt, splitRealCard.getDynamicObject("org"));
                ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
                listShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
            });
        }
        EntryGrid befEntry = (EntryGrid)this.getControl("assetsplitentry");
        befEntry.addRowClickListener((RowClickEventListener)this);
        this.addItemClickListeners(new String[]{ADVCONTOOLBARAP1});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        if ("subassetsplitentry".equals(e.getEntryProp().getName())) {
            this.getModel().deleteEntryRow("subassetsplitentry", e.getRowDataEntities()[0].getRowIndex());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        BigDecimal originalVal;
        IDataModel model = this.getModel();
        String property = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if ("ismanualcode".equals(property)) {
            DynamicObject aft;
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection befEntry = dataEntity.getDynamicObjectCollection("assetsplitentry");
            if (befEntry.isEmpty()) {
                return;
            }
            DynamicObject befEntity = (DynamicObject)befEntry.get(0);
            DynamicObjectCollection aftEntry = befEntity.getDynamicObjectCollection("subassetsplitentry");
            if (aftEntry.isEmpty()) {
                return;
            }
            boolean newValue = Boolean.parseBoolean(changeData.getNewValue().toString());
            int index = 0;
            Iterator iterator = aftEntry.iterator();
            while (iterator.hasNext() && !(aft = (DynamicObject)iterator.next()).getBoolean("issourcecard")) {
                ++index;
            }
            IFormView view = this.getView();
            for (int i = 0; i < aftEntry.size(); ++i) {
                if (index == i) continue;
                model.setValue("aft_cardbillno", (Object)"", i, 0);
                model.setValue("aft_cardnumber", (Object)"", i, 0);
                model.setValue("aft_barcode", (Object)"", i, 0);
                view.setEnable(Boolean.valueOf(newValue), i, new String[]{"aft_cardbillno", "aft_cardnumber", "aft_barcode"});
            }
            this.cachePageEnableField();
        }
        if ("splittype".equals(property)) {
            this.cachePageEnableField();
        }
        if ("split_realcard".equals(property)) {
            if (changeData == null || changeData.getNewValue() == null) {
                model.deleteEntryData("assetsplitentry");
                return;
            }
            DynamicObject realDy = (DynamicObject)changeData.getNewValue();
            DynamicObject splitBill = model.getDataEntity();
            HashSet<Long> realCardIds = new HashSet<Long>(2);
            realCardIds.add(realDy.getLong("id"));
            String msg = FaUtils.checkRealCardBizStatus(realCardIds);
            if (!msg.isEmpty()) {
                this.getView().showErrorNotification(msg);
                model.setValue("split_realcard", changeData.getOldValue());
                return;
            }
            Set existCards = FaUtils.getCurRealCard((Date)splitBill.getDate("splitdate"), (Long)splitBill.getLong(Fa.id((String)"org")), (Boolean)false, realCardIds, (BusyTypeDetailEnum)BusyTypeDetailEnum.REAL_FIN_CHG, null);
            if (existCards.isEmpty()) {
                FaUtils.showErrorRealCardMsg((int)1, null, (DynamicObject)realDy, (IFormView)this.getView());
                model.setValue("split_realcard", changeData.getOldValue());
                return;
            }
            String dataAssetCardNumber = FaUtils.checkDataAssetRealCard(realCardIds);
            if (!dataAssetCardNumber.isEmpty()) {
                String part2 = ResManager.loadKDString((String)"\u5efa\u5361\u65b9\u5f0f\u4e3a\u3010\u6570\u636e\u5361\u7247\u3011\uff0c\u4e0d\u652f\u6301\u505a\u62c6\u5206\u4e1a\u52a1\u3002", (String)"FaSplitCardBillEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]);
                FaUtils.showErrorSourceFlagRealCardMsg((int)dataAssetCardNumber.split(",").length, (String)dataAssetCardNumber, (String)part2, (IFormView)this.getView());
                model.setValue("split_realcard", changeData.getOldValue());
                return;
            }
            this.splitCardPropertyChanged(realDy, true);
        }
        if ("aft_assetcat".equals(property)) {
            DynamicObject assetCat = (DynamicObject)changeData.getNewValue();
            if (assetCat == null) {
                return;
            }
            DynamicObjectCollection befSplitEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("assetsplitentry");
            int index = 0;
            for (DynamicObject befSplit : befSplitEntry) {
                DynamicObject befFinCard = befSplit.getDynamicObject("bef_fincard");
                Object assetBookPk = befFinCard.getDynamicObject("assetbook").getPkValue();
                DynamicObject assetBook4DB = BusinessDataServiceHelper.loadSingleFromCache((Object)assetBookPk, (String)"fa_assetbook");
                Object depSystemId = assetBook4DB.getDynamicObject("depresystem").getPkValue();
                DynamicObject targetPolicy = AssetPolicyUtil.getByDepreSystemAndCat((Object)depSystemId, (Object)assetCat.getPkValue());
                String decPolicy = targetPolicy.getString("decpolicy");
                boolean canDecVal = "2".equals(decPolicy) || "3".equals(decPolicy) || "4".equals(decPolicy);
                this.getModel().setValue("enabledecval", (Object)canDecVal, changeData.getRowIndex(), index);
                boolean noDepre = targetPolicy.getBoolean("nodepre");
                this.getModel().setValue("enabledep", (Object)(!noDepre ? 1 : 0), changeData.getRowIndex(), index);
                this.getModel().setValue("aft_unit", assetCat.get("unit"), changeData.getRowIndex(), index);
                ++index;
            }
            this.setCodeRuleFieldsChanged();
        }
        int parentRowIndex = changeData.getParentRowIndex();
        int rowIndex = changeData.getRowIndex();
        DynamicObject entryObj = changeData.getDataEntity();
        if ("aft_originalval".equals(property)) {
            originalVal = entryObj.getBigDecimal("aft_originalval");
            BigDecimal accumDepre = entryObj.getBigDecimal("aft_accumdepre");
            if (originalVal != null && accumDepre != null) {
                model.setValue("aft_networth", (Object)originalVal.subtract(accumDepre), rowIndex, parentRowIndex);
            }
        } else if ("aft_accumdepre".equals(property)) {
            originalVal = entryObj.getBigDecimal("aft_originalval");
            BigDecimal accumDepre = entryObj.getBigDecimal("aft_accumdepre");
            if (originalVal != null && accumDepre != null) {
                model.setValue("aft_networth", (Object)originalVal.subtract(accumDepre), rowIndex, parentRowIndex);
            }
        } else if ("aft_networth".equals(property) || "aft_decval".equals(property)) {
            BigDecimal netWorth = entryObj.getBigDecimal("aft_networth");
            BigDecimal decVal = entryObj.getBigDecimal("aft_decval");
            if (netWorth != null && decVal != null) {
                model.setValue("aft_netamount", (Object)netWorth.subtract(decVal), rowIndex, parentRowIndex);
            }
        }
        if ("aft_workloadunit".equals(property)) {
            Object depredAmount;
            Object preUsingaMount;
            IFormView formView = this.getView();
            DynamicObject workLoadUnit = (DynamicObject)formView.getModel().getValue("aft_workloadunit");
            int precision = 0;
            if (Objects.nonNull(workLoadUnit)) {
                precision = (Integer)workLoadUnit.get("precision");
            }
            if (Objects.nonNull(preUsingaMount = formView.getModel().getValue("aft_preusingamount"))) {
                BigDecimal preUsingaMountBigDecimal = (BigDecimal)preUsingaMount;
                preUsingaMountBigDecimal = preUsingaMountBigDecimal.setScale(precision, RoundingMode.HALF_UP);
                formView.getModel().setValue("aft_preusingamount", (Object)preUsingaMountBigDecimal);
            }
            if (Objects.nonNull(depredAmount = formView.getModel().getValue("aft_depredamount"))) {
                BigDecimal depredAmountBigDecimal = (BigDecimal)depredAmount;
                depredAmountBigDecimal = depredAmountBigDecimal.setScale(precision, RoundingMode.HALF_UP);
                formView.getModel().setValue("aft_depredamount", (Object)depredAmountBigDecimal);
            }
        }
        if (this.getModel().getDataEntity(true).getDynamicObjectCollection("assetsplitentry").size() > 1 && this.getAftFieldMapRealFields().contains(property)) {
            this.mulBookRealSync(property, changeData);
        }
    }

    private void setCodeRuleFieldsChanged() {
        MainEntityType entityType = this.getModel().getDataEntityType();
        DynamicObjectType aftSplitItemPropertyType = ((EntryProp)((EntryProp)entityType.getProperty("assetsplitentry")).getDynamicCollectionItemPropertyType().getProperty("subassetsplitentry")).getDynamicCollectionItemPropertyType();
        DynamicProperty enableDecValProp = aftSplitItemPropertyType.getProperty("enabledecval");
        DynamicProperty enableDepProp = aftSplitItemPropertyType.getProperty("enabledep");
        DynamicProperty aftRealCardProp = aftSplitItemPropertyType.getProperty(Fa.id((String)"aft_realcard"));
        DynamicObjectCollection befSplitEntry = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject befSplit : befSplitEntry) {
            DynamicObjectCollection aftSplitEntry = befSplit.getDynamicObjectCollection("subassetsplitentry");
            for (DynamicObject aftSplit : aftSplitEntry) {
                DataEntityState aftSplitDataEntityState = aftSplit.getDataEntityState();
                aftSplitDataEntityState.setBizChanged(enableDecValProp.getOrdinal(), Boolean.FALSE.booleanValue());
                aftSplitDataEntityState.setBizChanged(enableDepProp.getOrdinal(), Boolean.FALSE.booleanValue());
                aftSplitDataEntityState.setBizChanged(aftRealCardProp.getOrdinal(), Boolean.FALSE.booleanValue());
            }
        }
    }

    private void mulBookRealSync(String property, ChangeData changeData) {
        Map<String, IDataEntityProperty> aftSplitField2Prop = this.getAftSplitField2Prop();
        IDataEntityProperty dataProperty = aftSplitField2Prop.get(property);
        if (dataProperty == null) {
            logger.info("\u8d44\u4ea7\u62c6\u5206\u5355\u4e0e\u5b9e\u7269\u5361\u7247\u5b57\u6bb5\u6620\u5c04\u5b58\u5728\u9519\u8bef\u914d\u7f6e\uff0c\u62c6\u5206\u540e\u5206\u5f55\u627e\u4e0d\u5230\u8be5\u5b57\u6bb5\u6807\u8bc6\uff1a" + property);
        } else {
            boolean isEmpty;
            Object newValue = null;
            boolean isMustInput = false;
            if (dataProperty instanceof FieldProp) {
                newValue = dataProperty instanceof MuliLangTextProp ? this.getMulLocaleString(changeData, property) : changeData.getNewValue();
                isMustInput = ((FieldProp)dataProperty).isMustInput();
            } else if (dataProperty instanceof BasedataProp) {
                newValue = changeData.getNewValue();
                isMustInput = ((BasedataProp)dataProperty).isMustInput();
            } else if (dataProperty instanceof MulBasedataProp) {
                newValue = changeData.getNewValue();
                isMustInput = ((MulBasedataProp)dataProperty).isMustInput();
            } else {
                logger.info("\u6682\u4e0d\u652f\u6301\u8054\u52a8\u7c7b\u578b\uff0c\u5b57\u6bb5\u6807\u8bc6\uff1a" + property);
            }
            if (isMustInput && (isEmpty = newValue instanceof LocaleString ? ((LocaleString)newValue).isEmpty() : ObjectUtils.isEmpty((Object)newValue))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaSplitCardBillEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]), dataProperty.getDisplayName()));
                return;
            }
            this.syncRealData(changeData, property, newValue);
        }
    }

    private Map<String, IDataEntityProperty> getAftSplitField2Prop() {
        EntryProp befSplitEntryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)"assetsplitentry");
        EntryProp aftSplitEntryProp = (EntryProp)befSplitEntryProp.getDynamicCollectionItemPropertyType().getProperties().get((Object)"subassetsplitentry");
        DataEntityPropertyCollection aftSplitEntryProps = aftSplitEntryProp.getDynamicCollectionItemPropertyType().getProperties();
        HashMap<String, IDataEntityProperty> field2Prop = new HashMap<String, IDataEntityProperty>(FaUtils.getInitialCapacity43((int)aftSplitEntryProps.size()));
        for (IDataEntityProperty property : aftSplitEntryProps) {
            field2Prop.put(property.getName(), property);
        }
        return field2Prop;
    }

    private List<String> getAftFieldMapRealFields() {
        String pageCacheStr = this.getPageCache().get("subassetsplitentry");
        if (!kd.bos.util.StringUtils.isEmpty((String)pageCacheStr)) {
            return (List)SerializationUtils.deSerializeFromBase64((String)pageCacheStr);
        }
        BillFieldMappingConvertHelper realHelp = FaSplitBillAndCardHelper.getConfigHelper((String)"SR01");
        List aftSplitEntryRealFields = realHelp.getConfigFields4Source();
        this.getPageCache().put("subassetsplitentry", SerializationUtils.serializeToBase64((Object)aftSplitEntryRealFields));
        return aftSplitEntryRealFields;
    }

    private void syncRealData(ChangeData changeData, String field, Object newValue) {
        int rowIndex = changeData.getRowIndex();
        int parentRowIndex = changeData.getParentRowIndex();
        DynamicObjectCollection befSplitList = this.getModel().getEntryEntity("assetsplitentry");
        for (int i = 0; i < befSplitList.size(); ++i) {
            if (i == parentRowIndex) continue;
            DynamicObjectCollection aftSplitList = ((DynamicObject)befSplitList.get(i)).getDynamicObjectCollection("subassetsplitentry");
            ((DynamicObject)aftSplitList.get(rowIndex)).set(field, newValue);
        }
    }

    private LocaleString getMulLocaleString(ChangeData changeData, String field) {
        LocaleString localeString = new LocaleString();
        LocaleDynamicObjectCollection localeDynamicColl = (LocaleDynamicObjectCollection)changeData.getNewValue();
        if (localeDynamicColl.isEmpty()) {
            return localeString;
        }
        String localeValue = RequestContext.get().getLang().name();
        for (DynamicObject local : localeDynamicColl) {
            if (kd.bos.util.StringUtils.isEmpty((String)local.getString(field))) continue;
            String locale = local.getString("localeid");
            if (localeValue.equals(locale)) {
                localeString.setLocaleValue(local.getString(field));
            }
            if ("zh_CN".equals(locale)) {
                localeString.setLocaleValue_zh_CN(local.getString(field));
                continue;
            }
            if ("zh_TW".equals(locale)) {
                localeString.setLocaleValue_zh_TW(local.getString(field));
                continue;
            }
            localeString.setLocaleValue_en(local.getString(field));
        }
        return localeString;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "bar_avgsplit": {
                this.avgSplit();
                this.setEnable4CloseGuide();
                break;
            }
            case "bar_scalesplit": {
                this.scaleSplit();
                this.setEnable4CloseGuide();
                break;
            }
            case "targetcard": {
                this.showTargetCards();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FaFormCurPeriodBizUtils.showGuideConfirm4EditView(args, this.getView(), "fa_assetsplitbill", (IFormPlugin)this);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        FaFormCurPeriodBizUtils.guideConfirmCallBack(messageBoxClosedEvent, this.getView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String type = ((AbstractOperate)args.getSource()).getOperateKey();
        List<String> doOperateType = Collections.singletonList("unaudit");
        if (doOperateType.contains(type)) {
            this.resetAftSplitCard();
        }
        this.setEnableByChangeItem();
        Long pkId = this.getModel().getDataEntity().getLong("id");
        this.getPageCache().put("billId", String.valueOf(pkId));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (KEY_CALLBACK_SPLIYSCALE.equalsIgnoreCase(actionId)) {
            this.callBackSplitScaleSet(closedCallBackEvent);
        } else if ("fa_asset_card".equals(actionId)) {
            ArrayList newRealCardIds = new ArrayList(16);
            DynamicObject splitBill = this.getModel().getDataEntity(true);
            DynamicObjectCollection befEntries = splitBill.getDynamicObjectCollection("assetsplitentry");
            for (DynamicObject bef : befEntries) {
                DynamicObjectCollection aftSplitEntry = bef.getDynamicObjectCollection("subassetsplitentry");
                aftSplitEntry.stream().forEach(t -> {
                    Long newCardId;
                    if (!t.getBoolean("issourcecard") && (newCardId = Long.valueOf(t.getLong(Fa.id((String)"aft_realcard")))) != 0L) {
                        newRealCardIds.add(newCardId);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(newRealCardIds)) {
                this.getPageCache().put("newRealCardIds", JSON.toJSONString(newRealCardIds));
            }
        }
        if (KEY_CALLBACK_TARGET_CARD.equals(actionId)) {
            this.setCodeRuleFieldsChanged();
        }
    }

    public void initImportData(InitImportDataEventArgs e) {
        super.initImportData(e);
        this.importCheckCodeRule("fa_assetsplitbill", e, "org");
        ArrayList sourceDataList = new ArrayList(e.getSourceDataList());
        Set allOrgNumbers = sourceDataList.stream().map(v -> this.getNumber((Map<String, Object>)v, "org")).collect(Collectors.toSet());
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter("number", "in", allOrgNumbers).toArray());
        Map<String, Object> orgNumber_id = orgs.stream().collect(Collectors.toMap(v -> v.getString("number"), v -> v.get("id")));
        Map<Long, List<DynamicObject>> orgId2AssetBookMap = this.getOrgId2AssetBookMap(orgNumber_id.values());
        HashMap orgId_mainBook = new HashMap(orgId2AssetBookMap.size());
        for (Map.Entry<Long, List<DynamicObject>> entry : orgId2AssetBookMap.entrySet()) {
            List<DynamicObject> assetBooks = entry.getValue();
            if (!CollectionUtils.isNotEmpty(assetBooks)) continue;
            orgId_mainBook.put(entry.getKey(), assetBooks.stream().filter(t -> t.getBoolean("ismainbook")).findFirst().orElse(null));
        }
        String faError = "faError";
        Iterator iterator = sourceDataList.iterator();
        while (iterator.hasNext()) {
            Map sourceData = (Map)iterator.next();
            String orgNumber = this.getNumber(sourceData, "org");
            if (!orgNumber_id.containsKey(orgNumber)) {
                sourceData.put(faError, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"FaSplitCardBillEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                iterator.remove();
                continue;
            }
            Object orgId = orgNumber_id.get(orgNumber);
            List<DynamicObject> assetBooks = orgId2AssetBookMap.get(orgId);
            sourceData.put(KEY_IMPORT_ORG2ASSETBOOKS, assetBooks);
            DynamicObject mainBook = (DynamicObject)orgId_mainBook.get(orgId);
            sourceData.put(KEY_IMPORT_ORGMAINASSETBOOK, mainBook);
            if (orgId_mainBook.containsKey(orgId)) continue;
            sourceData.put(faError, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5b58\u5728\u4e3b\u8d26\u7c3f\u3002", (String)"FaSplitCardBillEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            iterator.remove();
        }
        Set allRealNumbers = sourceDataList.stream().map(v -> this.getNumber((Map<String, Object>)v, "split_realcard")).collect(Collectors.toSet());
        String fields = Fa.comma((String[])new String[]{"realcard", "realcard.number", "realcard.org", "finaccountdate", "depremethod.type", "realcardmasterid"});
        DynamicObjectCollection allFinCards = QueryServiceHelper.query((String)"fa_card_fin", (String)fields, (QFilter[])new QFilter[]{new QFilter("endperiod", "=", (Object)99999999999L), new QFilter("realcard.number", "in", allRealNumbers)});
        Function<DynamicObject, String> keyFn = v -> v.getString("realcard.org") + "," + v.getString("realcard.number");
        HashMap key_finCards = new HashMap();
        for (DynamicObject finCard : allFinCards) {
            String key = keyFn.apply(finCard);
            if (!key_finCards.containsKey(key)) {
                key_finCards.put(key, new ArrayList());
            }
            ((List)key_finCards.get(key)).add(finCard);
        }
        for (Map sourceData : sourceDataList) {
            String orgNumber = this.getNumber(sourceData, "org");
            Object orgId = orgNumber_id.get(orgNumber);
            assert (orgId != null);
            String realNumber = this.getNumber(sourceData, "split_realcard");
            List finCards = (List)key_finCards.get(orgId + "," + realNumber);
            if (finCards == null || finCards.isEmpty()) {
                sourceData.put(faError, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u201c%1$s\u201d\u4e0d\u5b58\u5728\u5361\u7247\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"FaSplitCardBillEditPlugin_4", (String)"fi-fa-formplugin", (Object[])new Object[0]), orgNumber, realNumber));
                continue;
            }
            DynamicObject mainBook = (DynamicObject)orgId_mainBook.get(orgId);
            assert (mainBook != null);
            Date endDate = mainBook.getDate("curperiod.enddate");
            Date nextPeriodBeginDate = DateUtil.getNextDay0hour((Date)endDate);
            boolean fail = false;
            for (DynamicObject finCard : finCards) {
                if (finCard.getDate("finaccountdate").compareTo(nextPeriodBeginDate) < 0) continue;
                sourceData.put(faError, ResManager.loadKDString((String)"\u88ab\u62c6\u5206\u5361\u7247\u662f\u672a\u6765\u671f\u95f4\u7684\u5165\u8d26\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u62c6\u5206\u3002", (String)"FaSplitCardBillEditPlugin_5", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                fail = true;
                break;
            }
            if (fail) continue;
            Map splitRealCard = (Map)sourceData.get("split_realcard");
            splitRealCard.put("importprop", "id");
            splitRealCard.put("id", ((DynamicObject)finCards.get(0)).getString("realcardmasterid"));
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        if (sourceData.containsKey("faError")) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), (String)sourceData.get("faError"));
            e.setCancel(true);
            return;
        }
        if (this.checkIsOldTemplate((ImportDataEventArgs)e) && !sourceData.containsKey("assetsplitentry")) {
            return;
        }
        List befSplitEntryList = (List)sourceData.get("assetsplitentry");
        Set befDepreuses = befSplitEntryList.stream().map(v -> this.getNumber((Map<String, Object>)v, "bef_depreuse")).collect(Collectors.toSet());
        if (befDepreuses.isEmpty()) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaSplitCardBillEditPlugin_6", (String)"fi-fa-formplugin", (Object[])new Object[0]), befDepreuses));
            e.setCancel(true);
            return;
        }
        this.checkWorkLoadUnit(e, befSplitEntryList);
        Map realcard = (Map)sourceData.get("split_realcard");
        Object realcardId = realcard.get("id");
        Set exitDepreUseNums = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.dot((String[])new String[]{"depreuse", "number"}), (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"org", "number"}), "=", (Object)this.getNumber(sourceData, "org"))}).stream().map(v -> v.getString(Fa.dot((String[])new String[]{"depreuse", "number"}))).collect(Collectors.toSet());
        befDepreuses.removeAll(exitDepreUseNums);
        if (!befDepreuses.isEmpty()) {
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6838\u7b97\u7ec4\u7ec7\u7684\u6240\u6709\u8d44\u4ea7\u8d26\u7c3f\u4e2d\u4e0d\u5b58\u5728\u5f55\u5165\u7684\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u6298\u65e7\u7528\u9014\u3002", (String)"FaSplitCardBillEditPlugin_7", (String)"fi-fa-formplugin", (Object[])new Object[0]), befDepreuses));
            e.setCancel(true);
            return;
        }
        if (!this.checkIsOldTemplate((ImportDataEventArgs)e)) {
            return;
        }
        HashSet realCards = new HashSet(1);
        realCards.add(realcardId);
        List finCardList = FaUtils.queryFinCards(realCards);
        int index = 0;
        for (Map befSplitEntry : befSplitEntryList) {
            String splitRate;
            DynamicObject finCard;
            BigDecimal befOriginal;
            List aftSplitEntryList = (List)befSplitEntry.get("subassetsplitentry");
            if (aftSplitEntryList.isEmpty()) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u8d44\u4ea7\u539f\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaSplitCardBillEditPlugin_8", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            BigDecimal aftOriginal = BigDecimal.ZERO;
            StringBuilder sb = new StringBuilder();
            for (Map aftSplitEntry : aftSplitEntryList) {
                JSONObject aftSplitObj = new JSONObject(aftSplitEntry);
                BigDecimal aftSplitOriginal = aftSplitObj.getBigDecimal("aft_originalval");
                aftOriginal = aftOriginal.add(aftSplitOriginal);
                sb.append(aftSplitOriginal).append(":");
            }
            if (finCardList != null && !finCardList.isEmpty() && aftOriginal.compareTo(befOriginal = (finCard = (DynamicObject)finCardList.get(0)).getBigDecimal("originalval")) != 0) {
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), ResManager.loadKDString((String)"\u62c6\u5206\u540e\u7684\u8d44\u4ea7\u539f\u503c\u4e0d\u7b49\u4e8e\u62c6\u5206\u524d\u7684\u8d44\u4ea7\u539f\u503c\u3002", (String)"FaSplitCardBillEditPlugin_9", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String string = splitRate = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
            if (StringUtils.isNotEmpty((CharSequence)splitRate)) {
                sourceData.put("splitrate", splitRate);
                String[] splits = splitRate.split(":");
                sourceData.put("splitqty", splits.length);
                sourceData.put("splittype", "B");
                sourceData.put("isavgsplit", Boolean.FALSE);
            }
            ++index;
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Long pkId = this.getModel().getDataEntity().getLong("id");
        this.getPageCache().put("billId", String.valueOf(pkId));
    }

    public void pageRelease(EventObject e) {
        super.pageRelease(e);
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("fa_assetsplitbill".equals(formId)) {
            String newRealCardIdsStr;
            long pkId;
            String pkIdStr = this.getPageCache().get("billId");
            long l = pkId = kd.bos.util.StringUtils.isEmpty((String)pkIdStr) ? 0L : Long.parseLong(pkIdStr);
            if (pkId == 0L && kd.bos.util.StringUtils.isNotEmpty((String)(newRealCardIdsStr = this.getPageCache().get("newRealCardIds")))) {
                List newRealCardIds = JSON.parseArray((String)newRealCardIdsStr, Long.class);
                AttachmentServiceHelper.batchRemove((String)"fa_card_real", newRealCardIds.stream().collect(Collectors.toList()));
            }
        }
    }

    private void checkWorkLoadUnit(BeforeImportDataEventArgs e, List<Map<String, Object>> befSplitEntryList) {
        Set depreMethodNumber = FaUtils.getDepreMethodNumberByType((String)"5");
        Map<String, Integer> unitPrecision = this.getUnitPrecision(befSplitEntryList, depreMethodNumber);
        int entryRowIndex = -1;
        for (Map<String, Object> befSplitEntry : befSplitEntryList) {
            List aftSplitEntryList = (List)befSplitEntry.get("subassetsplitentry");
            for (Map stringObjectMap : aftSplitEntryList) {
                BigDecimal depredAmountBigDecimal;
                ++entryRowIndex;
                JSONObject aftSplitObj = new JSONObject(stringObjectMap);
                JSONObject aftDepremethod = aftSplitObj.getJSONObject("aft_depremethod");
                if (Objects.isNull(aftDepremethod)) continue;
                String number = aftDepremethod.getString("number");
                int precision = 0;
                JSONObject aftWorkLoadUnit = aftSplitObj.getJSONObject("aft_workloadunit");
                if (depreMethodNumber.contains(number)) {
                    boolean mustInputWorkLoadUnit = FaFinCardUtil.isMustInputWorkLoadUnit();
                    if (Objects.isNull(aftWorkLoadUnit) && mustInputWorkLoadUnit) {
                        e.addCancelMessage(Integer.valueOf(entryRowIndex), Integer.valueOf(0), ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u6cd5\u5361\u7247\uff0c\u5de5\u4f5c\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaSplitCardBillEditPlugin_10", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    if (Objects.nonNull(aftWorkLoadUnit)) {
                        String unitNumber = aftWorkLoadUnit.getString("number");
                        if (!unitPrecision.containsKey(unitNumber)) {
                            e.addCancelMessage(Integer.valueOf(entryRowIndex), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u5355\u4f4d\uff1a%s \u4e0d\u5b58\u5728\u3002", (String)"FaSplitCardBillEditPlugin_11", (String)"fi-fa-formplugin", (Object[])new Object[0]), unitNumber));
                            e.setCancel(Boolean.TRUE.booleanValue());
                        } else {
                            precision = unitPrecision.get(unitNumber);
                        }
                    }
                } else if (Objects.nonNull(aftWorkLoadUnit)) {
                    e.addCancelMessage(Integer.valueOf(entryRowIndex), Integer.valueOf(0), ResManager.loadKDString((String)"\u975e\u5de5\u4f5c\u91cf\u6cd5\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5de5\u4f5c\u91cf\u5355\u4f4d\u3002", (String)"FaSplitCardBillEditPlugin_12", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    e.setCancel(Boolean.TRUE.booleanValue());
                }
                BigDecimal preusingAmountBigDecimal = aftSplitObj.getBigDecimal("aft_preusingamount");
                if (Objects.nonNull(preusingAmountBigDecimal)) {
                    if (preusingAmountBigDecimal.compareTo(BigDecimal.ZERO) <= 0) {
                        e.addCancelMessage(Integer.valueOf(entryRowIndex), Integer.valueOf(0), ResManager.loadKDString((String)"\u5f55\u5165\u7684\u9884\u8ba1\u5bff\u547d\u5fc5\u987b\u5927\u4e8e\u96f6\u3002", (String)"FaSplitCardBillEditPlugin_13", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                        e.setCancel(true);
                    }
                    String expectUseStr = preusingAmountBigDecimal.stripTrailingZeros().toPlainString();
                    int expectUsePrecision = 0;
                    if (expectUseStr.split("\\.").length > 1) {
                        expectUsePrecision = expectUseStr.split("\\.")[1].length();
                    }
                    if (expectUsePrecision > precision) {
                        e.addCancelMessage(Integer.valueOf(entryRowIndex), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u9884\u8ba1\u5bff\u547d\u7cbe\u5ea6%1$s \u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5355\u4f4d\u7cbe\u5ea6%2$s\u3002", (String)"FaSplitCardBillEditPlugin_14", (String)"fi-fa-formplugin", (Object[])new Object[0]), expectUsePrecision, precision));
                        e.setCancel(true);
                    }
                }
                if (!Objects.nonNull(depredAmountBigDecimal = aftSplitObj.getBigDecimal("aft_depredamount"))) continue;
                if (depredAmountBigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                    e.addCancelMessage(Integer.valueOf(entryRowIndex), Integer.valueOf(0), ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u9700\u8981\u5f55\u5165\u6b63\u6574\u6570\u62160\u3002", (String)"FaSplitCardBillEditPlugin_15", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                String depredAmountStr = depredAmountBigDecimal.stripTrailingZeros().toPlainString();
                int depredAmountPrecision = 0;
                if (depredAmountStr.split("\\.").length > 1) {
                    depredAmountPrecision = depredAmountStr.split("\\.")[1].length();
                }
                if (depredAmountPrecision <= precision) continue;
                e.addCancelMessage(Integer.valueOf(entryRowIndex), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u7cbe\u5ea6%1$s\u5927\u4e8e\u5de5\u4f5c\u91cf\u5355\u4f4d\u7cbe\u5ea6%2$s\u3002", (String)"FaSplitCardBillEditPlugin_16", (String)"fi-fa-formplugin", (Object[])new Object[0]), depredAmountPrecision, precision));
                e.setCancel(true);
            }
        }
    }

    private Map<String, Integer> getUnitPrecision(List<Map<String, Object>> befSplitEntryList, Set<String> depreMethodNumber) {
        DynamicObject[] load;
        HashSet<String> unitNumberSet = new HashSet<String>(16);
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        for (Map<String, Object> befSplitEntry : befSplitEntryList) {
            List aftSplitEntryList = (List)befSplitEntry.get("subassetsplitentry");
            for (Map map : aftSplitEntryList) {
                JSONObject aftWorkloadunit;
                String number;
                JSONObject aftSplitObj = new JSONObject(map);
                JSONObject aftDepremethod = aftSplitObj.getJSONObject("aft_depremethod");
                if (Objects.isNull(aftDepremethod) || !depreMethodNumber.contains(number = aftDepremethod.getString("number")) || !Objects.nonNull(aftWorkloadunit = aftSplitObj.getJSONObject("aft_workloadunit"))) continue;
                unitNumberSet.add(aftWorkloadunit.getString("number"));
            }
        }
        if (unitNumberSet.size() == 0) {
            return result;
        }
        String selectProperties = Fa.comma((String[])new String[]{"number", "precision"});
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"bd_measureunits", (String)selectProperties, (QFilter[])new QFilter[]{new QFilter("number", "in", unitNumberSet)})) {
            String number = dynamicObject.getString("number");
            int precision = dynamicObject.getInt("precision");
            result.put(number, precision);
        }
        return result;
    }

    private String getNumber(Map<String, Object> sourceData, String prop) {
        return (String)((Map)sourceData.get(prop)).get("number");
    }

    public void afterImportData(ImportDataEventArgs e) {
        Date splitDate;
        super.afterImportData(e);
        Map sourceData = e.getSourceData();
        IDataModel model = this.getModel();
        DynamicObject org = model.getDataEntity().getDynamicObject("org");
        if (org == null) {
            return;
        }
        Long orgid = org.getLong("id");
        DynamicObject mainBook = (DynamicObject)sourceData.get(KEY_IMPORT_ORGMAINASSETBOOK);
        if (mainBook != null) {
            this.getModel().setValue("splitperiod", mainBook.get("curperiod"));
        }
        if ((splitDate = (Date)model.getValue("splitdate")) == null) {
            return;
        }
        String bookNames = this.checkAssetBookDate(orgid, splitDate, sourceData);
        if (!bookNames.isEmpty()) {
            String msgCaption = ResManager.loadKDString((String)"\u62c6\u5206\u65e5\u671f\u4e0d\u5728\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"FaSplitCardBillEditPlugin_17", (String)"fi-fa-formplugin", (Object[])new Object[0]);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format("%s:%s\u3002", msgCaption, bookNames));
            e.setCancel(true);
            return;
        }
        DynamicObject realDy = (DynamicObject)model.getValue("split_realcard");
        this.splitCardPropertyChanged(realDy, false);
        if (this.checkIsOldTemplate(e)) {
            String splitRate = (String)model.getValue("splitrate");
            int splitQty = (Integer)model.getValue("splitqty");
            String[] scaleArr = splitRate.split(":");
            boolean isAvgSplit = (Boolean)model.getValue("isavgsplit");
            if (isAvgSplit) {
                scaleArr = new String[splitQty];
                for (int i = 0; i < splitQty; ++i) {
                    scaleArr[i] = "1";
                }
            } else if (scaleArr.length != splitQty) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u62c6\u5206\u540e\u5361\u7247\u6570\u91cf\u8ddf\u62c6\u5206\u6bd4\u4f8b\u4e2a\u6570\u4e0d\u5339\u914d\u3002", (String)"FaSplitCardBillEditPlugin_18", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            List<BigDecimal> scaleList = Arrays.stream(scaleArr).map(BigDecimal::new).collect(Collectors.toList());
            model.setValue("isautocarry", (Object)Boolean.TRUE);
            this.createSplitCards(scaleList);
        } else {
            DynamicObject splitBill = model.getDataEntity();
            String billNo = splitBill.getString("billno");
            String biztype = splitBill.getString("biztype");
            splitBill.set("splittype", (Object)"B");
            splitBill.set("isavgsplit", (Object)false);
            FaSplitBillAndCardHelper convertHelper = new FaSplitBillAndCardHelper();
            boolean isAutoCarry = splitBill.getBoolean("isautocarry");
            DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
            Map<String, Long> depreuseCountMap = befSplitEntry.stream().map(v -> v.getString(Fa.dot((String[])new String[]{"bef_depreuse", "number"}))).collect(Collectors.groupingBy(v -> v, Collectors.counting()));
            for (Map.Entry<String, Long> entry : depreuseCountMap.entrySet()) {
                if (entry.getValue().compareTo(1L) <= 0) continue;
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u62c6\u5206\u5355\uff0c\u88ab\u62c6\u5206\u5361\u7247\u7684\u6298\u65e7\u7528\u9014%2$s\u7f16\u7801\u91cd\u590d\u3002", (String)"FaSplitCardBillEditPlugin_19", (String)"fi-fa-formplugin", (Object[])new Object[0]), billNo, entry.getKey()));
                e.setCancel(true);
                return;
            }
            int index = -1;
            HashSet<Integer> exitIndexSet = null;
            for (DynamicObject befSplit : befSplitEntry) {
                ++index;
                DynamicObject finDy = befSplit.getDynamicObject("bef_fincard");
                DynamicObject depreuse = befSplit.getDynamicObject("bef_depreuse");
                String depreUseNum = depreuse.getString("number");
                DynamicObjectCollection aftSplitEntry = befSplit.getDynamicObjectCollection("subassetsplitentry");
                long count = aftSplitEntry.stream().filter(v -> v.getBoolean("issourcecard")).count();
                if (count != 1L) {
                    e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u62c6\u5206\u5355\u6298\u65e7\u7528\u9014\u4e3a%2$s\u65f6\u6709\u4e14\u4ec5\u6709\u4e00\u4e2a\u6e90\u5361\u7247\u6807\u8bc6\u4e3a\u662f\u3002", (String)"FaSplitCardBillEditPlugin_20", (String)"fi-fa-formplugin", (Object[])new Object[0]), billNo, depreUseNum));
                    e.setCancel(true);
                    continue;
                }
                if ("B".equals(biztype)) {
                    splitBill.set("splitqty", (Object)(aftSplitEntry.size() - 1));
                } else {
                    splitBill.set("splitqty", (Object)aftSplitEntry.size());
                }
                int subIndex = -1;
                HashSet<Integer> indexSet = new HashSet<Integer>(aftSplitEntry.size());
                if (realDy == null || finDy == null) {
                    return;
                }
                realDy = BusinessDataServiceHelper.loadSingleFromCache((Object)realDy.getPkValue(), (String)"fa_card_real");
                finDy = BusinessDataServiceHelper.loadSingleFromCache((Object)finDy.getPkValue(), (String)"fa_card_fin");
                for (DynamicObject curRow : aftSplitEntry) {
                    ++subIndex;
                    int aftIndex = curRow.getInt("index");
                    if (indexSet.contains(aftIndex)) {
                        e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(subIndex), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u62c6\u5206\u5355\u6298\u65e7\u7528\u9014\u4e3a%2$s\u65f6\uff0c\u5206\u5f55\u884c\u53f7%3$s\u4e0d\u552f\u4e00\u3002", (String)"FaSplitCardBillEditPlugin_21", (String)"fi-fa-formplugin", (Object[])new Object[0]), billNo, depreUseNum, aftIndex));
                        e.setCancel(true);
                        return;
                    }
                    indexSet.add(aftIndex);
                    boolean isSourceCard = curRow.getBoolean("issourcecard");
                    if (isSourceCard) {
                        this.aftSplitSourceCardRow(realDy, finDy, curRow);
                        BigDecimal oldAssetMount = curRow.getBigDecimal("aft_assetamount");
                        BigDecimal oldOriginalval = curRow.getBigDecimal("aft_originalval");
                        BigDecimal oldAccumDepre = curRow.getBigDecimal("aft_accumdepre");
                        BigDecimal oldDecval = curRow.getBigDecimal("aft_decval");
                        BigDecimal oldPreresidualval = curRow.getBigDecimal("aft_preresidualval");
                        BigDecimal oldIncometax = curRow.getBigDecimal("aft_incometax");
                        this.aftEntryFieldCarry(convertHelper, realDy, finDy, isAutoCarry, curRow, isSourceCard, isSourceCard);
                        if ("B".equals(biztype)) {
                            oldAssetMount = befSplit.getBigDecimal("bef_assetamount");
                            oldOriginalval = BigDecimal.ZERO;
                            oldAccumDepre = BigDecimal.ZERO;
                            oldDecval = BigDecimal.ZERO;
                            oldPreresidualval = BigDecimal.ZERO;
                            oldIncometax = BigDecimal.ZERO;
                            curRow.set("aft_originalamount", (Object)BigDecimal.ZERO);
                        }
                        curRow.set("aft_assetamount", (Object)oldAssetMount);
                        curRow.set("aft_originalval", (Object)oldOriginalval);
                        curRow.set("aft_accumdepre", (Object)oldAccumDepre);
                        curRow.set("aft_decval", (Object)oldDecval);
                        curRow.set("aft_preresidualval", (Object)oldPreresidualval);
                        curRow.set("aft_incometax", (Object)oldIncometax);
                        continue;
                    }
                    this.aftEntryFieldCarry(convertHelper, realDy, finDy, isAutoCarry, curRow, isSourceCard, isSourceCard);
                    DynamicObject depreMethod = curRow.getDynamicObject("aft_depremethod");
                    if (depreMethod == null) {
                        curRow.set("aft_workloadunit", null);
                        continue;
                    }
                    String type = depreMethod.getString("type");
                    if ("5".equals(type)) continue;
                    curRow.set("aft_workloadunit", null);
                }
                if (exitIndexSet == null) {
                    exitIndexSet = indexSet;
                    continue;
                }
                boolean exit = exitIndexSet.retainAll(indexSet);
                if (!exit) continue;
                e.addCancelMessage(Integer.valueOf(index), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u62c6\u5206\u5355\u6298\u65e7\u7528\u9014\u4e3a%2$s\u65f6\u7684\u5206\u5f55\u884c\u53f7\u4e0e\u5176\u4ed6\u6298\u65e7\u7528\u9014\u7684\u5206\u5f55\u884c\u53f7\u4e0d\u4e00\u4e00\u5bf9\u5e94\u3002", (String)"FaSplitCardBillEditPlugin_22", (String)"fi-fa-formplugin", (Object[])new Object[0]), billNo, depreUseNum));
                e.setCancel(true);
                return;
            }
            if (mainBook != null) {
                this.unifiedAssetBooksReal(mainBook.getLong(Fa.id((String)"depreuse")), splitBill, e);
            }
        }
        model.setValue("splitrate", (Object)"");
    }

    private void unifiedAssetBooksReal(Long mainDepreuseId, DynamicObject splitBill, ImportDataEventArgs e) {
        List<String> realProperties = this.getAftFieldMapRealFields();
        HashMap map = new HashMap(splitBill.getInt("splitqty"));
        DynamicObjectCollection befSplitEntry = splitBill.getDynamicObjectCollection("assetsplitentry");
        int befIndex = -1;
        for (DynamicObject befcol : befSplitEntry) {
            ++befIndex;
            DynamicObjectCollection aftSplitEntry = befcol.getDynamicObjectCollection("subassetsplitentry");
            long depreuseId = befcol.getLong(Fa.dot((String[])new String[]{"bef_depreuse", "id"}));
            int aftIndex = -1;
            for (DynamicObject aftcol : aftSplitEntry) {
                String secFlag;
                Map<String, Object> realMap;
                ++aftIndex;
                int index = aftcol.getInt("index");
                if (mainDepreuseId == depreuseId) {
                    realMap = new HashMap(realProperties.size());
                    for (String realProperty : realProperties) {
                        realMap.put(realProperty, aftcol.get(realProperty));
                    }
                    realMap.put("issourcecard", aftcol.getBoolean("issourcecard"));
                    map.put(index, realMap);
                    continue;
                }
                if (!map.containsKey(index)) continue;
                realMap = (Map)map.get(index);
                for (String realProperty : realProperties) {
                    aftcol.set(realProperty, realMap.get(realProperty));
                }
                boolean sourceFlag = aftcol.getBoolean("issourcecard");
                if (sourceFlag == Boolean.parseBoolean(secFlag = String.valueOf(realMap.get("issourcecard")))) continue;
                e.addCancelMessage(Integer.valueOf(befIndex), Integer.valueOf(aftIndex), String.format(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u53f7%s\u76f8\u540c\u65f6\uff0c\u6e90\u5361\u7247\u6807\u8bc6\u4e0d\u4e00\u81f4\u3002", (String)"FaSplitCardBillEditPlugin_23", (String)"fi-fa-formplugin", (Object[])new Object[0]), index));
                e.setCancel(true);
            }
        }
    }

    private boolean checkIsOldTemplate(ImportDataEventArgs e) {
        Map sourceData = e.getSourceData();
        return !sourceData.containsKey("biztype");
    }

    private String checkAssetBookDate(long orgId, Date splitDate, Map<String, Object> sourceData) {
        List assetBookObjs = (List)sourceData.get(KEY_IMPORT_ORG2ASSETBOOKS);
        ArrayList<String> assetBookNames = new ArrayList<String>(assetBookObjs.size());
        for (DynamicObject assetBook : assetBookObjs) {
            String status = assetBook.getString("status");
            if (!"C".equalsIgnoreCase(status)) continue;
            DynamicObject curPeriodDy = assetBook.getDynamicObject("curperiod");
            Date startDate = curPeriodDy.getDate("begindate");
            Date endDate = curPeriodDy.getDate("enddate");
            if (!splitDate.after(endDate) && !splitDate.before(startDate)) continue;
            assetBookNames.add(assetBook.getDynamicObject("depreuse").getString("name"));
        }
        if (assetBookNames.isEmpty()) {
            return kd.bos.util.StringUtils.getEmpty();
        }
        return Fa.join(assetBookNames, (String)",");
    }

    private void initValue() {
        DynamicObject mainBook;
        Long org;
        IDataModel model = this.getModel();
        Object isChangingMainOrg = this.getModel().getContextVariable("isChangingMainOrg");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (isChangingMainOrg == null && parentView != null && parentView.toString().indexOf("FormView-fa_mainpage_grid") == 0) {
            List accountUnits = FaPermissionUtils.getAllBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_assetsplitbill");
            org = FaPermissionUtils.getDefaultAcctOrg((List)accountUnits);
            this.getModel().setValue("fa_assetsplitbill", (Object)org);
        }
        model.setValue("billstatus", (Object)BillStatus.A);
        model.setValue("appliant", model.getValue("creator"));
        Object orgObj = this.getModel().getValue("org");
        if (orgObj != null && (mainBook = FaBizUtils.getAsstBookByOrg((Long)(org = Long.valueOf(((DynamicObject)orgObj).getLong("id"))))) != null) {
            this.getModel().setValue("splitperiod", (Object)mainBook.getLong("curperiod"));
        }
    }

    private void setDataRange() {
        FaBizUtils.setDate((IFormView)this.getView(), (String)"splitdate", (DateEdit)((DateEdit)this.getControl("splitdate")), (boolean)false, (boolean)this.getView().getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW));
    }

    private void beforeOrgSelect(BeforeF7SelectEvent evt) {
        List orgIds = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.getView().getPageId(), (String)"fa_assetsplitbill");
        QFilter qFilter = new QFilter("id", "in", (Object)orgIds);
        List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(qFilter);
    }

    private void beforeF7RealCardSelect(BeforeF7SelectEvent evt) {
        long orgId = (Long)this.getModel().getValue("org_id");
        DynamicObject mainBook = FaUtils.getMainBookByOrg((Long)orgId);
        if (mainBook == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e3b\u8d26\u7c3f", (String)"FaSplitCardBillEditPlugin_24", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        FaQFilter.realCardQFilter(this.getModel(), evt);
    }

    private void resetAftSplitCard() {
        IDataModel model = this.getModel();
        DynamicObject dateEntity = model.getDataEntity();
        boolean isManualCode = dateEntity.getBoolean("ismanualcode");
        DynamicObjectCollection befRowDys = dateEntity.getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject befRowDy : befRowDys) {
            long befRealId = befRowDy.getLong("realcard_id");
            long befFinId = befRowDy.getLong("bef_fincard_id");
            DynamicObjectCollection aftRowDys = befRowDy.getDynamicObjectCollection("subassetsplitentry");
            for (DynamicObject aftRowDy : aftRowDys) {
                long aftFinId;
                DynamicObject aftRealDy = aftRowDy.getDynamicObject("aft_realcard");
                long aftRealId = aftRealDy == null ? 0L : aftRealDy.getLong("id");
                DynamicObject aftFinDy = aftRowDy.getDynamicObject("aft_fincard");
                long l = aftFinId = aftFinDy == null ? 0L : aftFinDy.getLong("id");
                if (befRealId != aftRealId && !isManualCode) {
                    aftRowDy.set("aft_realcard", null);
                    aftRowDy.set("aft_cardbillno", (Object)"");
                    aftRowDy.set("aft_cardnumber", (Object)"");
                }
                if (befFinId == aftFinId) continue;
                aftRowDy.set("aft_fincard", null);
            }
        }
        this.getView().updateView("subassetsplitentry");
    }

    void splitCardPropertyChanged(DynamicObject realDy, boolean isUpdateView) {
        boolean flag;
        IDataModel model = this.getModel();
        if (realDy == null) {
            model.deleteEntryData("assetsplitentry");
            model.deleteEntryData("subassetsplitentry");
            return;
        }
        HashSet<Object> realCardPKSet = new HashSet<Object>();
        realCardPKSet.add(realDy.getPkValue());
        Map<String, DynamicObject> finMap = this.getFinCardByReal(realCardPKSet);
        ArrayList<Object> fincards = new ArrayList<DynamicObject>(finMap.values());
        DynamicObjectCollection befEntry = model.getDataEntity().getDynamicObjectCollection("assetsplitentry");
        boolean bl = flag = !isUpdateView && !befEntry.isEmpty();
        if (flag) {
            ArrayList<DynamicObject> oldFin = new ArrayList<DynamicObject>(befEntry.size());
            for (DynamicObject befObj : befEntry) {
                long depreUseId = befObj.getLong(Fa.dot((String[])new String[]{"bef_depreuse", "id"}));
                DynamicObject finCard = finMap.get(realDy.getPkValue() + "_" + depreUseId);
                if (finCard == null) continue;
                oldFin.add(finCard);
            }
            fincards = oldFin;
        } else {
            model.deleteEntryData("assetsplitentry");
        }
        int befIndex = -1;
        Long orgId = realDy.getLong("org.id");
        DynamicObjectCollection assetBooks = FaBizUtils.getAllBookByOrg((Long)orgId);
        HashMap<Long, DynamicObject> depreUseId2BookMap = new HashMap<Long, DynamicObject>(3, 1.0f);
        for (DynamicObject book : assetBooks) {
            depreUseId2BookMap.put(book.getLong("depreuse"), book);
        }
        Calendar calendar = Calendar.getInstance();
        for (DynamicObject dynamicObject : fincards) {
            ++befIndex;
            DynamicObject curRrealDy = dynamicObject.getDynamicObject("realcard");
            if (!flag) {
                befIndex = model.insertEntryRow("assetsplitentry", befIndex);
            }
            model.setValue("bef_depreuse", dynamicObject.get("depreuse"), befIndex);
            model.setValue("realcard", curRrealDy.getPkValue(), befIndex);
            DynamicObject unitDy = curRrealDy.getDynamicObject("unit");
            Object unitPK = unitDy == null ? Integer.valueOf(0) : unitDy.getPkValue();
            model.setValue("bef_unit", unitPK, befIndex);
            model.setValue("bef_fincard", dynamicObject.getPkValue(), befIndex);
            model.setValue("bef_basecurrency", dynamicObject.get("basecurrency"), befIndex);
            model.setValue("bef_assetamount", (Object)curRrealDy.getBigDecimal("assetamount"), befIndex);
            model.setValue("bef_originalval", (Object)dynamicObject.getBigDecimal("originalval"), befIndex);
            BigDecimal monthdepre = dynamicObject.getBigDecimal("monthdepre");
            BigDecimal accumdepre = dynamicObject.getBigDecimal("accumdepre");
            BigDecimal addupyeardepre = dynamicObject.getBigDecimal("addupyeardepre");
            BigDecimal netWorth = dynamicObject.getBigDecimal("networth");
            BigDecimal newAmount = dynamicObject.getBigDecimal("netamount");
            long curPeriodId = this.getCurPeriod(dynamicObject);
            long bizPeriodId = dynamicObject.getLong("bizperiod_id");
            DynamicObject assetBook = (DynamicObject)depreUseId2BookMap.get(dynamicObject.getLong("depreuse.id"));
            model.setValue("bef_monthorigvalchg", (Object)dynamicObject.getBigDecimal("monthorigvalchg"), befIndex);
            model.setValue("bef_yearorigvalchg", (Object)dynamicObject.getBigDecimal("yearorigvalchg"), befIndex);
            model.setValue("bef_monthdepre", (Object)dynamicObject.getBigDecimal("monthdepre"), befIndex);
            model.setValue("bef_monthdeprechg", (Object)dynamicObject.getBigDecimal("monthdeprechg"), befIndex);
            if (bizPeriodId == curPeriodId) {
                model.setValue("bef_accumdepre", (Object)accumdepre.subtract(monthdepre), befIndex);
                if (assetBook.getInt("periodNumber") == 1) {
                    model.setValue("bef_addupyeardepre", (Object)BigDecimal.ZERO, befIndex);
                } else {
                    model.setValue("bef_addupyeardepre", (Object)addupyeardepre.subtract(monthdepre), befIndex);
                }
                model.setValue("bef_networth", (Object)netWorth.add(monthdepre), befIndex);
                model.setValue("bef_netamount", (Object)newAmount.add(monthdepre), befIndex);
            } else {
                model.setValue("bef_accumdepre", (Object)accumdepre, befIndex);
                model.setValue("bef_monthorigvalchg", (Object)BigDecimal.ZERO, befIndex);
                model.setValue("bef_monthdepre", (Object)BigDecimal.ZERO, befIndex);
                model.setValue("bef_monthdeprechg", (Object)BigDecimal.ZERO, befIndex);
                if (assetBook.getInt("periodNumber") == 1) {
                    model.setValue("bef_addupyeardepre", (Object)BigDecimal.ZERO, befIndex);
                    model.setValue("bef_yearorigvalchg", (Object)BigDecimal.ZERO, befIndex);
                } else {
                    Long depreUseId = assetBook.getLong("depreuse");
                    List lessCurPeriodidsInThisYear = FaPeriodUtils.getLessCuPeriods((Long)assetBook.getLong("periodtype"), (Long)assetBook.getLong("curperiod"), (Long)assetBook.getLong("periodyear"));
                    HashSet<String> numbers = new HashSet<String>(16);
                    numbers.add(realDy.getString("number"));
                    QFilter[] filters = new QFilter[]{new QFilter("number", "in", numbers), new QFilter("bizperiod", "in", (Object)lessCurPeriodidsInThisYear), new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId)};
                    boolean isExisted = QueryServiceHelper.exists((String)"fa_card_fin", (QFilter[])filters);
                    boolean justInitDataThisYear = false;
                    if (!isExisted) {
                        Date finAccountDate = dynamicObject.getDate("finaccountdate");
                        calendar.setTime(finAccountDate);
                        int finAccountDateYear = calendar.get(1);
                        int periodYear = assetBook.getInt("periodyear");
                        if (99999999999L == dynamicObject.getLong(Fa.id((String)"endperiod")) && dynamicObject.getLong(Fa.id((String)"bizperiod")) == 0L && finAccountDateYear == periodYear) {
                            justInitDataThisYear = true;
                        }
                    }
                    if (!isExisted && !justInitDataThisYear) {
                        model.setValue("bef_addupyeardepre", (Object)BigDecimal.ZERO, befIndex);
                        model.setValue("bef_yearorigvalchg", (Object)BigDecimal.ZERO, befIndex);
                    } else {
                        model.setValue("bef_addupyeardepre", (Object)addupyeardepre, befIndex);
                        model.setValue("bef_yearorigvalchg", (Object)dynamicObject.getBigDecimal("yearorigvalchg"), befIndex);
                    }
                }
                model.setValue("bef_networth", (Object)netWorth, befIndex);
                model.setValue("bef_netamount", (Object)newAmount, befIndex);
            }
            model.setValue("bef_decval", (Object)dynamicObject.getBigDecimal("decval"), befIndex);
            model.setValue("bef_preresidualval", (Object)dynamicObject.getBigDecimal("preresidualval"), befIndex);
            model.setValue("bef_originalamount", (Object)dynamicObject.getBigDecimal("originalamount"), befIndex);
            model.setValue("bef_incometax", (Object)dynamicObject.getBigDecimal("incometax"), befIndex);
            model.setValue("bef_monthorigvalchg", (Object)dynamicObject.getBigDecimal("monthorigvalchg"), befIndex);
            model.setValue("bef_yearorigvalchg", (Object)dynamicObject.getBigDecimal("yearorigvalchg"), befIndex);
            model.setValue("bef_monthdepre", (Object)dynamicObject.getBigDecimal("monthdepre"), befIndex);
            model.setValue("bef_monthdeprechg", (Object)dynamicObject.getBigDecimal("monthdeprechg"), befIndex);
            BigDecimal partClearDepre = this.getPartClearDepre(dynamicObject.getLong("id"));
            model.setValue("bef_partcleardepre", (Object)partClearDepre, befIndex);
        }
        if (isUpdateView) {
            this.setEnableWhenOne(realDy);
        }
    }

    void setEnableWhenOne(DynamicObject realDy) {
        if (realDy == null) {
            return;
        }
        IDataModel model = this.getModel();
        BigDecimal qty = realDy.getBigDecimal("assetamount");
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"splittype"});
        String billStatus = (String)this.getModel().getValue("billstatus");
        if (qty.compareTo(BigDecimal.ONE) == 0 && "A".equals(billStatus)) {
            model.setValue("splittype", (Object)"B");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"splittype"});
            this.getView().updateView("splittype");
        }
    }

    long getCurPeriod(DynamicObject finDy) {
        long orgId = (Long)this.getModel().getValue("org_id");
        long depureId = finDy.getLong("depreuse_id");
        DynamicObject curPeriodDy = FaBizUtils.getAsstBookByOrgAndDepreuse((Long)orgId, (Long)depureId, (String)"curperiod");
        long curPeriod = curPeriodDy.getLong("curperiod");
        return curPeriod;
    }

    @Deprecated
    public Map<String, DynamicObject> queryRealCards(Set<Object> realCardPKSet, List<FieldEntry> fieldEntrys) {
        DynamicObject[] realCards;
        if (realCardPKSet == null || realCardPKSet.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, DynamicObject> realCardMap = new LinkedHashMap<String, DynamicObject>(realCardPKSet.size());
        HashSet realCardPK = new HashSet();
        realCardPKSet.forEach(r -> realCardPK.add(Long.parseLong(String.valueOf(r))));
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", realCardPK)};
        Set<String> fields = fieldEntrys == null || fieldEntrys.isEmpty() ? new HashSet<String>(4) : fieldEntrys.stream().map(field -> field.filed).collect(Collectors.toSet());
        fields.add("unit");
        String selector = String.join((CharSequence)",", fields);
        for (DynamicObject realCard : realCards = FaBillDaoFactory.getInstance((String)"fa_card_real").query(selector, filters)) {
            String realCardId = realCard.getPkValue().toString();
            realCardMap.put(realCardId, realCard);
        }
        return realCardMap;
    }

    private Map<String, DynamicObject> getFinCardByReal(Set<Object> realCards) {
        LinkedHashMap<String, DynamicObject> finCardMap = new LinkedHashMap<String, DynamicObject>(realCards.size());
        List<FieldEntry> fieldEntries = this.getSplitFields().get("fa_card_fin");
        Set fieldsSet = fieldEntries.stream().map(field -> field.filed).collect(Collectors.toSet());
        fieldsSet.add("basecurrency");
        List finCardLst = FaUtils.queryFinCardList(realCards, fieldsSet, null, null);
        for (DynamicObject finCard : finCardLst) {
            String readCardStr = finCard.getString("realcardmasterid");
            String depreuseStr = finCard.getDynamicObject("depreuse").getPkValue().toString();
            String keyStr = String.format("%s_%s", readCardStr, depreuseStr);
            finCardMap.put(keyStr, finCard);
        }
        return finCardMap;
    }

    private void avgSplit() {
        IDataModel model = this.getModel();
        Object realCard = model.getValue("split_realcard");
        String splitType = model.getValue("splittype").toString();
        if (realCard == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u53d6\u8981\u62c6\u5206\u7684\u5361\u7247\u3002", (String)"FaSplitCardBillEditPlugin_25", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject realDy = (DynamicObject)realCard;
        BigDecimal assetAmount = realDy.getBigDecimal("assetamount");
        if (assetAmount.compareTo(BigDecimal.ONE) == 0 && "A".equals(splitType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62c6\u5206\u5361\u7247\u6570\u91cf\u4e3a1\u65f6\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u91cf\u62c6\u5206\u3002", (String)"FaSplitCardBillEditPlugin_26", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        Object qtyObj = model.getValue("splitqty");
        if (qtyObj == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u62c6\u5206\u540e\u5361\u7247\u6570\u91cf\u3002", (String)"FaSplitCardBillEditPlugin_27", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        List<BigDecimal> scaleList = this.getScaleList();
        this.createSplitCards(scaleList);
        String invalidateSplit = this.getPageCache().get(AUTO_SPLIT_ERROR_FLAG);
        if ("true".equalsIgnoreCase(invalidateSplit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9047\u5230\u7a0b\u5e8f\u65e0\u6cd5\u6b63\u786e\u62c6\u5206\u7684\u6570\u636e\uff0c\u8bf7\u624b\u52a8\u8c03\u6574\u3002", (String)"FaSplitCardBillEditPlugin_28", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    private void scaleSplit() {
        IDataModel model = this.getModel();
        Object realCard = model.getValue("split_realcard");
        String splitType = model.getValue("splittype").toString();
        if (realCard == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u53d6\u8981\u62c6\u5206\u7684\u5361\u7247", (String)"FaSplitCardBillEditPlugin_29", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject realDy = (DynamicObject)realCard;
        BigDecimal assetAmount = realDy.getBigDecimal("assetamount");
        if (assetAmount.compareTo(BigDecimal.ONE) == 0 && "A".equals(splitType)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62c6\u5206\u5361\u7247\u6570\u91cf\u4e3a1\u65f6\uff0c\u4e0d\u80fd\u8fdb\u884c\u6570\u91cf\u62c6\u5206\u3002", (String)"FaSplitCardBillEditPlugin_30", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        Object qty = model.getValue("splitqty");
        if (qty == null || qty.toString().equalsIgnoreCase("0")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8f93\u5165\u62c6\u5206\u540e\u5361\u7247\u6570\u91cf\u3002", (String)"FaSplitCardBillEditPlugin_27", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showSplitScaleSetForm();
    }

    List<BigDecimal> getScaleList() {
        IDataModel model = this.getModel();
        int qty = (Integer)model.getValue("splitqty");
        ArrayList<BigDecimal> scaleList = new ArrayList<BigDecimal>(qty);
        Object bizType = model.getValue("biztype");
        if ("B".equals(bizType)) {
            scaleList.add(BigDecimal.ZERO);
        }
        for (int i = 0; i < qty; ++i) {
            scaleList.add(BigDecimal.ONE);
        }
        return scaleList;
    }

    List<BigDecimal> getAssetamount() {
        IDataModel model = this.getModel();
        DynamicObjectCollection aftSplitEntrys = (DynamicObjectCollection)model.getValue("subassetsplitentry");
        ArrayList<BigDecimal> result = new ArrayList<BigDecimal>(aftSplitEntrys.size());
        for (DynamicObject aftSplitEntry : aftSplitEntrys) {
            result.add(aftSplitEntry.getBigDecimal("aft_assetamount"));
        }
        return result;
    }

    void createSplitCards(List<BigDecimal> scaleList) {
        IDataModel model = this.getModel();
        int rowcount = model.getEntryRowCount("assetsplitentry");
        FaSplitBillAndCardHelper convertHelper = new FaSplitBillAndCardHelper();
        for (int befIndex = 0; befIndex < rowcount; ++befIndex) {
            this.createSplitCard(befIndex, scaleList, convertHelper);
        }
        this.setAftSplitEnable();
    }

    void createSplitCard(int befIndex, List<BigDecimal> scaleList, FaSplitBillAndCardHelper convertHelper) {
        IDataModel model = this.getModel();
        int lastPos = scaleList.size() - 1;
        model.setEntryCurrentRowIndex("assetsplitentry", befIndex);
        DynamicObject realDy = (DynamicObject)model.getValue("realcard", befIndex);
        if (realDy == null) {
            return;
        }
        realDy = BusinessDataServiceHelper.loadSingleFromCache((Object)realDy.getPkValue(), (String)"fa_card_real");
        DynamicObject unitDy = (DynamicObject)model.getValue("bef_unit", befIndex);
        int unitPrecision = unitDy == null ? 15 : unitDy.getInt("precision");
        List<ScaleEntry> unitScales = this.getScaleDataByList(scaleList, unitPrecision);
        DynamicObject baseCurrencyDy = (DynamicObject)model.getValue("bef_basecurrency", befIndex);
        int currencyPrecision = baseCurrencyDy == null ? 15 : baseCurrencyDy.getInt("amtprecision");
        List<ScaleEntry> currencyScales = this.getScaleDataByList(scaleList, currencyPrecision);
        DynamicObject finDy = (DynamicObject)model.getValue("bef_fincard", befIndex);
        if (finDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5df2\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"FaSplitCardBillEditPlugin_31", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        finDy = BusinessDataServiceHelper.loadSingleFromCache((Object)finDy.getPkValue(), (String)"fa_card_fin");
        DynamicObject currency = finDy.getDynamicObject("currency");
        currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (DynamicObjectType)currency.getDynamicObjectType());
        finDy.set("currency", (Object)currency);
        int curPrecision = currency == null ? 15 : currency.getInt("amtprecision");
        List<ScaleEntry> curScales = this.getScaleDataByList(scaleList, curPrecision);
        this.splitCardData(befIndex, convertHelper, model, lastPos, realDy, unitScales, currencyScales, finDy, curScales);
    }

    private void splitCardData(int befIndex, FaSplitBillAndCardHelper convertHelper, IDataModel model, int lastPos, DynamicObject realDy, List<ScaleEntry> unitScales, List<ScaleEntry> currencyScales, DynamicObject finDy, List<ScaleEntry> curScales) {
        BigDecimal sumAssetAmount = BigDecimal.ZERO;
        BigDecimal sumOriginalVal = BigDecimal.ZERO;
        BigDecimal sumAccumDepre = BigDecimal.ZERO;
        BigDecimal sumDecVal = BigDecimal.ZERO;
        BigDecimal sumPreResidualVal = BigDecimal.ZERO;
        BigDecimal sumOriginalAmount = BigDecimal.ZERO;
        BigDecimal sumIncomeTax = BigDecimal.ZERO;
        BigDecimal befAssetAmount = (BigDecimal)model.getValue("bef_assetamount", befIndex);
        BigDecimal befOriginalVal = (BigDecimal)model.getValue("bef_originalval", befIndex);
        BigDecimal befAccumDepre = (BigDecimal)model.getValue("bef_accumdepre", befIndex);
        BigDecimal befDecVal = (BigDecimal)model.getValue("bef_decval", befIndex);
        BigDecimal befPreResidualVal = (BigDecimal)model.getValue("bef_preresidualval", befIndex);
        BigDecimal befOriginalAmount = (BigDecimal)model.getValue("bef_originalamount", befIndex);
        BigDecimal befIncomeTax = (BigDecimal)model.getValue("bef_incometax", befIndex);
        boolean isQtySplit = "A".equals(model.getValue("splittype"));
        int index = 0;
        model.deleteEntryData("subassetsplitentry");
        model.beginInit();
        model.batchCreateNewEntryRow("subassetsplitentry", currencyScales.size());
        boolean isAutoCarry = (Boolean)model.getValue("isautocarry");
        boolean isAvgSplit = (Boolean)model.getValue("isavgsplit");
        String splitRate = (String)model.getValue("splitrate");
        DynamicObjectCollection entryEntity = model.getEntryEntity("subassetsplitentry");
        for (ScaleEntry currencyScale : currencyScales) {
            DynamicObject curRow = (DynamicObject)entryEntity.get(index);
            curRow.set("index", (Object)(index + 1));
            this.aftEntryFieldCarry(convertHelper, realDy, finDy, isAutoCarry, curRow, true, index == 0);
            BigDecimal assetAmount = befAssetAmount;
            BigDecimal originalVal = BigDecimal.ZERO;
            BigDecimal accumDepre = BigDecimal.ZERO;
            BigDecimal decVal = BigDecimal.ZERO;
            BigDecimal preResidualVal = BigDecimal.ZERO;
            BigDecimal originalAmount = BigDecimal.ZERO;
            BigDecimal incomeTax = BigDecimal.ZERO;
            if (isAvgSplit || kd.bos.util.StringUtils.isNotEmpty((String)splitRate)) {
                if (index == lastPos) {
                    if (isQtySplit) {
                        assetAmount = befAssetAmount.subtract(sumAssetAmount);
                    }
                    originalVal = befOriginalVal.subtract(sumOriginalVal);
                    accumDepre = befAccumDepre.subtract(sumAccumDepre);
                    decVal = befDecVal.subtract(sumDecVal);
                    incomeTax = befIncomeTax.subtract(sumIncomeTax);
                    originalAmount = befOriginalAmount.subtract(sumOriginalAmount);
                    preResidualVal = befPreResidualVal.subtract(sumPreResidualVal);
                } else {
                    if (isQtySplit) {
                        assetAmount = this.getScaleValue(befAssetAmount, unitScales.get(index));
                        sumAssetAmount = sumAssetAmount.add(assetAmount);
                    }
                    originalVal = this.getScaleValue(befOriginalVal, currencyScale);
                    accumDepre = this.getScaleValue(befAccumDepre, currencyScale);
                    decVal = this.getScaleValue(befDecVal, currencyScale);
                    incomeTax = this.getScaleValue(befIncomeTax, currencyScale);
                    originalAmount = this.getScaleValue(befOriginalAmount, curScales.get(index));
                    preResidualVal = this.getScaleValue(befPreResidualVal, currencyScale);
                    sumOriginalVal = sumOriginalVal.add(originalVal);
                    sumAccumDepre = sumAccumDepre.add(accumDepre);
                    sumDecVal = sumDecVal.add(decVal);
                    sumIncomeTax = sumIncomeTax.add(incomeTax);
                    sumOriginalAmount = sumOriginalAmount.add(originalAmount);
                    sumPreResidualVal = sumPreResidualVal.add(preResidualVal);
                }
            } else if (isQtySplit) {
                assetAmount = BigDecimal.ZERO;
            }
            BigDecimal calcPreResidualVal = originalVal.subtract(accumDepre).subtract(decVal);
            if (calcPreResidualVal.compareTo(BigDecimal.ZERO) < 0) {
                this.getPageCache().put(AUTO_SPLIT_ERROR_FLAG, "true");
            }
            if (calcPreResidualVal.compareTo(preResidualVal) < 0) {
                preResidualVal = calcPreResidualVal;
            }
            curRow.set("aft_assetamount", (Object)assetAmount);
            curRow.set("aft_originalval", (Object)originalVal);
            curRow.set("aft_accumdepre", (Object)accumDepre);
            curRow.set("aft_decval", (Object)decVal);
            curRow.set("aft_preresidualval", (Object)preResidualVal);
            curRow.set("aft_networth", (Object)originalVal.subtract(accumDepre));
            curRow.set("aft_netamount", (Object)calcPreResidualVal);
            curRow.set("aft_originalamount", (Object)originalAmount);
            curRow.set("aft_incometax", (Object)incomeTax);
            curRow.set("aft_monthdepre", (Object)BigDecimal.ZERO);
            if (index == 0) {
                curRow.set("issourcecard", (Object)true);
                this.aftSplitSourceCardRow(realDy, finDy, curRow);
                BigDecimal befAddUpYearDep = (BigDecimal)model.getValue("bef_addupyeardepre", befIndex);
                curRow.set("aft_addupyeardepre", (Object)befAddUpYearDep);
                curRow.set("aft_monthorigvalchg", (Object)originalVal.subtract(befOriginalVal));
                curRow.set("aft_yearorigvalchg", (Object)originalVal.subtract(befOriginalVal));
                curRow.set("aft_monthdeprechg", (Object)decVal.subtract(befDecVal));
                curRow.set("aft_monthaccumdeprechg", (Object)accumDepre.subtract(befAccumDepre));
            } else {
                curRow.set("issourcecard", (Object)false);
                curRow.set("aft_addupyeardepre", (Object)BigDecimal.ZERO);
                curRow.set("aft_monthorigvalchg", (Object)originalVal);
                curRow.set("aft_yearorigvalchg", (Object)originalVal);
                curRow.set("aft_monthdeprechg", (Object)decVal);
                curRow.set("aft_monthaccumdeprechg", (Object)accumDepre);
            }
            ++index;
        }
        model.endInit();
        IFormView view = this.getView();
        this.getModel().getDataEntity(true);
        view.updateView("subassetsplitentry");
    }

    private void aftSplitSourceCardRow(DynamicObject realDy, DynamicObject finDy, DynamicObject curRow) {
        curRow.set("aft_cardbillno", (Object)realDy.getString("billno"));
        curRow.set("aft_cardnumber", (Object)realDy.getString("number"));
        curRow.set("aft_barcode", (Object)realDy.getString("barcode"));
        curRow.set("aft_realcard", (Object)realDy);
        curRow.set("aft_fincard", (Object)finDy);
        DynamicObject splitBill = this.getModel().getDataEntity();
        String bizType = splitBill.getString("biztype");
        if ("B".equalsIgnoreCase(bizType)) {
            curRow.set("aft_assetamount", (Object)realDy.getBigDecimal("assetamount"));
        }
    }

    private void aftEntryFieldCarry(FaSplitBillAndCardHelper convertHelper, DynamicObject realDy, DynamicObject finDy, boolean isAutoCarry, DynamicObject curRow, boolean isNeedConvert, boolean isSourceCard) {
        if (isAutoCarry || isSourceCard) {
            Map blacklistMap = BillFieldMappingBlackListUtils.getBillMappingBlacklistMap();
            Set blackList = (Set)blacklistMap.get("fa_card_real");
            blackList.addAll(Arrays.asList("number", "billno", "barcode"));
            if (realDy == null || finDy == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u88ab\u62c6\u5206\u8d44\u4ea7\u627e\u4e0d\u5230\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"FaSplitCardBillEditPlugin_32", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                return;
            }
            convertHelper.cardConvert2SubEntity(curRow, realDy, finDy, isNeedConvert, blacklistMap);
            long bizPeriodId = finDy.getLong(Fa.id((String)"bizperiod"));
            long splitPeriodId = this.getModel().getDataEntity().getLong(Fa.id((String)"splitperiod"));
            if (bizPeriodId == splitPeriodId) {
                BigDecimal calcDepAmount = finDy.getBigDecimal("depredamount").subtract(finDy.getBigDecimal("addidepreamount"));
                curRow.set("aft_depredamount", (Object)calcDepAmount);
            }
        }
        if (realDy == null || finDy == null) {
            return;
        }
        curRow.set("aft_assetunit", (Object)realDy.getDynamicObject("assetunit"));
        curRow.set("aft_org", (Object)realDy.getDynamicObject("org"));
        curRow.set("aft_depreuse", (Object)finDy.getDynamicObject("depreuse"));
        curRow.set("aft_realaccountdate", (Object)realDy.getDate("realaccountdate"));
        curRow.set("aft_finaccountdate", (Object)finDy.getDate("finaccountdate"));
        curRow.set("aft_currency", (Object)this.getCurrency(finDy, "currency"));
        curRow.set("aft_currencyrate", (Object)finDy.getBigDecimal("currencyrate"));
        curRow.set("aft_basecurrency", (Object)this.getCurrency(finDy, "basecurrency"));
    }

    private DynamicObject getCurrency(DynamicObject finDy, String currencyField) {
        long currencyId = finDy.getLong(Fa.id((String)currencyField));
        return (DynamicObject)ThreadCache.get((Object)("getCurrencyById_" + currencyId), () -> BusinessDataServiceHelper.loadSingle((Object)currencyId, (String)"bd_currency"));
    }

    private BigDecimal getScaleValue(BigDecimal totalAmount, ScaleEntry scaleEntry) {
        if (totalAmount.compareTo(BigDecimal.ZERO) == 0 || scaleEntry.totalValue.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal rowHalfUpAvg = totalAmount.multiply(scaleEntry.value).divide(scaleEntry.totalValue, scaleEntry.Precise, RoundingMode.HALF_UP);
        if (rowHalfUpAvg.multiply(scaleEntry.totalValue.subtract(BigDecimal.ONE)).compareTo(totalAmount.multiply(scaleEntry.value)) <= 0) {
            return rowHalfUpAvg;
        }
        return totalAmount.multiply(scaleEntry.value).divide(scaleEntry.totalValue, scaleEntry.Precise, RoundingMode.DOWN);
    }

    private void showSplitScaleSetForm() {
        IDataModel model = this.getModel();
        String splitType = model.getValue("splittype").toString();
        BigDecimal splitQty = BigDecimal.ZERO;
        Object qty = model.getValue("splitqty");
        splitQty = new BigDecimal(qty.toString());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fa_splitscale");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("splittype", (Object)splitType);
        showParameter.setCustomParam("splitqty", (Object)splitQty);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_CALLBACK_SPLIYSCALE);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void callBackSplitScaleSet(ClosedCallBackEvent closedCallBackEvent) {
        IDataModel model = this.getModel();
        if (closedCallBackEvent.getReturnData() != null) {
            String splitScaleStr = (String)closedCallBackEvent.getReturnData();
            this.getModel().setValue("splitrate", (Object)splitScaleStr);
            if (kd.bos.util.StringUtils.isBlank((String)splitScaleStr)) {
                return;
            }
            String[] scaleArr = splitScaleStr.split(":");
            List<BigDecimal> scaleList = Arrays.asList(scaleArr).stream().map(str -> new BigDecimal((String)str)).collect(Collectors.toList());
            Object bizType = model.getValue("biztype");
            if ("B".equals(bizType)) {
                scaleList.add(0, BigDecimal.ZERO);
            }
            this.createSplitCards(scaleList);
            String invalidateSplit = this.getPageCache().get(AUTO_SPLIT_ERROR_FLAG);
            if ("true".equalsIgnoreCase(invalidateSplit)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9047\u5230\u7a0b\u5e8f\u65e0\u6cd5\u6b63\u786e\u62c6\u5206\u7684\u6570\u636e\uff0c\u8bf7\u624b\u52a8\u8c03\u6574\u3002", (String)"FaSplitCardBillEditPlugin_33", (String)"fi-fa-formplugin", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.valueOf(true), -1, new String[]{"aft_accumdepre", "aft_addupyeardepre", "aft_decval", "aft_preresidualval"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"fillaftentry"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), -1, new String[]{"aft_accumdepre", "aft_addupyeardepre", "aft_decval", "aft_preresidualval"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"fillaftentry"});
            }
        }
    }

    private List<ScaleEntry> getScaleDataByList(List<BigDecimal> scaleList, int precise) {
        BigDecimal totalDecimal = scaleList.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        ArrayList<ScaleEntry> scaleEntrys = new ArrayList<ScaleEntry>(scaleList.size());
        for (BigDecimal scale : scaleList) {
            ScaleEntry scaleEntry = new ScaleEntry();
            scaleEntry.value = scale;
            scaleEntry.totalValue = totalDecimal;
            scaleEntry.Precise = precise;
            scaleEntrys.add(scaleEntry);
        }
        return scaleEntrys;
    }

    @Deprecated
    BigDecimal getPartClearDepre(Long finId) {
        BigDecimal result = BigDecimal.ZERO;
        long periodId = (Long)this.getModel().getValue("splitperiod_id");
        QFilter statusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter periodFilter = new QFilter("clearperiod", "=", (Object)periodId);
        QFilter finFilter = new QFilter(Fa.dot((String[])new String[]{"detail_entry", "fincard"}), "=", (Object)finId);
        QFilter isClearAllFilter = new QFilter(Fa.dot((String[])new String[]{"detail_entry", "isclearall"}), "!=", (Object)"1");
        String selectFields = Fa.dot((String[])new String[]{"detail_entry", "addupdepre"}) + " " + "addupdepre";
        DynamicObjectCollection itemDys = QueryServiceHelper.query((String)"fa_clearbill", (String)selectFields, (QFilter[])new QFilter[]{statusFilter, periodFilter, finFilter, isClearAllFilter});
        if (itemDys != null && itemDys.size() > 0) {
            result = itemDys.stream().map(dy -> dy.getBigDecimal("addupdepre")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return result;
    }

    private Map<String, List<FieldEntry>> getSplitFields() {
        HashMap<String, List<FieldEntry>> result = new HashMap<String, List<FieldEntry>>();
        ArrayList<FieldEntry> realFieldEntrys = new ArrayList<FieldEntry>();
        realFieldEntrys.add(this.getFieldEntry("assetamount", ResManager.loadKDString((String)"\u8d44\u4ea7", (String)"FaSplitCardBillEditPlugin_34", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_real"));
        ArrayList<FieldEntry> finFieldEntrys = new ArrayList<FieldEntry>();
        finFieldEntrys.add(this.getFieldEntry("originalval", ResManager.loadKDString((String)"\u539f\u503c", (String)"FaSplitCardBillEditPlugin_35", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("accumdepre", ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7", (String)"FaSplitCardBillEditPlugin_36", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("addupyeardepre", ResManager.loadKDString((String)"\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7", (String)"FaSplitCardBillEditPlugin_37", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("decval", ResManager.loadKDString((String)"\u51cf\u503c\u51c6\u5907", (String)"FaSplitCardBillEditPlugin_38", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("preresidualval", ResManager.loadKDString((String)"\u51c0\u6b8b\u503c", (String)"FaSplitCardBillEditPlugin_39", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("networth", ResManager.loadKDString((String)"\u51c0\u503c", (String)"FaSplitCardBillEditPlugin_40", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("netamount", ResManager.loadKDString((String)"\u51c0\u989d", (String)"FaSplitCardBillEditPlugin_41", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("originalamount", ResManager.loadKDString((String)"\u539f\u5e01\u91d1\u989d", (String)"FaSplitCardBillEditPlugin_42", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("incometax", ResManager.loadKDString((String)"\u8fdb\u9879\u7a0e\u989d", (String)"FaSplitCardBillEditPlugin_43", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("monthorigvalchg", ResManager.loadKDString((String)"\u672c\u671f\u539f\u503c\u53d8\u52a8", (String)"FaSplitCardBillEditPlugin_44", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("yearorigvalchg", ResManager.loadKDString((String)"\u672c\u5e74\u539f\u503c\u53d8\u52a8", (String)"FaSplitCardBillEditPlugin_45", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("monthdepre", ResManager.loadKDString((String)"\u672c\u671f\u6298\u65e7", (String)"FaSplitCardBillEditPlugin_46", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        finFieldEntrys.add(this.getFieldEntry("monthdeprechg", ResManager.loadKDString((String)"\u672c\u671f\u51cf\u503c\u53d8\u52a8", (String)"FaSplitCardBillEditPlugin_47", (String)"fi-fa-formplugin", (Object[])new Object[0]), "fa_card_fin"));
        result.put("fa_card_real", realFieldEntrys);
        result.put("fa_card_fin", finFieldEntrys);
        return result;
    }

    FieldEntry getFieldEntry(String filed, String filedName, String formMeta) {
        FieldEntry fieldEntry = new FieldEntry();
        fieldEntry.filed = filed;
        fieldEntry.filedName = filedName;
        fieldEntry.formMeta = formMeta;
        return fieldEntry;
    }

    private void showTargetCards() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        EntryGrid entryGrid = (EntryGrid)this.getControl("subassetsplitentry");
        int[] selectedRowIndex = entryGrid.getSelectRows();
        if (selectedRowIndex == null || selectedRowIndex.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u62c6\u5206\u540e\u5361\u7247\u201d\u3002", (String)"FaSplitCardBillEditPlugin_48", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter showParam = new BillShowParameter();
        showParam.setParentFormId("fa_assetsplitbill");
        showParam.setFormId("fa_split_asset_cards");
        showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParam.getOpenStyle().setTargetKey("fa_asset_card");
        showParam.setCaption(ResManager.loadKDString((String)"\u76ee\u6807\u5361\u7247", (String)"FaSplitCardBillEditPlugin_49", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        showParam.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "fa_asset_card"));
        DynamicObjectCollection entries = this.getModel().getEntryEntity("subassetsplitentry");
        DynamicObject selectedRow = (DynamicObject)entries.get(selectedRowIndex[0]);
        Integer cardIndex = selectedRow.getInt("index");
        DynamicObject depreuse = selectedRow.getDynamicObject("aft_depreuse");
        Long depreuseId = depreuse.getLong("id");
        if (BillStatus.A.name().equals(billStatus) && depreuse.getBoolean("default")) {
            showParam.setStatus(OperationStatus.ADDNEW);
        } else {
            showParam.setStatus(OperationStatus.VIEW);
        }
        FaSplitBillAndCardHelper helper = new FaSplitBillAndCardHelper();
        ArrayList<Integer> indexList = new ArrayList<Integer>(1);
        indexList.add(cardIndex);
        Map indexCardDTOMap = helper.splitBillConvert2RealFinCardMap(this.getModel().getDataEntity(true), indexList);
        String indexCardDTOMapStr = SerializationUtils.serializeToBase64((Object)indexCardDTOMap);
        IAppCache appCache = AppCache.get((String)"fa");
        String cacheKey = "cache_real_fin_card_" + showParam.getPageId();
        appCache.put(cacheKey, (Object)indexCardDTOMapStr);
        Boolean isManualCode = (Boolean)this.getModel().getValue("ismanualcode");
        HashMap seq2IndexMap = new HashMap(entries.size());
        entries.stream().forEach(t -> seq2IndexMap.put(t.getInt("seq"), t.getInt("index")));
        Map customParams = showParam.getCustomParams();
        customParams.put(KEY_CACHE_REAL_FIN_CARD, cacheKey);
        customParams.put("ismanualcode", isManualCode);
        customParams.put("biztype", this.getModel().getValue("biztype"));
        customParams.put("fa_assetsplitbill_billstatus", billStatus);
        customParams.put(KEY_SPLIT_PAGE_ID, this.getView().getPageId());
        customParams.put("default_depreuse_id", depreuseId);
        customParams.put(KEY_SEQ_INDEX_RELATION, SerializationUtils.serializeToBase64(seq2IndexMap));
        customParams.put(KEY_MAX_SEQ, entries.size());
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_CALLBACK_TARGET_CARD);
        showParam.setCloseCallBack(closeCallBack);
        this.getView().showForm((FormShowParameter)showParam);
    }

    private Map<Long, List<DynamicObject>> getOrgId2AssetBookMap(Collection<Object> orgIds) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        HashMap<Long, List<DynamicObject>> results = new HashMap<Long, List<DynamicObject>>(orgIds.size());
        Map assetBookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        if (assetBookMap == null || assetBookMap.isEmpty()) {
            return results;
        }
        for (DynamicObject assetBook : assetBookMap.values()) {
            Long orgId = assetBook.getLong(Fa.id((String)"org"));
            ArrayList<DynamicObject> oneOrgAssetBooks = (ArrayList<DynamicObject>)results.get(orgId);
            if (oneOrgAssetBooks == null) {
                oneOrgAssetBooks = new ArrayList<DynamicObject>();
                results.put(orgId, oneOrgAssetBooks);
            }
            oneOrgAssetBooks.add(assetBook);
        }
        return results;
    }
}

