/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.split;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.utils.FaBizUtils;

public class FaSplitGuideEditPlugin
extends AbstractFormPlugin {
    private static final String CANCEL = "cancel";
    private static final String NEXT = "next";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{CANCEL, NEXT});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentViewNoPlugin = this.getView().getViewNoPlugin(parentPageId);
        this.getModel().setValue("org", (Object)parentViewNoPlugin.getPageCache().get("org"));
        String orgId = parentViewNoPlugin.getPageCache().get("org");
        if (StringUtils.isEmpty((String)orgId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u518d\u65b0\u589e\u3002", (String)"FaSplitGuideEditPlugin_0", (String)"fi-fa-formplugin", (Object[])new Object[0]));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"contentpanelflex"});
            return;
        }
        DynamicObject mainBook = FaBizUtils.getAsstBookByOrg((Long)Long.parseLong(orgId));
        if (mainBook != null) {
            this.getModel().setValue("splitperiod", (Object)mainBook.getLong("curperiod"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (NEXT.equalsIgnoreCase(ctlSource.getKey())) {
            String msg = this.checkData();
            if (msg == null) {
                this.returnData();
            } else {
                this.getView().showTipNotification(msg);
            }
        } else if (CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    private String checkData() {
        int splitQty;
        String bizType;
        DynamicObject splitGuide = this.getModel().getDataEntity();
        HashSet<String> msg = new HashSet<String>(4);
        if (splitGuide.getDynamicObject("org") == null) {
            msg.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaSplitGuideEditPlugin_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if (splitGuide.getDynamicObject("split_realcard") == null) {
            msg.add(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u88ab\u62c6\u5206\u5361\u7247\u3002", (String)"FaSplitGuideEditPlugin_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if ("B".equals(bizType = splitGuide.getString("biztype")) && (splitQty = splitGuide.getInt("splitqty")) == 1) {
            msg.add(ResManager.loadKDString((String)"\u5b8c\u5168\u8f6c\u5165\u65b0\u589e\u65f6\uff0c\u62c6\u5206\u540e\u5361\u7247\u6570\u5fc5\u987b\u5927\u4e8e1\u3002", (String)"FaSplitGuideEditPlugin_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        if (msg.isEmpty()) {
            return null;
        }
        return String.join((CharSequence)"\r\n", msg);
    }

    private void returnData() {
        DynamicObject splitGuild = this.getModel().getDataEntity(true);
        this.getView().returnDataToParent((Object)splitGuild);
        this.getView().close();
    }
}

